/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs11;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs11.PKCS11KeyCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.security.Key;
import java.security.KeyStore;
import java.util.Enumeration;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.provider.java.security.JSSLoadStoreParameter;

public class PKCS11KeyFindCLI
extends CommandCLI {
    public PKCS11KeyCLI keyCLI;

    public PKCS11KeyFindCLI(PKCS11KeyCLI keyCLI) {
        super("find", "Find PKCS #11 keys", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        String tokenName = this.getConfig().getTokenName();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
        KeyStore ks = KeyStore.getInstance("pkcs11");
        ks.load((KeyStore.LoadStoreParameter)new JSSLoadStoreParameter(token));
        Enumeration<String> aliases = ks.aliases();
        boolean first = true;
        while (aliases.hasMoreElements()) {
            Key key;
            String alias = aliases.nextElement();
            if (ks.isCertificateEntry(alias) || (key = ks.getKey(alias, null)) == null) continue;
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            PKCS11KeyCLI.printKeyInfo(alias, key);
        }
    }
}

