/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.config;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.dbs.CSCfgDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.dogtagpki.server.tps.config.ConfigDatabase;
import org.dogtagpki.server.tps.config.ConfigRecord;
import org.dogtagpki.server.tps.config.ProfileMappingRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMappingDatabase
extends CSCfgDatabase<ProfileMappingRecord> {
    public static Logger logger = LoggerFactory.getLogger(ProfileMappingDatabase.class);

    public ProfileMappingDatabase() {
        super("Profile Mapping", "Profile_Mappings");
    }

    public ProfileMappingRecord createProfileMappingRecord(ConfigDatabase configDatabase, ConfigRecord configRecord, String profileMappingID) throws EBaseException {
        ProfileMappingRecord profileMappingRecord = new ProfileMappingRecord();
        profileMappingRecord.setID(profileMappingID);
        String status = this.getRecordStatus(profileMappingID);
        profileMappingRecord.setStatus(status);
        Map<String, String> properties = configDatabase.getProperties(configRecord, profileMappingID);
        profileMappingRecord.setProperties(properties);
        return profileMappingRecord;
    }

    public Collection<ProfileMappingRecord> findRecords(String filter) throws Exception {
        ArrayList<ProfileMappingRecord> result = new ArrayList<ProfileMappingRecord>();
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        for (String profileMappingID : configRecord.getKeys()) {
            if (filter != null && !profileMappingID.contains(filter)) continue;
            ProfileMappingRecord profileMappingRecord = this.createProfileMappingRecord(configDatabase, configRecord, profileMappingID);
            result.add(profileMappingRecord);
        }
        return result;
    }

    public ProfileMappingRecord getRecord(String profileMappingID) throws Exception {
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        return this.createProfileMappingRecord(configDatabase, configRecord, profileMappingID);
    }

    public void addRecord(String profileMappingID, ProfileMappingRecord profileMappingRecord) throws Exception {
        logger.debug("ProfileMappingDatabase.addRecord(\"" + profileMappingID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        Map properties = profileMappingRecord.getProperties();
        configDatabase.validateProperties(configRecord, profileMappingID, properties);
        configRecord.addKey(profileMappingID);
        configDatabase.updateRecord(this.substoreName, configRecord);
        configDatabase.addProperties(configRecord, profileMappingID, properties);
        this.setRecordStatus(profileMappingID, profileMappingRecord.getStatus());
        configDatabase.commit();
    }

    public void updateRecord(String profileMappingID, ProfileMappingRecord profileMappingRecord) throws Exception {
        logger.debug("ProfileMappingDatabase.updateRecord(\"" + profileMappingID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        Map properties = profileMappingRecord.getProperties();
        configDatabase.validateProperties(configRecord, profileMappingID, properties);
        configDatabase.removeProperties(configRecord, profileMappingID);
        configDatabase.addProperties(configRecord, profileMappingID, properties);
        this.setRecordStatus(profileMappingID, profileMappingRecord.getStatus());
        configDatabase.commit();
    }

    public void removeRecord(String profileMappingID) throws Exception {
        logger.debug("ProfileMappingDatabase.removeRecord(\"" + profileMappingID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        configDatabase.removeProperties(configRecord, profileMappingID);
        configRecord.removeKey(profileMappingID);
        configDatabase.updateRecord(this.substoreName, configRecord);
        this.removeRecordStatus(profileMappingID);
        configDatabase.commit();
    }
}

