/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.LDAPDatabase;
import com.netscape.cmsutil.ldap.LDAPUtil;
import java.util.Date;
import java.util.Map;
import org.dogtagpki.server.tps.dbs.TokenRecord;

public class TokenDatabase
extends LDAPDatabase<TokenRecord> {
    public TokenDatabase(DBSubsystem dbSubsystem, String baseDN) throws EBaseException {
        super("Token", dbSubsystem, baseDN, TokenRecord.class);
    }

    public void addRecord(String id, TokenRecord tokenRecord) throws Exception {
        tokenRecord.setCreateTimestamp(new Date());
        super.addRecord(id, (IDBObj)tokenRecord);
    }

    public void updateRecord(String id, TokenRecord tokenRecord) throws Exception {
        tokenRecord.setModifyTimestamp(new Date());
        super.updateRecord(id, (IDBObj)tokenRecord);
    }

    public String createDN(String id) {
        return "cn=" + id + "," + this.baseDN;
    }

    public String createFilter(String keyword, Map<String, String> attributes) {
        StringBuilder sb = new StringBuilder();
        if (keyword != null) {
            keyword = LDAPUtil.escapeFilter((Object)keyword);
            sb.append("(|(id=*" + keyword + "*)(userID=*" + keyword + "*))");
        }
        this.createFilter(sb, attributes);
        if (sb.length() == 0) {
            sb.append("(objectClass=" + TokenRecord.class.getName() + ")");
        }
        return sb.toString();
    }
}

