/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.logging;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class LogEntry {
    private String mEntry;
    private String mLevel;
    private String mSource;
    private String mDetail;
    private String mDate;
    private String mTime;
    private Vector<String> mRow;
    private final String DATE_PATTERN = "dd/MMM/yyyy:HH:mm:ss z";

    public LogEntry(String entry) throws ParseException {
        this.mEntry = entry;
        this.mRow = this.parse();
    }

    public Vector<String> parse() throws ParseException {
        int x = this.mEntry.indexOf("[");
        if (x == -1) {
            throw new ParseException(this.mEntry, 0);
        }
        String temp = this.mEntry.substring(x + 1);
        if ((x = temp.indexOf("]")) == -1) {
            throw new ParseException(this.mEntry, 0);
        }
        String dateStr = temp.substring(0, x);
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss z");
        Date date = format.parse(dateStr);
        this.mDate = DateFormat.getDateInstance().format(date);
        this.mTime = DateFormat.getTimeInstance().format(date);
        if ((x = (temp = temp.substring(x + 2)).indexOf("]")) == -1) {
            throw new ParseException(this.mEntry, 0);
        }
        this.mSource = temp.substring(1, x);
        if ((x = (temp = temp.substring(x + 2)).indexOf("]")) == -1) {
            throw new ParseException(this.mEntry, 0);
        }
        this.mLevel = temp.substring(1, x);
        this.mDetail = temp.substring(x + 2);
        Vector<String> row = new Vector<String>();
        row.addElement(this.mSource);
        row.addElement(this.mLevel);
        row.addElement(this.mDate);
        row.addElement(this.mTime);
        row.addElement(this.mDetail);
        return row;
    }

    public String getSource() {
        return this.mSource;
    }

    public String getLevel() {
        return this.mLevel;
    }

    public String getDetail() {
        return this.mDetail;
    }

    public String getDate() {
        return this.mDate;
    }

    public String getTime() {
        return this.mTime;
    }

    public Vector<String> getRow() {
        return this.mRow;
    }

    public String getEntry() {
        return this.mEntry;
    }

    public void appendDetail(String msg) {
        this.mDetail = this.mDetail + "\n" + msg;
        this.mEntry = this.mEntry + "\n" + msg;
    }
}

