/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.base;

import com.netscape.certsrv.authentication.AuthMgrPlugin;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthManager;

public class DynamicVariablesServlet
extends CMSServlet {
    private static final long serialVersionUID = 7246774978153039460L;
    public static final String PROP_ACCESS = "ServletAccess";
    public static final String PROP_AUTHMGR = "AuthMgr";
    public static final String PROP_CLIENTAUTH = "GetClientCert";
    public static final String PROP_AUTHORITY = "authority";
    public static final String PROP_CLONING = "cloning";
    private static final String INFO = "dynamicVariables";
    private static final String PROP_DYNVAR = "dynamicVariables";
    private static final String PROP_CRLURL = "cloneMasterCrlUrl";
    private static final String VAR_SERVERDATE_STRING = "serverdate()";
    private static final Integer VAR_SERVERDATE = 1;
    private static final String VAR_SUBSYSTEMNAME_STRING = "subsystemname()";
    private static final Integer VAR_SUBSYSTEMNAME = 2;
    private String VAR_SUBSYSTEMNAME_VALUE = null;
    private static final String VAR_HTTP_STRING = "http()";
    private static final Integer VAR_HTTP = 3;
    private static final String VAR_AUTHMGRS_STRING = "authmgrs()";
    private static final Integer VAR_AUTHMGRS = 4;
    private static final String VAR_CLA_CRL_URL_STRING = "clacrlurl()";
    private static final Integer VAR_CLA_CRL_URL = 6;
    private String mAuthMgrCacheString = "";
    private long mAuthMgrCacheTime = 0L;
    private final int AUTHMGRCACHE = 10;
    private Hashtable<Integer, String> dynvars = null;
    private String mGetClientCert = "false";
    private String mAuthMgr = null;
    private ServletConfig mServletCfg;
    private ServletContext mServletCtx = null;

    public String getServletInfo() {
        return "dynamicVariables";
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mAuthMgr = sc.getInitParameter(PROP_AUTHMGR);
        this.mGetClientCert = sc.getInitParameter(PROP_CLIENTAUTH);
        this.mServletCfg = sc;
        this.mServletCtx = sc.getServletContext();
        this.VAR_SUBSYSTEMNAME_VALUE = sc.getInitParameter(PROP_AUTHORITY);
        try {
            String dynvarconfig = sc.getInitParameter("dynamicVariables");
            StringTokenizer s = new StringTokenizer(dynvarconfig, ",");
            this.dynvars = new Hashtable();
            while (s.hasMoreTokens()) {
                String token = s.nextToken();
                int i = token.indexOf(61);
                String varname = token.substring(0, i);
                String varvalue = token.substring(i + 1);
                Integer varcode = null;
                if (varvalue.equalsIgnoreCase(VAR_SERVERDATE_STRING)) {
                    varcode = VAR_SERVERDATE;
                } else if (varvalue.equalsIgnoreCase(VAR_SUBSYSTEMNAME_STRING)) {
                    varcode = VAR_SUBSYSTEMNAME;
                } else if (varvalue.equalsIgnoreCase(VAR_HTTP_STRING)) {
                    varcode = VAR_HTTP;
                } else if (varvalue.equalsIgnoreCase(VAR_AUTHMGRS_STRING)) {
                    varcode = VAR_AUTHMGRS;
                } else if (varvalue.equalsIgnoreCase(VAR_CLA_CRL_URL_STRING)) {
                    varcode = VAR_CLA_CRL_URL;
                } else {
                    throw new ServletException("bad configuration parameter in dynamicVariables");
                }
                if (varcode == null) continue;
                this.dynvars.put(varcode, varname);
            }
        }
        catch (Exception e) {
            this.dynvars = null;
        }
    }

    @Override
    public void service(HttpServletRequest httpReq, HttpServletResponse httpResp) throws ServletException, IOException {
        CMSEngine engine = this.getCMSEngine();
        boolean running_state = engine.isInRunningState();
        if (!running_state) {
            throw new IOException("CMS server is not ready to serve.");
        }
        if (this.mAuthMgr != null) {
            try {
                this.authenticate(httpReq);
            }
            catch (EBaseException e) {
                this.mServletCtx.log(CMS.getLogMessage("CMSGW_FILE_NO_ACCESS", e.toString()));
                httpResp.sendError(403);
                return;
            }
        }
        httpResp.setContentType("application/x-javascript");
        httpResp.setHeader("Pragma", "no-cache");
        try {
            ServletOutputStream os = httpResp.getOutputStream();
            if (os != null) {
                if (this.dynvars != null) {
                    String importCrlUrl = this.getImportCrlUrl();
                    Enumeration<Integer> k = this.dynvars.keys();
                    while (k.hasMoreElements()) {
                        Object toBeWritten;
                        Integer varcode = k.nextElement();
                        if (varcode.equals(VAR_SERVERDATE)) {
                            toBeWritten = this.dynvars.get(varcode) + "=" + this.getServerDate() + ";\n";
                            os.print((String)toBeWritten);
                        }
                        if (varcode.equals(VAR_SUBSYSTEMNAME) && this.getSubsystemName() != null) {
                            toBeWritten = this.dynvars.get(varcode) + "=\"" + this.getSubsystemName() + "\";\n";
                            os.print((String)toBeWritten);
                        }
                        if (varcode.equals(VAR_HTTP) && this.getHttp(httpReq) != null) {
                            toBeWritten = this.dynvars.get(varcode) + "=\"" + this.getHttp(httpReq) + "\";\n";
                            os.print((String)toBeWritten);
                        }
                        if (varcode.equals(VAR_CLA_CRL_URL) && importCrlUrl != null) {
                            toBeWritten = this.dynvars.get(varcode) + "=\"" + this.getImportCrlUrl() + "\";\n";
                            os.print((String)toBeWritten);
                        }
                        if (!varcode.equals(VAR_AUTHMGRS)) continue;
                        toBeWritten = "";
                        AuthSubsystem as = engine.getAuthSubsystem();
                        Enumeration<AuthManager> ame = as.getAuthManagers();
                        Date d = new Date();
                        long now = d.getTime();
                        if (now > this.mAuthMgrCacheTime + 10000L) {
                            int i = 0;
                            StringBuffer sb = new StringBuffer();
                            while (ame.hasMoreElements()) {
                                AuthManager am = ame.nextElement();
                                String amName = am.getImplName();
                                AuthMgrPlugin ap = as.getAuthManagerPluginImpl(amName);
                                if (!ap.isVisible()) continue;
                                sb.append("authmanager[");
                                sb.append(i);
                                sb.append("]=\"");
                                sb.append(amName);
                                sb.append("\";\n");
                                ++i;
                            }
                            this.mAuthMgrCacheString = toBeWritten = sb.toString();
                            this.mAuthMgrCacheTime = now;
                        } else {
                            toBeWritten = this.mAuthMgrCacheString;
                        }
                        if (((String)toBeWritten).length() == 0) continue;
                        os.print("authmanager = new Array();\n");
                        os.print((String)toBeWritten);
                    }
                }
                os.close();
            }
        }
        catch (IOException e) {
            throw new ServletException("couldn't get outputstream");
        }
    }

    private String getServerDate() {
        Date d = new Date();
        String now = Long.toString(d.getTime());
        return now;
    }

    private String getSubsystemName() {
        return this.VAR_SUBSYSTEMNAME_VALUE;
    }

    private String getHttp(HttpServletRequest httpReq) {
        return httpReq.isSecure() ? "false" : "true";
    }

    private String getImportCrlUrl() {
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        ConfigStore config = cs.getSubStore(PROP_CLONING, ConfigStore.class);
        String mCrlurl = "";
        try {
            mCrlurl = config.getString(PROP_CRLURL, "");
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
        return mCrlurl;
    }
}

