/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.DBVirtualList;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.DBRegistry;
import com.netscape.cmscore.dbs.ElementProcessor;
import java.util.Arrays;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPVirtualList<E extends IDBObj>
extends DBVirtualList<E> {
    public static Logger logger = LoggerFactory.getLogger(LDAPVirtualList.class);
    private DBRegistry mRegistry = null;
    private LDAPConnection mConn = null;
    private String mBase = null;
    private String mFilter = null;
    private String[] mAttrs = null;
    private int mSize = -1;
    private Vector<E> mEntries = new Vector();
    private boolean mInitialized = false;
    private LDAPSortKey[] mKeys;
    private LDAPControl[] mPageControls = null;
    private int mPageSize = 10;
    private int mTop = 0;
    private int mBeforeCount;
    private int mAfterCount;
    private int mSelectedIndex = 0;
    private int mJumpToIndex = 0;
    private int mJumpToInitialIndex = 0;
    private int mJumpToDirection = 1;
    private String mJumpTo = null;

    public LDAPVirtualList(DBRegistry registry, LDAPConnection c, String base, String filter, String[] attrs) throws EBaseException {
        this.mRegistry = registry;
        this.mFilter = filter;
        this.mBase = base;
        this.mAttrs = attrs;
        logger.debug("In LDAPVirtualList filter attrs filter: " + filter + " attrs: " + Arrays.toString(attrs));
        this.mPageControls = new LDAPControl[2];
        try {
            this.mConn = (LDAPConnection)c.clone();
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", e.toString()));
        }
    }

    public LDAPVirtualList(DBRegistry registry, LDAPConnection c, String base, String filter, String[] attrs, String[] sortKey) throws EBaseException {
        logger.debug("In LDAPVirtualList filter attrs sotrKey[]  filter: " + filter + " attrs: " + Arrays.toString(attrs));
        this.mRegistry = registry;
        this.mFilter = filter;
        try {
            this.mConn = (LDAPConnection)c.clone();
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", e.toString()));
        }
        this.mBase = base;
        this.mAttrs = attrs;
        this.mPageControls = new LDAPControl[2];
        this.setSortKey(sortKey);
    }

    public LDAPVirtualList(DBRegistry registry, LDAPConnection c, String base, String filter, String[] attrs, String sortKey) throws EBaseException {
        logger.debug("In LDAPVirtualList filter attrs sortKey   filter: " + filter + " attrs: " + Arrays.toString(attrs));
        this.mRegistry = registry;
        this.mFilter = filter;
        try {
            this.mConn = (LDAPConnection)c.clone();
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", e.toString()));
        }
        this.mBase = base;
        this.mAttrs = attrs;
        this.mPageControls = new LDAPControl[2];
        this.setSortKey(sortKey);
    }

    public LDAPVirtualList(DBRegistry registry, LDAPConnection c, String base, String filter, String[] attrs, String[] sortKey, int pageSize) throws EBaseException {
        logger.debug("In LDAPVirtualList filter attrs sortKey[] pageSize filter: " + filter + " attrs: " + Arrays.toString(attrs) + " pageSize " + pageSize);
        this.mRegistry = registry;
        this.mFilter = filter;
        try {
            this.mConn = (LDAPConnection)c.clone();
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", e.toString()));
        }
        this.mBase = base;
        this.mAttrs = attrs;
        this.mPageControls = new LDAPControl[2];
        this.setSortKey(sortKey);
        this.setPageSize(pageSize);
    }

    public LDAPVirtualList(DBRegistry registry, LDAPConnection c, String base, String filter, String[] attrs, String sortKey, int pageSize) throws EBaseException {
        logger.debug("In LDAPVirtualList filter attrs sortKey pageSize filter: " + filter + " attrs: " + Arrays.toString(attrs) + " pageSize " + pageSize);
        this.mRegistry = registry;
        this.mFilter = filter;
        try {
            this.mConn = (LDAPConnection)c.clone();
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", e.toString()));
        }
        this.mBase = base;
        this.mAttrs = attrs;
        this.mPageControls = new LDAPControl[2];
        this.setSortKey(sortKey);
        this.setPageSize(pageSize);
    }

    public LDAPVirtualList(DBRegistry registry, LDAPConnection c, String base, String filter, String[] attrs, String startFrom, String sortKey, int pageSize) throws EBaseException {
        logger.debug("In LDAPVirtualList filter attrs startFrom sortKey pageSize filter: " + filter + " attrs: " + Arrays.toString(attrs) + " pageSize " + pageSize + " startFrom " + startFrom);
        this.mRegistry = registry;
        this.mFilter = filter;
        try {
            this.mConn = (LDAPConnection)c.clone();
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage("CMS_BASE_CONN_FAILED", e.toString()));
        }
        this.mBase = base;
        this.mAttrs = attrs;
        this.mPageControls = new LDAPControl[2];
        this.mJumpTo = startFrom;
        this.setSortKey(sortKey);
        if (pageSize < 0) {
            this.mJumpToDirection = -1;
        }
        this.mPageSize = pageSize;
        this.mBeforeCount = 0;
        this.mAfterCount = this.mPageSize;
    }

    @Override
    public void setPageSize(int size) {
        if (this.mJumpTo != null) {
            return;
        }
        this.mPageSize = size;
        this.mBeforeCount = 0;
        this.mAfterCount = this.mPageSize;
    }

    @Override
    public void setSortKey(String sortKey) throws EBaseException {
        String[] keys = new String[]{sortKey};
        this.setSortKey(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSortKey(String[] sortKeys) throws EBaseException {
        if (sortKeys == null) {
            throw new EBaseException("sort keys cannot be null");
        }
        this.mKeys = new LDAPSortKey[sortKeys.length];
        String[] la = null;
        LDAPVirtualList lDAPVirtualList = this;
        synchronized (lDAPVirtualList) {
            la = this.mRegistry.getLDAPAttributes(sortKeys);
        }
        if (la == null) {
            throw new EBaseException("sort keys cannot be null");
        }
        for (int i = 0; i < sortKeys.length; ++i) {
            this.mKeys[i] = new LDAPSortKey(la[i]);
        }
        if (this.mKeys == null) {
            throw new EBaseException("sort keys cannot be null");
        }
        this.mPageControls[0] = new LDAPSortControl(this.mKeys, true);
    }

    @Override
    public int getSize() {
        if (!this.mInitialized) {
            this.mInitialized = true;
            if (this.mJumpTo == null) {
                this.mBeforeCount = 0;
                this.mAfterCount = this.mPageSize;
            }
            LDAPVirtualListControl cont = null;
            if (this.mJumpTo == null) {
                logger.debug("LDAPVirtualList: searching for entry A");
                cont = new LDAPVirtualListControl("A", this.mBeforeCount, this.mAfterCount);
            } else {
                logger.debug("LDAPVirtualList: searching for entry " + this.mJumpTo);
                if (this.mPageSize < 0) {
                    this.mBeforeCount = this.mPageSize * -1;
                    this.mAfterCount = 0;
                }
                cont = new LDAPVirtualListControl(this.mJumpTo, this.mBeforeCount, this.mAfterCount);
            }
            this.mPageControls[1] = cont;
            this.getJumpToPage();
        }
        logger.debug("LDAPVirtualList: size: " + this.mSize);
        return this.mSize;
    }

    @Override
    public int getSizeBeforeJumpTo() {
        if (!this.mInitialized || this.mJumpTo == null) {
            return 0;
        }
        int size = 0;
        size = this.mJumpToDirection < 0 ? this.mTop + this.mEntries.size() : this.mTop;
        return size;
    }

    @Override
    public int getSizeAfterJumpTo() {
        if (!this.mInitialized || this.mJumpTo == null) {
            return 0;
        }
        int size = this.mSize - this.mTop;
        return size;
    }

    /*
     * Exception decompiling
     */
    private synchronized boolean getEntries() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getCurrentIndex() {
        return this.mTop;
    }

    private synchronized boolean getJumpToPage() {
        try {
            if (!this.getEntries()) {
                return false;
            }
            LDAPControl[] c = this.mConn.getResponseControls();
            LDAPVirtualListResponse nextCont = null;
            if (c != null) {
                for (LDAPControl control : c) {
                    if (!(control instanceof LDAPVirtualListResponse)) continue;
                    nextCont = (LDAPVirtualListResponse)control;
                    break;
                }
            }
            if (nextCont != null) {
                this.mSelectedIndex = nextCont.getFirstPosition() - 1;
                this.mTop = Math.max(0, this.mSelectedIndex - this.mBeforeCount);
                logger.debug("LDAPVirtualList: top: " + this.mTop);
                if (this.mJumpTo != null) {
                    this.mJumpToInitialIndex = this.mTop;
                }
                this.mSize = nextCont.getContentCount();
                ((LDAPVirtualListControl)this.mPageControls[1]).setListSize(this.mSize);
                this.mInitialized = true;
            } else {
                logger.warn(CMS.getLogMessage("CMSCORE_DBS_VL_NULL_RESPONSE", new Object[0]));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean getPage(int first) {
        logger.debug("LDAPVirtualList.getPage(" + first + ")");
        if (!this.mInitialized) {
            LDAPVirtualListControl cont = new LDAPVirtualListControl(0, this.mBeforeCount, this.mAfterCount, 0);
            this.mPageControls[1] = cont;
        }
        ((LDAPVirtualListControl)this.mPageControls[1]).setRange(first, this.mBeforeCount, this.mAfterCount);
        return this.getPage();
    }

    private boolean getPage() {
        if (!this.getEntries()) {
            return false;
        }
        LDAPControl[] c = this.mConn.getResponseControls();
        LDAPVirtualListResponse nextCont = null;
        if (c != null) {
            for (LDAPControl control : c) {
                if (!(control instanceof LDAPVirtualListResponse)) continue;
                nextCont = (LDAPVirtualListResponse)control;
                break;
            }
        }
        if (nextCont != null) {
            this.mSelectedIndex = nextCont.getFirstPosition() - 1;
            this.mTop = Math.max(0, this.mSelectedIndex - this.mBeforeCount);
            this.mSize = nextCont.getContentCount();
            ((LDAPVirtualListControl)this.mPageControls[1]).setListSize(this.mSize);
            this.mInitialized = true;
        } else {
            logger.warn(CMS.getLogMessage("CMSCORE_DBS_VL_NULL_RESPONSE", new Object[0]));
        }
        return true;
    }

    @Override
    public boolean getPage(String text) {
        this.mPageControls[1] = new LDAPVirtualListControl(text, this.mBeforeCount, this.mAfterCount);
        return this.getPage();
    }

    @Override
    public E getElementAt(int index) {
        int offset;
        if (!this.mInitialized) {
            this.mSize = this.getSize();
        }
        if (index < 0 || index >= this.mSize) {
            logger.warn("LDAPVirtualList: returning null");
            return null;
        }
        if (this.mJumpTo != null) {
            this.mJumpToIndex = index == 0 ? 0 : ++this.mJumpToIndex;
            if (this.mJumpToDirection > 0 && this.mJumpToInitialIndex + index >= this.mSize) {
                logger.warn("mJumpTo virtual list exhausted   mTop " + this.mTop + " mSize " + this.mSize);
                return null;
            }
            if (this.mJumpToIndex >= this.mEntries.size()) {
                this.mJumpToIndex = 0;
                if (this.mJumpToDirection > 0) {
                    this.getPage(index + this.mJumpToInitialIndex + 1);
                } else {
                    if (this.mTop == 0) {
                        this.getPage(0);
                        logger.warn("asking for a page less than zero in reverse case, return null");
                        return null;
                    }
                    logger.debug("getting page reverse mJumptoIndex  " + this.mJumpToIndex + " mTop " + this.mTop);
                    this.getPage(this.mTop);
                }
            }
            if (this.mJumpToDirection > 0) {
                return (E)((IDBObj)this.mEntries.elementAt(this.mJumpToIndex));
            }
            int reverse_index = this.mEntries.size() - this.mJumpToIndex - 1;
            if (reverse_index < 0 || reverse_index >= this.mEntries.size()) {
                logger.warn("reverse_index out of range " + reverse_index);
                return null;
            }
            return (E)((IDBObj)this.mEntries.elementAt(reverse_index));
        }
        if (index < this.mTop || index >= this.mTop + this.mEntries.size()) {
            this.getPage(index);
        }
        return (E)((offset = index - this.mTop) < 0 || offset >= this.mEntries.size() ? null : (IDBObj)this.mEntries.elementAt(offset));
    }

    @Override
    public E getJumpToElementAt(int i) {
        return (E)((IDBObj)this.mEntries.elementAt(i));
    }

    @Override
    public void processElements(int startidx, int endidx, ElementProcessor ep) throws EBaseException {
        if (!this.mInitialized) {
            this.mSize = this.getSize();
        }
        if (this.mJumpTo != null) {
            for (int i = startidx; i <= endidx; ++i) {
                E element = this.getJumpToElementAt(i);
                if (element == null) continue;
                ep.process(element);
            }
            return;
        }
        if (startidx >= endidx) {
            throw new EBaseException("startidx must be less than endidx");
        }
        this.setPageSize(endidx - startidx);
        this.getPage(startidx);
        for (int i = startidx; i <= endidx; ++i) {
            E element = this.getElementAt(i);
            if (element == null) continue;
            ep.process(element);
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.mSelectedIndex;
    }

    @Override
    public int getFirstIndex() {
        return this.mTop;
    }
}

