/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.request.IRequestVirtualList;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmscore.request.RunListeners;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestNotifier {
    public static Logger logger = LoggerFactory.getLogger(RequestNotifier.class);
    protected CMSEngine engine;
    private Hashtable<String, RequestListener> mListeners = new Hashtable();
    private Vector<Thread> mNotifierThreads = new Vector();
    private Vector<String> mRequests = new Vector();
    private int mMaxRequests = 100;
    private boolean mSearchForRequests = false;
    private int mMaxThreads = 1;
    private boolean mIsPublishingQueueEnabled = false;
    private int mPublishingQueuePriority = 0;
    private String mPublishingStatus = null;
    private int mSavePublishingStatus = 0;
    private int mSavePublishingCounter = 0;
    private Object publishingCounterMonitor = new Object();

    public RequestNotifier() {
        this.mPublishingQueuePriority = Thread.currentThread().getPriority();
    }

    public CMSEngine getCMSEngine() {
        return this.engine;
    }

    public void setCMSEngine(CMSEngine engine) {
        this.engine = engine;
    }

    public void setPublishingQueue(boolean isPublishingQueueEnabled, int publishingQueuePriorityLevel, int maxNumberOfPublishingThreads, int publishingQueuePageSize, int savePublishingStatus) {
        logger.debug("setPublishingQueue:  Publishing Queue Enabled: " + isPublishingQueueEnabled + "  Priority Level: " + publishingQueuePriorityLevel + "  Maximum Number of Threads: " + maxNumberOfPublishingThreads + "  Page Size: " + publishingQueuePageSize);
        this.mIsPublishingQueueEnabled = isPublishingQueueEnabled;
        this.mMaxThreads = maxNumberOfPublishingThreads;
        this.mMaxRequests = publishingQueuePageSize;
        this.mSavePublishingStatus = savePublishingStatus;
        this.mPublishingQueuePriority = publishingQueuePriorityLevel > 1 ? 10 : (publishingQueuePriorityLevel > 0 ? (Thread.currentThread().getPriority() + 10) / 2 : (publishingQueuePriorityLevel < -1 ? 1 : (publishingQueuePriorityLevel < 0 ? (Thread.currentThread().getPriority() + 1) / 2 : Thread.currentThread().getPriority())));
        RequestRepository requestRepository = this.engine.getRequestRepository();
        if (this.mIsPublishingQueueEnabled && this.mSavePublishingStatus > 0 && requestRepository != null) {
            this.mPublishingStatus = requestRepository.getPublishingStatus();
            try {
                BigInteger status = new BigInteger(this.mPublishingStatus);
                if (status.compareTo(BigInteger.ZERO) > -1) {
                    this.recoverPublishingQueue(this.mPublishingStatus);
                }
            }
            catch (Exception e) {
                logger.warn("setPublishingQueue:  Exception: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void registerListener(RequestListener listener) {
        this.mListeners.put(listener.getClass().getName(), listener);
    }

    public void registerListener(String name, RequestListener listener) {
        this.mListeners.put(name, listener);
    }

    public void removeListener(RequestListener listener) {
        this.mListeners.remove(listener.getClass().getName());
    }

    public Enumeration<String> getListenerNames() {
        return this.mListeners.keys();
    }

    public void removeListener(String name) {
        this.mListeners.remove(name);
    }

    public RequestListener getListener(String name) {
        return this.mListeners.get(name);
    }

    public Enumeration<RequestListener> getListeners() {
        return this.mListeners.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePublishingStatus(String id) {
        RequestRepository requestRepository = this.engine.getRequestRepository();
        if (requestRepository != null) {
            Object object = this.publishingCounterMonitor;
            synchronized (object) {
                if (this.mSavePublishingCounter == 0) {
                    logger.debug("updatePublishingStatus  requestId: " + id);
                    requestRepository.setPublishingStatus(id);
                }
                ++this.mSavePublishingCounter;
                logger.debug("updatePublishingStatus  mSavePublishingCounter: " + this.mSavePublishingCounter + " mSavePublishingStatus: " + this.mSavePublishingStatus);
                if (this.mSavePublishingCounter >= this.mSavePublishingStatus) {
                    this.mSavePublishingCounter = 0;
                }
            }
        } else {
            logger.warn("updatePublishingStatus  requestQueue == null");
        }
    }

    public synchronized Request getRequest() {
        RequestRepository requestRepository;
        Request r = null;
        String id = null;
        logger.debug("getRequest  mRequests=" + this.mRequests.size() + "  mSearchForRequests=" + this.mSearchForRequests);
        if (this.mSearchForRequests && this.mRequests.size() == 1) {
            id = this.mRequests.elementAt(0);
            requestRepository = this.engine.getRequestRepository();
            if (id != null && requestRepository != null) {
                IRequestVirtualList list;
                logger.debug("getRequest  request id=" + id);
                try {
                    list = requestRepository.getPagedRequestsByFilter(new RequestId(id), false, "(requeststate=complete)", this.mMaxRequests, "requestId");
                }
                catch (EBaseException e) {
                    throw new RuntimeException(e);
                }
                int s = list.getSize() - list.getCurrentIndex();
                logger.debug("getRequest  list size: " + s);
                for (int i = 0; i < s; ++i) {
                    String requestType;
                    r = null;
                    try {
                        r = list.getElementAt(i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (r == null || (requestType = r.getRequestType()) == null || !requestType.equals("enrollment") && !requestType.equals("renewal") && !requestType.equals("revocation") && !requestType.equals("CMCRevReq") && !requestType.equals("unrevocation")) continue;
                    if (i == 0 && id.equals(r.getRequestId().toString())) {
                        if (s != 1) continue;
                        break;
                    }
                    if (this.mRequests.size() >= this.mMaxRequests) break;
                    this.mRequests.addElement(r.getRequestId().toString());
                    logger.debug("getRequest  added " + r.getRequestType() + " request " + r.getRequestId().toString() + " to mRequests: " + this.mRequests.size() + " (" + this.mMaxRequests + ")");
                }
                logger.debug("getRequest  done with adding requests to mRequests: " + this.mRequests.size());
            } else {
                logger.warn("getRequest  has no access to the request queue");
            }
        }
        if (this.mRequests.size() > 0) {
            id = this.mRequests.elementAt(0);
            if (id != null) {
                logger.debug("getRequest  getting request: " + id);
                requestRepository = this.engine.getRequestRepository();
                if (requestRepository != null) {
                    try {
                        r = requestRepository.readRequest(new RequestId(id));
                        this.mRequests.remove(0);
                        logger.debug("getRequest  request " + id + (r != null ? " found" : " not found"));
                    }
                    catch (EBaseException e) {
                        logger.warn("getRequest  Exception: " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    logger.warn("getRequest  has no access to the request queue");
                }
            }
            if (this.mRequests.size() == 0) {
                this.mSearchForRequests = false;
            }
        }
        logger.debug("getRequest  mRequests=" + this.mRequests.size() + "  mSearchForRequests=" + this.mSearchForRequests + " done");
        return r;
    }

    public int getNumberOfRequests() {
        return this.mRequests.size();
    }

    public boolean isPublishingQueueEnabled() {
        return this.mIsPublishingQueueEnabled;
    }

    public void removeNotifierThread(Thread notifierThread) {
        if (this.mNotifierThreads.size() > 0) {
            RequestRepository requestRepository;
            this.mNotifierThreads.remove(notifierThread);
            if (this.mNotifierThreads.size() == 0 && (requestRepository = this.engine.getRequestRepository()) != null) {
                requestRepository.setPublishingStatus("-1");
            }
        }
        logger.debug("Number of publishing threads: " + this.mNotifierThreads.size());
    }

    public void notify(Request r) {
        block4: {
            block5: {
                block3: {
                    logger.info("RequestNotifier: Request " + r.getRequestId().toHexString() + " " + r.getRequestStatus());
                    logger.info("RequestNotifier: - publishing queue enabled: " + this.mIsPublishingQueueEnabled);
                    logger.info("RequestNotifier: - max threads: " + this.mMaxThreads);
                    if (!this.mIsPublishingQueueEnabled) break block3;
                    logger.info("RequestNotifier: Notifying " + this.mListeners.size() + " listener(s) through a queue");
                    this.addToNotify(r);
                    break block4;
                }
                if (this.mMaxThreads != 0) break block5;
                logger.info("RequestNotifier: Notifying " + this.mListeners.size() + " listener(s) synchronously");
                Enumeration<RequestListener> listeners = this.mListeners.elements();
                if (listeners == null || r == null) break block4;
                while (listeners.hasMoreElements()) {
                    RequestListener l = listeners.nextElement();
                    logger.info("RequestNotifier: Processing request " + r.getRequestId().toHexString() + " with " + l.getClass().getSimpleName());
                    l.accept(r);
                }
                break block4;
            }
            logger.info("RequestNotifier: Notifying " + this.mListeners.size() + " listener(s) asynchronously");
            try {
                new Thread((Runnable)new RunListeners(r, this.mListeners.elements()), "RequestNotifier-notify").start();
            }
            catch (Throwable e) {
                logger.warn("Could not run listeners for request " + r.getRequestId().toHexString() + ": " + e.getMessage(), e);
            }
        }
    }

    public boolean checkAvailablePublishingConnections() {
        return false;
    }

    private boolean morePublishingThreads() {
        boolean moreThreads = false;
        if (this.mNotifierThreads.size() == 0) {
            moreThreads = true;
        } else if (this.mNotifierThreads.size() < this.mMaxThreads) {
            logger.debug("morePublishingThreads  (" + this.mRequests.size() + ">" + this.mMaxRequests * this.mNotifierThreads.size() / this.mMaxThreads + " (" + this.mMaxRequests + "*" + this.mNotifierThreads.size() + "):" + this.mMaxThreads);
            if (this.mRequests.size() > this.mMaxRequests * this.mNotifierThreads.size() / this.mMaxThreads && this.checkAvailablePublishingConnections()) {
                moreThreads = true;
            }
        }
        logger.debug("morePublishingThreads  moreThreads: " + moreThreads);
        return moreThreads;
    }

    public synchronized void addToNotify(Request r) {
        logger.info("RequestNotifier: Notifying all listeners for request " + r.getRequestId().toHexString());
        if (!this.mSearchForRequests) {
            logger.info("RequestNotifier: - max requests: " + this.mMaxRequests);
            logger.info("RequestNotifier: - buffer size: " + this.mRequests.size());
            if (this.mRequests.size() < this.mMaxRequests) {
                logger.info("RequestNotifier: Extending buffer");
                this.mRequests.addElement(r.getRequestId().toString());
                if (this.morePublishingThreads()) {
                    try {
                        Thread notifierThread = new Thread((Runnable)new RunListeners(this), "RequestNotifier-addToNotify");
                        if (notifierThread != null) {
                            this.mNotifierThreads.addElement(notifierThread);
                            logger.info("RequestNotifier: - publishing threads: " + this.mNotifierThreads.size());
                            if (this.mPublishingQueuePriority > 0) {
                                notifierThread.setPriority(this.mPublishingQueuePriority);
                            }
                            notifierThread.start();
                        }
                    }
                    catch (Throwable e) {
                        logger.warn("Unable to notify listeners: " + e.getMessage(), e);
                    }
                }
            } else {
                this.mSearchForRequests = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverPublishingQueue(String id) {
        logger.info("RequestNotifier: Recovering publishing queue for request " + id);
        logger.info("RequestNotifier: - requests: " + this.mRequests.size());
        logger.info("RequestNotifier: - max requests: " + this.mMaxRequests);
        if (this.mRequests.size() == 0) {
            logger.info("RequestNotifier: Extending buffer");
            this.mRequests.addElement(id);
            if (this.morePublishingThreads()) {
                RequestNotifier requestNotifier = this;
                synchronized (requestNotifier) {
                    this.mSearchForRequests = true;
                }
                try {
                    Thread notifierThread = new Thread((Runnable)new RunListeners(this), "RequestNotifier-recoverPublishingQueue");
                    if (notifierThread != null) {
                        this.mNotifierThreads.addElement(notifierThread);
                        logger.info("RequestNotifier: - publishing threads: " + this.mNotifierThreads.size());
                        if (this.mPublishingQueuePriority > 0) {
                            notifierThread.setPriority(this.mPublishingQueuePriority);
                        }
                        notifierThread.start();
                    }
                }
                catch (Throwable e) {
                    logger.warn("Unable to recover publishing queue: " + e.getMessage(), e);
                }
            }
        }
    }
}

