/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tomcat;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKITrustManager
implements X509TrustManager {
    static final Logger logger = LoggerFactory.getLogger(PKITrustManager.class);
    static final String SERVER_AUTH_OID = "1.3.6.1.5.5.7.3.1";
    static final String CLIENT_AUTH_OID = "1.3.6.1.5.5.7.3.2";

    public void checkCertChain(X509Certificate[] certChain, String keyUsage) throws Exception {
        logger.debug("PKITrustManager: checkCertChain(" + keyUsage + ")");
        for (X509Certificate cert : certChain = Cert.sortCertificateChain((X509Certificate[])certChain)) {
            logger.debug("PKITrustManager:  - " + cert.getSubjectDN());
        }
        X509Certificate[] caCerts = this.getAcceptedIssuers();
        for (int i = 0; i < certChain.length; ++i) {
            X509Certificate cert = certChain[i];
            String usage = i == certChain.length - 1 ? keyUsage : null;
            this.checkCert(cert, caCerts, usage);
            caCerts = new X509Certificate[]{cert};
        }
    }

    public void checkCert(X509Certificate cert, X509Certificate[] caCerts, String keyUsage) throws Exception {
        logger.debug("PKITrustManager: checkCert(" + cert.getSubjectDN() + "):");
        boolean[] aki = cert.getIssuerUniqueID();
        logger.debug("PKITrustManager: cert AKI: " + Arrays.toString(aki));
        X509Certificate issuer = null;
        for (X509Certificate caCert : caCerts) {
            boolean[] ski = caCert.getSubjectUniqueID();
            logger.debug("PKITrustManager: SKI of " + caCert.getSubjectDN() + ": " + Arrays.toString(ski));
            try {
                cert.verify(caCert.getPublicKey(), "Mozilla-JSS");
                issuer = caCert;
                break;
            }
            catch (Exception e) {
                logger.debug("PKITrustManager: invalid certificate: " + e);
            }
        }
        if (issuer == null) {
            throw new CertificateException("Unable to validate signature: " + cert.getSubjectDN());
        }
        logger.debug("PKITrustManager: cert signed by " + issuer.getSubjectDN());
        logger.debug("PKITrustManager: checking validity range:");
        logger.debug("PKITrustManager:  - not before: " + cert.getNotBefore());
        logger.debug("PKITrustManager:  - not after: " + cert.getNotAfter());
        cert.checkValidity();
        if (keyUsage != null) {
            List<String> extendedKeyUsages = cert.getExtendedKeyUsage();
            logger.debug("PKITrustManager: checking extended key usages:");
            for (String extKeyUsage : extendedKeyUsages) {
                logger.debug("PKITrustManager:  - " + extKeyUsage);
            }
            if (extendedKeyUsages.contains(keyUsage)) {
                logger.debug("PKITrustManager: extended key usage found: " + keyUsage);
            } else {
                throw new CertificateException("Missing extended key usage: " + keyUsage);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certChain, String authType) throws CertificateException {
        logger.debug("PKITrustManager: checkClientTrusted(" + authType + "):");
        try {
            this.checkCertChain(certChain, CLIENT_AUTH_OID);
            logger.debug("PKITrustManager: SSL client certificate is valid");
        }
        catch (CertificateException e) {
            logger.warn("Invalid SSL client certificate: " + e);
            throw e;
        }
        catch (Exception e) {
            logger.warn("Unable to validate certificate: " + e);
            throw new CertificateException(e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certChain, String authType) throws CertificateException {
        logger.debug("PKITrustManager: checkServerTrusted(" + certChain.length + ", " + authType + "):");
        try {
            this.checkCertChain(certChain, SERVER_AUTH_OID);
            logger.debug("PKITrustManager: SSL server certificate is valid");
        }
        catch (CertificateException e) {
            logger.warn("Invalid SSL server certificate: " + e);
            throw e;
        }
        catch (Exception e) {
            logger.warn("Unable to validate SSL server certificate: " + e);
            throw new CertificateException(e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        logger.debug("PKITrustManager: getAcceptedIssuers():");
        ArrayList<X509CertImpl> caCerts = new ArrayList<X509CertImpl>();
        try {
            CryptoManager manager = CryptoManager.getInstance();
            for (org.mozilla.jss.crypto.X509Certificate cert : manager.getCACerts()) {
                logger.debug("PKITrustManager:  - " + cert.getSubjectDN());
                try {
                    X509CertImpl caCert = new X509CertImpl(cert.getEncoded());
                    caCert.checkValidity();
                    caCerts.add(caCert);
                }
                catch (Exception e) {
                    logger.debug("PKITrustManager: invalid CA certificate: " + e);
                }
            }
        }
        catch (NotInitializedException e) {
            logger.error("Unable to get CryptoManager: " + e, (Throwable)e);
            throw new RuntimeException(e);
        }
        return caCerts.toArray(new X509Certificate[caCerts.size()]);
    }
}

