/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Date;
import org.dogtagpki.acme.ACME;
import org.dogtagpki.acme.ACMEChallenge;
import org.dogtagpki.acme.ACMEIdentifier;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ACMEAuthorization {
    @JsonIgnore
    private String id;
    @JsonIgnore
    private String accountID;
    @JsonIgnore
    private Date creationTime;
    @JsonIgnore
    private Date expirationTime;
    private String status;
    private String expires;
    private ACMEIdentifier identifier;
    private Collection<ACMEChallenge> challenges;
    private Boolean wildcard;

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
        this.expires = expirationTime == null ? null : ACME.DATE_FORMAT.format(expirationTime);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getExpires() {
        return this.expires;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public ACMEIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(ACMEIdentifier identifier) {
        this.identifier = identifier;
    }

    public Collection<ACMEChallenge> getChallenges() {
        return this.challenges;
    }

    public ACMEChallenge getChallenge(String challengeID) {
        if (this.challenges != null) {
            for (ACMEChallenge challenge : this.challenges) {
                if (!challenge.getID().equals(challengeID)) continue;
                return challenge;
            }
        }
        return null;
    }

    public void setChallenges(Collection<ACMEChallenge> challenges) {
        this.challenges = challenges;
    }

    public Boolean getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
    }

    public String toJSON() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static ACMEAuthorization fromJSON(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (ACMEAuthorization)mapper.readValue(json, ACMEAuthorization.class);
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

