// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_ext_autogen.cpp:
//   Capture functions for the OpenGL ES extension entry points.

#include "libANGLE/capture_gles_ext_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/FrameCapture.h"
#include "libANGLE/gl_enum_utils.h"
#include "libANGLE/validationESEXT.h"

using namespace angle;

namespace gl
{

CallCapture CaptureDrawArraysInstancedBaseInstanceANGLE(const State &glState,
                                                        bool isCallValid,
                                                        PrimitiveMode modePacked,
                                                        GLint first,
                                                        GLsizei count,
                                                        GLsizei instanceCount,
                                                        GLuint baseInstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("instanceCount", ParamType::TGLsizei, instanceCount);
    paramBuffer.addValueParam("baseInstance", ParamType::TGLuint, baseInstance);

    return CallCapture(gl::EntryPoint::DrawArraysInstancedBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertexBaseInstanceANGLE(const State &glState,
                                                                    bool isCallValid,
                                                                    PrimitiveMode modePacked,
                                                                    GLsizei count,
                                                                    DrawElementsType typePacked,
                                                                    const GLvoid *indices,
                                                                    GLsizei instanceCounts,
                                                                    GLint baseVertex,
                                                                    GLuint baseInstance)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseVertexBaseInstanceANGLE_indices(
            glState, isCallValid, modePacked, count, typePacked, indices, instanceCounts,
            baseVertex, baseInstance, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, static_cast<const GLvoid *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instanceCounts", ParamType::TGLsizei, instanceCounts);
    paramBuffer.addValueParam("baseVertex", ParamType::TGLint, baseVertex);
    paramBuffer.addValueParam("baseInstance", ParamType::TGLuint, baseInstance);

    return CallCapture(gl::EntryPoint::DrawElementsInstancedBaseVertexBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysInstancedBaseInstanceANGLE(const State &glState,
                                                             bool isCallValid,
                                                             PrimitiveMode modePacked,
                                                             const GLint *firsts,
                                                             const GLsizei *counts,
                                                             const GLsizei *instanceCounts,
                                                             const GLuint *baseInstances,
                                                             GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
        CaptureMultiDrawArraysInstancedBaseInstanceANGLE_firsts(
            glState, isCallValid, modePacked, firsts, counts, instanceCounts, baseInstances,
            drawcount, &firstsParam);
        paramBuffer.addParam(std::move(firstsParam));
    }
    else
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &firstsParam.value);
        paramBuffer.addParam(std::move(firstsParam));
    }

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawArraysInstancedBaseInstanceANGLE_counts(
            glState, isCallValid, modePacked, firsts, counts, instanceCounts, baseInstances,
            drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    if (isCallValid)
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
        CaptureMultiDrawArraysInstancedBaseInstanceANGLE_instanceCounts(
            glState, isCallValid, modePacked, firsts, counts, instanceCounts, baseInstances,
            drawcount, &instanceCountsParam);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }
    else
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &instanceCountsParam.value);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }

    if (isCallValid)
    {
        ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, baseInstances, &baseInstancesParam.value);
        CaptureMultiDrawArraysInstancedBaseInstanceANGLE_baseInstances(
            glState, isCallValid, modePacked, firsts, counts, instanceCounts, baseInstances,
            drawcount, &baseInstancesParam);
        paramBuffer.addParam(std::move(baseInstancesParam));
    }
    else
    {
        ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &baseInstancesParam.value);
        paramBuffer.addParam(std::move(baseInstancesParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawArraysInstancedBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(
    const State &glState,
    bool isCallValid,
    PrimitiveMode modePacked,
    const GLsizei *counts,
    DrawElementsType typePacked,
    const GLvoid *const *indices,
    const GLsizei *instanceCounts,
    const GLint *baseVertices,
    const GLuint *baseInstances,
    GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_counts(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
        InitParamValue(ParamType::TGLvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_indices(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
        InitParamValue(ParamType::TGLvoidConstPointerPointer,
                       static_cast<const GLvoid *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    if (isCallValid)
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_instanceCounts(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &instanceCountsParam);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }
    else
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &instanceCountsParam.value);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }

    if (isCallValid)
    {
        ParamCapture baseVerticesParam("baseVertices", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, baseVertices, &baseVerticesParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_baseVertices(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &baseVerticesParam);
        paramBuffer.addParam(std::move(baseVerticesParam));
    }
    else
    {
        ParamCapture baseVerticesParam("baseVertices", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &baseVerticesParam.value);
        paramBuffer.addParam(std::move(baseVerticesParam));
    }

    if (isCallValid)
    {
        ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, baseInstances, &baseInstancesParam.value);
        CaptureMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE_baseInstances(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            baseVertices, baseInstances, drawcount, &baseInstancesParam);
        paramBuffer.addParam(std::move(baseInstancesParam));
    }
    else
    {
        ParamCapture baseInstancesParam("baseInstances", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &baseInstancesParam.value);
        paramBuffer.addParam(std::move(baseInstancesParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureCopyTexture3DANGLE(const State &glState,
                                      bool isCallValid,
                                      TextureID sourceIdPacked,
                                      GLint sourceLevel,
                                      TextureTarget destTargetPacked,
                                      TextureID destIdPacked,
                                      GLint destLevel,
                                      GLint internalFormat,
                                      GLenum destType,
                                      GLboolean unpackFlipY,
                                      GLboolean unpackPremultiplyAlpha,
                                      GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLint, internalFormat);
    paramBuffer.addEnumParam("destType", GLenumGroup::DefaultGroup, ParamType::TGLenum, destType);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(gl::EntryPoint::CopyTexture3DANGLE, std::move(paramBuffer));
}

CallCapture CaptureCopySubTexture3DANGLE(const State &glState,
                                         bool isCallValid,
                                         TextureID sourceIdPacked,
                                         GLint sourceLevel,
                                         TextureTarget destTargetPacked,
                                         TextureID destIdPacked,
                                         GLint destLevel,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLint zoffset,
                                         GLint x,
                                         GLint y,
                                         GLint z,
                                         GLint width,
                                         GLint height,
                                         GLint depth,
                                         GLboolean unpackFlipY,
                                         GLboolean unpackPremultiplyAlpha,
                                         GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);
    paramBuffer.addValueParam("depth", ParamType::TGLint, depth);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(gl::EntryPoint::CopySubTexture3DANGLE, std::move(paramBuffer));
}

CallCapture CaptureBlitFramebufferANGLE(const State &glState,
                                        bool isCallValid,
                                        GLint srcX0,
                                        GLint srcY0,
                                        GLint srcX1,
                                        GLint srcY1,
                                        GLint dstX0,
                                        GLint dstY0,
                                        GLint dstX1,
                                        GLint dstY1,
                                        GLbitfield mask,
                                        GLenum filter)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcX0", ParamType::TGLint, srcX0);
    paramBuffer.addValueParam("srcY0", ParamType::TGLint, srcY0);
    paramBuffer.addValueParam("srcX1", ParamType::TGLint, srcX1);
    paramBuffer.addValueParam("srcY1", ParamType::TGLint, srcY1);
    paramBuffer.addValueParam("dstX0", ParamType::TGLint, dstX0);
    paramBuffer.addValueParam("dstY0", ParamType::TGLint, dstY0);
    paramBuffer.addValueParam("dstX1", ParamType::TGLint, dstX1);
    paramBuffer.addValueParam("dstY1", ParamType::TGLint, dstY1);
    paramBuffer.addEnumParam("mask", GLenumGroup::ClearBufferMask, ParamType::TGLbitfield, mask);
    paramBuffer.addEnumParam("filter", GLenumGroup::BlitFramebufferFilter, ParamType::TGLenum,
                             filter);

    return CallCapture(gl::EntryPoint::BlitFramebufferANGLE, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageMultisampleANGLE(const State &glState,
                                                       bool isCallValid,
                                                       GLenum target,
                                                       GLsizei samples,
                                                       GLenum internalformat,
                                                       GLsizei width,
                                                       GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::RenderbufferStorageMultisampleANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexImageANGLE(const State &glState,
                                    bool isCallValid,
                                    TextureTarget targetPacked,
                                    GLint level,
                                    GLenum format,
                                    GLenum type,
                                    void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetTexImageANGLE_pixels(glState, isCallValid, targetPacked, level, format, type,
                                       pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexImageANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferImageANGLE(const State &glState,
                                             bool isCallValid,
                                             GLenum target,
                                             GLenum format,
                                             GLenum type,
                                             void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureGetRenderbufferImageANGLE_pixels(glState, isCallValid, target, format, type, pixels,
                                                &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(gl::EntryPoint::GetRenderbufferImageANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterivANGLE(const State &glState,
                                               bool isCallValid,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameterivANGLE_params(glState, isCallValid, targetPacked, level, pname,
                                                  params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexLevelParameterivANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfvANGLE(const State &glState,
                                               bool isCallValid,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameterfvANGLE_params(glState, isCallValid, targetPacked, level, pname,
                                                  params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexLevelParameterfvANGLE, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedANGLE(const State &glState,
                                            bool isCallValid,
                                            PrimitiveMode modePacked,
                                            GLint first,
                                            GLsizei count,
                                            GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(gl::EntryPoint::DrawArraysInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedANGLE(const State &glState,
                                              bool isCallValid,
                                              PrimitiveMode modePacked,
                                              GLsizei count,
                                              DrawElementsType typePacked,
                                              const void *indices,
                                              GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedANGLE_indices(glState, isCallValid, modePacked, count,
                                                  typePacked, indices, primcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(gl::EntryPoint::DrawElementsInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisorANGLE(const State &glState,
                                            bool isCallValid,
                                            GLuint index,
                                            GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(gl::EntryPoint::VertexAttribDivisorANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMemFlags2DANGLE(const State &glState,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLsizei levels,
                                             GLenum internalFormat,
                                             GLsizei width,
                                             GLsizei height,
                                             MemoryObjectID memoryPacked,
                                             GLuint64 offset,
                                             GLbitfield createFlags,
                                             GLbitfield usageFlags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);
    paramBuffer.addEnumParam("createFlags", GLenumGroup::DefaultGroup, ParamType::TGLbitfield,
                             createFlags);
    paramBuffer.addEnumParam("usageFlags", GLenumGroup::DefaultGroup, ParamType::TGLbitfield,
                             usageFlags);

    return CallCapture(gl::EntryPoint::TexStorageMemFlags2DANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMemFlags2DMultisampleANGLE(const State &glState,
                                                        bool isCallValid,
                                                        TextureType targetPacked,
                                                        GLsizei samples,
                                                        GLenum internalFormat,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLboolean fixedSampleLocations,
                                                        MemoryObjectID memoryPacked,
                                                        GLuint64 offset,
                                                        GLbitfield createFlags,
                                                        GLbitfield usageFlags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);
    paramBuffer.addEnumParam("createFlags", GLenumGroup::DefaultGroup, ParamType::TGLbitfield,
                             createFlags);
    paramBuffer.addEnumParam("usageFlags", GLenumGroup::DefaultGroup, ParamType::TGLbitfield,
                             usageFlags);

    return CallCapture(gl::EntryPoint::TexStorageMemFlags2DMultisampleANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureTexStorageMemFlags3DANGLE(const State &glState,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLsizei levels,
                                             GLenum internalFormat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth,
                                             MemoryObjectID memoryPacked,
                                             GLuint64 offset,
                                             GLbitfield createFlags,
                                             GLbitfield usageFlags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);
    paramBuffer.addEnumParam("createFlags", GLenumGroup::DefaultGroup, ParamType::TGLbitfield,
                             createFlags);
    paramBuffer.addEnumParam("usageFlags", GLenumGroup::DefaultGroup, ParamType::TGLbitfield,
                             usageFlags);

    return CallCapture(gl::EntryPoint::TexStorageMemFlags3DANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMemFlags3DMultisampleANGLE(const State &glState,
                                                        bool isCallValid,
                                                        TextureType targetPacked,
                                                        GLsizei samples,
                                                        GLenum internalFormat,
                                                        GLsizei width,
                                                        GLsizei height,
                                                        GLsizei depth,
                                                        GLboolean fixedSampleLocations,
                                                        MemoryObjectID memoryPacked,
                                                        GLuint64 offset,
                                                        GLbitfield createFlags,
                                                        GLbitfield usageFlags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);
    paramBuffer.addEnumParam("createFlags", GLenumGroup::DefaultGroup, ParamType::TGLbitfield,
                             createFlags);
    paramBuffer.addEnumParam("usageFlags", GLenumGroup::DefaultGroup, ParamType::TGLbitfield,
                             usageFlags);

    return CallCapture(gl::EntryPoint::TexStorageMemFlags3DMultisampleANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureImportMemoryZirconHandleANGLE(const State &glState,
                                                 bool isCallValid,
                                                 MemoryObjectID memoryPacked,
                                                 GLuint64 size,
                                                 HandleType handleTypePacked,
                                                 GLuint handle)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("size", ParamType::TGLuint64, size);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("handle", ParamType::TGLuint, handle);

    return CallCapture(gl::EntryPoint::ImportMemoryZirconHandleANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysANGLE(const State &glState,
                                        bool isCallValid,
                                        PrimitiveMode modePacked,
                                        const GLint *firsts,
                                        const GLsizei *counts,
                                        GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
        CaptureMultiDrawArraysANGLE_firsts(glState, isCallValid, modePacked, firsts, counts,
                                           drawcount, &firstsParam);
        paramBuffer.addParam(std::move(firstsParam));
    }
    else
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &firstsParam.value);
        paramBuffer.addParam(std::move(firstsParam));
    }

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawArraysANGLE_counts(glState, isCallValid, modePacked, firsts, counts,
                                           drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawArraysANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawArraysInstancedANGLE(const State &glState,
                                                 bool isCallValid,
                                                 PrimitiveMode modePacked,
                                                 const GLint *firsts,
                                                 const GLsizei *counts,
                                                 const GLsizei *instanceCounts,
                                                 GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, firsts, &firstsParam.value);
        CaptureMultiDrawArraysInstancedANGLE_firsts(glState, isCallValid, modePacked, firsts,
                                                    counts, instanceCounts, drawcount,
                                                    &firstsParam);
        paramBuffer.addParam(std::move(firstsParam));
    }
    else
    {
        ParamCapture firstsParam("firsts", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &firstsParam.value);
        paramBuffer.addParam(std::move(firstsParam));
    }

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawArraysInstancedANGLE_counts(glState, isCallValid, modePacked, firsts,
                                                    counts, instanceCounts, drawcount,
                                                    &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    if (isCallValid)
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
        CaptureMultiDrawArraysInstancedANGLE_instanceCounts(glState, isCallValid, modePacked,
                                                            firsts, counts, instanceCounts,
                                                            drawcount, &instanceCountsParam);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }
    else
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &instanceCountsParam.value);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawArraysInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsANGLE(const State &glState,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          const GLsizei *counts,
                                          DrawElementsType typePacked,
                                          const GLvoid *const *indices,
                                          GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawElementsANGLE_counts(glState, isCallValid, modePacked, counts, typePacked,
                                             indices, drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
        InitParamValue(ParamType::TGLvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsANGLE_indices(glState, isCallValid, modePacked, counts, typePacked,
                                              indices, drawcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
        InitParamValue(ParamType::TGLvoidConstPointerPointer,
                       static_cast<const GLvoid *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawElementsANGLE, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsInstancedANGLE(const State &glState,
                                                   bool isCallValid,
                                                   PrimitiveMode modePacked,
                                                   const GLsizei *counts,
                                                   DrawElementsType typePacked,
                                                   const GLvoid *const *indices,
                                                   const GLsizei *instanceCounts,
                                                   GLsizei drawcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, counts, &countsParam.value);
        CaptureMultiDrawElementsInstancedANGLE_counts(glState, isCallValid, modePacked, counts,
                                                      typePacked, indices, instanceCounts,
                                                      drawcount, &countsParam);
        paramBuffer.addParam(std::move(countsParam));
    }
    else
    {
        ParamCapture countsParam("counts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countsParam.value);
        paramBuffer.addParam(std::move(countsParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
        InitParamValue(ParamType::TGLvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsInstancedANGLE_indices(glState, isCallValid, modePacked, counts,
                                                       typePacked, indices, instanceCounts,
                                                       drawcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TGLvoidConstPointerPointer);
        InitParamValue(ParamType::TGLvoidConstPointerPointer,
                       static_cast<const GLvoid *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    if (isCallValid)
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, instanceCounts, &instanceCountsParam.value);
        CaptureMultiDrawElementsInstancedANGLE_instanceCounts(
            glState, isCallValid, modePacked, counts, typePacked, indices, instanceCounts,
            drawcount, &instanceCountsParam);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }
    else
    {
        ParamCapture instanceCountsParam("instanceCounts", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &instanceCountsParam.value);
        paramBuffer.addParam(std::move(instanceCountsParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    return CallCapture(gl::EntryPoint::MultiDrawElementsInstancedANGLE, std::move(paramBuffer));
}

CallCapture CaptureProvokingVertexANGLE(const State &glState,
                                        bool isCallValid,
                                        ProvokingVertexConvention modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TProvokingVertexConvention, modePacked);

    return CallCapture(gl::EntryPoint::ProvokingVertexANGLE, std::move(paramBuffer));
}

CallCapture CaptureRequestExtensionANGLE(const State &glState, bool isCallValid, const GLchar *name)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureRequestExtensionANGLE_name(glState, isCallValid, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(gl::EntryPoint::RequestExtensionANGLE, std::move(paramBuffer));
}

CallCapture CaptureDisableExtensionANGLE(const State &glState, bool isCallValid, const GLchar *name)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureDisableExtensionANGLE_name(glState, isCallValid, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(gl::EntryPoint::DisableExtensionANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBooleanvRobustANGLE(const State &glState,
                                          bool isCallValid,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLboolean *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBooleanvRobustANGLE_length(glState, isCallValid, pname, bufSize, length, params,
                                             &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, params, &paramsParam.value);
        CaptureGetBooleanvRobustANGLE_params(glState, isCallValid, pname, bufSize, length, params,
                                             &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, static_cast<GLboolean *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetBooleanvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameterivRobustANGLE(const State &glState,
                                                   bool isCallValid,
                                                   BufferBinding targetPacked,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   GLsizei *length,
                                                   GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBufferParameterivRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                      bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetBufferParameterivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                      bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetBufferParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetFloatvRobustANGLE(const State &glState,
                                        bool isCallValid,
                                        GLenum pname,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetFloatvRobustANGLE_length(glState, isCallValid, pname, bufSize, length, params,
                                           &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetFloatvRobustANGLE_params(glState, isCallValid, pname, bufSize, length, params,
                                           &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetFloatvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameterivRobustANGLE(const State &glState,
                                                                  bool isCallValid,
                                                                  GLenum target,
                                                                  GLenum attachment,
                                                                  GLenum pname,
                                                                  GLsizei bufSize,
                                                                  GLsizei *length,
                                                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetFramebufferAttachmentParameterivRobustANGLE_length(
            glState, isCallValid, target, attachment, pname, bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferAttachmentParameterivRobustANGLE_params(
            glState, isCallValid, target, attachment, pname, bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetFramebufferAttachmentParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetIntegervRobustANGLE(const State &glState,
                                          bool isCallValid,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetIntegervRobustANGLE_length(glState, isCallValid, pname, bufSize, length, data,
                                             &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
        CaptureGetIntegervRobustANGLE_data(glState, isCallValid, pname, bufSize, length, data,
                                           &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::GetIntegervRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetProgramivRobustANGLE(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramivRobustANGLE_length(glState, isCallValid, programPacked, pname, bufSize,
                                              length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetProgramivRobustANGLE_params(glState, isCallValid, programPacked, pname, bufSize,
                                              length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetProgramivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameterivRobustANGLE(const State &glState,
                                                         bool isCallValid,
                                                         GLenum target,
                                                         GLenum pname,
                                                         GLsizei bufSize,
                                                         GLsizei *length,
                                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetRenderbufferParameterivRobustANGLE_length(glState, isCallValid, target, pname,
                                                            bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetRenderbufferParameterivRobustANGLE_params(glState, isCallValid, target, pname,
                                                            bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetRenderbufferParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetShaderivRobustANGLE(const State &glState,
                                          bool isCallValid,
                                          ShaderProgramID shaderPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetShaderivRobustANGLE_length(glState, isCallValid, shaderPacked, pname, bufSize,
                                             length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetShaderivRobustANGLE_params(glState, isCallValid, shaderPacked, pname, bufSize,
                                             length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetShaderivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterfvRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexParameterfvRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexParameterfvRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterivRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexParameterivRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexParameterivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetUniformfvRobustANGLE(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetUniformfvRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                              bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetUniformfvRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                              bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetUniformfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetUniformivRobustANGLE(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetUniformivRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                              bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetUniformivRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                              bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetUniformivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribfvRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribfvRobustANGLE_length(glState, isCallValid, index, pname, bufSize,
                                                   length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetVertexAttribfvRobustANGLE_params(glState, isCallValid, index, pname, bufSize,
                                                   length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetVertexAttribfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribivRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribivRobustANGLE_length(glState, isCallValid, index, pname, bufSize,
                                                   length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetVertexAttribivRobustANGLE_params(glState, isCallValid, index, pname, bufSize,
                                                   length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetVertexAttribivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribPointervRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      GLuint index,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      void **pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribPointervRobustANGLE_length(glState, isCallValid, index, pname,
                                                         bufSize, length, pointer, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, pointer, &pointerParam.value);
        CaptureGetVertexAttribPointervRobustANGLE_pointer(glState, isCallValid, index, pname,
                                                          bufSize, length, pointer, &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(gl::EntryPoint::GetVertexAttribPointervRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureReadPixelsRobustANGLE(const State &glState,
                                         bool isCallValid,
                                         GLint x,
                                         GLint y,
                                         GLsizei width,
                                         GLsizei height,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLsizei *columns,
                                         GLsizei *rows,
                                         void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureReadPixelsRobustANGLE_length(glState, isCallValid, x, y, width, height, format, type,
                                            bufSize, length, columns, rows, pixels, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, columns, &columnsParam.value);
        CaptureReadPixelsRobustANGLE_columns(glState, isCallValid, x, y, width, height, format,
                                             type, bufSize, length, columns, rows, pixels,
                                             &columnsParam);
        paramBuffer.addParam(std::move(columnsParam));
    }
    else
    {
        ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &columnsParam.value);
        paramBuffer.addParam(std::move(columnsParam));
    }

    if (isCallValid)
    {
        ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, rows, &rowsParam.value);
        CaptureReadPixelsRobustANGLE_rows(glState, isCallValid, x, y, width, height, format, type,
                                          bufSize, length, columns, rows, pixels, &rowsParam);
        paramBuffer.addParam(std::move(rowsParam));
    }
    else
    {
        ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &rowsParam.value);
        paramBuffer.addParam(std::move(rowsParam));
    }

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, pixels, &pixelsParam.value);
        CaptureReadPixelsRobustANGLE_pixels(glState, isCallValid, x, y, width, height, format, type,
                                            bufSize, length, columns, rows, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(gl::EntryPoint::ReadPixelsRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexImage2DRobustANGLE(const State &glState,
                                         bool isCallValid,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexImage2DRobustANGLE_pixels(glState, isCallValid, targetPacked, level,
                                            internalformat, width, height, border, format, type,
                                            bufSize, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(gl::EntryPoint::TexImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterfvRobustANGLE(const State &glState,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureTexParameterfvRobustANGLE_params(glState, isCallValid, targetPacked, pname, bufSize,
                                                params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::TexParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterivRobustANGLE(const State &glState,
                                             bool isCallValid,
                                             TextureType targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexParameterivRobustANGLE_params(glState, isCallValid, targetPacked, pname, bufSize,
                                                params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::TexParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage2DRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            TextureTarget targetPacked,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexSubImage2DRobustANGLE_pixels(glState, isCallValid, targetPacked, level, xoffset,
                                               yoffset, width, height, format, type, bufSize,
                                               pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(gl::EntryPoint::TexSubImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexImage3DRobustANGLE(const State &glState,
                                         bool isCallValid,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLint internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLint border,
                                         GLenum format,
                                         GLenum type,
                                         GLsizei bufSize,
                                         const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexImage3DRobustANGLE_pixels(glState, isCallValid, targetPacked, level,
                                            internalformat, width, height, depth, border, format,
                                            type, bufSize, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(gl::EntryPoint::TexImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3DRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            TextureTarget targetPacked,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLint zoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLsizei depth,
                                            GLenum format,
                                            GLenum type,
                                            GLsizei bufSize,
                                            const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexSubImage3DRobustANGLE_pixels(glState, isCallValid, targetPacked, level, xoffset,
                                               yoffset, zoffset, width, height, depth, format, type,
                                               bufSize, pixels, &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(gl::EntryPoint::TexSubImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage2DRobustANGLE(const State &glState,
                                                   bool isCallValid,
                                                   TextureTarget targetPacked,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexImage2DRobustANGLE_data(glState, isCallValid, targetPacked, level,
                                                    internalformat, width, height, border,
                                                    imageSize, dataSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, static_cast<const GLvoid *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::CompressedTexImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage2DRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      TextureTarget targetPacked,
                                                      GLint level,
                                                      GLsizei xoffset,
                                                      GLsizei yoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLsizei, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLsizei, yoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexSubImage2DRobustANGLE_data(glState, isCallValid, targetPacked, level,
                                                       xoffset, yoffset, width, height, format,
                                                       imageSize, dataSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, static_cast<const GLvoid *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::CompressedTexSubImage2DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3DRobustANGLE(const State &glState,
                                                   bool isCallValid,
                                                   TextureTarget targetPacked,
                                                   GLint level,
                                                   GLenum internalformat,
                                                   GLsizei width,
                                                   GLsizei height,
                                                   GLsizei depth,
                                                   GLint border,
                                                   GLsizei imageSize,
                                                   GLsizei dataSize,
                                                   const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexImage3DRobustANGLE_data(glState, isCallValid, targetPacked, level,
                                                    internalformat, width, height, depth, border,
                                                    imageSize, dataSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, static_cast<const GLvoid *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::CompressedTexImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3DRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      TextureTarget targetPacked,
                                                      GLint level,
                                                      GLint xoffset,
                                                      GLint yoffset,
                                                      GLint zoffset,
                                                      GLsizei width,
                                                      GLsizei height,
                                                      GLsizei depth,
                                                      GLenum format,
                                                      GLsizei imageSize,
                                                      GLsizei dataSize,
                                                      const GLvoid *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);
    paramBuffer.addValueParam("dataSize", ParamType::TGLsizei, dataSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexSubImage3DRobustANGLE_data(
            glState, isCallValid, targetPacked, level, xoffset, yoffset, zoffset, width, height,
            depth, format, imageSize, dataSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLvoidConstPointer);
        InitParamValue(ParamType::TGLvoidConstPointer, static_cast<const GLvoid *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::CompressedTexSubImage3DRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryivRobustANGLE(const State &glState,
                                         bool isCallValid,
                                         QueryType targetPacked,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         GLsizei *length,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryivRobustANGLE_length(glState, isCallValid, targetPacked, pname, bufSize,
                                            length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryivRobustANGLE_params(glState, isCallValid, targetPacked, pname, bufSize,
                                            length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuivRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                QueryID idPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryObjectuivRobustANGLE_length(glState, isCallValid, idPacked, pname, bufSize,
                                                   length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectuivRobustANGLE_params(glState, isCallValid, idPacked, pname, bufSize,
                                                   length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryObjectuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointervRobustANGLE(const State &glState,
                                                bool isCallValid,
                                                BufferBinding targetPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                GLsizei *length,
                                                void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBufferPointervRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetBufferPointervRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                   bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetBufferPointervRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetIntegeri_vRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetIntegeri_vRobustANGLE_length(glState, isCallValid, target, index, bufSize, length,
                                               data, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
        CaptureGetIntegeri_vRobustANGLE_data(glState, isCallValid, target, index, bufSize, length,
                                             data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::GetIntegeri_vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetInternalformativRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLenum internalformat,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetInternalformativRobustANGLE_length(glState, isCallValid, target, internalformat,
                                                     pname, bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetInternalformativRobustANGLE_params(glState, isCallValid, target, internalformat,
                                                     pname, bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetInternalformativRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIivRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 GLuint index,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribIivRobustANGLE_length(glState, isCallValid, index, pname, bufSize,
                                                    length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetVertexAttribIivRobustANGLE_params(glState, isCallValid, index, pname, bufSize,
                                                    length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetVertexAttribIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIuivRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  GLuint index,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetVertexAttribIuivRobustANGLE_length(glState, isCallValid, index, pname, bufSize,
                                                     length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetVertexAttribIuivRobustANGLE_params(glState, isCallValid, index, pname, bufSize,
                                                     length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetVertexAttribIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetUniformuivRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            ShaderProgramID programPacked,
                                            UniformLocation locationPacked,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetUniformuivRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetUniformuivRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetUniformuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformBlockivRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      ShaderProgramID programPacked,
                                                      GLuint uniformBlockIndex,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("uniformBlockIndex", ParamType::TGLuint, uniformBlockIndex);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetActiveUniformBlockivRobustANGLE_length(glState, isCallValid, programPacked,
                                                         uniformBlockIndex, pname, bufSize, length,
                                                         params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetActiveUniformBlockivRobustANGLE_params(glState, isCallValid, programPacked,
                                                         uniformBlockIndex, pname, bufSize, length,
                                                         params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetActiveUniformBlockivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetInteger64vRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetInteger64vRobustANGLE_length(glState, isCallValid, pname, bufSize, length, data,
                                               &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
        CaptureGetInteger64vRobustANGLE_data(glState, isCallValid, pname, bufSize, length, data,
                                             &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::GetInteger64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetInteger64i_vRobustANGLE(const State &glState,
                                              bool isCallValid,
                                              GLenum target,
                                              GLuint index,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetInteger64i_vRobustANGLE_length(glState, isCallValid, target, index, bufSize,
                                                 length, data, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
        CaptureGetInteger64i_vRobustANGLE_data(glState, isCallValid, target, index, bufSize, length,
                                               data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::GetInteger64i_vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameteri64vRobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     BufferBinding targetPacked,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBufferParameteri64vRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                        bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetBufferParameteri64vRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                        bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetBufferParameteri64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterivRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 SamplerID samplerPacked,
                                                 GLuint pname,
                                                 GLsizei bufSize,
                                                 const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addValueParam("pname", ParamType::TGLuint, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterivRobustANGLE_param(glState, isCallValid, samplerPacked, pname,
                                                   bufSize, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(gl::EntryPoint::SamplerParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterfvRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 SamplerID samplerPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 const GLfloat *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, param, &paramParam.value);
        CaptureSamplerParameterfvRobustANGLE_param(glState, isCallValid, samplerPacked, pname,
                                                   bufSize, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(gl::EntryPoint::SamplerParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterivRobustANGLE(const State &glState,
                                                    bool isCallValid,
                                                    SamplerID samplerPacked,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetSamplerParameterivRobustANGLE_length(glState, isCallValid, samplerPacked, pname,
                                                       bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterivRobustANGLE_params(glState, isCallValid, samplerPacked, pname,
                                                       bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetSamplerParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterfvRobustANGLE(const State &glState,
                                                    bool isCallValid,
                                                    SamplerID samplerPacked,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetSamplerParameterfvRobustANGLE_length(glState, isCallValid, samplerPacked, pname,
                                                       bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterfvRobustANGLE_params(glState, isCallValid, samplerPacked, pname,
                                                       bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetSamplerParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferParameterivRobustANGLE(const State &glState,
                                                        bool isCallValid,
                                                        GLenum target,
                                                        GLenum pname,
                                                        GLsizei bufSize,
                                                        GLsizei *length,
                                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetFramebufferParameterivRobustANGLE_length(glState, isCallValid, target, pname,
                                                           bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferParameterivRobustANGLE_params(glState, isCallValid, target, pname,
                                                           bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetFramebufferParameterivRobustANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetProgramInterfaceivRobustANGLE(const State &glState,
                                                    bool isCallValid,
                                                    ShaderProgramID programPacked,
                                                    GLenum programInterface,
                                                    GLenum pname,
                                                    GLsizei bufSize,
                                                    GLsizei *length,
                                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             programInterface);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramInterfaceivRobustANGLE_length(glState, isCallValid, programPacked,
                                                       programInterface, pname, bufSize, length,
                                                       params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetProgramInterfaceivRobustANGLE_params(glState, isCallValid, programPacked,
                                                       programInterface, pname, bufSize, length,
                                                       params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetProgramInterfaceivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetBooleani_vRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            GLenum target,
                                            GLuint index,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLboolean *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetBooleani_vRobustANGLE_length(glState, isCallValid, target, index, bufSize, length,
                                               data, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, data, &dataParam.value);
        CaptureGetBooleani_vRobustANGLE_data(glState, isCallValid, target, index, bufSize, length,
                                             data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, static_cast<GLboolean *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::GetBooleani_vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefvRobustANGLE(const State &glState,
                                               bool isCallValid,
                                               GLenum pname,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetMultisamplefvRobustANGLE_length(glState, isCallValid, pname, index, bufSize,
                                                  length, val, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
        CaptureGetMultisamplefvRobustANGLE_val(glState, isCallValid, pname, index, bufSize, length,
                                               val, &valParam);
        paramBuffer.addParam(std::move(valParam));
    }
    else
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &valParam.value);
        paramBuffer.addParam(std::move(valParam));
    }

    return CallCapture(gl::EntryPoint::GetMultisamplefvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterivRobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     TextureTarget targetPacked,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexLevelParameterivRobustANGLE_length(glState, isCallValid, targetPacked, level,
                                                        pname, bufSize, length, params,
                                                        &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameterivRobustANGLE_params(glState, isCallValid, targetPacked, level,
                                                        pname, bufSize, length, params,
                                                        &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexLevelParameterivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfvRobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     TextureTarget targetPacked,
                                                     GLint level,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexLevelParameterfvRobustANGLE_length(glState, isCallValid, targetPacked, level,
                                                        pname, bufSize, length, params,
                                                        &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameterfvRobustANGLE_params(glState, isCallValid, targetPacked, level,
                                                        pname, bufSize, length, params,
                                                        &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexLevelParameterfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetPointervRobustANGLERobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetPointervRobustANGLERobustANGLE_length(glState, isCallValid, pname, bufSize,
                                                        length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetPointervRobustANGLERobustANGLE_params(glState, isCallValid, pname, bufSize,
                                                        length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetPointervRobustANGLERobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureReadnPixelsRobustANGLE(const State &glState,
                                          bool isCallValid,
                                          GLint x,
                                          GLint y,
                                          GLsizei width,
                                          GLsizei height,
                                          GLenum format,
                                          GLenum type,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLsizei *columns,
                                          GLsizei *rows,
                                          void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::DefaultGroup, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureReadnPixelsRobustANGLE_length(glState, isCallValid, x, y, width, height, format,
                                             type, bufSize, length, columns, rows, data,
                                             &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, columns, &columnsParam.value);
        CaptureReadnPixelsRobustANGLE_columns(glState, isCallValid, x, y, width, height, format,
                                              type, bufSize, length, columns, rows, data,
                                              &columnsParam);
        paramBuffer.addParam(std::move(columnsParam));
    }
    else
    {
        ParamCapture columnsParam("columns", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &columnsParam.value);
        paramBuffer.addParam(std::move(columnsParam));
    }

    if (isCallValid)
    {
        ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, rows, &rowsParam.value);
        CaptureReadnPixelsRobustANGLE_rows(glState, isCallValid, x, y, width, height, format, type,
                                           bufSize, length, columns, rows, data, &rowsParam);
        paramBuffer.addParam(std::move(rowsParam));
    }
    else
    {
        ParamCapture rowsParam("rows", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &rowsParam.value);
        paramBuffer.addParam(std::move(rowsParam));
    }

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
        CaptureReadnPixelsRobustANGLE_data(glState, isCallValid, x, y, width, height, format, type,
                                           bufSize, length, columns, rows, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::ReadnPixelsRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfvRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            ShaderProgramID programPacked,
                                            UniformLocation locationPacked,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetnUniformfvRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetnUniformfvRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetnUniformfvRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformivRobustANGLE(const State &glState,
                                            bool isCallValid,
                                            ShaderProgramID programPacked,
                                            UniformLocation locationPacked,
                                            GLsizei bufSize,
                                            GLsizei *length,
                                            GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetnUniformivRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetnUniformivRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                               bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetnUniformivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformuivRobustANGLE(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetnUniformuivRobustANGLE_length(glState, isCallValid, programPacked, locationPacked,
                                                bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetnUniformuivRobustANGLE_params(glState, isCallValid, programPacked, locationPacked,
                                                bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetnUniformuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIivRobustANGLE(const State &glState,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIivRobustANGLE_params(glState, isCallValid, targetPacked, pname, bufSize,
                                                 params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::TexParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuivRobustANGLE(const State &glState,
                                               bool isCallValid,
                                               TextureType targetPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIuivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                  bufSize, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::TexParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIivRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexParameterIivRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                    bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                    bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuivRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  TextureType targetPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTexParameterIuivRobustANGLE_length(glState, isCallValid, targetPacked, pname,
                                                     bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIuivRobustANGLE_params(glState, isCallValid, targetPacked, pname,
                                                     bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIivRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  SamplerID samplerPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIivRobustANGLE_param(glState, isCallValid, samplerPacked, pname,
                                                    bufSize, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(gl::EntryPoint::SamplerParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuivRobustANGLE(const State &glState,
                                                   bool isCallValid,
                                                   SamplerID samplerPacked,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIuivRobustANGLE_param(glState, isCallValid, samplerPacked, pname,
                                                     bufSize, param, &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(gl::EntryPoint::SamplerParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIivRobustANGLE(const State &glState,
                                                     bool isCallValid,
                                                     SamplerID samplerPacked,
                                                     GLenum pname,
                                                     GLsizei bufSize,
                                                     GLsizei *length,
                                                     GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetSamplerParameterIivRobustANGLE_length(glState, isCallValid, samplerPacked, pname,
                                                        bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIivRobustANGLE_params(glState, isCallValid, samplerPacked, pname,
                                                        bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetSamplerParameterIivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuivRobustANGLE(const State &glState,
                                                      bool isCallValid,
                                                      SamplerID samplerPacked,
                                                      GLenum pname,
                                                      GLsizei bufSize,
                                                      GLsizei *length,
                                                      GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetSamplerParameterIuivRobustANGLE_length(glState, isCallValid, samplerPacked, pname,
                                                         bufSize, length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIuivRobustANGLE_params(glState, isCallValid, samplerPacked, pname,
                                                         bufSize, length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetSamplerParameterIuivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectivRobustANGLE(const State &glState,
                                               bool isCallValid,
                                               QueryID idPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryObjectivRobustANGLE_length(glState, isCallValid, idPacked, pname, bufSize,
                                                  length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectivRobustANGLE_params(glState, isCallValid, idPacked, pname, bufSize,
                                                  length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryObjectivRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjecti64vRobustANGLE(const State &glState,
                                                 bool isCallValid,
                                                 QueryID idPacked,
                                                 GLenum pname,
                                                 GLsizei bufSize,
                                                 GLsizei *length,
                                                 GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryObjecti64vRobustANGLE_length(glState, isCallValid, idPacked, pname, bufSize,
                                                    length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjecti64vRobustANGLE_params(glState, isCallValid, idPacked, pname, bufSize,
                                                    length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryObjecti64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectui64vRobustANGLE(const State &glState,
                                                  bool isCallValid,
                                                  QueryID idPacked,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  GLsizei *length,
                                                  GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetQueryObjectui64vRobustANGLE_length(glState, isCallValid, idPacked, pname, bufSize,
                                                     length, params, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjectui64vRobustANGLE_params(glState, isCallValid, idPacked, pname, bufSize,
                                                     length, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, static_cast<GLuint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryObjectui64vRobustANGLE, std::move(paramBuffer));
}

CallCapture CaptureImportSemaphoreZirconHandleANGLE(const State &glState,
                                                    bool isCallValid,
                                                    SemaphoreID semaphorePacked,
                                                    HandleType handleTypePacked,
                                                    GLuint handle)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("handle", ParamType::TGLuint, handle);

    return CallCapture(gl::EntryPoint::ImportSemaphoreZirconHandleANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexImage2DExternalANGLE(const State &glState,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLint internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLint border,
                                           GLenum format,
                                           GLenum type)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    return CallCapture(gl::EntryPoint::TexImage2DExternalANGLE, std::move(paramBuffer));
}

CallCapture CaptureInvalidateTextureANGLE(const State &glState,
                                          bool isCallValid,
                                          TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture(gl::EntryPoint::InvalidateTextureANGLE, std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DMultisampleANGLE(const State &glState,
                                                bool isCallValid,
                                                TextureType targetPacked,
                                                GLsizei samples,
                                                GLenum internalformat,
                                                GLsizei width,
                                                GLsizei height,
                                                GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(gl::EntryPoint::TexStorage2DMultisampleANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefvANGLE(const State &glState,
                                         bool isCallValid,
                                         GLenum pname,
                                         GLuint index,
                                         GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
        CaptureGetMultisamplefvANGLE_val(glState, isCallValid, pname, index, val, &valParam);
        paramBuffer.addParam(std::move(valParam));
    }
    else
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &valParam.value);
        paramBuffer.addParam(std::move(valParam));
    }

    return CallCapture(gl::EntryPoint::GetMultisamplefvANGLE, std::move(paramBuffer));
}

CallCapture CaptureSampleMaskiANGLE(const State &glState,
                                    bool isCallValid,
                                    GLuint maskNumber,
                                    GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("maskNumber", ParamType::TGLuint, maskNumber);
    paramBuffer.addEnumParam("mask", GLenumGroup::DefaultGroup, ParamType::TGLbitfield, mask);

    return CallCapture(gl::EntryPoint::SampleMaskiANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetTranslatedShaderSourceANGLE(const State &glState,
                                                  bool isCallValid,
                                                  ShaderProgramID shaderPacked,
                                                  GLsizei bufsize,
                                                  GLsizei *length,
                                                  GLchar *source)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("shaderPacked", ParamType::TShaderProgramID, shaderPacked);
    paramBuffer.addValueParam("bufsize", ParamType::TGLsizei, bufsize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTranslatedShaderSourceANGLE_length(glState, isCallValid, shaderPacked, bufsize,
                                                     length, source, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture sourceParam("source", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, source, &sourceParam.value);
        CaptureGetTranslatedShaderSourceANGLE_source(glState, isCallValid, shaderPacked, bufsize,
                                                     length, source, &sourceParam);
        paramBuffer.addParam(std::move(sourceParam));
    }
    else
    {
        ParamCapture sourceParam("source", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &sourceParam.value);
        paramBuffer.addParam(std::move(sourceParam));
    }

    return CallCapture(gl::EntryPoint::GetTranslatedShaderSourceANGLE, std::move(paramBuffer));
}

CallCapture CaptureBindUniformLocationCHROMIUM(const State &glState,
                                               bool isCallValid,
                                               ShaderProgramID programPacked,
                                               UniformLocation locationPacked,
                                               const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureBindUniformLocationCHROMIUM_name(glState, isCallValid, programPacked, locationPacked,
                                                name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(gl::EntryPoint::BindUniformLocationCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCompressedCopyTextureCHROMIUM(const State &glState,
                                                 bool isCallValid,
                                                 TextureID sourceIdPacked,
                                                 TextureID destIdPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);

    return CallCapture(gl::EntryPoint::CompressedCopyTextureCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCopyTextureCHROMIUM(const State &glState,
                                       bool isCallValid,
                                       TextureID sourceIdPacked,
                                       GLint sourceLevel,
                                       TextureTarget destTargetPacked,
                                       TextureID destIdPacked,
                                       GLint destLevel,
                                       GLint internalFormat,
                                       GLenum destType,
                                       GLboolean unpackFlipY,
                                       GLboolean unpackPremultiplyAlpha,
                                       GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("internalFormat", ParamType::TGLint, internalFormat);
    paramBuffer.addEnumParam("destType", GLenumGroup::DefaultGroup, ParamType::TGLenum, destType);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(gl::EntryPoint::CopyTextureCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCopySubTextureCHROMIUM(const State &glState,
                                          bool isCallValid,
                                          TextureID sourceIdPacked,
                                          GLint sourceLevel,
                                          TextureTarget destTargetPacked,
                                          TextureID destIdPacked,
                                          GLint destLevel,
                                          GLint xoffset,
                                          GLint yoffset,
                                          GLint x,
                                          GLint y,
                                          GLint width,
                                          GLint height,
                                          GLboolean unpackFlipY,
                                          GLboolean unpackPremultiplyAlpha,
                                          GLboolean unpackUnmultiplyAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sourceIdPacked", ParamType::TTextureID, sourceIdPacked);
    paramBuffer.addValueParam("sourceLevel", ParamType::TGLint, sourceLevel);
    paramBuffer.addValueParam("destTargetPacked", ParamType::TTextureTarget, destTargetPacked);
    paramBuffer.addValueParam("destIdPacked", ParamType::TTextureID, destIdPacked);
    paramBuffer.addValueParam("destLevel", ParamType::TGLint, destLevel);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);
    paramBuffer.addValueParam("unpackFlipY", ParamType::TGLboolean, unpackFlipY);
    paramBuffer.addValueParam("unpackPremultiplyAlpha", ParamType::TGLboolean,
                              unpackPremultiplyAlpha);
    paramBuffer.addValueParam("unpackUnmultiplyAlpha", ParamType::TGLboolean,
                              unpackUnmultiplyAlpha);

    return CallCapture(gl::EntryPoint::CopySubTextureCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureCoverageModulationCHROMIUM(const State &glState,
                                              bool isCallValid,
                                              GLenum components)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("components", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             components);

    return CallCapture(gl::EntryPoint::CoverageModulationCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureLoseContextCHROMIUM(const State &glState,
                                       bool isCallValid,
                                       GraphicsResetStatus currentPacked,
                                       GraphicsResetStatus otherPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("currentPacked", ParamType::TGraphicsResetStatus, currentPacked);
    paramBuffer.addValueParam("otherPacked", ParamType::TGraphicsResetStatus, otherPacked);

    return CallCapture(gl::EntryPoint::LoseContextCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureBindFragDataLocationEXT(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLuint color,
                                           const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("color", ParamType::TGLuint, color);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureBindFragDataLocationEXT_name(glState, isCallValid, programPacked, color, name,
                                            &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(gl::EntryPoint::BindFragDataLocationEXT, std::move(paramBuffer));
}

CallCapture CaptureBindFragDataLocationIndexedEXT(const State &glState,
                                                  bool isCallValid,
                                                  ShaderProgramID programPacked,
                                                  GLuint colorNumber,
                                                  GLuint index,
                                                  const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("colorNumber", ParamType::TGLuint, colorNumber);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureBindFragDataLocationIndexedEXT_name(glState, isCallValid, programPacked, colorNumber,
                                                   index, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(gl::EntryPoint::BindFragDataLocationIndexedEXT, std::move(paramBuffer));
}

CallCapture CaptureGetFragDataIndexEXT(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       const GLchar *name,
                                       GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetFragDataIndexEXT_name(glState, isCallValid, programPacked, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetFragDataIndexEXT, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceLocationIndexEXT(const State &glState,
                                                      bool isCallValid,
                                                      ShaderProgramID programPacked,
                                                      GLenum programInterface,
                                                      const GLchar *name,
                                                      GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetProgramResourceLocationIndexEXT_name(glState, isCallValid, programPacked,
                                                       programInterface, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetProgramResourceLocationIndexEXT, std::move(paramBuffer));
}

CallCapture CaptureBufferStorageEXT(const State &glState,
                                    bool isCallValid,
                                    BufferBinding targetPacked,
                                    GLsizeiptr size,
                                    const void *data,
                                    GLbitfield flags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureBufferStorageEXT_data(glState, isCallValid, targetPacked, size, data, flags,
                                     &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    paramBuffer.addEnumParam("flags", GLenumGroup::MapBufferUsageMask, ParamType::TGLbitfield,
                             flags);

    return CallCapture(gl::EntryPoint::BufferStorageEXT, std::move(paramBuffer));
}

CallCapture CaptureCopyImageSubDataEXT(const State &glState,
                                       bool isCallValid,
                                       GLuint srcName,
                                       GLenum srcTarget,
                                       GLint srcLevel,
                                       GLint srcX,
                                       GLint srcY,
                                       GLint srcZ,
                                       GLuint dstName,
                                       GLenum dstTarget,
                                       GLint dstLevel,
                                       GLint dstX,
                                       GLint dstY,
                                       GLint dstZ,
                                       GLsizei srcWidth,
                                       GLsizei srcHeight,
                                       GLsizei srcDepth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcName", ParamType::TGLuint, srcName);
    paramBuffer.addEnumParam("srcTarget", GLenumGroup::CopyBufferSubDataTarget, ParamType::TGLenum,
                             srcTarget);
    paramBuffer.addValueParam("srcLevel", ParamType::TGLint, srcLevel);
    paramBuffer.addValueParam("srcX", ParamType::TGLint, srcX);
    paramBuffer.addValueParam("srcY", ParamType::TGLint, srcY);
    paramBuffer.addValueParam("srcZ", ParamType::TGLint, srcZ);
    paramBuffer.addValueParam("dstName", ParamType::TGLuint, dstName);
    paramBuffer.addEnumParam("dstTarget", GLenumGroup::CopyBufferSubDataTarget, ParamType::TGLenum,
                             dstTarget);
    paramBuffer.addValueParam("dstLevel", ParamType::TGLint, dstLevel);
    paramBuffer.addValueParam("dstX", ParamType::TGLint, dstX);
    paramBuffer.addValueParam("dstY", ParamType::TGLint, dstY);
    paramBuffer.addValueParam("dstZ", ParamType::TGLint, dstZ);
    paramBuffer.addValueParam("srcWidth", ParamType::TGLsizei, srcWidth);
    paramBuffer.addValueParam("srcHeight", ParamType::TGLsizei, srcHeight);
    paramBuffer.addValueParam("srcDepth", ParamType::TGLsizei, srcDepth);

    return CallCapture(gl::EntryPoint::CopyImageSubDataEXT, std::move(paramBuffer));
}

CallCapture CaptureInsertEventMarkerEXT(const State &glState,
                                        bool isCallValid,
                                        GLsizei length,
                                        const GLchar *marker)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, marker, &markerParam.value);
        CaptureInsertEventMarkerEXT_marker(glState, isCallValid, length, marker, &markerParam);
        paramBuffer.addParam(std::move(markerParam));
    }
    else
    {
        ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &markerParam.value);
        paramBuffer.addParam(std::move(markerParam));
    }

    return CallCapture(gl::EntryPoint::InsertEventMarkerEXT, std::move(paramBuffer));
}

CallCapture CapturePopGroupMarkerEXT(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::PopGroupMarkerEXT, std::move(paramBuffer));
}

CallCapture CapturePushGroupMarkerEXT(const State &glState,
                                      bool isCallValid,
                                      GLsizei length,
                                      const GLchar *marker)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, marker, &markerParam.value);
        CapturePushGroupMarkerEXT_marker(glState, isCallValid, length, marker, &markerParam);
        paramBuffer.addParam(std::move(markerParam));
    }
    else
    {
        ParamCapture markerParam("marker", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &markerParam.value);
        paramBuffer.addParam(std::move(markerParam));
    }

    return CallCapture(gl::EntryPoint::PushGroupMarkerEXT, std::move(paramBuffer));
}

CallCapture CaptureDiscardFramebufferEXT(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLsizei numAttachments,
                                         const GLenum *attachments)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    if (isCallValid)
    {
        ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
        CaptureDiscardFramebufferEXT_attachments(glState, isCallValid, target, numAttachments,
                                                 attachments, &attachmentsParam);
        paramBuffer.addParam(std::move(attachmentsParam));
    }
    else
    {
        ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &attachmentsParam.value);
        paramBuffer.addParam(std::move(attachmentsParam));
    }

    return CallCapture(gl::EntryPoint::DiscardFramebufferEXT, std::move(paramBuffer));
}

CallCapture CaptureBeginQueryEXT(const State &glState,
                                 bool isCallValid,
                                 QueryType targetPacked,
                                 QueryID idPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);

    return CallCapture(gl::EntryPoint::BeginQueryEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteQueriesEXT(const State &glState,
                                    bool isCallValid,
                                    GLsizei n,
                                    const QueryID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDConstPointer);
        InitParamValue(ParamType::TQueryIDConstPointer, idsPacked, &idsPackedParam.value);
        CaptureDeleteQueriesEXT_idsPacked(glState, isCallValid, n, idsPacked, &idsPackedParam);
        paramBuffer.addParam(std::move(idsPackedParam));
    }
    else
    {
        ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDConstPointer);
        InitParamValue(ParamType::TQueryIDConstPointer, static_cast<const QueryID *>(nullptr),
                       &idsPackedParam.value);
        paramBuffer.addParam(std::move(idsPackedParam));
    }

    return CallCapture(gl::EntryPoint::DeleteQueriesEXT, std::move(paramBuffer));
}

CallCapture CaptureEndQueryEXT(const State &glState, bool isCallValid, QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture(gl::EntryPoint::EndQueryEXT, std::move(paramBuffer));
}

CallCapture CaptureGenQueriesEXT(const State &glState,
                                 bool isCallValid,
                                 GLsizei n,
                                 QueryID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDPointer);
        InitParamValue(ParamType::TQueryIDPointer, idsPacked, &idsPackedParam.value);
        CaptureGenQueriesEXT_idsPacked(glState, isCallValid, n, idsPacked, &idsPackedParam);
        paramBuffer.addParam(std::move(idsPackedParam));
    }
    else
    {
        ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDPointer);
        InitParamValue(ParamType::TQueryIDPointer, static_cast<QueryID *>(nullptr),
                       &idsPackedParam.value);
        paramBuffer.addParam(std::move(idsPackedParam));
    }

    return CallCapture(gl::EntryPoint::GenQueriesEXT, std::move(paramBuffer));
}

CallCapture CaptureGetInteger64vEXT(const State &glState,
                                    bool isCallValid,
                                    GLenum pname,
                                    GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::GetPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
        CaptureGetInteger64vEXT_data(glState, isCallValid, pname, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::GetInteger64vEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjecti64vEXT(const State &glState,
                                         bool isCallValid,
                                         QueryID idPacked,
                                         GLenum pname,
                                         GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjecti64vEXT_params(glState, isCallValid, idPacked, pname, params,
                                            &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryObjecti64vEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectivEXT(const State &glState,
                                       bool isCallValid,
                                       QueryID idPacked,
                                       GLenum pname,
                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectivEXT_params(glState, isCallValid, idPacked, pname, params,
                                          &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryObjectivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectui64vEXT(const State &glState,
                                          bool isCallValid,
                                          QueryID idPacked,
                                          GLenum pname,
                                          GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjectui64vEXT_params(glState, isCallValid, idPacked, pname, params,
                                             &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, static_cast<GLuint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryObjectui64vEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuivEXT(const State &glState,
                                        bool isCallValid,
                                        QueryID idPacked,
                                        GLenum pname,
                                        GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectuivEXT_params(glState, isCallValid, idPacked, pname, params,
                                           &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryObjectuivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetQueryivEXT(const State &glState,
                                 bool isCallValid,
                                 QueryType targetPacked,
                                 GLenum pname,
                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::QueryParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryivEXT_params(glState, isCallValid, targetPacked, pname, params,
                                    &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetQueryivEXT, std::move(paramBuffer));
}

CallCapture CaptureIsQueryEXT(const State &glState,
                              bool isCallValid,
                              QueryID idPacked,
                              GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsQueryEXT, std::move(paramBuffer));
}

CallCapture CaptureQueryCounterEXT(const State &glState,
                                   bool isCallValid,
                                   QueryID idPacked,
                                   QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture(gl::EntryPoint::QueryCounterEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawBuffersEXT(const State &glState,
                                  bool isCallValid,
                                  GLsizei n,
                                  const GLenum *bufs)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, bufs, &bufsParam.value);
        CaptureDrawBuffersEXT_bufs(glState, isCallValid, n, bufs, &bufsParam);
        paramBuffer.addParam(std::move(bufsParam));
    }
    else
    {
        ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &bufsParam.value);
        paramBuffer.addParam(std::move(bufsParam));
    }

    return CallCapture(gl::EntryPoint::DrawBuffersEXT, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationSeparateiEXT(const State &glState,
                                             bool isCallValid,
                                             GLuint buf,
                                             GLenum modeRGB,
                                             GLenum modeAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("modeRGB", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum,
                             modeRGB);
    paramBuffer.addEnumParam("modeAlpha", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum,
                             modeAlpha);

    return CallCapture(gl::EntryPoint::BlendEquationSeparateiEXT, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationiEXT(const State &glState,
                                     bool isCallValid,
                                     GLuint buf,
                                     GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("mode", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum, mode);

    return CallCapture(gl::EntryPoint::BlendEquationiEXT, std::move(paramBuffer));
}

CallCapture CaptureBlendFuncSeparateiEXT(const State &glState,
                                         bool isCallValid,
                                         GLuint buf,
                                         GLenum srcRGB,
                                         GLenum dstRGB,
                                         GLenum srcAlpha,
                                         GLenum dstAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("srcRGB", GLenumGroup::BlendingFactor, ParamType::TGLenum, srcRGB);
    paramBuffer.addEnumParam("dstRGB", GLenumGroup::BlendingFactor, ParamType::TGLenum, dstRGB);
    paramBuffer.addEnumParam("srcAlpha", GLenumGroup::BlendingFactor, ParamType::TGLenum, srcAlpha);
    paramBuffer.addEnumParam("dstAlpha", GLenumGroup::BlendingFactor, ParamType::TGLenum, dstAlpha);

    return CallCapture(gl::EntryPoint::BlendFuncSeparateiEXT, std::move(paramBuffer));
}

CallCapture CaptureBlendFunciEXT(const State &glState,
                                 bool isCallValid,
                                 GLuint buf,
                                 GLenum src,
                                 GLenum dst)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("src", GLenumGroup::BlendingFactor, ParamType::TGLenum, src);
    paramBuffer.addEnumParam("dst", GLenumGroup::BlendingFactor, ParamType::TGLenum, dst);

    return CallCapture(gl::EntryPoint::BlendFunciEXT, std::move(paramBuffer));
}

CallCapture CaptureColorMaskiEXT(const State &glState,
                                 bool isCallValid,
                                 GLuint index,
                                 GLboolean r,
                                 GLboolean g,
                                 GLboolean b,
                                 GLboolean a)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("r", ParamType::TGLboolean, r);
    paramBuffer.addValueParam("g", ParamType::TGLboolean, g);
    paramBuffer.addValueParam("b", ParamType::TGLboolean, b);
    paramBuffer.addValueParam("a", ParamType::TGLboolean, a);

    return CallCapture(gl::EntryPoint::ColorMaskiEXT, std::move(paramBuffer));
}

CallCapture CaptureDisableiEXT(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(gl::EntryPoint::DisableiEXT, std::move(paramBuffer));
}

CallCapture CaptureEnableiEXT(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(gl::EntryPoint::EnableiEXT, std::move(paramBuffer));
}

CallCapture CaptureIsEnablediEXT(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLuint index,
                                 GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsEnablediEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsBaseVertexEXT(const State &glState,
                                             bool isCallValid,
                                             PrimitiveMode modePacked,
                                             GLsizei count,
                                             DrawElementsType typePacked,
                                             const void *indices,
                                             GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsBaseVertexEXT_indices(glState, isCallValid, modePacked, count,
                                                 typePacked, indices, basevertex, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(gl::EntryPoint::DrawElementsBaseVertexEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertexEXT(const State &glState,
                                                      bool isCallValid,
                                                      PrimitiveMode modePacked,
                                                      GLsizei count,
                                                      DrawElementsType typePacked,
                                                      const void *indices,
                                                      GLsizei instancecount,
                                                      GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseVertexEXT_indices(glState, isCallValid, modePacked, count,
                                                          typePacked, indices, instancecount,
                                                          basevertex, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(gl::EntryPoint::DrawElementsInstancedBaseVertexEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawRangeElementsBaseVertexEXT(const State &glState,
                                                  bool isCallValid,
                                                  PrimitiveMode modePacked,
                                                  GLuint start,
                                                  GLuint end,
                                                  GLsizei count,
                                                  DrawElementsType typePacked,
                                                  const void *indices,
                                                  GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLuint, start);
    paramBuffer.addValueParam("end", ParamType::TGLuint, end);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawRangeElementsBaseVertexEXT_indices(glState, isCallValid, modePacked, start, end,
                                                      count, typePacked, indices, basevertex,
                                                      &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(gl::EntryPoint::DrawRangeElementsBaseVertexEXT, std::move(paramBuffer));
}

CallCapture CaptureMultiDrawElementsBaseVertexEXT(const State &glState,
                                                  bool isCallValid,
                                                  PrimitiveMode modePacked,
                                                  const GLsizei *count,
                                                  DrawElementsType typePacked,
                                                  const void *const *indices,
                                                  GLsizei primcount,
                                                  const GLint *basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, count, &countParam.value);
        CaptureMultiDrawElementsBaseVertexEXT_count(glState, isCallValid, modePacked, count,
                                                    typePacked, indices, primcount, basevertex,
                                                    &countParam);
        paramBuffer.addParam(std::move(countParam));
    }
    else
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countParam.value);
        paramBuffer.addParam(std::move(countParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsBaseVertexEXT_indices(glState, isCallValid, modePacked, count,
                                                      typePacked, indices, primcount, basevertex,
                                                      &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer,
                       static_cast<const void *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    if (isCallValid)
    {
        ParamCapture basevertexParam("basevertex", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, basevertex, &basevertexParam.value);
        CaptureMultiDrawElementsBaseVertexEXT_basevertex(glState, isCallValid, modePacked, count,
                                                         typePacked, indices, primcount, basevertex,
                                                         &basevertexParam);
        paramBuffer.addParam(std::move(basevertexParam));
    }
    else
    {
        ParamCapture basevertexParam("basevertex", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &basevertexParam.value);
        paramBuffer.addParam(std::move(basevertexParam));
    }

    return CallCapture(gl::EntryPoint::MultiDrawElementsBaseVertexEXT, std::move(paramBuffer));
}

CallCapture CaptureBufferStorageExternalEXT(const State &glState,
                                            bool isCallValid,
                                            BufferBinding targetPacked,
                                            GLintptr offset,
                                            GLsizeiptr size,
                                            GLeglClientBufferEXT clientBuffer,
                                            GLbitfield flags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);
    paramBuffer.addValueParam("clientBuffer", ParamType::TGLeglClientBufferEXT, clientBuffer);
    paramBuffer.addEnumParam("flags", GLenumGroup::MapBufferUsageMask, ParamType::TGLbitfield,
                             flags);

    return CallCapture(gl::EntryPoint::BufferStorageExternalEXT, std::move(paramBuffer));
}

CallCapture CaptureNamedBufferStorageExternalEXT(const State &glState,
                                                 bool isCallValid,
                                                 GLuint buffer,
                                                 GLintptr offset,
                                                 GLsizeiptr size,
                                                 GLeglClientBufferEXT clientBuffer,
                                                 GLbitfield flags)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buffer", ParamType::TGLuint, buffer);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);
    paramBuffer.addValueParam("clientBuffer", ParamType::TGLeglClientBufferEXT, clientBuffer);
    paramBuffer.addEnumParam("flags", GLenumGroup::MapBufferUsageMask, ParamType::TGLbitfield,
                             flags);

    return CallCapture(gl::EntryPoint::NamedBufferStorageExternalEXT, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureEXT(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLenum attachment,
                                         TextureID texturePacked,
                                         GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(gl::EntryPoint::FramebufferTextureEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstancedEXT(const State &glState,
                                          bool isCallValid,
                                          PrimitiveMode modePacked,
                                          GLint start,
                                          GLsizei count,
                                          GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLint, start);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(gl::EntryPoint::DrawArraysInstancedEXT, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedEXT(const State &glState,
                                            bool isCallValid,
                                            PrimitiveMode modePacked,
                                            GLsizei count,
                                            DrawElementsType typePacked,
                                            const void *indices,
                                            GLsizei primcount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedEXT_indices(glState, isCallValid, modePacked, count, typePacked,
                                                indices, primcount, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("primcount", ParamType::TGLsizei, primcount);

    return CallCapture(gl::EntryPoint::DrawElementsInstancedEXT, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisorEXT(const State &glState,
                                          bool isCallValid,
                                          GLuint index,
                                          GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(gl::EntryPoint::VertexAttribDivisorEXT, std::move(paramBuffer));
}

CallCapture CaptureFlushMappedBufferRangeEXT(const State &glState,
                                             bool isCallValid,
                                             BufferBinding targetPacked,
                                             GLintptr offset,
                                             GLsizeiptr length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);

    return CallCapture(gl::EntryPoint::FlushMappedBufferRangeEXT, std::move(paramBuffer));
}

CallCapture CaptureMapBufferRangeEXT(const State &glState,
                                     bool isCallValid,
                                     BufferBinding targetPacked,
                                     GLintptr offset,
                                     GLsizeiptr length,
                                     GLbitfield access,
                                     void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);
    paramBuffer.addEnumParam("access", GLenumGroup::BufferAccessMask, ParamType::TGLbitfield,
                             access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::MapBufferRangeEXT, std::move(paramBuffer));
}

CallCapture CaptureBufferStorageMemEXT(const State &glState,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLsizeiptr size,
                                       MemoryObjectID memoryPacked,
                                       GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::BufferStorageMemEXT, std::move(paramBuffer));
}

CallCapture CaptureCreateMemoryObjectsEXT(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          MemoryObjectID *memoryObjectsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture memoryObjectsPackedParam("memoryObjectsPacked",
                                              ParamType::TMemoryObjectIDPointer);
        InitParamValue(ParamType::TMemoryObjectIDPointer, memoryObjectsPacked,
                       &memoryObjectsPackedParam.value);
        CaptureCreateMemoryObjectsEXT_memoryObjectsPacked(
            glState, isCallValid, n, memoryObjectsPacked, &memoryObjectsPackedParam);
        paramBuffer.addParam(std::move(memoryObjectsPackedParam));
    }
    else
    {
        ParamCapture memoryObjectsPackedParam("memoryObjectsPacked",
                                              ParamType::TMemoryObjectIDPointer);
        InitParamValue(ParamType::TMemoryObjectIDPointer, static_cast<MemoryObjectID *>(nullptr),
                       &memoryObjectsPackedParam.value);
        paramBuffer.addParam(std::move(memoryObjectsPackedParam));
    }

    return CallCapture(gl::EntryPoint::CreateMemoryObjectsEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteMemoryObjectsEXT(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          const MemoryObjectID *memoryObjectsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture memoryObjectsPackedParam("memoryObjectsPacked",
                                              ParamType::TMemoryObjectIDConstPointer);
        InitParamValue(ParamType::TMemoryObjectIDConstPointer, memoryObjectsPacked,
                       &memoryObjectsPackedParam.value);
        CaptureDeleteMemoryObjectsEXT_memoryObjectsPacked(
            glState, isCallValid, n, memoryObjectsPacked, &memoryObjectsPackedParam);
        paramBuffer.addParam(std::move(memoryObjectsPackedParam));
    }
    else
    {
        ParamCapture memoryObjectsPackedParam("memoryObjectsPacked",
                                              ParamType::TMemoryObjectIDConstPointer);
        InitParamValue(ParamType::TMemoryObjectIDConstPointer,
                       static_cast<const MemoryObjectID *>(nullptr),
                       &memoryObjectsPackedParam.value);
        paramBuffer.addParam(std::move(memoryObjectsPackedParam));
    }

    return CallCapture(gl::EntryPoint::DeleteMemoryObjectsEXT, std::move(paramBuffer));
}

CallCapture CaptureGetMemoryObjectParameterivEXT(const State &glState,
                                                 bool isCallValid,
                                                 MemoryObjectID memoryObjectPacked,
                                                 GLenum pname,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObjectPacked", ParamType::TMemoryObjectID, memoryObjectPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::MemoryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetMemoryObjectParameterivEXT_params(glState, isCallValid, memoryObjectPacked, pname,
                                                    params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetMemoryObjectParameterivEXT, std::move(paramBuffer));
}

CallCapture CaptureGetUnsignedBytevEXT(const State &glState,
                                       bool isCallValid,
                                       GLenum pname,
                                       GLubyte *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::GetPName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, data, &dataParam.value);
        CaptureGetUnsignedBytevEXT_data(glState, isCallValid, pname, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, static_cast<GLubyte *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::GetUnsignedBytevEXT, std::move(paramBuffer));
}

CallCapture CaptureGetUnsignedBytei_vEXT(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLuint index,
                                         GLubyte *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, data, &dataParam.value);
        CaptureGetUnsignedBytei_vEXT_data(glState, isCallValid, target, index, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLubytePointer);
        InitParamValue(ParamType::TGLubytePointer, static_cast<GLubyte *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::GetUnsignedBytei_vEXT, std::move(paramBuffer));
}

CallCapture CaptureIsMemoryObjectEXT(const State &glState,
                                     bool isCallValid,
                                     MemoryObjectID memoryObjectPacked,
                                     GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObjectPacked", ParamType::TMemoryObjectID, memoryObjectPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsMemoryObjectEXT, std::move(paramBuffer));
}

CallCapture CaptureMemoryObjectParameterivEXT(const State &glState,
                                              bool isCallValid,
                                              MemoryObjectID memoryObjectPacked,
                                              GLenum pname,
                                              const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryObjectPacked", ParamType::TMemoryObjectID, memoryObjectPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::MemoryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureMemoryObjectParameterivEXT_params(glState, isCallValid, memoryObjectPacked, pname,
                                                 params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::MemoryObjectParameterivEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem2DEXT(const State &glState,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      MemoryObjectID memoryPacked,
                                      GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::TexStorageMem2DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem2DMultisampleEXT(const State &glState,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLboolean fixedSampleLocations,
                                                 MemoryObjectID memoryPacked,
                                                 GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::TexStorageMem2DMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem3DEXT(const State &glState,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLsizei levels,
                                      GLenum internalFormat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      MemoryObjectID memoryPacked,
                                      GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::TexStorageMem3DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorageMem3DMultisampleEXT(const State &glState,
                                                 bool isCallValid,
                                                 TextureType targetPacked,
                                                 GLsizei samples,
                                                 GLenum internalFormat,
                                                 GLsizei width,
                                                 GLsizei height,
                                                 GLsizei depth,
                                                 GLboolean fixedSampleLocations,
                                                 MemoryObjectID memoryPacked,
                                                 GLuint64 offset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             internalFormat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedSampleLocations", ParamType::TGLboolean, fixedSampleLocations);
    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLuint64, offset);

    return CallCapture(gl::EntryPoint::TexStorageMem3DMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureImportMemoryFdEXT(const State &glState,
                                     bool isCallValid,
                                     MemoryObjectID memoryPacked,
                                     GLuint64 size,
                                     HandleType handleTypePacked,
                                     GLint fd)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memoryPacked", ParamType::TMemoryObjectID, memoryPacked);
    paramBuffer.addValueParam("size", ParamType::TGLuint64, size);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("fd", ParamType::TGLint, fd);

    return CallCapture(gl::EntryPoint::ImportMemoryFdEXT, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2DMultisampleEXT(const State &glState,
                                                      bool isCallValid,
                                                      GLenum target,
                                                      GLenum attachment,
                                                      TextureTarget textargetPacked,
                                                      TextureID texturePacked,
                                                      GLint level,
                                                      GLsizei samples)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);

    return CallCapture(gl::EntryPoint::FramebufferTexture2DMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageMultisampleEXT(const State &glState,
                                                     bool isCallValid,
                                                     GLenum target,
                                                     GLsizei samples,
                                                     GLenum internalformat,
                                                     GLsizei width,
                                                     GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::RenderbufferStorageMultisampleEXT, std::move(paramBuffer));
}

CallCapture CaptureGetGraphicsResetStatusEXT(const State &glState,
                                             bool isCallValid,
                                             GLenum returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetGraphicsResetStatusEXT, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformfvEXT(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLsizei bufSize,
                                    GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetnUniformfvEXT_params(glState, isCallValid, programPacked, locationPacked, bufSize,
                                       params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetnUniformfvEXT, std::move(paramBuffer));
}

CallCapture CaptureGetnUniformivEXT(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLsizei bufSize,
                                    GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetnUniformivEXT_params(glState, isCallValid, programPacked, locationPacked, bufSize,
                                       params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetnUniformivEXT, std::move(paramBuffer));
}

CallCapture CaptureReadnPixelsEXT(const State &glState,
                                  bool isCallValid,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLenum type,
                                  GLsizei bufSize,
                                  void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, data, &dataParam.value);
        CaptureReadnPixelsEXT_data(glState, isCallValid, x, y, width, height, format, type, bufSize,
                                   data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::ReadnPixelsEXT, std::move(paramBuffer));
}

CallCapture CaptureDeleteSemaphoresEXT(const State &glState,
                                       bool isCallValid,
                                       GLsizei n,
                                       const SemaphoreID *semaphoresPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDConstPointer);
        InitParamValue(ParamType::TSemaphoreIDConstPointer, semaphoresPacked,
                       &semaphoresPackedParam.value);
        CaptureDeleteSemaphoresEXT_semaphoresPacked(glState, isCallValid, n, semaphoresPacked,
                                                    &semaphoresPackedParam);
        paramBuffer.addParam(std::move(semaphoresPackedParam));
    }
    else
    {
        ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDConstPointer);
        InitParamValue(ParamType::TSemaphoreIDConstPointer,
                       static_cast<const SemaphoreID *>(nullptr), &semaphoresPackedParam.value);
        paramBuffer.addParam(std::move(semaphoresPackedParam));
    }

    return CallCapture(gl::EntryPoint::DeleteSemaphoresEXT, std::move(paramBuffer));
}

CallCapture CaptureGenSemaphoresEXT(const State &glState,
                                    bool isCallValid,
                                    GLsizei n,
                                    SemaphoreID *semaphoresPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDPointer);
        InitParamValue(ParamType::TSemaphoreIDPointer, semaphoresPacked,
                       &semaphoresPackedParam.value);
        CaptureGenSemaphoresEXT_semaphoresPacked(glState, isCallValid, n, semaphoresPacked,
                                                 &semaphoresPackedParam);
        paramBuffer.addParam(std::move(semaphoresPackedParam));
    }
    else
    {
        ParamCapture semaphoresPackedParam("semaphoresPacked", ParamType::TSemaphoreIDPointer);
        InitParamValue(ParamType::TSemaphoreIDPointer, static_cast<SemaphoreID *>(nullptr),
                       &semaphoresPackedParam.value);
        paramBuffer.addParam(std::move(semaphoresPackedParam));
    }

    return CallCapture(gl::EntryPoint::GenSemaphoresEXT, std::move(paramBuffer));
}

CallCapture CaptureGetSemaphoreParameterui64vEXT(const State &glState,
                                                 bool isCallValid,
                                                 SemaphoreID semaphorePacked,
                                                 GLenum pname,
                                                 GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SemaphoreParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
        CaptureGetSemaphoreParameterui64vEXT_params(glState, isCallValid, semaphorePacked, pname,
                                                    params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, static_cast<GLuint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetSemaphoreParameterui64vEXT, std::move(paramBuffer));
}

CallCapture CaptureIsSemaphoreEXT(const State &glState,
                                  bool isCallValid,
                                  SemaphoreID semaphorePacked,
                                  GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsSemaphoreEXT, std::move(paramBuffer));
}

CallCapture CaptureSemaphoreParameterui64vEXT(const State &glState,
                                              bool isCallValid,
                                              SemaphoreID semaphorePacked,
                                              GLenum pname,
                                              const GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SemaphoreParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64ConstPointer);
        InitParamValue(ParamType::TGLuint64ConstPointer, params, &paramsParam.value);
        CaptureSemaphoreParameterui64vEXT_params(glState, isCallValid, semaphorePacked, pname,
                                                 params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64ConstPointer);
        InitParamValue(ParamType::TGLuint64ConstPointer, static_cast<const GLuint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::SemaphoreParameterui64vEXT, std::move(paramBuffer));
}

CallCapture CaptureSignalSemaphoreEXT(const State &glState,
                                      bool isCallValid,
                                      SemaphoreID semaphorePacked,
                                      GLuint numBufferBarriers,
                                      const BufferID *buffersPacked,
                                      GLuint numTextureBarriers,
                                      const TextureID *texturesPacked,
                                      const GLenum *dstLayouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("numBufferBarriers", ParamType::TGLuint, numBufferBarriers);

    if (isCallValid)
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
        CaptureSignalSemaphoreEXT_buffersPacked(
            glState, isCallValid, semaphorePacked, numBufferBarriers, buffersPacked,
            numTextureBarriers, texturesPacked, dstLayouts, &buffersPackedParam);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }
    else
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, static_cast<const BufferID *>(nullptr),
                       &buffersPackedParam.value);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }

    paramBuffer.addValueParam("numTextureBarriers", ParamType::TGLuint, numTextureBarriers);

    if (isCallValid)
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked,
                       &texturesPackedParam.value);
        CaptureSignalSemaphoreEXT_texturesPacked(
            glState, isCallValid, semaphorePacked, numBufferBarriers, buffersPacked,
            numTextureBarriers, texturesPacked, dstLayouts, &texturesPackedParam);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }
    else
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, static_cast<const TextureID *>(nullptr),
                       &texturesPackedParam.value);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }

    if (isCallValid)
    {
        ParamCapture dstLayoutsParam("dstLayouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, dstLayouts, &dstLayoutsParam.value);
        CaptureSignalSemaphoreEXT_dstLayouts(glState, isCallValid, semaphorePacked,
                                             numBufferBarriers, buffersPacked, numTextureBarriers,
                                             texturesPacked, dstLayouts, &dstLayoutsParam);
        paramBuffer.addParam(std::move(dstLayoutsParam));
    }
    else
    {
        ParamCapture dstLayoutsParam("dstLayouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &dstLayoutsParam.value);
        paramBuffer.addParam(std::move(dstLayoutsParam));
    }

    return CallCapture(gl::EntryPoint::SignalSemaphoreEXT, std::move(paramBuffer));
}

CallCapture CaptureWaitSemaphoreEXT(const State &glState,
                                    bool isCallValid,
                                    SemaphoreID semaphorePacked,
                                    GLuint numBufferBarriers,
                                    const BufferID *buffersPacked,
                                    GLuint numTextureBarriers,
                                    const TextureID *texturesPacked,
                                    const GLenum *srcLayouts)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("numBufferBarriers", ParamType::TGLuint, numBufferBarriers);

    if (isCallValid)
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, buffersPacked, &buffersPackedParam.value);
        CaptureWaitSemaphoreEXT_buffersPacked(glState, isCallValid, semaphorePacked,
                                              numBufferBarriers, buffersPacked, numTextureBarriers,
                                              texturesPacked, srcLayouts, &buffersPackedParam);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }
    else
    {
        ParamCapture buffersPackedParam("buffersPacked", ParamType::TBufferIDConstPointer);
        InitParamValue(ParamType::TBufferIDConstPointer, static_cast<const BufferID *>(nullptr),
                       &buffersPackedParam.value);
        paramBuffer.addParam(std::move(buffersPackedParam));
    }

    paramBuffer.addValueParam("numTextureBarriers", ParamType::TGLuint, numTextureBarriers);

    if (isCallValid)
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, texturesPacked,
                       &texturesPackedParam.value);
        CaptureWaitSemaphoreEXT_texturesPacked(glState, isCallValid, semaphorePacked,
                                               numBufferBarriers, buffersPacked, numTextureBarriers,
                                               texturesPacked, srcLayouts, &texturesPackedParam);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }
    else
    {
        ParamCapture texturesPackedParam("texturesPacked", ParamType::TTextureIDConstPointer);
        InitParamValue(ParamType::TTextureIDConstPointer, static_cast<const TextureID *>(nullptr),
                       &texturesPackedParam.value);
        paramBuffer.addParam(std::move(texturesPackedParam));
    }

    if (isCallValid)
    {
        ParamCapture srcLayoutsParam("srcLayouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, srcLayouts, &srcLayoutsParam.value);
        CaptureWaitSemaphoreEXT_srcLayouts(glState, isCallValid, semaphorePacked, numBufferBarriers,
                                           buffersPacked, numTextureBarriers, texturesPacked,
                                           srcLayouts, &srcLayoutsParam);
        paramBuffer.addParam(std::move(srcLayoutsParam));
    }
    else
    {
        ParamCapture srcLayoutsParam("srcLayouts", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &srcLayoutsParam.value);
        paramBuffer.addParam(std::move(srcLayoutsParam));
    }

    return CallCapture(gl::EntryPoint::WaitSemaphoreEXT, std::move(paramBuffer));
}

CallCapture CaptureImportSemaphoreFdEXT(const State &glState,
                                        bool isCallValid,
                                        SemaphoreID semaphorePacked,
                                        HandleType handleTypePacked,
                                        GLint fd)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("semaphorePacked", ParamType::TSemaphoreID, semaphorePacked);
    paramBuffer.addValueParam("handleTypePacked", ParamType::THandleType, handleTypePacked);
    paramBuffer.addValueParam("fd", ParamType::TGLint, fd);

    return CallCapture(gl::EntryPoint::ImportSemaphoreFdEXT, std::move(paramBuffer));
}

CallCapture CaptureTexBufferEXT(const State &glState,
                                bool isCallValid,
                                TextureType targetPacked,
                                GLenum internalformat,
                                BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(gl::EntryPoint::TexBufferEXT, std::move(paramBuffer));
}

CallCapture CaptureTexBufferRangeEXT(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum internalformat,
                                     BufferID bufferPacked,
                                     GLintptr offset,
                                     GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(gl::EntryPoint::TexBufferRangeEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorage1DEXT(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);

    return CallCapture(gl::EntryPoint::TexStorage1DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DEXT(const State &glState,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::TexStorage2DEXT, std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DEXT(const State &glState,
                                   bool isCallValid,
                                   TextureType targetPacked,
                                   GLsizei levels,
                                   GLenum internalformat,
                                   GLsizei width,
                                   GLsizei height,
                                   GLsizei depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);

    return CallCapture(gl::EntryPoint::TexStorage3DEXT, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageCallbackKHR(const State &glState,
                                           bool isCallValid,
                                           GLDEBUGPROCKHR callback,
                                           const void *userParam)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("callback", ParamType::TGLDEBUGPROCKHR, callback);

    if (isCallValid)
    {
        ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, userParam, &userParamParam.value);
        CaptureDebugMessageCallbackKHR_userParam(glState, isCallValid, callback, userParam,
                                                 &userParamParam);
        paramBuffer.addParam(std::move(userParamParam));
    }
    else
    {
        ParamCapture userParamParam("userParam", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &userParamParam.value);
        paramBuffer.addParam(std::move(userParamParam));
    }

    return CallCapture(gl::EntryPoint::DebugMessageCallbackKHR, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageControlKHR(const State &glState,
                                          bool isCallValid,
                                          GLenum source,
                                          GLenum type,
                                          GLenum severity,
                                          GLsizei count,
                                          const GLuint *ids,
                                          GLboolean enabled)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLenumGroup::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLenumGroup::DebugType, ParamType::TGLenum, type);
    paramBuffer.addEnumParam("severity", GLenumGroup::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, ids, &idsParam.value);
        CaptureDebugMessageControlKHR_ids(glState, isCallValid, source, type, severity, count, ids,
                                          enabled, &idsParam);
        paramBuffer.addParam(std::move(idsParam));
    }
    else
    {
        ParamCapture idsParam("ids", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &idsParam.value);
        paramBuffer.addParam(std::move(idsParam));
    }

    paramBuffer.addValueParam("enabled", ParamType::TGLboolean, enabled);

    return CallCapture(gl::EntryPoint::DebugMessageControlKHR, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageInsertKHR(const State &glState,
                                         bool isCallValid,
                                         GLenum source,
                                         GLenum type,
                                         GLuint id,
                                         GLenum severity,
                                         GLsizei length,
                                         const GLchar *buf)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLenumGroup::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addEnumParam("type", GLenumGroup::DebugType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addEnumParam("severity", GLenumGroup::DebugSeverity, ParamType::TGLenum, severity);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture bufParam("buf", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, buf, &bufParam.value);
        CaptureDebugMessageInsertKHR_buf(glState, isCallValid, source, type, id, severity, length,
                                         buf, &bufParam);
        paramBuffer.addParam(std::move(bufParam));
    }
    else
    {
        ParamCapture bufParam("buf", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &bufParam.value);
        paramBuffer.addParam(std::move(bufParam));
    }

    return CallCapture(gl::EntryPoint::DebugMessageInsertKHR, std::move(paramBuffer));
}

CallCapture CaptureGetDebugMessageLogKHR(const State &glState,
                                         bool isCallValid,
                                         GLuint count,
                                         GLsizei bufSize,
                                         GLenum *sources,
                                         GLenum *types,
                                         GLuint *ids,
                                         GLenum *severities,
                                         GLsizei *lengths,
                                         GLchar *messageLog,
                                         GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture sourcesParam("sources", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, sources, &sourcesParam.value);
        CaptureGetDebugMessageLogKHR_sources(glState, isCallValid, count, bufSize, sources, types,
                                             ids, severities, lengths, messageLog, &sourcesParam);
        paramBuffer.addParam(std::move(sourcesParam));
    }
    else
    {
        ParamCapture sourcesParam("sources", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &sourcesParam.value);
        paramBuffer.addParam(std::move(sourcesParam));
    }

    if (isCallValid)
    {
        ParamCapture typesParam("types", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, types, &typesParam.value);
        CaptureGetDebugMessageLogKHR_types(glState, isCallValid, count, bufSize, sources, types,
                                           ids, severities, lengths, messageLog, &typesParam);
        paramBuffer.addParam(std::move(typesParam));
    }
    else
    {
        ParamCapture typesParam("types", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &typesParam.value);
        paramBuffer.addParam(std::move(typesParam));
    }

    if (isCallValid)
    {
        ParamCapture idsParam("ids", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, ids, &idsParam.value);
        CaptureGetDebugMessageLogKHR_ids(glState, isCallValid, count, bufSize, sources, types, ids,
                                         severities, lengths, messageLog, &idsParam);
        paramBuffer.addParam(std::move(idsParam));
    }
    else
    {
        ParamCapture idsParam("ids", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr), &idsParam.value);
        paramBuffer.addParam(std::move(idsParam));
    }

    if (isCallValid)
    {
        ParamCapture severitiesParam("severities", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, severities, &severitiesParam.value);
        CaptureGetDebugMessageLogKHR_severities(glState, isCallValid, count, bufSize, sources,
                                                types, ids, severities, lengths, messageLog,
                                                &severitiesParam);
        paramBuffer.addParam(std::move(severitiesParam));
    }
    else
    {
        ParamCapture severitiesParam("severities", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &severitiesParam.value);
        paramBuffer.addParam(std::move(severitiesParam));
    }

    if (isCallValid)
    {
        ParamCapture lengthsParam("lengths", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, lengths, &lengthsParam.value);
        CaptureGetDebugMessageLogKHR_lengths(glState, isCallValid, count, bufSize, sources, types,
                                             ids, severities, lengths, messageLog, &lengthsParam);
        paramBuffer.addParam(std::move(lengthsParam));
    }
    else
    {
        ParamCapture lengthsParam("lengths", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthsParam.value);
        paramBuffer.addParam(std::move(lengthsParam));
    }

    if (isCallValid)
    {
        ParamCapture messageLogParam("messageLog", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, messageLog, &messageLogParam.value);
        CaptureGetDebugMessageLogKHR_messageLog(glState, isCallValid, count, bufSize, sources,
                                                types, ids, severities, lengths, messageLog,
                                                &messageLogParam);
        paramBuffer.addParam(std::move(messageLogParam));
    }
    else
    {
        ParamCapture messageLogParam("messageLog", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &messageLogParam.value);
        paramBuffer.addParam(std::move(messageLogParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::GetDebugMessageLogKHR, std::move(paramBuffer));
}

CallCapture CaptureGetObjectLabelKHR(const State &glState,
                                     bool isCallValid,
                                     GLenum identifier,
                                     GLuint name,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetObjectLabelKHR_length(glState, isCallValid, identifier, name, bufSize, length,
                                        label, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
        CaptureGetObjectLabelKHR_label(glState, isCallValid, identifier, name, bufSize, length,
                                       label, &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(gl::EntryPoint::GetObjectLabelKHR, std::move(paramBuffer));
}

CallCapture CaptureGetObjectPtrLabelKHR(const State &glState,
                                        bool isCallValid,
                                        const void *ptr,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLchar *label)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureGetObjectPtrLabelKHR_ptr(glState, isCallValid, ptr, bufSize, length, label,
                                        &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetObjectPtrLabelKHR_length(glState, isCallValid, ptr, bufSize, length, label,
                                           &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, label, &labelParam.value);
        CaptureGetObjectPtrLabelKHR_label(glState, isCallValid, ptr, bufSize, length, label,
                                          &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(gl::EntryPoint::GetObjectPtrLabelKHR, std::move(paramBuffer));
}

CallCapture CaptureGetPointervKHR(const State &glState,
                                  bool isCallValid,
                                  GLenum pname,
                                  void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetPointervKHR_params(glState, isCallValid, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetPointervKHR, std::move(paramBuffer));
}

CallCapture CaptureObjectLabelKHR(const State &glState,
                                  bool isCallValid,
                                  GLenum identifier,
                                  GLuint name,
                                  GLsizei length,
                                  const GLchar *label)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("identifier", GLenumGroup::ObjectIdentifier, ParamType::TGLenum,
                             identifier);
    paramBuffer.addValueParam("name", ParamType::TGLuint, name);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
        CaptureObjectLabelKHR_label(glState, isCallValid, identifier, name, length, label,
                                    &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(gl::EntryPoint::ObjectLabelKHR, std::move(paramBuffer));
}

CallCapture CaptureObjectPtrLabelKHR(const State &glState,
                                     bool isCallValid,
                                     const void *ptr,
                                     GLsizei length,
                                     const GLchar *label)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureObjectPtrLabelKHR_ptr(glState, isCallValid, ptr, length, label, &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, label, &labelParam.value);
        CaptureObjectPtrLabelKHR_label(glState, isCallValid, ptr, length, label, &labelParam);
        paramBuffer.addParam(std::move(labelParam));
    }
    else
    {
        ParamCapture labelParam("label", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &labelParam.value);
        paramBuffer.addParam(std::move(labelParam));
    }

    return CallCapture(gl::EntryPoint::ObjectPtrLabelKHR, std::move(paramBuffer));
}

CallCapture CapturePopDebugGroupKHR(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::PopDebugGroupKHR, std::move(paramBuffer));
}

CallCapture CapturePushDebugGroupKHR(const State &glState,
                                     bool isCallValid,
                                     GLenum source,
                                     GLuint id,
                                     GLsizei length,
                                     const GLchar *message)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("source", GLenumGroup::DebugSource, ParamType::TGLenum, source);
    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    if (isCallValid)
    {
        ParamCapture messageParam("message", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, message, &messageParam.value);
        CapturePushDebugGroupKHR_message(glState, isCallValid, source, id, length, message,
                                         &messageParam);
        paramBuffer.addParam(std::move(messageParam));
    }
    else
    {
        ParamCapture messageParam("message", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &messageParam.value);
        paramBuffer.addParam(std::move(messageParam));
    }

    return CallCapture(gl::EntryPoint::PushDebugGroupKHR, std::move(paramBuffer));
}

CallCapture CaptureMaxShaderCompilerThreadsKHR(const State &glState, bool isCallValid, GLuint count)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLuint, count);

    return CallCapture(gl::EntryPoint::MaxShaderCompilerThreadsKHR, std::move(paramBuffer));
}

CallCapture CaptureDeleteFencesNV(const State &glState,
                                  bool isCallValid,
                                  GLsizei n,
                                  const FenceNVID *fencesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDConstPointer);
        InitParamValue(ParamType::TFenceNVIDConstPointer, fencesPacked, &fencesPackedParam.value);
        CaptureDeleteFencesNV_fencesPacked(glState, isCallValid, n, fencesPacked,
                                           &fencesPackedParam);
        paramBuffer.addParam(std::move(fencesPackedParam));
    }
    else
    {
        ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDConstPointer);
        InitParamValue(ParamType::TFenceNVIDConstPointer, static_cast<const FenceNVID *>(nullptr),
                       &fencesPackedParam.value);
        paramBuffer.addParam(std::move(fencesPackedParam));
    }

    return CallCapture(gl::EntryPoint::DeleteFencesNV, std::move(paramBuffer));
}

CallCapture CaptureFinishFenceNV(const State &glState, bool isCallValid, FenceNVID fencePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);

    return CallCapture(gl::EntryPoint::FinishFenceNV, std::move(paramBuffer));
}

CallCapture CaptureGenFencesNV(const State &glState,
                               bool isCallValid,
                               GLsizei n,
                               FenceNVID *fencesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDPointer);
        InitParamValue(ParamType::TFenceNVIDPointer, fencesPacked, &fencesPackedParam.value);
        CaptureGenFencesNV_fencesPacked(glState, isCallValid, n, fencesPacked, &fencesPackedParam);
        paramBuffer.addParam(std::move(fencesPackedParam));
    }
    else
    {
        ParamCapture fencesPackedParam("fencesPacked", ParamType::TFenceNVIDPointer);
        InitParamValue(ParamType::TFenceNVIDPointer, static_cast<FenceNVID *>(nullptr),
                       &fencesPackedParam.value);
        paramBuffer.addParam(std::move(fencesPackedParam));
    }

    return CallCapture(gl::EntryPoint::GenFencesNV, std::move(paramBuffer));
}

CallCapture CaptureGetFenceivNV(const State &glState,
                                bool isCallValid,
                                FenceNVID fencePacked,
                                GLenum pname,
                                GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFenceivNV_params(glState, isCallValid, fencePacked, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetFenceivNV, std::move(paramBuffer));
}

CallCapture CaptureIsFenceNV(const State &glState,
                             bool isCallValid,
                             FenceNVID fencePacked,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsFenceNV, std::move(paramBuffer));
}

CallCapture CaptureSetFenceNV(const State &glState,
                              bool isCallValid,
                              FenceNVID fencePacked,
                              GLenum condition)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);
    paramBuffer.addEnumParam("condition", GLenumGroup::DefaultGroup, ParamType::TGLenum, condition);

    return CallCapture(gl::EntryPoint::SetFenceNV, std::move(paramBuffer));
}

CallCapture CaptureTestFenceNV(const State &glState,
                               bool isCallValid,
                               FenceNVID fencePacked,
                               GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("fencePacked", ParamType::TFenceNVID, fencePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::TestFenceNV, std::move(paramBuffer));
}

CallCapture CaptureEGLImageTargetRenderbufferStorageOES(const State &glState,
                                                        bool isCallValid,
                                                        GLenum target,
                                                        GLeglImageOES image)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::DefaultGroup, ParamType::TGLenum, target);
    paramBuffer.addValueParam("image", ParamType::TGLeglImageOES, image);

    return CallCapture(gl::EntryPoint::EGLImageTargetRenderbufferStorageOES,
                       std::move(paramBuffer));
}

CallCapture CaptureEGLImageTargetTexture2DOES(const State &glState,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLeglImageOES image)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("image", ParamType::TGLeglImageOES, image);

    return CallCapture(gl::EntryPoint::EGLImageTargetTexture2DOES, std::move(paramBuffer));
}

CallCapture CaptureCopyImageSubDataOES(const State &glState,
                                       bool isCallValid,
                                       GLuint srcName,
                                       GLenum srcTarget,
                                       GLint srcLevel,
                                       GLint srcX,
                                       GLint srcY,
                                       GLint srcZ,
                                       GLuint dstName,
                                       GLenum dstTarget,
                                       GLint dstLevel,
                                       GLint dstX,
                                       GLint dstY,
                                       GLint dstZ,
                                       GLsizei srcWidth,
                                       GLsizei srcHeight,
                                       GLsizei srcDepth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcName", ParamType::TGLuint, srcName);
    paramBuffer.addEnumParam("srcTarget", GLenumGroup::CopyBufferSubDataTarget, ParamType::TGLenum,
                             srcTarget);
    paramBuffer.addValueParam("srcLevel", ParamType::TGLint, srcLevel);
    paramBuffer.addValueParam("srcX", ParamType::TGLint, srcX);
    paramBuffer.addValueParam("srcY", ParamType::TGLint, srcY);
    paramBuffer.addValueParam("srcZ", ParamType::TGLint, srcZ);
    paramBuffer.addValueParam("dstName", ParamType::TGLuint, dstName);
    paramBuffer.addEnumParam("dstTarget", GLenumGroup::CopyBufferSubDataTarget, ParamType::TGLenum,
                             dstTarget);
    paramBuffer.addValueParam("dstLevel", ParamType::TGLint, dstLevel);
    paramBuffer.addValueParam("dstX", ParamType::TGLint, dstX);
    paramBuffer.addValueParam("dstY", ParamType::TGLint, dstY);
    paramBuffer.addValueParam("dstZ", ParamType::TGLint, dstZ);
    paramBuffer.addValueParam("srcWidth", ParamType::TGLsizei, srcWidth);
    paramBuffer.addValueParam("srcHeight", ParamType::TGLsizei, srcHeight);
    paramBuffer.addValueParam("srcDepth", ParamType::TGLsizei, srcDepth);

    return CallCapture(gl::EntryPoint::CopyImageSubDataOES, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationSeparateiOES(const State &glState,
                                             bool isCallValid,
                                             GLuint buf,
                                             GLenum modeRGB,
                                             GLenum modeAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("modeRGB", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum,
                             modeRGB);
    paramBuffer.addEnumParam("modeAlpha", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum,
                             modeAlpha);

    return CallCapture(gl::EntryPoint::BlendEquationSeparateiOES, std::move(paramBuffer));
}

CallCapture CaptureBlendEquationiOES(const State &glState,
                                     bool isCallValid,
                                     GLuint buf,
                                     GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("mode", GLenumGroup::BlendEquationModeEXT, ParamType::TGLenum, mode);

    return CallCapture(gl::EntryPoint::BlendEquationiOES, std::move(paramBuffer));
}

CallCapture CaptureBlendFuncSeparateiOES(const State &glState,
                                         bool isCallValid,
                                         GLuint buf,
                                         GLenum srcRGB,
                                         GLenum dstRGB,
                                         GLenum srcAlpha,
                                         GLenum dstAlpha)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("srcRGB", GLenumGroup::BlendingFactor, ParamType::TGLenum, srcRGB);
    paramBuffer.addEnumParam("dstRGB", GLenumGroup::BlendingFactor, ParamType::TGLenum, dstRGB);
    paramBuffer.addEnumParam("srcAlpha", GLenumGroup::BlendingFactor, ParamType::TGLenum, srcAlpha);
    paramBuffer.addEnumParam("dstAlpha", GLenumGroup::BlendingFactor, ParamType::TGLenum, dstAlpha);

    return CallCapture(gl::EntryPoint::BlendFuncSeparateiOES, std::move(paramBuffer));
}

CallCapture CaptureBlendFunciOES(const State &glState,
                                 bool isCallValid,
                                 GLuint buf,
                                 GLenum src,
                                 GLenum dst)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buf", ParamType::TGLuint, buf);
    paramBuffer.addEnumParam("src", GLenumGroup::BlendingFactor, ParamType::TGLenum, src);
    paramBuffer.addEnumParam("dst", GLenumGroup::BlendingFactor, ParamType::TGLenum, dst);

    return CallCapture(gl::EntryPoint::BlendFunciOES, std::move(paramBuffer));
}

CallCapture CaptureColorMaskiOES(const State &glState,
                                 bool isCallValid,
                                 GLuint index,
                                 GLboolean r,
                                 GLboolean g,
                                 GLboolean b,
                                 GLboolean a)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("r", ParamType::TGLboolean, r);
    paramBuffer.addValueParam("g", ParamType::TGLboolean, g);
    paramBuffer.addValueParam("b", ParamType::TGLboolean, b);
    paramBuffer.addValueParam("a", ParamType::TGLboolean, a);

    return CallCapture(gl::EntryPoint::ColorMaskiOES, std::move(paramBuffer));
}

CallCapture CaptureDisableiOES(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(gl::EntryPoint::DisableiOES, std::move(paramBuffer));
}

CallCapture CaptureEnableiOES(const State &glState, bool isCallValid, GLenum target, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(gl::EntryPoint::EnableiOES, std::move(paramBuffer));
}

CallCapture CaptureIsEnablediOES(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLuint index,
                                 GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::EnableCap, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsEnablediOES, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsBaseVertexOES(const State &glState,
                                             bool isCallValid,
                                             PrimitiveMode modePacked,
                                             GLsizei count,
                                             DrawElementsType typePacked,
                                             const void *indices,
                                             GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsBaseVertexOES_indices(glState, isCallValid, modePacked, count,
                                                 typePacked, indices, basevertex, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(gl::EntryPoint::DrawElementsBaseVertexOES, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstancedBaseVertexOES(const State &glState,
                                                      bool isCallValid,
                                                      PrimitiveMode modePacked,
                                                      GLsizei count,
                                                      DrawElementsType typePacked,
                                                      const void *indices,
                                                      GLsizei instancecount,
                                                      GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstancedBaseVertexOES_indices(glState, isCallValid, modePacked, count,
                                                          typePacked, indices, instancecount,
                                                          basevertex, &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);
    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(gl::EntryPoint::DrawElementsInstancedBaseVertexOES, std::move(paramBuffer));
}

CallCapture CaptureDrawRangeElementsBaseVertexOES(const State &glState,
                                                  bool isCallValid,
                                                  PrimitiveMode modePacked,
                                                  GLuint start,
                                                  GLuint end,
                                                  GLsizei count,
                                                  DrawElementsType typePacked,
                                                  const void *indices,
                                                  GLint basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLuint, start);
    paramBuffer.addValueParam("end", ParamType::TGLuint, end);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawRangeElementsBaseVertexOES_indices(glState, isCallValid, modePacked, start, end,
                                                      count, typePacked, indices, basevertex,
                                                      &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("basevertex", ParamType::TGLint, basevertex);

    return CallCapture(gl::EntryPoint::DrawRangeElementsBaseVertexOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexfOES(const State &glState,
                               bool isCallValid,
                               GLfloat x,
                               GLfloat y,
                               GLfloat z,
                               GLfloat width,
                               GLfloat height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfloat, x);
    paramBuffer.addValueParam("y", ParamType::TGLfloat, y);
    paramBuffer.addValueParam("z", ParamType::TGLfloat, z);
    paramBuffer.addValueParam("width", ParamType::TGLfloat, width);
    paramBuffer.addValueParam("height", ParamType::TGLfloat, height);

    return CallCapture(gl::EntryPoint::DrawTexfOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexfvOES(const State &glState, bool isCallValid, const GLfloat *coords)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, coords, &coordsParam.value);
        CaptureDrawTexfvOES_coords(glState, isCallValid, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(gl::EntryPoint::DrawTexfvOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexiOES(const State &glState,
                               bool isCallValid,
                               GLint x,
                               GLint y,
                               GLint z,
                               GLint width,
                               GLint height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("width", ParamType::TGLint, width);
    paramBuffer.addValueParam("height", ParamType::TGLint, height);

    return CallCapture(gl::EntryPoint::DrawTexiOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexivOES(const State &glState, bool isCallValid, const GLint *coords)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, coords, &coordsParam.value);
        CaptureDrawTexivOES_coords(glState, isCallValid, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(gl::EntryPoint::DrawTexivOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexsOES(const State &glState,
                               bool isCallValid,
                               GLshort x,
                               GLshort y,
                               GLshort z,
                               GLshort width,
                               GLshort height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLshort, x);
    paramBuffer.addValueParam("y", ParamType::TGLshort, y);
    paramBuffer.addValueParam("z", ParamType::TGLshort, z);
    paramBuffer.addValueParam("width", ParamType::TGLshort, width);
    paramBuffer.addValueParam("height", ParamType::TGLshort, height);

    return CallCapture(gl::EntryPoint::DrawTexsOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexsvOES(const State &glState, bool isCallValid, const GLshort *coords)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, coords, &coordsParam.value);
        CaptureDrawTexsvOES_coords(glState, isCallValid, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(gl::EntryPoint::DrawTexsvOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexxOES(const State &glState,
                               bool isCallValid,
                               GLfixed x,
                               GLfixed y,
                               GLfixed z,
                               GLfixed width,
                               GLfixed height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("x", ParamType::TGLfixed, x);
    paramBuffer.addValueParam("y", ParamType::TGLfixed, y);
    paramBuffer.addValueParam("z", ParamType::TGLfixed, z);
    paramBuffer.addValueParam("width", ParamType::TGLfixed, width);
    paramBuffer.addValueParam("height", ParamType::TGLfixed, height);

    return CallCapture(gl::EntryPoint::DrawTexxOES, std::move(paramBuffer));
}

CallCapture CaptureDrawTexxvOES(const State &glState, bool isCallValid, const GLfixed *coords)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, coords, &coordsParam.value);
        CaptureDrawTexxvOES_coords(glState, isCallValid, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(gl::EntryPoint::DrawTexxvOES, std::move(paramBuffer));
}

CallCapture CaptureBindFramebufferOES(const State &glState,
                                      bool isCallValid,
                                      GLenum target,
                                      FramebufferID framebufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    return CallCapture(gl::EntryPoint::BindFramebufferOES, std::move(paramBuffer));
}

CallCapture CaptureBindRenderbufferOES(const State &glState,
                                       bool isCallValid,
                                       GLenum target,
                                       RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(gl::EntryPoint::BindRenderbufferOES, std::move(paramBuffer));
}

CallCapture CaptureCheckFramebufferStatusOES(const State &glState,
                                             bool isCallValid,
                                             GLenum target,
                                             GLenum returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::CheckFramebufferStatusOES, std::move(paramBuffer));
}

CallCapture CaptureDeleteFramebuffersOES(const State &glState,
                                         bool isCallValid,
                                         GLsizei n,
                                         const FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture framebuffersPackedParam("framebuffersPacked",
                                             ParamType::TFramebufferIDConstPointer);
        InitParamValue(ParamType::TFramebufferIDConstPointer, framebuffersPacked,
                       &framebuffersPackedParam.value);
        CaptureDeleteFramebuffersOES_framebuffersPacked(glState, isCallValid, n, framebuffersPacked,
                                                        &framebuffersPackedParam);
        paramBuffer.addParam(std::move(framebuffersPackedParam));
    }
    else
    {
        ParamCapture framebuffersPackedParam("framebuffersPacked",
                                             ParamType::TFramebufferIDConstPointer);
        InitParamValue(ParamType::TFramebufferIDConstPointer,
                       static_cast<const FramebufferID *>(nullptr), &framebuffersPackedParam.value);
        paramBuffer.addParam(std::move(framebuffersPackedParam));
    }

    return CallCapture(gl::EntryPoint::DeleteFramebuffersOES, std::move(paramBuffer));
}

CallCapture CaptureDeleteRenderbuffersOES(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          const RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDConstPointer);
        InitParamValue(ParamType::TRenderbufferIDConstPointer, renderbuffersPacked,
                       &renderbuffersPackedParam.value);
        CaptureDeleteRenderbuffersOES_renderbuffersPacked(
            glState, isCallValid, n, renderbuffersPacked, &renderbuffersPackedParam);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }
    else
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDConstPointer);
        InitParamValue(ParamType::TRenderbufferIDConstPointer,
                       static_cast<const RenderbufferID *>(nullptr),
                       &renderbuffersPackedParam.value);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }

    return CallCapture(gl::EntryPoint::DeleteRenderbuffersOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferRenderbufferOES(const State &glState,
                                              bool isCallValid,
                                              GLenum target,
                                              GLenum attachment,
                                              GLenum renderbuffertarget,
                                              RenderbufferID renderbufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("renderbuffertarget", GLenumGroup::RenderbufferTarget,
                             ParamType::TGLenum, renderbuffertarget);
    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    return CallCapture(gl::EntryPoint::FramebufferRenderbufferOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture2DOES(const State &glState,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           TextureTarget textargetPacked,
                                           TextureID texturePacked,
                                           GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(gl::EntryPoint::FramebufferTexture2DOES, std::move(paramBuffer));
}

CallCapture CaptureGenFramebuffersOES(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      FramebufferID *framebuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture framebuffersPackedParam("framebuffersPacked",
                                             ParamType::TFramebufferIDPointer);
        InitParamValue(ParamType::TFramebufferIDPointer, framebuffersPacked,
                       &framebuffersPackedParam.value);
        CaptureGenFramebuffersOES_framebuffersPacked(glState, isCallValid, n, framebuffersPacked,
                                                     &framebuffersPackedParam);
        paramBuffer.addParam(std::move(framebuffersPackedParam));
    }
    else
    {
        ParamCapture framebuffersPackedParam("framebuffersPacked",
                                             ParamType::TFramebufferIDPointer);
        InitParamValue(ParamType::TFramebufferIDPointer, static_cast<FramebufferID *>(nullptr),
                       &framebuffersPackedParam.value);
        paramBuffer.addParam(std::move(framebuffersPackedParam));
    }

    return CallCapture(gl::EntryPoint::GenFramebuffersOES, std::move(paramBuffer));
}

CallCapture CaptureGenRenderbuffersOES(const State &glState,
                                       bool isCallValid,
                                       GLsizei n,
                                       RenderbufferID *renderbuffersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDPointer);
        InitParamValue(ParamType::TRenderbufferIDPointer, renderbuffersPacked,
                       &renderbuffersPackedParam.value);
        CaptureGenRenderbuffersOES_renderbuffersPacked(glState, isCallValid, n, renderbuffersPacked,
                                                       &renderbuffersPackedParam);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }
    else
    {
        ParamCapture renderbuffersPackedParam("renderbuffersPacked",
                                              ParamType::TRenderbufferIDPointer);
        InitParamValue(ParamType::TRenderbufferIDPointer, static_cast<RenderbufferID *>(nullptr),
                       &renderbuffersPackedParam.value);
        paramBuffer.addParam(std::move(renderbuffersPackedParam));
    }

    return CallCapture(gl::EntryPoint::GenRenderbuffersOES, std::move(paramBuffer));
}

CallCapture CaptureGenerateMipmapOES(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);

    return CallCapture(gl::EntryPoint::GenerateMipmapOES, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferAttachmentParameterivOES(const State &glState,
                                                          bool isCallValid,
                                                          GLenum target,
                                                          GLenum attachment,
                                                          GLenum pname,
                                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addEnumParam("pname", GLenumGroup::FramebufferAttachmentParameterName,
                             ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferAttachmentParameterivOES_params(
            glState, isCallValid, target, attachment, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetFramebufferAttachmentParameterivOES,
                       std::move(paramBuffer));
}

CallCapture CaptureGetRenderbufferParameterivOES(const State &glState,
                                                 bool isCallValid,
                                                 GLenum target,
                                                 GLenum pname,
                                                 GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::RenderbufferParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetRenderbufferParameterivOES_params(glState, isCallValid, target, pname, params,
                                                    &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetRenderbufferParameterivOES, std::move(paramBuffer));
}

CallCapture CaptureIsFramebufferOES(const State &glState,
                                    bool isCallValid,
                                    FramebufferID framebufferPacked,
                                    GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("framebufferPacked", ParamType::TFramebufferID, framebufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsFramebufferOES, std::move(paramBuffer));
}

CallCapture CaptureIsRenderbufferOES(const State &glState,
                                     bool isCallValid,
                                     RenderbufferID renderbufferPacked,
                                     GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("renderbufferPacked", ParamType::TRenderbufferID, renderbufferPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsRenderbufferOES, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageOES(const State &glState,
                                          bool isCallValid,
                                          GLenum target,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::RenderbufferStorageOES, std::move(paramBuffer));
}

CallCapture CaptureGetProgramBinaryOES(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       GLsizei bufSize,
                                       GLsizei *length,
                                       GLenum *binaryFormat,
                                       void *binary)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramBinaryOES_length(glState, isCallValid, programPacked, bufSize, length,
                                          binaryFormat, binary, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture binaryFormatParam("binaryFormat", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, binaryFormat, &binaryFormatParam.value);
        CaptureGetProgramBinaryOES_binaryFormat(glState, isCallValid, programPacked, bufSize,
                                                length, binaryFormat, binary, &binaryFormatParam);
        paramBuffer.addParam(std::move(binaryFormatParam));
    }
    else
    {
        ParamCapture binaryFormatParam("binaryFormat", ParamType::TGLenumPointer);
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &binaryFormatParam.value);
        paramBuffer.addParam(std::move(binaryFormatParam));
    }

    if (isCallValid)
    {
        ParamCapture binaryParam("binary", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, binary, &binaryParam.value);
        CaptureGetProgramBinaryOES_binary(glState, isCallValid, programPacked, bufSize, length,
                                          binaryFormat, binary, &binaryParam);
        paramBuffer.addParam(std::move(binaryParam));
    }
    else
    {
        ParamCapture binaryParam("binary", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &binaryParam.value);
        paramBuffer.addParam(std::move(binaryParam));
    }

    return CallCapture(gl::EntryPoint::GetProgramBinaryOES, std::move(paramBuffer));
}

CallCapture CaptureProgramBinaryOES(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLenum binaryFormat,
                                    const void *binary,
                                    GLint length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("binaryFormat", GLenumGroup::DefaultGroup, ParamType::TGLenum,
                             binaryFormat);

    if (isCallValid)
    {
        ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, binary, &binaryParam.value);
        CaptureProgramBinaryOES_binary(glState, isCallValid, programPacked, binaryFormat, binary,
                                       length, &binaryParam);
        paramBuffer.addParam(std::move(binaryParam));
    }
    else
    {
        ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &binaryParam.value);
        paramBuffer.addParam(std::move(binaryParam));
    }

    paramBuffer.addValueParam("length", ParamType::TGLint, length);

    return CallCapture(gl::EntryPoint::ProgramBinaryOES, std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointervOES(const State &glState,
                                        bool isCallValid,
                                        BufferBinding targetPacked,
                                        GLenum pname,
                                        void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetBufferPointervOES_params(glState, isCallValid, targetPacked, pname, params,
                                           &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetBufferPointervOES, std::move(paramBuffer));
}

CallCapture CaptureMapBufferOES(const State &glState,
                                bool isCallValid,
                                BufferBinding targetPacked,
                                GLenum access,
                                void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("access", GLenumGroup::BufferAccessARB, ParamType::TGLenum, access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::MapBufferOES, std::move(paramBuffer));
}

CallCapture CaptureUnmapBufferOES(const State &glState,
                                  bool isCallValid,
                                  BufferBinding targetPacked,
                                  GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::UnmapBufferOES, std::move(paramBuffer));
}

CallCapture CaptureCurrentPaletteMatrixOES(const State &glState,
                                           bool isCallValid,
                                           GLuint matrixpaletteindex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("matrixpaletteindex", ParamType::TGLuint, matrixpaletteindex);

    return CallCapture(gl::EntryPoint::CurrentPaletteMatrixOES, std::move(paramBuffer));
}

CallCapture CaptureLoadPaletteFromModelViewMatrixOES(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(gl::EntryPoint::LoadPaletteFromModelViewMatrixOES, std::move(paramBuffer));
}

CallCapture CaptureMatrixIndexPointerOES(const State &glState,
                                         bool isCallValid,
                                         GLint size,
                                         GLenum type,
                                         GLsizei stride,
                                         const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureMatrixIndexPointerOES_pointer(glState, isCallValid, size, type, stride, pointer,
                                             &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(gl::EntryPoint::MatrixIndexPointerOES, std::move(paramBuffer));
}

CallCapture CaptureWeightPointerOES(const State &glState,
                                    bool isCallValid,
                                    GLint size,
                                    GLenum type,
                                    GLsizei stride,
                                    const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addEnumParam("type", GLenumGroup::DefaultGroup, ParamType::TGLenum, type);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureWeightPointerOES_pointer(glState, isCallValid, size, type, stride, pointer,
                                        &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(gl::EntryPoint::WeightPointerOES, std::move(paramBuffer));
}

CallCapture CapturePointSizePointerOES(const State &glState,
                                       bool isCallValid,
                                       VertexAttribType typePacked,
                                       GLsizei stride,
                                       const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    if (isCallValid)
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CapturePointSizePointerOES_pointer(glState, isCallValid, typePacked, stride, pointer,
                                           &pointerParam);
        paramBuffer.addParam(std::move(pointerParam));
    }
    else
    {
        ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
        paramBuffer.addParam(std::move(pointerParam));
    }

    return CallCapture(gl::EntryPoint::PointSizePointerOES, std::move(paramBuffer));
}

CallCapture CaptureQueryMatrixxOES(const State &glState,
                                   bool isCallValid,
                                   GLfixed *mantissa,
                                   GLint *exponent,
                                   GLbitfield returnValue)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture mantissaParam("mantissa", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, mantissa, &mantissaParam.value);
        CaptureQueryMatrixxOES_mantissa(glState, isCallValid, mantissa, exponent, &mantissaParam);
        paramBuffer.addParam(std::move(mantissaParam));
    }
    else
    {
        ParamCapture mantissaParam("mantissa", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &mantissaParam.value);
        paramBuffer.addParam(std::move(mantissaParam));
    }

    if (isCallValid)
    {
        ParamCapture exponentParam("exponent", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, exponent, &exponentParam.value);
        CaptureQueryMatrixxOES_exponent(glState, isCallValid, mantissa, exponent, &exponentParam);
        paramBuffer.addParam(std::move(exponentParam));
    }
    else
    {
        ParamCapture exponentParam("exponent", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr),
                       &exponentParam.value);
        paramBuffer.addParam(std::move(exponentParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLbitfield);
    InitParamValue(ParamType::TGLbitfield, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::QueryMatrixxOES, std::move(paramBuffer));
}

CallCapture CaptureMinSampleShadingOES(const State &glState, bool isCallValid, GLfloat value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("value", ParamType::TGLfloat, value);

    return CallCapture(gl::EntryPoint::MinSampleShadingOES, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3DOES(const State &glState,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLint border,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexImage3DOES_data(glState, isCallValid, targetPacked, level,
                                            internalformat, width, height, depth, border, imageSize,
                                            data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::CompressedTexImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3DOES(const State &glState,
                                              bool isCallValid,
                                              TextureTarget targetPacked,
                                              GLint level,
                                              GLint xoffset,
                                              GLint yoffset,
                                              GLint zoffset,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLenum format,
                                              GLsizei imageSize,
                                              const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexSubImage3DOES_data(glState, isCallValid, targetPacked, level, xoffset,
                                               yoffset, zoffset, width, height, depth, format,
                                               imageSize, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(gl::EntryPoint::CompressedTexSubImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage3DOES(const State &glState,
                                        bool isCallValid,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLint xoffset,
                                        GLint yoffset,
                                        GLint zoffset,
                                        GLint x,
                                        GLint y,
                                        GLsizei width,
                                        GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(gl::EntryPoint::CopyTexSubImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture3DOES(const State &glState,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           TextureTarget textargetPacked,
                                           TextureID texturePacked,
                                           GLint level,
                                           GLint zoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);

    return CallCapture(gl::EntryPoint::FramebufferTexture3DOES, std::move(paramBuffer));
}

CallCapture CaptureTexImage3DOES(const State &glState,
                                 bool isCallValid,
                                 TextureTarget targetPacked,
                                 GLint level,
                                 GLenum internalformat,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth,
                                 GLint border,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexImage3DOES_pixels(glState, isCallValid, targetPacked, level, internalformat,
                                    width, height, depth, border, format, type, pixels,
                                    &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(gl::EntryPoint::TexImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3DOES(const State &glState,
                                    bool isCallValid,
                                    TextureTarget targetPacked,
                                    GLint level,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint zoffset,
                                    GLsizei width,
                                    GLsizei height,
                                    GLsizei depth,
                                    GLenum format,
                                    GLenum type,
                                    const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLenumGroup::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLenumGroup::PixelType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexSubImage3DOES_pixels(glState, isCallValid, targetPacked, level, xoffset, yoffset,
                                       zoffset, width, height, depth, format, type, pixels,
                                       &pixelsParam);
        paramBuffer.addParam(std::move(pixelsParam));
    }
    else
    {
        ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
        paramBuffer.addParam(std::move(pixelsParam));
    }

    return CallCapture(gl::EntryPoint::TexSubImage3DOES, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIivOES(const State &glState,
                                             bool isCallValid,
                                             SamplerID samplerPacked,
                                             GLenum pname,
                                             GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIivOES_params(glState, isCallValid, samplerPacked, pname, params,
                                                &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetSamplerParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterIuivOES(const State &glState,
                                              bool isCallValid,
                                              SamplerID samplerPacked,
                                              GLenum pname,
                                              GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterIuivOES_params(glState, isCallValid, samplerPacked, pname, params,
                                                 &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetSamplerParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIivOES(const State &glState,
                                         bool isCallValid,
                                         TextureType targetPacked,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIivOES_params(glState, isCallValid, targetPacked, pname, params,
                                            &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexParameterIuivOES(const State &glState,
                                          bool isCallValid,
                                          TextureType targetPacked,
                                          GLenum pname,
                                          GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetTexParameterIuivOES_params(glState, isCallValid, targetPacked, pname, params,
                                             &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintPointer);
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIivOES(const State &glState,
                                          bool isCallValid,
                                          SamplerID samplerPacked,
                                          GLenum pname,
                                          const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIivOES_param(glState, isCallValid, samplerPacked, pname, param,
                                            &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(gl::EntryPoint::SamplerParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterIuivOES(const State &glState,
                                           bool isCallValid,
                                           SamplerID samplerPacked,
                                           GLenum pname,
                                           const GLuint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::SamplerParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, param, &paramParam.value);
        CaptureSamplerParameterIuivOES_param(glState, isCallValid, samplerPacked, pname, param,
                                             &paramParam);
        paramBuffer.addParam(std::move(paramParam));
    }
    else
    {
        ParamCapture paramParam("param", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramParam.value);
        paramBuffer.addParam(std::move(paramParam));
    }

    return CallCapture(gl::EntryPoint::SamplerParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIivOES(const State &glState,
                                      bool isCallValid,
                                      TextureType targetPacked,
                                      GLenum pname,
                                      const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIivOES_params(glState, isCallValid, targetPacked, pname, params,
                                         &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::TexParameterIivOES, std::move(paramBuffer));
}

CallCapture CaptureTexParameterIuivOES(const State &glState,
                                       bool isCallValid,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       const GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureParameterName, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, params, &paramsParam.value);
        CaptureTexParameterIuivOES_params(glState, isCallValid, targetPacked, pname, params,
                                          &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::TexParameterIuivOES, std::move(paramBuffer));
}

CallCapture CaptureTexBufferOES(const State &glState,
                                bool isCallValid,
                                TextureType targetPacked,
                                GLenum internalformat,
                                BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(gl::EntryPoint::TexBufferOES, std::move(paramBuffer));
}

CallCapture CaptureTexBufferRangeOES(const State &glState,
                                     bool isCallValid,
                                     TextureType targetPacked,
                                     GLenum internalformat,
                                     BufferID bufferPacked,
                                     GLintptr offset,
                                     GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(gl::EntryPoint::TexBufferRangeOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenfvOES(const State &glState,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexGenfvOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexGenfvOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenivOES(const State &glState,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexGenivOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexGenivOES, std::move(paramBuffer));
}

CallCapture CaptureGetTexGenxvOES(const State &glState,
                                  bool isCallValid,
                                  GLenum coord,
                                  GLenum pname,
                                  GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, params, &paramsParam.value);
        CaptureGetTexGenxvOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedPointer);
        InitParamValue(ParamType::TGLfixedPointer, static_cast<GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::GetTexGenxvOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenfOES(const State &glState,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(gl::EntryPoint::TexGenfOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenfvOES(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, params, &paramsParam.value);
        CaptureTexGenfvOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::TexGenfvOES, std::move(paramBuffer));
}

CallCapture CaptureTexGeniOES(const State &glState,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(gl::EntryPoint::TexGeniOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenivOES(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, params, &paramsParam.value);
        CaptureTexGenivOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::TexGenivOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenxOES(const State &glState,
                              bool isCallValid,
                              GLenum coord,
                              GLenum pname,
                              GLfixed param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfixed, param);

    return CallCapture(gl::EntryPoint::TexGenxOES, std::move(paramBuffer));
}

CallCapture CaptureTexGenxvOES(const State &glState,
                               bool isCallValid,
                               GLenum coord,
                               GLenum pname,
                               const GLfixed *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("coord", GLenumGroup::TextureCoordName, ParamType::TGLenum, coord);
    paramBuffer.addEnumParam("pname", GLenumGroup::TextureGenParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, params, &paramsParam.value);
        CaptureTexGenxvOES_params(glState, isCallValid, coord, pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfixedConstPointer);
        InitParamValue(ParamType::TGLfixedConstPointer, static_cast<const GLfixed *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(gl::EntryPoint::TexGenxvOES, std::move(paramBuffer));
}

CallCapture CaptureTexStorage3DMultisampleOES(const State &glState,
                                              bool isCallValid,
                                              TextureType targetPacked,
                                              GLsizei samples,
                                              GLenum internalformat,
                                              GLsizei width,
                                              GLsizei height,
                                              GLsizei depth,
                                              GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(gl::EntryPoint::TexStorage3DMultisampleOES, std::move(paramBuffer));
}

CallCapture CaptureBindVertexArrayOES(const State &glState,
                                      bool isCallValid,
                                      VertexArrayID arrayPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TVertexArrayID, arrayPacked);

    return CallCapture(gl::EntryPoint::BindVertexArrayOES, std::move(paramBuffer));
}

CallCapture CaptureDeleteVertexArraysOES(const State &glState,
                                         bool isCallValid,
                                         GLsizei n,
                                         const VertexArrayID *arraysPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDConstPointer);
        InitParamValue(ParamType::TVertexArrayIDConstPointer, arraysPacked,
                       &arraysPackedParam.value);
        CaptureDeleteVertexArraysOES_arraysPacked(glState, isCallValid, n, arraysPacked,
                                                  &arraysPackedParam);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }
    else
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDConstPointer);
        InitParamValue(ParamType::TVertexArrayIDConstPointer,
                       static_cast<const VertexArrayID *>(nullptr), &arraysPackedParam.value);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }

    return CallCapture(gl::EntryPoint::DeleteVertexArraysOES, std::move(paramBuffer));
}

CallCapture CaptureGenVertexArraysOES(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      VertexArrayID *arraysPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDPointer);
        InitParamValue(ParamType::TVertexArrayIDPointer, arraysPacked, &arraysPackedParam.value);
        CaptureGenVertexArraysOES_arraysPacked(glState, isCallValid, n, arraysPacked,
                                               &arraysPackedParam);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }
    else
    {
        ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDPointer);
        InitParamValue(ParamType::TVertexArrayIDPointer, static_cast<VertexArrayID *>(nullptr),
                       &arraysPackedParam.value);
        paramBuffer.addParam(std::move(arraysPackedParam));
    }

    return CallCapture(gl::EntryPoint::GenVertexArraysOES, std::move(paramBuffer));
}

CallCapture CaptureIsVertexArrayOES(const State &glState,
                                    bool isCallValid,
                                    VertexArrayID arrayPacked,
                                    GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TVertexArrayID, arrayPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(gl::EntryPoint::IsVertexArrayOES, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureMultiviewOVR(const State &glState,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLenum attachment,
                                                  TextureID texturePacked,
                                                  GLint level,
                                                  GLint baseViewIndex,
                                                  GLsizei numViews)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLenumGroup::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("baseViewIndex", ParamType::TGLint, baseViewIndex);
    paramBuffer.addValueParam("numViews", ParamType::TGLsizei, numViews);

    return CallCapture(gl::EntryPoint::FramebufferTextureMultiviewOVR, std::move(paramBuffer));
}

}  // namespace gl
