// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gl_3_autogen.cpp:
//   Capture functions for the OpenGL ES Desktop GL 3.x entry points.

#include "libANGLE/capture/capture_gl_3_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationGL3_autogen.h"

using namespace angle;

namespace gl
{

// GL 3.0
CallCapture CaptureBeginConditionalRender(const State &glState,
                                          bool isCallValid,
                                          GLuint id,
                                          GLenum mode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("id", ParamType::TGLuint, id);
    paramBuffer.addEnumParam("mode", BigGLEnum::ConditionalRenderMode, ParamType::TGLenum, mode);

    return CallCapture(angle::EntryPoint::GLBeginConditionalRender, std::move(paramBuffer));
}

CallCapture CaptureBindFragDataLocation(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        GLuint color,
                                        const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("color", ParamType::TGLuint, color);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureBindFragDataLocation_name(glState, isCallValid, programPacked, color, name,
                                         &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLBindFragDataLocation, std::move(paramBuffer));
}

CallCapture CaptureClampColor(const State &glState, bool isCallValid, GLenum target, GLenum clamp)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::AllEnums, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("clamp", BigGLEnum::AllEnums, ParamType::TGLenum, clamp);

    return CallCapture(angle::EntryPoint::GLClampColor, std::move(paramBuffer));
}

CallCapture CaptureEndConditionalRender(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLEndConditionalRender, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture1D(const State &glState,
                                        bool isCallValid,
                                        GLenum target,
                                        GLenum attachment,
                                        TextureTarget textargetPacked,
                                        TextureID texturePacked,
                                        GLint level)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", BigGLEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);

    return CallCapture(angle::EntryPoint::GLFramebufferTexture1D, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTexture3D(const State &glState,
                                        bool isCallValid,
                                        GLenum target,
                                        GLenum attachment,
                                        TextureTarget textargetPacked,
                                        TextureID texturePacked,
                                        GLint level,
                                        GLint zoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", BigGLEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("textargetPacked", ParamType::TTextureTarget, textargetPacked);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);

    return CallCapture(angle::EntryPoint::GLFramebufferTexture3D, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI1i(const State &glState, bool isCallValid, GLuint index, GLint x)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);

    return CallCapture(angle::EntryPoint::GLVertexAttribI1i, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI1iv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureVertexAttribI1iv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI1iv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI1ui(const State &glState, bool isCallValid, GLuint index, GLuint x)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLuint, x);

    return CallCapture(angle::EntryPoint::GLVertexAttribI1ui, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI1uiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     const GLuint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, v, &vParam.value);
        CaptureVertexAttribI1uiv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI1uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI2i(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   GLint x,
                                   GLint y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);

    return CallCapture(angle::EntryPoint::GLVertexAttribI2i, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI2iv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureVertexAttribI2iv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI2iv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI2ui(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    GLuint x,
                                    GLuint y)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLuint, x);
    paramBuffer.addValueParam("y", ParamType::TGLuint, y);

    return CallCapture(angle::EntryPoint::GLVertexAttribI2ui, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI2uiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     const GLuint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, v, &vParam.value);
        CaptureVertexAttribI2uiv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI2uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI3i(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   GLint x,
                                   GLint y,
                                   GLint z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);

    return CallCapture(angle::EntryPoint::GLVertexAttribI3i, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI3iv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureVertexAttribI3iv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI3iv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI3ui(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    GLuint x,
                                    GLuint y,
                                    GLuint z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLuint, x);
    paramBuffer.addValueParam("y", ParamType::TGLuint, y);
    paramBuffer.addValueParam("z", ParamType::TGLuint, z);

    return CallCapture(angle::EntryPoint::GLVertexAttribI3ui, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI3uiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     const GLuint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, v, &vParam.value);
        CaptureVertexAttribI3uiv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI3uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4bv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLbyte *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, v, &vParam.value);
        CaptureVertexAttribI4bv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLbyteConstPointer);
        InitParamValue(ParamType::TGLbyteConstPointer, static_cast<const GLbyte *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI4bv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4sv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLshort *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, v, &vParam.value);
        CaptureVertexAttribI4sv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLshortConstPointer);
        InitParamValue(ParamType::TGLshortConstPointer, static_cast<const GLshort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI4sv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4ubv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     const GLubyte *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, v, &vParam.value);
        CaptureVertexAttribI4ubv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLubyteConstPointer);
        InitParamValue(ParamType::TGLubyteConstPointer, static_cast<const GLubyte *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI4ubv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4usv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     const GLushort *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture vParam("v", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, v, &vParam.value);
        CaptureVertexAttribI4usv_v(glState, isCallValid, index, v, &vParam);
        paramBuffer.addParam(std::move(vParam));
    }
    else
    {
        ParamCapture vParam("v", ParamType::TGLushortConstPointer);
        InitParamValue(ParamType::TGLushortConstPointer, static_cast<const GLushort *>(nullptr),
                       &vParam.value);
        paramBuffer.addParam(std::move(vParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribI4usv, std::move(paramBuffer));
}

// GL 3.1
CallCapture CaptureGetActiveUniformName(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        GLuint uniformIndex,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLchar *uniformName)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("uniformIndex", ParamType::TGLuint, uniformIndex);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetActiveUniformName_length(glState, isCallValid, programPacked, uniformIndex,
                                           bufSize, length, uniformName, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture uniformNameParam("uniformName", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, uniformName, &uniformNameParam.value);
        CaptureGetActiveUniformName_uniformName(glState, isCallValid, programPacked, uniformIndex,
                                                bufSize, length, uniformName, &uniformNameParam);
        paramBuffer.addParam(std::move(uniformNameParam));
    }
    else
    {
        ParamCapture uniformNameParam("uniformName", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &uniformNameParam.value);
        paramBuffer.addParam(std::move(uniformNameParam));
    }

    return CallCapture(angle::EntryPoint::GLGetActiveUniformName, std::move(paramBuffer));
}

CallCapture CapturePrimitiveRestartIndex(const State &glState, bool isCallValid, GLuint index)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    return CallCapture(angle::EntryPoint::GLPrimitiveRestartIndex, std::move(paramBuffer));
}

// GL 3.2
CallCapture CaptureMultiDrawElementsBaseVertex(const State &glState,
                                               bool isCallValid,
                                               PrimitiveMode modePacked,
                                               const GLsizei *count,
                                               DrawElementsType typePacked,
                                               const void *const *indices,
                                               GLsizei drawcount,
                                               const GLint *basevertex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, count, &countParam.value);
        CaptureMultiDrawElementsBaseVertex_count(glState, isCallValid, modePacked, count,
                                                 typePacked, indices, drawcount, basevertex,
                                                 &countParam);
        paramBuffer.addParam(std::move(countParam));
    }
    else
    {
        ParamCapture countParam("count", ParamType::TGLsizeiConstPointer);
        InitParamValue(ParamType::TGLsizeiConstPointer, static_cast<const GLsizei *>(nullptr),
                       &countParam.value);
        paramBuffer.addParam(std::move(countParam));
    }

    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, indices, &indicesParam.value);
        CaptureMultiDrawElementsBaseVertex_indices(glState, isCallValid, modePacked, count,
                                                   typePacked, indices, drawcount, basevertex,
                                                   &indicesParam);
        paramBuffer.addParam(std::move(indicesParam));
    }
    else
    {
        ParamCapture indicesParam("indices", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer,
                       static_cast<const void *const *>(nullptr), &indicesParam.value);
        paramBuffer.addParam(std::move(indicesParam));
    }

    paramBuffer.addValueParam("drawcount", ParamType::TGLsizei, drawcount);

    if (isCallValid)
    {
        ParamCapture basevertexParam("basevertex", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, basevertex, &basevertexParam.value);
        CaptureMultiDrawElementsBaseVertex_basevertex(glState, isCallValid, modePacked, count,
                                                      typePacked, indices, drawcount, basevertex,
                                                      &basevertexParam);
        paramBuffer.addParam(std::move(basevertexParam));
    }
    else
    {
        ParamCapture basevertexParam("basevertex", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &basevertexParam.value);
        paramBuffer.addParam(std::move(basevertexParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiDrawElementsBaseVertex, std::move(paramBuffer));
}

CallCapture CaptureProvokingVertex(const State &glState,
                                   bool isCallValid,
                                   ProvokingVertexConvention modePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TProvokingVertexConvention, modePacked);

    return CallCapture(angle::EntryPoint::GLProvokingVertex, std::move(paramBuffer));
}

CallCapture CaptureTexImage2DMultisample(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLsizei samples,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(angle::EntryPoint::GLTexImage2DMultisample, std::move(paramBuffer));
}

CallCapture CaptureTexImage3DMultisample(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLsizei samples,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLsizei depth,
                                         GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", BigGLEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", BigGLEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(angle::EntryPoint::GLTexImage3DMultisample, std::move(paramBuffer));
}

// GL 3.3
CallCapture CaptureBindFragDataLocationIndexed(const State &glState,
                                               bool isCallValid,
                                               ShaderProgramID programPacked,
                                               GLuint colorNumber,
                                               GLuint index,
                                               const GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("colorNumber", ParamType::TGLuint, colorNumber);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureBindFragDataLocationIndexed_name(glState, isCallValid, programPacked, colorNumber,
                                                index, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLBindFragDataLocationIndexed, std::move(paramBuffer));
}

CallCapture CaptureColorP3ui(const State &glState, bool isCallValid, GLenum type, GLuint color)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::ColorPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("color", ParamType::TGLuint, color);

    return CallCapture(angle::EntryPoint::GLColorP3ui, std::move(paramBuffer));
}

CallCapture CaptureColorP3uiv(const State &glState,
                              bool isCallValid,
                              GLenum type,
                              const GLuint *color)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::ColorPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture colorParam("color", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, color, &colorParam.value);
        CaptureColorP3uiv_color(glState, isCallValid, type, color, &colorParam);
        paramBuffer.addParam(std::move(colorParam));
    }
    else
    {
        ParamCapture colorParam("color", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &colorParam.value);
        paramBuffer.addParam(std::move(colorParam));
    }

    return CallCapture(angle::EntryPoint::GLColorP3uiv, std::move(paramBuffer));
}

CallCapture CaptureColorP4ui(const State &glState, bool isCallValid, GLenum type, GLuint color)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::ColorPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("color", ParamType::TGLuint, color);

    return CallCapture(angle::EntryPoint::GLColorP4ui, std::move(paramBuffer));
}

CallCapture CaptureColorP4uiv(const State &glState,
                              bool isCallValid,
                              GLenum type,
                              const GLuint *color)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::ColorPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture colorParam("color", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, color, &colorParam.value);
        CaptureColorP4uiv_color(glState, isCallValid, type, color, &colorParam);
        paramBuffer.addParam(std::move(colorParam));
    }
    else
    {
        ParamCapture colorParam("color", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &colorParam.value);
        paramBuffer.addParam(std::move(colorParam));
    }

    return CallCapture(angle::EntryPoint::GLColorP4uiv, std::move(paramBuffer));
}

CallCapture CaptureGetFragDataIndex(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    const GLchar *name,
                                    GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetFragDataIndex_name(glState, isCallValid, programPacked, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetFragDataIndex, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjecti64v(const State &glState,
                                      bool isCallValid,
                                      QueryID idPacked,
                                      GLenum pname,
                                      GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjecti64v_params(glState, isCallValid, idPacked, pname, params,
                                         &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjecti64v, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectui64v(const State &glState,
                                       bool isCallValid,
                                       QueryID idPacked,
                                       GLenum pname,
                                       GLuint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", BigGLEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, params, &paramsParam.value);
        CaptureGetQueryObjectui64v_params(glState, isCallValid, idPacked, pname, params,
                                          &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLuint64Pointer);
        InitParamValue(ParamType::TGLuint64Pointer, static_cast<GLuint64 *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetQueryObjectui64v, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoordP1ui(const State &glState,
                                     bool isCallValid,
                                     GLenum texture,
                                     GLenum type,
                                     GLuint coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", BigGLEnum::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("coords", ParamType::TGLuint, coords);

    return CallCapture(angle::EntryPoint::GLMultiTexCoordP1ui, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoordP1uiv(const State &glState,
                                      bool isCallValid,
                                      GLenum texture,
                                      GLenum type,
                                      const GLuint *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", BigGLEnum::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, coords, &coordsParam.value);
        CaptureMultiTexCoordP1uiv_coords(glState, isCallValid, texture, type, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoordP1uiv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoordP2ui(const State &glState,
                                     bool isCallValid,
                                     GLenum texture,
                                     GLenum type,
                                     GLuint coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", BigGLEnum::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("coords", ParamType::TGLuint, coords);

    return CallCapture(angle::EntryPoint::GLMultiTexCoordP2ui, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoordP2uiv(const State &glState,
                                      bool isCallValid,
                                      GLenum texture,
                                      GLenum type,
                                      const GLuint *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", BigGLEnum::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, coords, &coordsParam.value);
        CaptureMultiTexCoordP2uiv_coords(glState, isCallValid, texture, type, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoordP2uiv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoordP3ui(const State &glState,
                                     bool isCallValid,
                                     GLenum texture,
                                     GLenum type,
                                     GLuint coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", BigGLEnum::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("coords", ParamType::TGLuint, coords);

    return CallCapture(angle::EntryPoint::GLMultiTexCoordP3ui, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoordP3uiv(const State &glState,
                                      bool isCallValid,
                                      GLenum texture,
                                      GLenum type,
                                      const GLuint *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", BigGLEnum::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, coords, &coordsParam.value);
        CaptureMultiTexCoordP3uiv_coords(glState, isCallValid, texture, type, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoordP3uiv, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoordP4ui(const State &glState,
                                     bool isCallValid,
                                     GLenum texture,
                                     GLenum type,
                                     GLuint coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", BigGLEnum::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("coords", ParamType::TGLuint, coords);

    return CallCapture(angle::EntryPoint::GLMultiTexCoordP4ui, std::move(paramBuffer));
}

CallCapture CaptureMultiTexCoordP4uiv(const State &glState,
                                      bool isCallValid,
                                      GLenum texture,
                                      GLenum type,
                                      const GLuint *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("texture", BigGLEnum::TextureUnit, ParamType::TGLenum, texture);
    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, coords, &coordsParam.value);
        CaptureMultiTexCoordP4uiv_coords(glState, isCallValid, texture, type, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLMultiTexCoordP4uiv, std::move(paramBuffer));
}

CallCapture CaptureNormalP3ui(const State &glState, bool isCallValid, GLenum type, GLuint coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::NormalPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("coords", ParamType::TGLuint, coords);

    return CallCapture(angle::EntryPoint::GLNormalP3ui, std::move(paramBuffer));
}

CallCapture CaptureNormalP3uiv(const State &glState,
                               bool isCallValid,
                               GLenum type,
                               const GLuint *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::NormalPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, coords, &coordsParam.value);
        CaptureNormalP3uiv_coords(glState, isCallValid, type, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLNormalP3uiv, std::move(paramBuffer));
}

CallCapture CaptureQueryCounter(const State &glState,
                                bool isCallValid,
                                QueryID idPacked,
                                QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture(angle::EntryPoint::GLQueryCounter, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColorP3ui(const State &glState,
                                      bool isCallValid,
                                      GLenum type,
                                      GLuint color)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::ColorPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("color", ParamType::TGLuint, color);

    return CallCapture(angle::EntryPoint::GLSecondaryColorP3ui, std::move(paramBuffer));
}

CallCapture CaptureSecondaryColorP3uiv(const State &glState,
                                       bool isCallValid,
                                       GLenum type,
                                       const GLuint *color)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::ColorPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture colorParam("color", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, color, &colorParam.value);
        CaptureSecondaryColorP3uiv_color(glState, isCallValid, type, color, &colorParam);
        paramBuffer.addParam(std::move(colorParam));
    }
    else
    {
        ParamCapture colorParam("color", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &colorParam.value);
        paramBuffer.addParam(std::move(colorParam));
    }

    return CallCapture(angle::EntryPoint::GLSecondaryColorP3uiv, std::move(paramBuffer));
}

CallCapture CaptureTexCoordP1ui(const State &glState, bool isCallValid, GLenum type, GLuint coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("coords", ParamType::TGLuint, coords);

    return CallCapture(angle::EntryPoint::GLTexCoordP1ui, std::move(paramBuffer));
}

CallCapture CaptureTexCoordP1uiv(const State &glState,
                                 bool isCallValid,
                                 GLenum type,
                                 const GLuint *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, coords, &coordsParam.value);
        CaptureTexCoordP1uiv_coords(glState, isCallValid, type, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoordP1uiv, std::move(paramBuffer));
}

CallCapture CaptureTexCoordP2ui(const State &glState, bool isCallValid, GLenum type, GLuint coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("coords", ParamType::TGLuint, coords);

    return CallCapture(angle::EntryPoint::GLTexCoordP2ui, std::move(paramBuffer));
}

CallCapture CaptureTexCoordP2uiv(const State &glState,
                                 bool isCallValid,
                                 GLenum type,
                                 const GLuint *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, coords, &coordsParam.value);
        CaptureTexCoordP2uiv_coords(glState, isCallValid, type, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoordP2uiv, std::move(paramBuffer));
}

CallCapture CaptureTexCoordP3ui(const State &glState, bool isCallValid, GLenum type, GLuint coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("coords", ParamType::TGLuint, coords);

    return CallCapture(angle::EntryPoint::GLTexCoordP3ui, std::move(paramBuffer));
}

CallCapture CaptureTexCoordP3uiv(const State &glState,
                                 bool isCallValid,
                                 GLenum type,
                                 const GLuint *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, coords, &coordsParam.value);
        CaptureTexCoordP3uiv_coords(glState, isCallValid, type, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoordP3uiv, std::move(paramBuffer));
}

CallCapture CaptureTexCoordP4ui(const State &glState, bool isCallValid, GLenum type, GLuint coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("coords", ParamType::TGLuint, coords);

    return CallCapture(angle::EntryPoint::GLTexCoordP4ui, std::move(paramBuffer));
}

CallCapture CaptureTexCoordP4uiv(const State &glState,
                                 bool isCallValid,
                                 GLenum type,
                                 const GLuint *coords)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::TexCoordPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, coords, &coordsParam.value);
        CaptureTexCoordP4uiv_coords(glState, isCallValid, type, coords, &coordsParam);
        paramBuffer.addParam(std::move(coordsParam));
    }
    else
    {
        ParamCapture coordsParam("coords", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &coordsParam.value);
        paramBuffer.addParam(std::move(coordsParam));
    }

    return CallCapture(angle::EntryPoint::GLTexCoordP4uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribP1ui(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    GLenum type,
                                    GLboolean normalized,
                                    GLuint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("value", ParamType::TGLuint, value);

    return CallCapture(angle::EntryPoint::GLVertexAttribP1ui, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribP1uiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureVertexAttribP1uiv_value(glState, isCallValid, index, type, normalized, value,
                                       &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribP1uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribP2ui(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    GLenum type,
                                    GLboolean normalized,
                                    GLuint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("value", ParamType::TGLuint, value);

    return CallCapture(angle::EntryPoint::GLVertexAttribP2ui, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribP2uiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureVertexAttribP2uiv_value(glState, isCallValid, index, type, normalized, value,
                                       &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribP2uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribP3ui(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    GLenum type,
                                    GLboolean normalized,
                                    GLuint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("value", ParamType::TGLuint, value);

    return CallCapture(angle::EntryPoint::GLVertexAttribP3ui, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribP3uiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureVertexAttribP3uiv_value(glState, isCallValid, index, type, normalized, value,
                                       &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribP3uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribP4ui(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    GLenum type,
                                    GLboolean normalized,
                                    GLuint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("value", ParamType::TGLuint, value);

    return CallCapture(angle::EntryPoint::GLVertexAttribP4ui, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribP4uiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     GLenum type,
                                     GLboolean normalized,
                                     const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("type", BigGLEnum::VertexAttribPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureVertexAttribP4uiv_value(glState, isCallValid, index, type, normalized, value,
                                       &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexAttribP4uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexP2ui(const State &glState, bool isCallValid, GLenum type, GLuint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::VertexPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("value", ParamType::TGLuint, value);

    return CallCapture(angle::EntryPoint::GLVertexP2ui, std::move(paramBuffer));
}

CallCapture CaptureVertexP2uiv(const State &glState,
                               bool isCallValid,
                               GLenum type,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::VertexPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureVertexP2uiv_value(glState, isCallValid, type, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexP2uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexP3ui(const State &glState, bool isCallValid, GLenum type, GLuint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::VertexPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("value", ParamType::TGLuint, value);

    return CallCapture(angle::EntryPoint::GLVertexP3ui, std::move(paramBuffer));
}

CallCapture CaptureVertexP3uiv(const State &glState,
                               bool isCallValid,
                               GLenum type,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::VertexPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureVertexP3uiv_value(glState, isCallValid, type, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexP3uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexP4ui(const State &glState, bool isCallValid, GLenum type, GLuint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::VertexPointerType, ParamType::TGLenum, type);
    paramBuffer.addValueParam("value", ParamType::TGLuint, value);

    return CallCapture(angle::EntryPoint::GLVertexP4ui, std::move(paramBuffer));
}

CallCapture CaptureVertexP4uiv(const State &glState,
                               bool isCallValid,
                               GLenum type,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("type", BigGLEnum::VertexPointerType, ParamType::TGLenum, type);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureVertexP4uiv_value(glState, isCallValid, type, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLVertexP4uiv, std::move(paramBuffer));
}

}  // namespace gl
