# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy

from . import models as _models
from ._configuration import NetworkManagementClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AdminRuleCollectionsOperations,
    AdminRulesOperations,
    ApplicationGatewayPrivateEndpointConnectionsOperations,
    ApplicationGatewayPrivateLinkResourcesOperations,
    ApplicationGatewayWafDynamicManifestsDefaultOperations,
    ApplicationGatewayWafDynamicManifestsOperations,
    ApplicationGatewaysOperations,
    ApplicationSecurityGroupsOperations,
    AvailableDelegationsOperations,
    AvailableEndpointServicesOperations,
    AvailablePrivateEndpointTypesOperations,
    AvailableResourceGroupDelegationsOperations,
    AvailableServiceAliasesOperations,
    AzureFirewallFqdnTagsOperations,
    AzureFirewallsOperations,
    BastionHostsOperations,
    BgpServiceCommunitiesOperations,
    ConfigurationPolicyGroupsOperations,
    ConnectionMonitorsOperations,
    ConnectivityConfigurationsOperations,
    CustomIPPrefixesOperations,
    DdosCustomPoliciesOperations,
    DdosProtectionPlansOperations,
    DefaultSecurityRulesOperations,
    DscpConfigurationOperations,
    ExpressRouteCircuitAuthorizationsOperations,
    ExpressRouteCircuitConnectionsOperations,
    ExpressRouteCircuitPeeringsOperations,
    ExpressRouteCircuitsOperations,
    ExpressRouteConnectionsOperations,
    ExpressRouteCrossConnectionPeeringsOperations,
    ExpressRouteCrossConnectionsOperations,
    ExpressRouteGatewaysOperations,
    ExpressRouteLinksOperations,
    ExpressRoutePortAuthorizationsOperations,
    ExpressRoutePortsLocationsOperations,
    ExpressRoutePortsOperations,
    ExpressRouteProviderPortsLocationOperations,
    ExpressRouteServiceProvidersOperations,
    FirewallPoliciesOperations,
    FirewallPolicyDeploymentsOperations,
    FirewallPolicyDraftsOperations,
    FirewallPolicyIdpsSignaturesFilterValuesOperations,
    FirewallPolicyIdpsSignaturesOperations,
    FirewallPolicyIdpsSignaturesOverridesOperations,
    FirewallPolicyRuleCollectionGroupDraftsOperations,
    FirewallPolicyRuleCollectionGroupsOperations,
    FlowLogsOperations,
    HubRouteTablesOperations,
    HubVirtualNetworkConnectionsOperations,
    InboundNatRulesOperations,
    InboundSecurityRuleOperations,
    IpAllocationsOperations,
    IpGroupsOperations,
    IpamPoolsOperations,
    LoadBalancerBackendAddressPoolsOperations,
    LoadBalancerFrontendIPConfigurationsOperations,
    LoadBalancerLoadBalancingRulesOperations,
    LoadBalancerNetworkInterfacesOperations,
    LoadBalancerOutboundRulesOperations,
    LoadBalancerProbesOperations,
    LoadBalancersOperations,
    LocalNetworkGatewaysOperations,
    ManagementGroupNetworkManagerConnectionsOperations,
    NatGatewaysOperations,
    NatRulesOperations,
    NetworkGroupsOperations,
    NetworkInterfaceIPConfigurationsOperations,
    NetworkInterfaceLoadBalancersOperations,
    NetworkInterfaceTapConfigurationsOperations,
    NetworkInterfacesOperations,
    NetworkManagementClientOperationsMixin,
    NetworkManagerCommitsOperations,
    NetworkManagerDeploymentStatusOperations,
    NetworkManagerRoutingConfigurationsOperations,
    NetworkManagersOperations,
    NetworkProfilesOperations,
    NetworkSecurityGroupsOperations,
    NetworkVirtualApplianceConnectionsOperations,
    NetworkVirtualAppliancesOperations,
    NetworkWatchersOperations,
    Operations,
    P2SVpnGatewaysOperations,
    PacketCapturesOperations,
    PeerExpressRouteCircuitConnectionsOperations,
    PrivateDnsZoneGroupsOperations,
    PrivateEndpointsOperations,
    PrivateLinkServicesOperations,
    PublicIPAddressesOperations,
    PublicIPPrefixesOperations,
    ReachabilityAnalysisIntentsOperations,
    ReachabilityAnalysisRunsOperations,
    ResourceNavigationLinksOperations,
    RouteFilterRulesOperations,
    RouteFiltersOperations,
    RouteMapsOperations,
    RouteTablesOperations,
    RoutesOperations,
    RoutingIntentOperations,
    RoutingRuleCollectionsOperations,
    RoutingRulesOperations,
    ScopeConnectionsOperations,
    SecurityAdminConfigurationsOperations,
    SecurityPartnerProvidersOperations,
    SecurityRulesOperations,
    SecurityUserConfigurationsOperations,
    SecurityUserRuleCollectionsOperations,
    SecurityUserRulesOperations,
    ServiceAssociationLinksOperations,
    ServiceEndpointPoliciesOperations,
    ServiceEndpointPolicyDefinitionsOperations,
    ServiceTagInformationOperations,
    ServiceTagsOperations,
    StaticCidrsOperations,
    StaticMembersOperations,
    SubnetsOperations,
    SubscriptionNetworkManagerConnectionsOperations,
    UsagesOperations,
    VerifierWorkspacesOperations,
    VipSwapOperations,
    VirtualApplianceSitesOperations,
    VirtualApplianceSkusOperations,
    VirtualHubBgpConnectionOperations,
    VirtualHubBgpConnectionsOperations,
    VirtualHubIpConfigurationOperations,
    VirtualHubRouteTableV2SOperations,
    VirtualHubsOperations,
    VirtualNetworkGatewayConnectionsOperations,
    VirtualNetworkGatewayNatRulesOperations,
    VirtualNetworkGatewaysOperations,
    VirtualNetworkPeeringsOperations,
    VirtualNetworkTapsOperations,
    VirtualNetworksOperations,
    VirtualRouterPeeringsOperations,
    VirtualRoutersOperations,
    VirtualWansOperations,
    VpnConnectionsOperations,
    VpnGatewaysOperations,
    VpnLinkConnectionsOperations,
    VpnServerConfigurationsAssociatedWithVirtualWanOperations,
    VpnServerConfigurationsOperations,
    VpnSiteLinkConnectionsOperations,
    VpnSiteLinksOperations,
    VpnSitesConfigurationOperations,
    VpnSitesOperations,
    WebApplicationFirewallPoliciesOperations,
    WebCategoriesOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials import TokenCredential


class NetworkManagementClient(
    NetworkManagementClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Network Client.

    :ivar application_gateways: ApplicationGatewaysOperations operations
    :vartype application_gateways: azure.mgmt.network.operations.ApplicationGatewaysOperations
    :ivar application_gateway_private_link_resources:
     ApplicationGatewayPrivateLinkResourcesOperations operations
    :vartype application_gateway_private_link_resources:
     azure.mgmt.network.operations.ApplicationGatewayPrivateLinkResourcesOperations
    :ivar application_gateway_private_endpoint_connections:
     ApplicationGatewayPrivateEndpointConnectionsOperations operations
    :vartype application_gateway_private_endpoint_connections:
     azure.mgmt.network.operations.ApplicationGatewayPrivateEndpointConnectionsOperations
    :ivar application_gateway_waf_dynamic_manifests_default:
     ApplicationGatewayWafDynamicManifestsDefaultOperations operations
    :vartype application_gateway_waf_dynamic_manifests_default:
     azure.mgmt.network.operations.ApplicationGatewayWafDynamicManifestsDefaultOperations
    :ivar application_gateway_waf_dynamic_manifests:
     ApplicationGatewayWafDynamicManifestsOperations operations
    :vartype application_gateway_waf_dynamic_manifests:
     azure.mgmt.network.operations.ApplicationGatewayWafDynamicManifestsOperations
    :ivar application_security_groups: ApplicationSecurityGroupsOperations operations
    :vartype application_security_groups:
     azure.mgmt.network.operations.ApplicationSecurityGroupsOperations
    :ivar available_delegations: AvailableDelegationsOperations operations
    :vartype available_delegations: azure.mgmt.network.operations.AvailableDelegationsOperations
    :ivar available_resource_group_delegations: AvailableResourceGroupDelegationsOperations
     operations
    :vartype available_resource_group_delegations:
     azure.mgmt.network.operations.AvailableResourceGroupDelegationsOperations
    :ivar available_service_aliases: AvailableServiceAliasesOperations operations
    :vartype available_service_aliases:
     azure.mgmt.network.operations.AvailableServiceAliasesOperations
    :ivar azure_firewalls: AzureFirewallsOperations operations
    :vartype azure_firewalls: azure.mgmt.network.operations.AzureFirewallsOperations
    :ivar azure_firewall_fqdn_tags: AzureFirewallFqdnTagsOperations operations
    :vartype azure_firewall_fqdn_tags:
     azure.mgmt.network.operations.AzureFirewallFqdnTagsOperations
    :ivar web_categories: WebCategoriesOperations operations
    :vartype web_categories: azure.mgmt.network.operations.WebCategoriesOperations
    :ivar bastion_hosts: BastionHostsOperations operations
    :vartype bastion_hosts: azure.mgmt.network.operations.BastionHostsOperations
    :ivar network_interfaces: NetworkInterfacesOperations operations
    :vartype network_interfaces: azure.mgmt.network.operations.NetworkInterfacesOperations
    :ivar public_ip_addresses: PublicIPAddressesOperations operations
    :vartype public_ip_addresses: azure.mgmt.network.operations.PublicIPAddressesOperations
    :ivar vip_swap: VipSwapOperations operations
    :vartype vip_swap: azure.mgmt.network.operations.VipSwapOperations
    :ivar custom_ip_prefixes: CustomIPPrefixesOperations operations
    :vartype custom_ip_prefixes: azure.mgmt.network.operations.CustomIPPrefixesOperations
    :ivar ddos_custom_policies: DdosCustomPoliciesOperations operations
    :vartype ddos_custom_policies: azure.mgmt.network.operations.DdosCustomPoliciesOperations
    :ivar ddos_protection_plans: DdosProtectionPlansOperations operations
    :vartype ddos_protection_plans: azure.mgmt.network.operations.DdosProtectionPlansOperations
    :ivar dscp_configuration: DscpConfigurationOperations operations
    :vartype dscp_configuration: azure.mgmt.network.operations.DscpConfigurationOperations
    :ivar available_endpoint_services: AvailableEndpointServicesOperations operations
    :vartype available_endpoint_services:
     azure.mgmt.network.operations.AvailableEndpointServicesOperations
    :ivar express_route_circuit_authorizations: ExpressRouteCircuitAuthorizationsOperations
     operations
    :vartype express_route_circuit_authorizations:
     azure.mgmt.network.operations.ExpressRouteCircuitAuthorizationsOperations
    :ivar express_route_circuit_peerings: ExpressRouteCircuitPeeringsOperations operations
    :vartype express_route_circuit_peerings:
     azure.mgmt.network.operations.ExpressRouteCircuitPeeringsOperations
    :ivar express_route_circuit_connections: ExpressRouteCircuitConnectionsOperations operations
    :vartype express_route_circuit_connections:
     azure.mgmt.network.operations.ExpressRouteCircuitConnectionsOperations
    :ivar peer_express_route_circuit_connections: PeerExpressRouteCircuitConnectionsOperations
     operations
    :vartype peer_express_route_circuit_connections:
     azure.mgmt.network.operations.PeerExpressRouteCircuitConnectionsOperations
    :ivar express_route_circuits: ExpressRouteCircuitsOperations operations
    :vartype express_route_circuits: azure.mgmt.network.operations.ExpressRouteCircuitsOperations
    :ivar express_route_service_providers: ExpressRouteServiceProvidersOperations operations
    :vartype express_route_service_providers:
     azure.mgmt.network.operations.ExpressRouteServiceProvidersOperations
    :ivar express_route_cross_connections: ExpressRouteCrossConnectionsOperations operations
    :vartype express_route_cross_connections:
     azure.mgmt.network.operations.ExpressRouteCrossConnectionsOperations
    :ivar express_route_cross_connection_peerings: ExpressRouteCrossConnectionPeeringsOperations
     operations
    :vartype express_route_cross_connection_peerings:
     azure.mgmt.network.operations.ExpressRouteCrossConnectionPeeringsOperations
    :ivar express_route_ports_locations: ExpressRoutePortsLocationsOperations operations
    :vartype express_route_ports_locations:
     azure.mgmt.network.operations.ExpressRoutePortsLocationsOperations
    :ivar express_route_ports: ExpressRoutePortsOperations operations
    :vartype express_route_ports: azure.mgmt.network.operations.ExpressRoutePortsOperations
    :ivar express_route_links: ExpressRouteLinksOperations operations
    :vartype express_route_links: azure.mgmt.network.operations.ExpressRouteLinksOperations
    :ivar express_route_port_authorizations: ExpressRoutePortAuthorizationsOperations operations
    :vartype express_route_port_authorizations:
     azure.mgmt.network.operations.ExpressRoutePortAuthorizationsOperations
    :ivar express_route_provider_ports_location: ExpressRouteProviderPortsLocationOperations
     operations
    :vartype express_route_provider_ports_location:
     azure.mgmt.network.operations.ExpressRouteProviderPortsLocationOperations
    :ivar firewall_policies: FirewallPoliciesOperations operations
    :vartype firewall_policies: azure.mgmt.network.operations.FirewallPoliciesOperations
    :ivar firewall_policy_rule_collection_groups: FirewallPolicyRuleCollectionGroupsOperations
     operations
    :vartype firewall_policy_rule_collection_groups:
     azure.mgmt.network.operations.FirewallPolicyRuleCollectionGroupsOperations
    :ivar firewall_policy_idps_signatures: FirewallPolicyIdpsSignaturesOperations operations
    :vartype firewall_policy_idps_signatures:
     azure.mgmt.network.operations.FirewallPolicyIdpsSignaturesOperations
    :ivar firewall_policy_idps_signatures_overrides:
     FirewallPolicyIdpsSignaturesOverridesOperations operations
    :vartype firewall_policy_idps_signatures_overrides:
     azure.mgmt.network.operations.FirewallPolicyIdpsSignaturesOverridesOperations
    :ivar firewall_policy_idps_signatures_filter_values:
     FirewallPolicyIdpsSignaturesFilterValuesOperations operations
    :vartype firewall_policy_idps_signatures_filter_values:
     azure.mgmt.network.operations.FirewallPolicyIdpsSignaturesFilterValuesOperations
    :ivar firewall_policy_drafts: FirewallPolicyDraftsOperations operations
    :vartype firewall_policy_drafts: azure.mgmt.network.operations.FirewallPolicyDraftsOperations
    :ivar firewall_policy_deployments: FirewallPolicyDeploymentsOperations operations
    :vartype firewall_policy_deployments:
     azure.mgmt.network.operations.FirewallPolicyDeploymentsOperations
    :ivar firewall_policy_rule_collection_group_drafts:
     FirewallPolicyRuleCollectionGroupDraftsOperations operations
    :vartype firewall_policy_rule_collection_group_drafts:
     azure.mgmt.network.operations.FirewallPolicyRuleCollectionGroupDraftsOperations
    :ivar ipam_pools: IpamPoolsOperations operations
    :vartype ipam_pools: azure.mgmt.network.operations.IpamPoolsOperations
    :ivar static_cidrs: StaticCidrsOperations operations
    :vartype static_cidrs: azure.mgmt.network.operations.StaticCidrsOperations
    :ivar ip_allocations: IpAllocationsOperations operations
    :vartype ip_allocations: azure.mgmt.network.operations.IpAllocationsOperations
    :ivar ip_groups: IpGroupsOperations operations
    :vartype ip_groups: azure.mgmt.network.operations.IpGroupsOperations
    :ivar load_balancers: LoadBalancersOperations operations
    :vartype load_balancers: azure.mgmt.network.operations.LoadBalancersOperations
    :ivar load_balancer_backend_address_pools: LoadBalancerBackendAddressPoolsOperations operations
    :vartype load_balancer_backend_address_pools:
     azure.mgmt.network.operations.LoadBalancerBackendAddressPoolsOperations
    :ivar load_balancer_frontend_ip_configurations: LoadBalancerFrontendIPConfigurationsOperations
     operations
    :vartype load_balancer_frontend_ip_configurations:
     azure.mgmt.network.operations.LoadBalancerFrontendIPConfigurationsOperations
    :ivar inbound_nat_rules: InboundNatRulesOperations operations
    :vartype inbound_nat_rules: azure.mgmt.network.operations.InboundNatRulesOperations
    :ivar load_balancer_load_balancing_rules: LoadBalancerLoadBalancingRulesOperations operations
    :vartype load_balancer_load_balancing_rules:
     azure.mgmt.network.operations.LoadBalancerLoadBalancingRulesOperations
    :ivar load_balancer_outbound_rules: LoadBalancerOutboundRulesOperations operations
    :vartype load_balancer_outbound_rules:
     azure.mgmt.network.operations.LoadBalancerOutboundRulesOperations
    :ivar load_balancer_network_interfaces: LoadBalancerNetworkInterfacesOperations operations
    :vartype load_balancer_network_interfaces:
     azure.mgmt.network.operations.LoadBalancerNetworkInterfacesOperations
    :ivar load_balancer_probes: LoadBalancerProbesOperations operations
    :vartype load_balancer_probes: azure.mgmt.network.operations.LoadBalancerProbesOperations
    :ivar nat_gateways: NatGatewaysOperations operations
    :vartype nat_gateways: azure.mgmt.network.operations.NatGatewaysOperations
    :ivar network_interface_ip_configurations: NetworkInterfaceIPConfigurationsOperations
     operations
    :vartype network_interface_ip_configurations:
     azure.mgmt.network.operations.NetworkInterfaceIPConfigurationsOperations
    :ivar network_interface_load_balancers: NetworkInterfaceLoadBalancersOperations operations
    :vartype network_interface_load_balancers:
     azure.mgmt.network.operations.NetworkInterfaceLoadBalancersOperations
    :ivar network_interface_tap_configurations: NetworkInterfaceTapConfigurationsOperations
     operations
    :vartype network_interface_tap_configurations:
     azure.mgmt.network.operations.NetworkInterfaceTapConfigurationsOperations
    :ivar network_managers: NetworkManagersOperations operations
    :vartype network_managers: azure.mgmt.network.operations.NetworkManagersOperations
    :ivar network_manager_commits: NetworkManagerCommitsOperations operations
    :vartype network_manager_commits: azure.mgmt.network.operations.NetworkManagerCommitsOperations
    :ivar network_manager_deployment_status: NetworkManagerDeploymentStatusOperations operations
    :vartype network_manager_deployment_status:
     azure.mgmt.network.operations.NetworkManagerDeploymentStatusOperations
    :ivar subscription_network_manager_connections: SubscriptionNetworkManagerConnectionsOperations
     operations
    :vartype subscription_network_manager_connections:
     azure.mgmt.network.operations.SubscriptionNetworkManagerConnectionsOperations
    :ivar management_group_network_manager_connections:
     ManagementGroupNetworkManagerConnectionsOperations operations
    :vartype management_group_network_manager_connections:
     azure.mgmt.network.operations.ManagementGroupNetworkManagerConnectionsOperations
    :ivar connectivity_configurations: ConnectivityConfigurationsOperations operations
    :vartype connectivity_configurations:
     azure.mgmt.network.operations.ConnectivityConfigurationsOperations
    :ivar network_groups: NetworkGroupsOperations operations
    :vartype network_groups: azure.mgmt.network.operations.NetworkGroupsOperations
    :ivar static_members: StaticMembersOperations operations
    :vartype static_members: azure.mgmt.network.operations.StaticMembersOperations
    :ivar network_manager_routing_configurations: NetworkManagerRoutingConfigurationsOperations
     operations
    :vartype network_manager_routing_configurations:
     azure.mgmt.network.operations.NetworkManagerRoutingConfigurationsOperations
    :ivar routing_rule_collections: RoutingRuleCollectionsOperations operations
    :vartype routing_rule_collections:
     azure.mgmt.network.operations.RoutingRuleCollectionsOperations
    :ivar routing_rules: RoutingRulesOperations operations
    :vartype routing_rules: azure.mgmt.network.operations.RoutingRulesOperations
    :ivar scope_connections: ScopeConnectionsOperations operations
    :vartype scope_connections: azure.mgmt.network.operations.ScopeConnectionsOperations
    :ivar security_admin_configurations: SecurityAdminConfigurationsOperations operations
    :vartype security_admin_configurations:
     azure.mgmt.network.operations.SecurityAdminConfigurationsOperations
    :ivar admin_rule_collections: AdminRuleCollectionsOperations operations
    :vartype admin_rule_collections: azure.mgmt.network.operations.AdminRuleCollectionsOperations
    :ivar admin_rules: AdminRulesOperations operations
    :vartype admin_rules: azure.mgmt.network.operations.AdminRulesOperations
    :ivar security_user_configurations: SecurityUserConfigurationsOperations operations
    :vartype security_user_configurations:
     azure.mgmt.network.operations.SecurityUserConfigurationsOperations
    :ivar security_user_rule_collections: SecurityUserRuleCollectionsOperations operations
    :vartype security_user_rule_collections:
     azure.mgmt.network.operations.SecurityUserRuleCollectionsOperations
    :ivar security_user_rules: SecurityUserRulesOperations operations
    :vartype security_user_rules: azure.mgmt.network.operations.SecurityUserRulesOperations
    :ivar network_profiles: NetworkProfilesOperations operations
    :vartype network_profiles: azure.mgmt.network.operations.NetworkProfilesOperations
    :ivar network_security_groups: NetworkSecurityGroupsOperations operations
    :vartype network_security_groups: azure.mgmt.network.operations.NetworkSecurityGroupsOperations
    :ivar security_rules: SecurityRulesOperations operations
    :vartype security_rules: azure.mgmt.network.operations.SecurityRulesOperations
    :ivar default_security_rules: DefaultSecurityRulesOperations operations
    :vartype default_security_rules: azure.mgmt.network.operations.DefaultSecurityRulesOperations
    :ivar reachability_analysis_intents: ReachabilityAnalysisIntentsOperations operations
    :vartype reachability_analysis_intents:
     azure.mgmt.network.operations.ReachabilityAnalysisIntentsOperations
    :ivar reachability_analysis_runs: ReachabilityAnalysisRunsOperations operations
    :vartype reachability_analysis_runs:
     azure.mgmt.network.operations.ReachabilityAnalysisRunsOperations
    :ivar verifier_workspaces: VerifierWorkspacesOperations operations
    :vartype verifier_workspaces: azure.mgmt.network.operations.VerifierWorkspacesOperations
    :ivar network_virtual_appliances: NetworkVirtualAppliancesOperations operations
    :vartype network_virtual_appliances:
     azure.mgmt.network.operations.NetworkVirtualAppliancesOperations
    :ivar virtual_appliance_sites: VirtualApplianceSitesOperations operations
    :vartype virtual_appliance_sites: azure.mgmt.network.operations.VirtualApplianceSitesOperations
    :ivar virtual_appliance_skus: VirtualApplianceSkusOperations operations
    :vartype virtual_appliance_skus: azure.mgmt.network.operations.VirtualApplianceSkusOperations
    :ivar inbound_security_rule: InboundSecurityRuleOperations operations
    :vartype inbound_security_rule: azure.mgmt.network.operations.InboundSecurityRuleOperations
    :ivar network_watchers: NetworkWatchersOperations operations
    :vartype network_watchers: azure.mgmt.network.operations.NetworkWatchersOperations
    :ivar packet_captures: PacketCapturesOperations operations
    :vartype packet_captures: azure.mgmt.network.operations.PacketCapturesOperations
    :ivar connection_monitors: ConnectionMonitorsOperations operations
    :vartype connection_monitors: azure.mgmt.network.operations.ConnectionMonitorsOperations
    :ivar flow_logs: FlowLogsOperations operations
    :vartype flow_logs: azure.mgmt.network.operations.FlowLogsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.network.operations.Operations
    :ivar private_endpoints: PrivateEndpointsOperations operations
    :vartype private_endpoints: azure.mgmt.network.operations.PrivateEndpointsOperations
    :ivar available_private_endpoint_types: AvailablePrivateEndpointTypesOperations operations
    :vartype available_private_endpoint_types:
     azure.mgmt.network.operations.AvailablePrivateEndpointTypesOperations
    :ivar private_dns_zone_groups: PrivateDnsZoneGroupsOperations operations
    :vartype private_dns_zone_groups: azure.mgmt.network.operations.PrivateDnsZoneGroupsOperations
    :ivar private_link_services: PrivateLinkServicesOperations operations
    :vartype private_link_services: azure.mgmt.network.operations.PrivateLinkServicesOperations
    :ivar public_ip_prefixes: PublicIPPrefixesOperations operations
    :vartype public_ip_prefixes: azure.mgmt.network.operations.PublicIPPrefixesOperations
    :ivar route_filters: RouteFiltersOperations operations
    :vartype route_filters: azure.mgmt.network.operations.RouteFiltersOperations
    :ivar route_filter_rules: RouteFilterRulesOperations operations
    :vartype route_filter_rules: azure.mgmt.network.operations.RouteFilterRulesOperations
    :ivar route_tables: RouteTablesOperations operations
    :vartype route_tables: azure.mgmt.network.operations.RouteTablesOperations
    :ivar routes: RoutesOperations operations
    :vartype routes: azure.mgmt.network.operations.RoutesOperations
    :ivar security_partner_providers: SecurityPartnerProvidersOperations operations
    :vartype security_partner_providers:
     azure.mgmt.network.operations.SecurityPartnerProvidersOperations
    :ivar bgp_service_communities: BgpServiceCommunitiesOperations operations
    :vartype bgp_service_communities: azure.mgmt.network.operations.BgpServiceCommunitiesOperations
    :ivar service_endpoint_policies: ServiceEndpointPoliciesOperations operations
    :vartype service_endpoint_policies:
     azure.mgmt.network.operations.ServiceEndpointPoliciesOperations
    :ivar service_endpoint_policy_definitions: ServiceEndpointPolicyDefinitionsOperations
     operations
    :vartype service_endpoint_policy_definitions:
     azure.mgmt.network.operations.ServiceEndpointPolicyDefinitionsOperations
    :ivar service_tags: ServiceTagsOperations operations
    :vartype service_tags: azure.mgmt.network.operations.ServiceTagsOperations
    :ivar service_tag_information: ServiceTagInformationOperations operations
    :vartype service_tag_information: azure.mgmt.network.operations.ServiceTagInformationOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.network.operations.UsagesOperations
    :ivar virtual_networks: VirtualNetworksOperations operations
    :vartype virtual_networks: azure.mgmt.network.operations.VirtualNetworksOperations
    :ivar subnets: SubnetsOperations operations
    :vartype subnets: azure.mgmt.network.operations.SubnetsOperations
    :ivar resource_navigation_links: ResourceNavigationLinksOperations operations
    :vartype resource_navigation_links:
     azure.mgmt.network.operations.ResourceNavigationLinksOperations
    :ivar service_association_links: ServiceAssociationLinksOperations operations
    :vartype service_association_links:
     azure.mgmt.network.operations.ServiceAssociationLinksOperations
    :ivar virtual_network_peerings: VirtualNetworkPeeringsOperations operations
    :vartype virtual_network_peerings:
     azure.mgmt.network.operations.VirtualNetworkPeeringsOperations
    :ivar virtual_network_gateways: VirtualNetworkGatewaysOperations operations
    :vartype virtual_network_gateways:
     azure.mgmt.network.operations.VirtualNetworkGatewaysOperations
    :ivar virtual_network_gateway_connections: VirtualNetworkGatewayConnectionsOperations
     operations
    :vartype virtual_network_gateway_connections:
     azure.mgmt.network.operations.VirtualNetworkGatewayConnectionsOperations
    :ivar local_network_gateways: LocalNetworkGatewaysOperations operations
    :vartype local_network_gateways: azure.mgmt.network.operations.LocalNetworkGatewaysOperations
    :ivar virtual_network_gateway_nat_rules: VirtualNetworkGatewayNatRulesOperations operations
    :vartype virtual_network_gateway_nat_rules:
     azure.mgmt.network.operations.VirtualNetworkGatewayNatRulesOperations
    :ivar virtual_network_taps: VirtualNetworkTapsOperations operations
    :vartype virtual_network_taps: azure.mgmt.network.operations.VirtualNetworkTapsOperations
    :ivar virtual_routers: VirtualRoutersOperations operations
    :vartype virtual_routers: azure.mgmt.network.operations.VirtualRoutersOperations
    :ivar virtual_router_peerings: VirtualRouterPeeringsOperations operations
    :vartype virtual_router_peerings: azure.mgmt.network.operations.VirtualRouterPeeringsOperations
    :ivar virtual_wans: VirtualWansOperations operations
    :vartype virtual_wans: azure.mgmt.network.operations.VirtualWansOperations
    :ivar vpn_sites: VpnSitesOperations operations
    :vartype vpn_sites: azure.mgmt.network.operations.VpnSitesOperations
    :ivar vpn_site_links: VpnSiteLinksOperations operations
    :vartype vpn_site_links: azure.mgmt.network.operations.VpnSiteLinksOperations
    :ivar vpn_sites_configuration: VpnSitesConfigurationOperations operations
    :vartype vpn_sites_configuration: azure.mgmt.network.operations.VpnSitesConfigurationOperations
    :ivar vpn_server_configurations: VpnServerConfigurationsOperations operations
    :vartype vpn_server_configurations:
     azure.mgmt.network.operations.VpnServerConfigurationsOperations
    :ivar configuration_policy_groups: ConfigurationPolicyGroupsOperations operations
    :vartype configuration_policy_groups:
     azure.mgmt.network.operations.ConfigurationPolicyGroupsOperations
    :ivar virtual_hubs: VirtualHubsOperations operations
    :vartype virtual_hubs: azure.mgmt.network.operations.VirtualHubsOperations
    :ivar route_maps: RouteMapsOperations operations
    :vartype route_maps: azure.mgmt.network.operations.RouteMapsOperations
    :ivar hub_virtual_network_connections: HubVirtualNetworkConnectionsOperations operations
    :vartype hub_virtual_network_connections:
     azure.mgmt.network.operations.HubVirtualNetworkConnectionsOperations
    :ivar vpn_gateways: VpnGatewaysOperations operations
    :vartype vpn_gateways: azure.mgmt.network.operations.VpnGatewaysOperations
    :ivar vpn_link_connections: VpnLinkConnectionsOperations operations
    :vartype vpn_link_connections: azure.mgmt.network.operations.VpnLinkConnectionsOperations
    :ivar vpn_connections: VpnConnectionsOperations operations
    :vartype vpn_connections: azure.mgmt.network.operations.VpnConnectionsOperations
    :ivar vpn_site_link_connections: VpnSiteLinkConnectionsOperations operations
    :vartype vpn_site_link_connections:
     azure.mgmt.network.operations.VpnSiteLinkConnectionsOperations
    :ivar nat_rules: NatRulesOperations operations
    :vartype nat_rules: azure.mgmt.network.operations.NatRulesOperations
    :ivar p2_svpn_gateways: P2SVpnGatewaysOperations operations
    :vartype p2_svpn_gateways: azure.mgmt.network.operations.P2SVpnGatewaysOperations
    :ivar vpn_server_configurations_associated_with_virtual_wan:
     VpnServerConfigurationsAssociatedWithVirtualWanOperations operations
    :vartype vpn_server_configurations_associated_with_virtual_wan:
     azure.mgmt.network.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations
    :ivar virtual_hub_route_table_v2_s: VirtualHubRouteTableV2SOperations operations
    :vartype virtual_hub_route_table_v2_s:
     azure.mgmt.network.operations.VirtualHubRouteTableV2SOperations
    :ivar express_route_gateways: ExpressRouteGatewaysOperations operations
    :vartype express_route_gateways: azure.mgmt.network.operations.ExpressRouteGatewaysOperations
    :ivar express_route_connections: ExpressRouteConnectionsOperations operations
    :vartype express_route_connections:
     azure.mgmt.network.operations.ExpressRouteConnectionsOperations
    :ivar network_virtual_appliance_connections: NetworkVirtualApplianceConnectionsOperations
     operations
    :vartype network_virtual_appliance_connections:
     azure.mgmt.network.operations.NetworkVirtualApplianceConnectionsOperations
    :ivar virtual_hub_bgp_connection: VirtualHubBgpConnectionOperations operations
    :vartype virtual_hub_bgp_connection:
     azure.mgmt.network.operations.VirtualHubBgpConnectionOperations
    :ivar virtual_hub_bgp_connections: VirtualHubBgpConnectionsOperations operations
    :vartype virtual_hub_bgp_connections:
     azure.mgmt.network.operations.VirtualHubBgpConnectionsOperations
    :ivar virtual_hub_ip_configuration: VirtualHubIpConfigurationOperations operations
    :vartype virtual_hub_ip_configuration:
     azure.mgmt.network.operations.VirtualHubIpConfigurationOperations
    :ivar hub_route_tables: HubRouteTablesOperations operations
    :vartype hub_route_tables: azure.mgmt.network.operations.HubRouteTablesOperations
    :ivar routing_intent: RoutingIntentOperations operations
    :vartype routing_intent: azure.mgmt.network.operations.RoutingIntentOperations
    :ivar web_application_firewall_policies: WebApplicationFirewallPoliciesOperations operations
    :vartype web_application_firewall_policies:
     azure.mgmt.network.operations.WebApplicationFirewallPoliciesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The subscription credentials which uniquely identify the Microsoft
     Azure subscription. The subscription ID forms part of the URI for every service call. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = NetworkManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.application_gateways = ApplicationGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.application_gateway_private_link_resources = ApplicationGatewayPrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.application_gateway_private_endpoint_connections = ApplicationGatewayPrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.application_gateway_waf_dynamic_manifests_default = ApplicationGatewayWafDynamicManifestsDefaultOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.application_gateway_waf_dynamic_manifests = ApplicationGatewayWafDynamicManifestsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.application_security_groups = ApplicationSecurityGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.available_delegations = AvailableDelegationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.available_resource_group_delegations = AvailableResourceGroupDelegationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.available_service_aliases = AvailableServiceAliasesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.azure_firewalls = AzureFirewallsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.azure_firewall_fqdn_tags = AzureFirewallFqdnTagsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.web_categories = WebCategoriesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.bastion_hosts = BastionHostsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.network_interfaces = NetworkInterfacesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.public_ip_addresses = PublicIPAddressesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.vip_swap = VipSwapOperations(self._client, self._config, self._serialize, self._deserialize)
        self.custom_ip_prefixes = CustomIPPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.ddos_custom_policies = DdosCustomPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.ddos_protection_plans = DdosProtectionPlansOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dscp_configuration = DscpConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.available_endpoint_services = AvailableEndpointServicesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_circuit_authorizations = ExpressRouteCircuitAuthorizationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_circuit_peerings = ExpressRouteCircuitPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_circuit_connections = ExpressRouteCircuitConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.peer_express_route_circuit_connections = PeerExpressRouteCircuitConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_circuits = ExpressRouteCircuitsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_service_providers = ExpressRouteServiceProvidersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_cross_connections = ExpressRouteCrossConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_cross_connection_peerings = ExpressRouteCrossConnectionPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_ports_locations = ExpressRoutePortsLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_ports = ExpressRoutePortsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_links = ExpressRouteLinksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_port_authorizations = ExpressRoutePortAuthorizationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_provider_ports_location = ExpressRouteProviderPortsLocationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_policies = FirewallPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_policy_rule_collection_groups = FirewallPolicyRuleCollectionGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_policy_idps_signatures = FirewallPolicyIdpsSignaturesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_policy_idps_signatures_overrides = FirewallPolicyIdpsSignaturesOverridesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_policy_idps_signatures_filter_values = FirewallPolicyIdpsSignaturesFilterValuesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_policy_drafts = FirewallPolicyDraftsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_policy_deployments = FirewallPolicyDeploymentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_policy_rule_collection_group_drafts = FirewallPolicyRuleCollectionGroupDraftsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.ipam_pools = IpamPoolsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.static_cidrs = StaticCidrsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.ip_allocations = IpAllocationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.ip_groups = IpGroupsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.load_balancers = LoadBalancersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.load_balancer_backend_address_pools = LoadBalancerBackendAddressPoolsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.load_balancer_frontend_ip_configurations = LoadBalancerFrontendIPConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.inbound_nat_rules = InboundNatRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.load_balancer_load_balancing_rules = LoadBalancerLoadBalancingRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.load_balancer_outbound_rules = LoadBalancerOutboundRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.load_balancer_network_interfaces = LoadBalancerNetworkInterfacesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.load_balancer_probes = LoadBalancerProbesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.nat_gateways = NatGatewaysOperations(self._client, self._config, self._serialize, self._deserialize)
        self.network_interface_ip_configurations = NetworkInterfaceIPConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_interface_load_balancers = NetworkInterfaceLoadBalancersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_interface_tap_configurations = NetworkInterfaceTapConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_managers = NetworkManagersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_manager_commits = NetworkManagerCommitsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_manager_deployment_status = NetworkManagerDeploymentStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.subscription_network_manager_connections = SubscriptionNetworkManagerConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.management_group_network_manager_connections = ManagementGroupNetworkManagerConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.connectivity_configurations = ConnectivityConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_groups = NetworkGroupsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.static_members = StaticMembersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.network_manager_routing_configurations = NetworkManagerRoutingConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.routing_rule_collections = RoutingRuleCollectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.routing_rules = RoutingRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.scope_connections = ScopeConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.security_admin_configurations = SecurityAdminConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.admin_rule_collections = AdminRuleCollectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.admin_rules = AdminRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.security_user_configurations = SecurityUserConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.security_user_rule_collections = SecurityUserRuleCollectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.security_user_rules = SecurityUserRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_profiles = NetworkProfilesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_security_groups = NetworkSecurityGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.security_rules = SecurityRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.default_security_rules = DefaultSecurityRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.reachability_analysis_intents = ReachabilityAnalysisIntentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.reachability_analysis_runs = ReachabilityAnalysisRunsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.verifier_workspaces = VerifierWorkspacesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_virtual_appliances = NetworkVirtualAppliancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_appliance_sites = VirtualApplianceSitesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_appliance_skus = VirtualApplianceSkusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.inbound_security_rule = InboundSecurityRuleOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_watchers = NetworkWatchersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.packet_captures = PacketCapturesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.connection_monitors = ConnectionMonitorsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.flow_logs = FlowLogsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.private_endpoints = PrivateEndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.available_private_endpoint_types = AvailablePrivateEndpointTypesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_dns_zone_groups = PrivateDnsZoneGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_services = PrivateLinkServicesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.public_ip_prefixes = PublicIPPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.route_filters = RouteFiltersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.route_filter_rules = RouteFilterRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.route_tables = RouteTablesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.routes = RoutesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.security_partner_providers = SecurityPartnerProvidersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.bgp_service_communities = BgpServiceCommunitiesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.service_endpoint_policies = ServiceEndpointPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.service_endpoint_policy_definitions = ServiceEndpointPolicyDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.service_tags = ServiceTagsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.service_tag_information = ServiceTagInformationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.usages = UsagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_networks = VirtualNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.subnets = SubnetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.resource_navigation_links = ResourceNavigationLinksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.service_association_links = ServiceAssociationLinksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_network_peerings = VirtualNetworkPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_network_gateways = VirtualNetworkGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_network_gateway_connections = VirtualNetworkGatewayConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.local_network_gateways = LocalNetworkGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_network_gateway_nat_rules = VirtualNetworkGatewayNatRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_network_taps = VirtualNetworkTapsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_routers = VirtualRoutersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_router_peerings = VirtualRouterPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_wans = VirtualWansOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vpn_sites = VpnSitesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vpn_site_links = VpnSiteLinksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vpn_sites_configuration = VpnSitesConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.vpn_server_configurations = VpnServerConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.configuration_policy_groups = ConfigurationPolicyGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_hubs = VirtualHubsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.route_maps = RouteMapsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.hub_virtual_network_connections = HubVirtualNetworkConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.vpn_gateways = VpnGatewaysOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vpn_link_connections = VpnLinkConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.vpn_connections = VpnConnectionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vpn_site_link_connections = VpnSiteLinkConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.nat_rules = NatRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.p2_svpn_gateways = P2SVpnGatewaysOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vpn_server_configurations_associated_with_virtual_wan = (
            VpnServerConfigurationsAssociatedWithVirtualWanOperations(
                self._client, self._config, self._serialize, self._deserialize
            )
        )
        self.virtual_hub_route_table_v2_s = VirtualHubRouteTableV2SOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_gateways = ExpressRouteGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.express_route_connections = ExpressRouteConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_virtual_appliance_connections = NetworkVirtualApplianceConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_hub_bgp_connection = VirtualHubBgpConnectionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_hub_bgp_connections = VirtualHubBgpConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_hub_ip_configuration = VirtualHubIpConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.hub_route_tables = HubRouteTablesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.routing_intent = RoutingIntentOperations(self._client, self._config, self._serialize, self._deserialize)
        self.web_application_firewall_policies = WebApplicationFirewallPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
