export declare const Components: {
    DataSource: {
        TestData: {
            QueryTab: {
                scenarioSelectContainer: string;
                scenarioSelect: string;
                max: string;
                min: string;
                noise: string;
                seriesCount: string;
                spread: string;
                startValue: string;
            };
        };
    };
    Panels: {
        Panel: {
            title: (title: string) => string;
            headerItems: (item: string) => string;
            containerByTitle: (title: string) => string;
            headerCornerInfo: (mode: string) => string;
        };
        Visualization: {
            Graph: {
                VisualizationTab: {
                    legendSection: string;
                };
                Legend: {
                    legendItemAlias: (name: string) => string;
                    showLegendSwitch: string;
                };
                xAxis: {
                    labels: () => string;
                };
            };
            BarGauge: {
                value: string;
            };
            Text: {
                container: () => string;
            };
        };
    };
    Drawer: {
        General: {
            title: (title: string) => string;
            expand: string;
            contract: string;
            close: string;
            rcContentWrapper: () => string;
        };
    };
    PanelEditor: {
        General: {
            content: string;
        };
        OptionsPane: {
            content: string;
            close: string;
            open: string;
            select: string;
            tab: (title: string) => string;
        };
        DataPane: {
            content: string;
        };
        FieldOptions: {
            propertyEditor: (type: string) => string;
        };
    };
    PanelInspector: {
        Data: {
            content: string;
        };
        Stats: {
            content: string;
        };
        Json: {
            content: string;
        };
        Query: {
            content: string;
            refreshButton: string;
            jsonObjectKeys: () => string;
        };
    };
    Tab: {
        title: (title: string) => string;
        active: () => string;
    };
    RefreshPicker: {
        runButton: string;
    };
    QueryTab: {
        content: string;
        queryInspectorButton: string;
        addQuery: string;
    };
    QueryEditorRows: {
        rows: string;
    };
    QueryEditorRow: {
        actionButton: (title: string) => string;
        title: (refId: string) => string;
    };
    AlertTab: {
        content: string;
    };
    Alert: {
        alert: (severity: string) => string;
    };
    TransformTab: {
        content: string;
        newTransform: (name: string) => string;
        transformationEditor: (name: string) => string;
        transformationEditorDebugger: (name: string) => string;
    };
    Transforms: {
        card: (name: string) => string;
        Reduce: {
            modeLabel: string;
            calculationsLabel: string;
        };
        searchInput: string;
    };
    PageToolbar: {
        container: () => string;
        item: (tooltip: string) => string;
    };
    QueryEditorToolbarItem: {
        button: (title: string) => string;
    };
    BackButton: {
        backArrow: string;
    };
    OptionsGroup: {
        toggle: (title?: string | undefined) => string;
    };
    PluginVisualization: {
        item: (title: string) => string;
        current: () => string;
    };
    Select: {
        option: string;
        input: () => string;
        singleValue: () => string;
    };
    FieldConfigEditor: {
        content: string;
    };
    OverridesConfigEditor: {
        content: string;
    };
    FolderPicker: {
        container: string;
    };
    DataSourcePicker: {
        container: string;
    };
    TimeZonePicker: {
        container: string;
    };
    TraceViewer: {
        spanBar: () => string;
    };
    QueryField: {
        container: string;
    };
    ValuePicker: {
        button: string;
        select: (name: string) => string;
    };
    Search: {
        section: string;
        items: string;
    };
    DashboardLinks: {
        container: string;
        dropDown: string;
        link: string;
    };
    CallToActionCard: {
        button: (name: string) => string;
    };
    DataLinksContextMenu: {
        singleLink: string;
    };
};
