function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import React from 'react';
import cx from 'classnames';
import { path as d3Path } from 'd3-path';
import { getY, getX, getSource, getTarget } from '../../../util/accessors';
export function pathHorizontalCurve(_ref) {
  var source = _ref.source,
      target = _ref.target,
      x = _ref.x,
      y = _ref.y,
      percent = _ref.percent;
  return function (link) {
    var sourceData = source(link);
    var targetData = target(link);
    var sx = x(sourceData);
    var sy = y(sourceData);
    var tx = x(targetData);
    var ty = y(targetData);
    var dx = tx - sx;
    var dy = ty - sy;
    var ix = percent * (dx + dy);
    var iy = percent * (dy - dx);
    var path = d3Path();
    path.moveTo(sx, sy);
    path.bezierCurveTo(sx + ix, sy + iy, tx + iy, ty - ix, tx, ty);
    return path.toString();
  };
}
export default function LinkHorizontalCurve(_ref2) {
  var className = _ref2.className,
      children = _ref2.children,
      data = _ref2.data,
      innerRef = _ref2.innerRef,
      path = _ref2.path,
      _ref2$percent = _ref2.percent,
      percent = _ref2$percent === void 0 ? 0.2 : _ref2$percent,
      _ref2$x = _ref2.x,
      x = _ref2$x === void 0 ? getY : _ref2$x,
      _ref2$y = _ref2.y,
      y = _ref2$y === void 0 ? getX : _ref2$y,
      _ref2$source = _ref2.source,
      source = _ref2$source === void 0 ? getSource : _ref2$source,
      _ref2$target = _ref2.target,
      target = _ref2$target === void 0 ? getTarget : _ref2$target,
      restProps = _objectWithoutPropertiesLoose(_ref2, ["className", "children", "data", "innerRef", "path", "percent", "x", "y", "source", "target"]);

  var pathGen = path || pathHorizontalCurve({
    source: source,
    target: target,
    x: x,
    y: y,
    percent: percent
  });
  if (children) return /*#__PURE__*/React.createElement(React.Fragment, null, children({
    path: pathGen
  }));
  return /*#__PURE__*/React.createElement("path", _extends({
    ref: innerRef,
    className: cx('visx-link visx-link-horizontal-curve', className),
    d: pathGen(data) || ''
  }, restProps));
}