"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeMetas = void 0;
var utils_1 = require("../utils");
var version_1 = require("../version");
function initializeMetas(config) {
    var _a;
    var items = [];
    var add = function (item) {
        items.push(item);
    };
    var remove = function (item) {
        items = items.filter(function (i) { return i !== item; });
    };
    var initial = {
        sdk: {
            name: '@grafana/agent-core',
            version: version_1.VERSION,
            integrations: config.instrumentations.map(function (_a) {
                var name = _a.name, version = _a.version;
                return ({ name: name, version: version });
            }),
        },
    };
    if (config.app) {
        initial.app = config.app;
    }
    if (config.user) {
        initial.user = config.user;
    }
    if (config.session) {
        initial.session = config.session;
    }
    (_a = config.metas) === null || _a === void 0 ? void 0 : _a.forEach(add);
    add(initial);
    return {
        add: add,
        remove: remove,
        get value() {
            var meta = {};
            items.forEach(function (item) { return Object.assign(meta, (0, utils_1.isFunction)(item) ? item() : item); });
            return meta;
        },
    };
}
exports.initializeMetas = initializeMetas;
//# sourceMappingURL=initialize.js.map