"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rmdir = void 0;
const fs = require("fs");
const path = require("path");
/**
 * Remove directory recursively
 * Ref https://stackoverflow.com/a/42505874
 */
const rmdir = (dirPath) => {
    if (!fs.existsSync(dirPath)) {
        return;
    }
    fs.readdirSync(dirPath).forEach((entry) => {
        const entryPath = path.join(dirPath, entry);
        if (fs.lstatSync(entryPath).isDirectory()) {
            (0, exports.rmdir)(entryPath);
        }
        else {
            fs.unlinkSync(entryPath);
        }
    });
    fs.rmdirSync(dirPath);
};
exports.rmdir = rmdir;
//# sourceMappingURL=rmdir.js.map