/**
 * @param {import("../../size.js").Size} size Canvas size in css pixels.
 * @param {Array<import("../../transform.js").Transform>} transforms Transforms
 * for rendering features to all worlds of the viewport, from coordinates to css
 * pixels.
 * @param {Array<import("../../Feature.js").FeatureLike>} features
 * Features to consider for hit detection.
 * @param {import("../../style/Style.js").StyleFunction|undefined} styleFunction
 * Layer style function.
 * @param {import("../../extent.js").Extent} extent Extent.
 * @param {number} resolution Resolution.
 * @param {number} rotation Rotation.
 * @return {ImageData} Hit detection image data.
 */
export function createHitDetectionImageData(size: import("../../size.js").Size, transforms: Array<import("../../transform.js").Transform>, features: Array<import("../../Feature.js").FeatureLike>, styleFunction: import("../../style/Style.js").StyleFunction | undefined, extent: import("../../extent.js").Extent, resolution: number, rotation: number): ImageData;
/**
 * @param {import("../../pixel").Pixel} pixel Pixel coordinate on the hit
 * detection canvas in css pixels.
 * @param {Array<import("../../Feature").FeatureLike>} features Features. Has to
 * match the `features` array that was passed to `createHitDetectionImageData()`.
 * @param {ImageData} imageData Hit detection image data generated by
 * `createHitDetectionImageData()`.
 * @return {Array<import("../../Feature").FeatureLike>} features Features.
 */
export function hitDetect(pixel: import("../../pixel").Pixel, features: Array<import("../../Feature").FeatureLike>, imageData: ImageData): Array<import("../../Feature").FeatureLike>;
export const HIT_DETECT_RESOLUTION: 0.5;
//# sourceMappingURL=hitdetect.d.ts.map