This is a simple example program that shows how perform cosign signing.

The program allows also to use annotation, in the same way as `cosign sign -a key=value`
does.

The program prints to the standard output all the Simple Signing objects that
have been successfully pushed.

# Key based Signing

The implementation is in [main.rs](./main.rs).

Create a keypair using the official cosign client:

```console
cosign generate-key-pair
```

Because the default key pair generated by cosign is `ECDSA_P256` key,
so we choose to use `ECDSA_P256_SHA256_ASN1` as the signing scheme.
Suppose the password used to encrypt the private key is `123`, and the target
image to be signed is `172.17.0.2:5000/ubuntu`

Also, let us the annotation `a=1`.

Sign a container image:

```console
cargo run --example sign \
    --all-features \
    -- \
    --key cosign.key \
    --image 172.17.0.2:5000/ubuntu \
    --signing-scheme ECDSA_P256_SHA256_ASN1 \
    --password 123 \
    --verbose \
    --http \
    --annotations a=1
```

Then the image will be signed.

Let us then verify it.

1. Using `cosign` (golang version)
```console
cosign verify --key cosign.pub \
    -a a=1 \
    172.17.0.2:5000/ubuntu
```

2. Or use `sigstore-rs`
```console
cargo run --example verify -- \
    --key cosign.pub \
    --annotations a=1 \
    --http \
    172.17.0.2:5000/ubuntu
```