/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.TTLTimer;
import netscape.ldap.util.DN;

public class LDAPCache
implements Serializable {
    static final long serialVersionUID = 6275167993337814294L;
    private Hashtable<Long, Vector<Object>> m_cache;
    private Vector<Vector<Long>> m_orderedStruct;
    private long m_timeToLive;
    private long m_maxSize;
    private String[] m_dns;
    private long m_remainingSize = 0L;
    private int m_refCnt = 0;
    public static final String DELIM = "#";
    private TTLTimer m_timer = null;
    private long m_totalOpers = 0L;
    private long m_hits = 0L;
    private long m_flushes = 0L;
    private static boolean m_debug = false;

    public LDAPCache(long ttl, long size) {
        this.init(ttl, size);
    }

    public LDAPCache(long ttl, long size, String[] dns) {
        this.init(ttl, size);
        this.m_dns = new String[dns.length];
        if (dns != null && dns.length > 0) {
            for (int i = 0; i < dns.length; ++i) {
                this.m_dns[i] = new DN(dns[i]).toString();
            }
        }
    }

    public long getSize() {
        return this.m_maxSize;
    }

    public long getTimeToLive() {
        return this.m_timeToLive / 1000L;
    }

    public String[] getBaseDNs() {
        return this.m_dns;
    }

    public synchronized boolean flushEntries(String dn, int scope) {
        if (m_debug) {
            System.out.println("DEBUG: User request for flushing entry: dn " + dn + " and scope " + scope);
        }
        if (dn == null) {
            this.m_remainingSize = this.m_maxSize;
            this.m_cache.clear();
            this.m_orderedStruct.removeAllElements();
            this.m_flushes = 0L;
            this.m_hits = 0L;
            this.m_totalOpers = 0L;
            return true;
        }
        DN dn2 = new DN(dn);
        Enumeration<Long> e = this.m_cache.keys();
        while (e.hasMoreElements()) {
            DN parentDN1;
            String d;
            DN dn1;
            int j;
            Long key = e.nextElement();
            Vector<Object> val = this.m_cache.get(key);
            int size2 = val.size();
            for (j = 1; !(j >= size2 || (dn1 = new DN(d = ((LDAPEntry)val.elementAt(j)).getDN())).equals(dn2) || scope == 1 && (parentDN1 = dn1.getParent()).equals(dn2) || scope == 2 && dn1.isDescendantOf(dn2)); ++j) {
            }
            if (j >= size2) continue;
            for (int k = 0; k < this.m_orderedStruct.size(); ++k) {
                Vector<Long> v = this.m_orderedStruct.elementAt(k);
                if (!key.equals(v.elementAt(0))) continue;
                this.m_orderedStruct.removeElementAt(k);
                break;
            }
            Vector<Object> entry = this.m_cache.remove(key);
            this.m_remainingSize += ((Long)entry.firstElement()).longValue();
            if (m_debug) {
                System.out.println("DEBUG: Successfully removed entry ->" + key);
            }
            return true;
        }
        if (m_debug) {
            System.out.println("DEBUG: The number of keys in the cache is " + this.m_cache.size());
        }
        return false;
    }

    public long getAvailableSize() {
        return this.m_remainingSize;
    }

    public long getTotalOperations() {
        return this.m_totalOpers;
    }

    public long getNumMisses() {
        return this.m_totalOpers - this.m_hits;
    }

    public long getNumHits() {
        return this.m_hits;
    }

    public long getNumFlushes() {
        return this.m_flushes;
    }

    Long createKey(String host, int port, String baseDN, String filter, int scope, String[] attrs, String bindDN, LDAPConstraints cons) throws LDAPException {
        long val;
        LDAPControl ctrl;
        int i;
        String[] objID;
        DN dn = new DN(baseDN);
        baseDN = dn.toString();
        if (this.m_dns != null) {
            int i2;
            for (i2 = 0; i2 < this.m_dns.length && !baseDN.equals(this.m_dns[i2]); ++i2) {
            }
            if (i2 >= this.m_dns.length) {
                throw new LDAPException(baseDN + " is not a cached base DN", 80);
            }
        }
        Object key = null;
        key = this.appendString(baseDN);
        key = (String)key + this.appendString(scope);
        key = (String)key + this.appendString(host);
        key = (String)key + this.appendString(port);
        key = (String)key + this.appendString(filter);
        key = (String)key + this.appendString(attrs);
        key = (String)key + this.appendString(bindDN);
        LDAPControl[] serverControls = null;
        LDAPControl[] clientControls = null;
        if (cons != null) {
            serverControls = cons.getServerControls();
            clientControls = cons.getClientControls();
        }
        if (serverControls != null && serverControls.length > 0) {
            objID = new String[serverControls.length];
            for (i = 0; i < serverControls.length; ++i) {
                ctrl = serverControls[i];
                val = this.getCRC32(ctrl.getValue());
                objID[i] = ctrl.getID() + ctrl.isCritical() + val;
            }
            key = (String)key + this.appendString(objID);
        } else {
            key = (String)key + this.appendString(0);
        }
        if (clientControls != null && clientControls.length > 0) {
            objID = new String[clientControls.length];
            for (i = 0; i < clientControls.length; ++i) {
                ctrl = clientControls[i];
                val = this.getCRC32(ctrl.getValue());
                objID[i] = ctrl.getID() + ctrl.isCritical() + val;
            }
            key = (String)key + this.appendString(objID);
        } else {
            key = (String)key + this.appendString(0);
        }
        long val2 = this.getCRC32(((String)key).getBytes());
        if (m_debug) {
            System.out.println("key=" + val2 + " for " + (String)key);
        }
        return val2;
    }

    synchronized Object getEntry(Long key) {
        Vector<Object> obj = null;
        obj = this.m_cache.get(key);
        ++this.m_totalOpers;
        if (m_debug) {
            if (obj == null) {
                System.out.println("DEBUG: Entry whose key -> " + key + " not found in the cache.");
            } else {
                System.out.println("DEBUG: Entry whose key -> " + key + " found in the cache.");
            }
        }
        if (obj != null) {
            ++this.m_hits;
        }
        return obj;
    }

    synchronized void flushEntries() {
        long diff;
        Vector<Long> v = null;
        boolean delete = false;
        long currTime = System.currentTimeMillis();
        this.m_flushes = 0L;
        while (this.m_orderedStruct.size() > 0 && (diff = currTime - (v = this.m_orderedStruct.firstElement()).elementAt(1)) >= this.m_timeToLive) {
            Long key = v.elementAt(0);
            if (m_debug) {
                System.out.println("DEBUG: Timer flush entry whose key is " + key);
            }
            Vector<Object> entry = this.m_cache.remove(key);
            this.m_remainingSize += ((Long)entry.firstElement()).longValue();
            this.m_orderedStruct.removeElementAt(0);
            ++this.m_flushes;
        }
        if (m_debug) {
            System.out.println("DEBUG: The number of keys in the cache is " + this.m_cache.size());
        }
    }

    synchronized boolean addEntry(Long key, Object value) {
        Vector<Long> element;
        if (this.m_cache.get(key) != null) {
            return false;
        }
        Vector v = (Vector)value;
        long size = (Long)v.elementAt(0);
        if (size > this.m_maxSize) {
            if (m_debug) {
                System.out.println("Failed to add an entry to the cache since the new entry exceeds the cache size");
            }
            return false;
        }
        if (size > this.m_remainingSize) {
            do {
                element = this.m_orderedStruct.firstElement();
                Long str = element.elementAt(0);
                Vector<Object> val = this.m_cache.remove(str);
                if (m_debug) {
                    System.out.println("DEBUG: The spare size of the cache is not big enough to hold the new entry, deleting the entry whose key -> " + str);
                }
                this.m_orderedStruct.removeElementAt(0);
                this.m_remainingSize += ((Long)val.elementAt(0)).longValue();
            } while (this.m_remainingSize < size);
        }
        this.m_remainingSize -= size;
        this.m_cache.put(key, v);
        element = new Vector(2);
        element.addElement(key);
        element.addElement(System.currentTimeMillis());
        this.m_orderedStruct.addElement(element);
        if (this.m_orderedStruct.size() == 1) {
            this.scheduleTTLTimer();
        }
        if (m_debug) {
            System.out.println("DEBUG: Adding a new entry whose key -> " + key);
            System.out.println("DEBUG: The current number of keys in the cache " + this.m_cache.size());
        }
        return true;
    }

    synchronized void scheduleTTLTimer() {
        if (this.m_orderedStruct.size() <= 0) {
            return;
        }
        if (this.m_timer == null) {
            this.m_timer = new TTLTimer(this);
        }
        Vector<Long> v = this.m_orderedStruct.firstElement();
        long currTime = System.currentTimeMillis();
        long creationTime = v.elementAt(1);
        long timeout = creationTime + this.m_timeToLive - currTime;
        if (timeout > 0L) {
            this.m_timer.start(timeout);
        } else {
            this.flushEntries();
            this.scheduleTTLTimer();
        }
    }

    public int getNumEntries() {
        return this.m_cache.size();
    }

    int getRefCount() {
        return this.m_refCnt;
    }

    synchronized void addReference() {
        ++this.m_refCnt;
        if (m_debug) {
            System.err.println("Cache refCnt=" + this.m_refCnt);
        }
    }

    synchronized void removeReference() {
        if (this.m_refCnt > 0) {
            --this.m_refCnt;
            if (m_debug) {
                System.err.println("Cache refCnt=" + this.m_refCnt);
            }
            if (this.m_refCnt == 0) {
                this.cleanup();
            }
        }
    }

    synchronized void cleanup() {
        this.flushEntries(null, 0);
        if (this.m_timer != null) {
            this.m_timer.stop();
            this.m_timer = null;
        }
    }

    private void init(long ttl, long size) {
        this.m_cache = new Hashtable();
        this.m_timeToLive = ttl * 1000L;
        this.m_maxSize = size;
        this.m_remainingSize = size;
        this.m_dns = null;
        this.m_orderedStruct = new Vector();
    }

    private String appendString(String str) {
        if (str == null) {
            return "null#";
        }
        return str.trim() + DELIM;
    }

    private String appendString(int num) {
        return num + DELIM;
    }

    private String appendString(String[] str) {
        if (str == null || str.length < 1) {
            return "0#";
        }
        String[] sorted = new String[str.length];
        System.arraycopy(str, 0, sorted, 0, str.length);
        this.sortStrings(sorted);
        String s = sorted.length + DELIM;
        for (int i = 0; i < sorted.length; ++i) {
            s = s + sorted[i].trim() + DELIM;
        }
        return s;
    }

    private void sortStrings(String[] str) {
        int i;
        for (i = 0; i < str.length; ++i) {
            str[i] = str[i].trim();
        }
        for (i = 0; i < str.length - 1; ++i) {
            for (int j = i + 1; j < str.length; ++j) {
                if (str[i].compareTo(str[j]) <= 0) continue;
                String t = str[i];
                str[i] = str[j];
                str[j] = t;
            }
        }
    }

    private long getCRC32(byte[] barray) {
        if (barray == null) {
            return 0L;
        }
        CRC32 crcVal = new CRC32();
        crcVal.update(barray);
        return crcVal.getValue();
    }

    static {
        try {
            String traceProp = System.getProperty("debug.cache");
            m_debug = traceProp != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

