; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -cost-model -analyze -mtriple=amdgcn-unknown-amdhsa %s | FileCheck -check-prefixes=ALL,CI %s
; RUN: opt -cost-model -analyze -mtriple=amdgcn-unknown-amdhsa -mcpu=fiji %s | FileCheck -check-prefixes=ALL,GFX89 %s
; RUN: opt -cost-model -analyze -mtriple=amdgcn-unknown-amdhsa -mcpu=gfx900 %s | FileCheck -check-prefixes=ALL,GFX89 %s
; RUN: opt -cost-model -cost-kind=code-size -analyze -mtriple=amdgcn-unknown-amdhsa %s | FileCheck -check-prefixes=ALL-SIZE,CI-SIZE %s
; RUN: opt -cost-model -cost-kind=code-size -analyze -mtriple=amdgcn-unknown-amdhsa -mcpu=fiji %s | FileCheck -check-prefixes=ALL-SIZE,GFX89-SIZE %s
; RUN: opt -cost-model -cost-kind=code-size -analyze -mtriple=amdgcn-unknown-amdhsa -mcpu=gfx900 %s | FileCheck -check-prefixes=ALL-SIZE,GFX89-SIZE %s
; END.

define amdgpu_kernel void @insertelement_i8(i32 %arg) {
; ALL-LABEL: 'insertelement_i8'
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> undef, i8 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_0 = insertelement <3 x i8> undef, i8 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> undef, i8 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_0 = insertelement <5 x i8> undef, i8 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_1 = insertelement <2 x i8> undef, i8 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_1 = insertelement <3 x i8> undef, i8 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_1 = insertelement <4 x i8> undef, i8 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_1 = insertelement <5 x i8> undef, i8 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_a = insertelement <2 x i8> undef, i8 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_a = insertelement <3 x i8> undef, i8 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_a = insertelement <4 x i8> undef, i8 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_a = insertelement <5 x i8> undef, i8 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; ALL-SIZE-LABEL: 'insertelement_i8'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> undef, i8 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_0 = insertelement <3 x i8> undef, i8 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> undef, i8 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_0 = insertelement <5 x i8> undef, i8 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_1 = insertelement <2 x i8> undef, i8 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_1 = insertelement <3 x i8> undef, i8 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_1 = insertelement <4 x i8> undef, i8 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_1 = insertelement <5 x i8> undef, i8 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_a = insertelement <2 x i8> undef, i8 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i8_a = insertelement <3 x i8> undef, i8 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_a = insertelement <4 x i8> undef, i8 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i8_a = insertelement <5 x i8> undef, i8 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2i8_0 = insertelement <2 x i8> undef, i8 42, i32 0
  %v3i8_0 = insertelement <3 x i8> undef, i8 42, i32 0
  %v4i8_0 = insertelement <4 x i8> undef, i8 42, i32 0
  %v5i8_0 = insertelement <5 x i8> undef, i8 42, i32 0
  %v2i8_1 = insertelement <2 x i8> undef, i8 42, i32 1
  %v3i8_1 = insertelement <3 x i8> undef, i8 42, i32 1
  %v4i8_1 = insertelement <4 x i8> undef, i8 42, i32 1
  %v5i8_1 = insertelement <5 x i8> undef, i8 42, i32 1
  %v2i8_a = insertelement <2 x i8> undef, i8 42, i32 %arg
  %v3i8_a = insertelement <3 x i8> undef, i8 42, i32 %arg
  %v4i8_a = insertelement <4 x i8> undef, i8 42, i32 %arg
  %v5i8_a = insertelement <5 x i8> undef, i8 42, i32 %arg
  ret void
}

define amdgpu_kernel void @insertelement_i16(i32 %arg) {
; CI-LABEL: 'insertelement_i16'
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; GFX89-LABEL: 'insertelement_i16'
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; CI-SIZE-LABEL: 'insertelement_i16'
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; GFX89-SIZE-LABEL: 'insertelement_i16'
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2i16_0 = insertelement <2 x i16> undef, i16 42, i32 0
  %v3i16_0 = insertelement <3 x i16> undef, i16 42, i32 0
  %v4i16_0 = insertelement <4 x i16> undef, i16 42, i32 0
  %v5i16_0 = insertelement <5 x i16> undef, i16 42, i32 0
  %v2i16_1 = insertelement <2 x i16> undef, i16 42, i32 1
  %v3i16_1 = insertelement <3 x i16> undef, i16 42, i32 1
  %v4i16_1 = insertelement <4 x i16> undef, i16 42, i32 1
  %v5i16_1 = insertelement <5 x i16> undef, i16 42, i32 1
  %v2i16_a = insertelement <2 x i16> undef, i16 42, i32 %arg
  %v3i16_a = insertelement <3 x i16> undef, i16 42, i32 %arg
  %v4i16_a = insertelement <4 x i16> undef, i16 42, i32 %arg
  %v5i16_a = insertelement <5 x i16> undef, i16 42, i32 %arg
  ret void
}

define amdgpu_kernel void @insertelement_i32(i32 %arg) {
; ALL-LABEL: 'insertelement_i32'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_0 = insertelement <2 x i32> undef, i32 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i32_0 = insertelement <3 x i32> undef, i32 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_0 = insertelement <4 x i32> undef, i32 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i32_0 = insertelement <5 x i32> undef, i32 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_1 = insertelement <2 x i32> undef, i32 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i32_1 = insertelement <3 x i32> undef, i32 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_1 = insertelement <4 x i32> undef, i32 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i32_1 = insertelement <5 x i32> undef, i32 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_a = insertelement <2 x i32> undef, i32 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v3i32_a = insertelement <3 x i32> undef, i32 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_a = insertelement <4 x i32> undef, i32 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v5i32_a = insertelement <5 x i32> undef, i32 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; ALL-SIZE-LABEL: 'insertelement_i32'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_0 = insertelement <2 x i32> undef, i32 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i32_0 = insertelement <3 x i32> undef, i32 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_0 = insertelement <4 x i32> undef, i32 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i32_0 = insertelement <5 x i32> undef, i32 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_1 = insertelement <2 x i32> undef, i32 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i32_1 = insertelement <3 x i32> undef, i32 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_1 = insertelement <4 x i32> undef, i32 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i32_1 = insertelement <5 x i32> undef, i32 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_a = insertelement <2 x i32> undef, i32 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v3i32_a = insertelement <3 x i32> undef, i32 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_a = insertelement <4 x i32> undef, i32 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v5i32_a = insertelement <5 x i32> undef, i32 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2i32_0 = insertelement <2 x i32> undef, i32 42, i32 0
  %v3i32_0 = insertelement <3 x i32> undef, i32 42, i32 0
  %v4i32_0 = insertelement <4 x i32> undef, i32 42, i32 0
  %v5i32_0 = insertelement <5 x i32> undef, i32 42, i32 0
  %v2i32_1 = insertelement <2 x i32> undef, i32 42, i32 1
  %v3i32_1 = insertelement <3 x i32> undef, i32 42, i32 1
  %v4i32_1 = insertelement <4 x i32> undef, i32 42, i32 1
  %v5i32_1 = insertelement <5 x i32> undef, i32 42, i32 1
  %v2i32_a = insertelement <2 x i32> undef, i32 42, i32 %arg
  %v3i32_a = insertelement <3 x i32> undef, i32 42, i32 %arg
  %v4i32_a = insertelement <4 x i32> undef, i32 42, i32 %arg
  %v5i32_a = insertelement <5 x i32> undef, i32 42, i32 %arg
  ret void
}

define amdgpu_kernel void @insertelement_i64(i32 %arg) {
; ALL-LABEL: 'insertelement_i64'
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_0 = insertelement <2 x i64> undef, i64 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i64_0 = insertelement <3 x i64> undef, i64 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_0 = insertelement <4 x i64> undef, i64 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i64_0 = insertelement <5 x i64> undef, i64 42, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_1 = insertelement <2 x i64> undef, i64 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i64_1 = insertelement <3 x i64> undef, i64 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_1 = insertelement <4 x i64> undef, i64 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i64_1 = insertelement <5 x i64> undef, i64 42, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_a = insertelement <2 x i64> undef, i64 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v3i64_a = insertelement <3 x i64> undef, i64 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_a = insertelement <4 x i64> undef, i64 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v5i64_a = insertelement <5 x i64> undef, i64 42, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret void
;
; ALL-SIZE-LABEL: 'insertelement_i64'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_0 = insertelement <2 x i64> undef, i64 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i64_0 = insertelement <3 x i64> undef, i64 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_0 = insertelement <4 x i64> undef, i64 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i64_0 = insertelement <5 x i64> undef, i64 42, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_1 = insertelement <2 x i64> undef, i64 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v3i64_1 = insertelement <3 x i64> undef, i64 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_1 = insertelement <4 x i64> undef, i64 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v5i64_1 = insertelement <5 x i64> undef, i64 42, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_a = insertelement <2 x i64> undef, i64 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v3i64_a = insertelement <3 x i64> undef, i64 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_a = insertelement <4 x i64> undef, i64 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v5i64_a = insertelement <5 x i64> undef, i64 42, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2i64_0 = insertelement <2 x i64> undef, i64 42, i32 0
  %v3i64_0 = insertelement <3 x i64> undef, i64 42, i32 0
  %v4i64_0 = insertelement <4 x i64> undef, i64 42, i32 0
  %v5i64_0 = insertelement <5 x i64> undef, i64 42, i32 0
  %v2i64_1 = insertelement <2 x i64> undef, i64 42, i32 1
  %v3i64_1 = insertelement <3 x i64> undef, i64 42, i32 1
  %v4i64_1 = insertelement <4 x i64> undef, i64 42, i32 1
  %v5i64_1 = insertelement <5 x i64> undef, i64 42, i32 1
  %v2i64_a = insertelement <2 x i64> undef, i64 42, i32 %arg
  %v3i64_a = insertelement <3 x i64> undef, i64 42, i32 %arg
  %v4i64_a = insertelement <4 x i64> undef, i64 42, i32 %arg
  %v5i64_a = insertelement <5 x i64> undef, i64 42, i32 %arg
  ret void
}

define i32 @insert_double_poison(i32 %arg) {
; ALL-LABEL: 'insert_double_poison'
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64_a = insertelement <2 x double> poison, double undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_0 = insertelement <2 x double> poison, double undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_1 = insertelement <2 x double> poison, double undef, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64_a = insertelement <4 x double> poison, double undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_0 = insertelement <4 x double> poison, double undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_3 = insertelement <4 x double> poison, double undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f64_a = insertelement <8 x double> poison, double undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_0 = insertelement <8 x double> poison, double undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_3 = insertelement <8 x double> poison, double undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_4 = insertelement <8 x double> poison, double undef, i32 4
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_7 = insertelement <8 x double> poison, double undef, i32 7
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 undef
;
; ALL-SIZE-LABEL: 'insert_double_poison'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64_a = insertelement <2 x double> poison, double undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_0 = insertelement <2 x double> poison, double undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_1 = insertelement <2 x double> poison, double undef, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64_a = insertelement <4 x double> poison, double undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_0 = insertelement <4 x double> poison, double undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_3 = insertelement <4 x double> poison, double undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f64_a = insertelement <8 x double> poison, double undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_0 = insertelement <8 x double> poison, double undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_3 = insertelement <8 x double> poison, double undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_4 = insertelement <8 x double> poison, double undef, i32 4
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_7 = insertelement <8 x double> poison, double undef, i32 7
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %v2f64_a = insertelement <2 x double> poison, double undef, i32 %arg
  %v2f64_0 = insertelement <2 x double> poison, double undef, i32 0
  %v2f64_1 = insertelement <2 x double> poison, double undef, i32 1

  %v4f64_a = insertelement <4 x double> poison, double undef, i32 %arg
  %v4f64_0 = insertelement <4 x double> poison, double undef, i32 0
  %v4f64_3 = insertelement <4 x double> poison, double undef, i32 3

  %v8f64_a = insertelement <8 x double> poison, double undef, i32 %arg
  %v8f64_0 = insertelement <8 x double> poison, double undef, i32 0
  %v8f64_3 = insertelement <8 x double> poison, double undef, i32 3
  %v8f64_4 = insertelement <8 x double> poison, double undef, i32 4
  %v8f64_7 = insertelement <8 x double> poison, double undef, i32 7

  ret i32 undef
}

define i32 @insert_float_poison(i32 %arg) {
; ALL-LABEL: 'insert_float_poison'
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32_a = insertelement <2 x float> poison, float undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_0 = insertelement <2 x float> poison, float undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_1 = insertelement <2 x float> poison, float undef, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32_a = insertelement <4 x float> poison, float undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_0 = insertelement <4 x float> poison, float undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_3 = insertelement <4 x float> poison, float undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32_a = insertelement <8 x float> poison, float undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_0 = insertelement <8 x float> poison, float undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_3 = insertelement <8 x float> poison, float undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_4 = insertelement <8 x float> poison, float undef, i32 4
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_7 = insertelement <8 x float> poison, float undef, i32 7
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f32_a = insertelement <16 x float> poison, float undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_0 = insertelement <16 x float> poison, float undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_3 = insertelement <16 x float> poison, float undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_8 = insertelement <16 x float> poison, float undef, i32 8
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_15 = insertelement <16 x float> poison, float undef, i32 15
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 undef
;
; ALL-SIZE-LABEL: 'insert_float_poison'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32_a = insertelement <2 x float> poison, float undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_0 = insertelement <2 x float> poison, float undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_1 = insertelement <2 x float> poison, float undef, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32_a = insertelement <4 x float> poison, float undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_0 = insertelement <4 x float> poison, float undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_3 = insertelement <4 x float> poison, float undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32_a = insertelement <8 x float> poison, float undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_0 = insertelement <8 x float> poison, float undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_3 = insertelement <8 x float> poison, float undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_4 = insertelement <8 x float> poison, float undef, i32 4
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_7 = insertelement <8 x float> poison, float undef, i32 7
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f32_a = insertelement <16 x float> poison, float undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_0 = insertelement <16 x float> poison, float undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_3 = insertelement <16 x float> poison, float undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_8 = insertelement <16 x float> poison, float undef, i32 8
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_15 = insertelement <16 x float> poison, float undef, i32 15
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %v2f32_a = insertelement <2 x float> poison, float undef, i32 %arg
  %v2f32_0 = insertelement <2 x float> poison, float undef, i32 0
  %v2f32_1 = insertelement <2 x float> poison, float undef, i32 1

  %v4f32_a = insertelement <4 x float> poison, float undef, i32 %arg
  %v4f32_0 = insertelement <4 x float> poison, float undef, i32 0
  %v4f32_3 = insertelement <4 x float> poison, float undef, i32 3

  %v8f32_a = insertelement <8 x float> poison, float undef, i32 %arg
  %v8f32_0 = insertelement <8 x float> poison, float undef, i32 0
  %v8f32_3 = insertelement <8 x float> poison, float undef, i32 3
  %v8f32_4 = insertelement <8 x float> poison, float undef, i32 4
  %v8f32_7 = insertelement <8 x float> poison, float undef, i32 7

  %v16f32_a  = insertelement <16 x float> poison, float undef, i32 %arg
  %v16f32_0  = insertelement <16 x float> poison, float undef, i32 0
  %v16f32_3  = insertelement <16 x float> poison, float undef, i32 3
  %v16f32_8  = insertelement <16 x float> poison, float undef, i32 8
  %v16f32_15 = insertelement <16 x float> poison, float undef, i32 15

  ret i32 undef
}

define i32 @insert_i64_poison(i32 %arg) {
; ALL-LABEL: 'insert_i64_poison'
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_a = insertelement <2 x i64> poison, i64 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_0 = insertelement <2 x i64> poison, i64 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_1 = insertelement <2 x i64> poison, i64 undef, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_a = insertelement <4 x i64> poison, i64 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_0 = insertelement <4 x i64> poison, i64 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_3 = insertelement <4 x i64> poison, i64 undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i64_a = insertelement <8 x i64> poison, i64 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i64_0 = insertelement <8 x i64> poison, i64 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i64_3 = insertelement <8 x i64> poison, i64 undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i64_4 = insertelement <8 x i64> poison, i64 undef, i32 4
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i64_7 = insertelement <8 x i64> poison, i64 undef, i32 7
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 undef
;
; ALL-SIZE-LABEL: 'insert_i64_poison'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_a = insertelement <2 x i64> poison, i64 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_0 = insertelement <2 x i64> poison, i64 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i64_1 = insertelement <2 x i64> poison, i64 undef, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_a = insertelement <4 x i64> poison, i64 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_0 = insertelement <4 x i64> poison, i64 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i64_3 = insertelement <4 x i64> poison, i64 undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i64_a = insertelement <8 x i64> poison, i64 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i64_0 = insertelement <8 x i64> poison, i64 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i64_3 = insertelement <8 x i64> poison, i64 undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i64_4 = insertelement <8 x i64> poison, i64 undef, i32 4
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i64_7 = insertelement <8 x i64> poison, i64 undef, i32 7
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %v2i64_a = insertelement <2 x i64> poison, i64 undef, i32 %arg
  %v2i64_0 = insertelement <2 x i64> poison, i64 undef, i32 0
  %v2i64_1 = insertelement <2 x i64> poison, i64 undef, i32 1

  %v4i64_a = insertelement <4 x i64> poison, i64 undef, i32 %arg
  %v4i64_0 = insertelement <4 x i64> poison, i64 undef, i32 0
  %v4i64_3 = insertelement <4 x i64> poison, i64 undef, i32 3

  %v8i64_a = insertelement <8 x i64> poison, i64 undef, i32 %arg
  %v8i64_0 = insertelement <8 x i64> poison, i64 undef, i32 0
  %v8i64_3 = insertelement <8 x i64> poison, i64 undef, i32 3
  %v8i64_4 = insertelement <8 x i64> poison, i64 undef, i32 4
  %v8i64_7 = insertelement <8 x i64> poison, i64 undef, i32 7

  ret i32 undef
}

define i32 @insert_i32_poison(i32 %arg) {
; ALL-LABEL: 'insert_i32_poison'
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_a = insertelement <2 x i32> poison, i32 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_0 = insertelement <2 x i32> poison, i32 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_1 = insertelement <2 x i32> poison, i32 undef, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_a = insertelement <4 x i32> poison, i32 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_0 = insertelement <4 x i32> poison, i32 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_3 = insertelement <4 x i32> poison, i32 undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_a = insertelement <8 x i32> poison, i32 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32_0 = insertelement <8 x i32> poison, i32 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32_3 = insertelement <8 x i32> poison, i32 undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32_4 = insertelement <8 x i32> poison, i32 undef, i32 4
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32_7 = insertelement <8 x i32> poison, i32 undef, i32 7
; ALL-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_a = insertelement <16 x i32> poison, i32 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_0 = insertelement <16 x i32> poison, i32 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_3 = insertelement <16 x i32> poison, i32 undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_8 = insertelement <16 x i32> poison, i32 undef, i32 8
; ALL-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_15 = insertelement <16 x i32> poison, i32 undef, i32 15
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 undef
;
; ALL-SIZE-LABEL: 'insert_i32_poison'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_a = insertelement <2 x i32> poison, i32 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_0 = insertelement <2 x i32> poison, i32 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i32_1 = insertelement <2 x i32> poison, i32 undef, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_a = insertelement <4 x i32> poison, i32 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_0 = insertelement <4 x i32> poison, i32 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i32_3 = insertelement <4 x i32> poison, i32 undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_a = insertelement <8 x i32> poison, i32 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32_0 = insertelement <8 x i32> poison, i32 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32_3 = insertelement <8 x i32> poison, i32 undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32_4 = insertelement <8 x i32> poison, i32 undef, i32 4
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i32_7 = insertelement <8 x i32> poison, i32 undef, i32 7
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_a = insertelement <16 x i32> poison, i32 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_0 = insertelement <16 x i32> poison, i32 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_3 = insertelement <16 x i32> poison, i32 undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_8 = insertelement <16 x i32> poison, i32 undef, i32 8
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i32_15 = insertelement <16 x i32> poison, i32 undef, i32 15
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %v2i32_a = insertelement <2 x i32> poison, i32 undef, i32 %arg
  %v2i32_0 = insertelement <2 x i32> poison, i32 undef, i32 0
  %v2i32_1 = insertelement <2 x i32> poison, i32 undef, i32 1

  %v4i32_a = insertelement <4 x i32> poison, i32 undef, i32 %arg
  %v4i32_0 = insertelement <4 x i32> poison, i32 undef, i32 0
  %v4i32_3 = insertelement <4 x i32> poison, i32 undef, i32 3

  %v8i32_a = insertelement <8 x i32> poison, i32 undef, i32 %arg
  %v8i32_0 = insertelement <8 x i32> poison, i32 undef, i32 0
  %v8i32_3 = insertelement <8 x i32> poison, i32 undef, i32 3
  %v8i32_4 = insertelement <8 x i32> poison, i32 undef, i32 4
  %v8i32_7 = insertelement <8 x i32> poison, i32 undef, i32 7

  %v16i32_a  = insertelement <16 x i32> poison, i32 undef, i32 %arg
  %v16i32_0  = insertelement <16 x i32> poison, i32 undef, i32 0
  %v16i32_3  = insertelement <16 x i32> poison, i32 undef, i32 3
  %v16i32_8  = insertelement <16 x i32> poison, i32 undef, i32 8
  %v16i32_15 = insertelement <16 x i32> poison, i32 undef, i32 15

  ret i32 undef
}

define i32 @insert_i16_poison(i32 %arg) {
; CI-LABEL: 'insert_i16_poison'
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> poison, i16 undef, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> poison, i16 undef, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> poison, i16 undef, i32 1
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> poison, i16 undef, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> poison, i16 undef, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_3 = insertelement <4 x i16> poison, i16 undef, i32 3
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_a = insertelement <8 x i16> poison, i16 undef, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = insertelement <8 x i16> poison, i16 undef, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_7 = insertelement <8 x i16> poison, i16 undef, i32 7
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_a = insertelement <16 x i16> poison, i16 undef, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = insertelement <16 x i16> poison, i16 undef, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_7 = insertelement <16 x i16> poison, i16 undef, i32 7
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_8 = insertelement <16 x i16> poison, i16 undef, i32 8
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_15 = insertelement <16 x i16> poison, i16 undef, i32 15
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_a = insertelement <32 x i16> poison, i16 undef, i32 %arg
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = insertelement <32 x i16> poison, i16 undef, i32 0
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_7 = insertelement <32 x i16> poison, i16 undef, i32 7
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_8 = insertelement <32 x i16> poison, i16 undef, i32 8
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_15 = insertelement <32 x i16> poison, i16 undef, i32 15
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_16 = insertelement <32 x i16> poison, i16 undef, i32 16
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_24 = insertelement <32 x i16> poison, i16 undef, i32 24
; CI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_31 = insertelement <32 x i16> poison, i16 undef, i32 31
; CI-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 undef
;
; GFX89-LABEL: 'insert_i16_poison'
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> poison, i16 undef, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i16_0 = insertelement <2 x i16> poison, i16 undef, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> poison, i16 undef, i32 1
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> poison, i16 undef, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i16_0 = insertelement <4 x i16> poison, i16 undef, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_3 = insertelement <4 x i16> poison, i16 undef, i32 3
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_a = insertelement <8 x i16> poison, i16 undef, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i16_0 = insertelement <8 x i16> poison, i16 undef, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_7 = insertelement <8 x i16> poison, i16 undef, i32 7
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_a = insertelement <16 x i16> poison, i16 undef, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i16_0 = insertelement <16 x i16> poison, i16 undef, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_7 = insertelement <16 x i16> poison, i16 undef, i32 7
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_8 = insertelement <16 x i16> poison, i16 undef, i32 8
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_15 = insertelement <16 x i16> poison, i16 undef, i32 15
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_a = insertelement <32 x i16> poison, i16 undef, i32 %arg
; GFX89-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32i16_0 = insertelement <32 x i16> poison, i16 undef, i32 0
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_7 = insertelement <32 x i16> poison, i16 undef, i32 7
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_8 = insertelement <32 x i16> poison, i16 undef, i32 8
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_15 = insertelement <32 x i16> poison, i16 undef, i32 15
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_16 = insertelement <32 x i16> poison, i16 undef, i32 16
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_24 = insertelement <32 x i16> poison, i16 undef, i32 24
; GFX89-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_31 = insertelement <32 x i16> poison, i16 undef, i32 31
; GFX89-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 undef
;
; CI-SIZE-LABEL: 'insert_i16_poison'
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> poison, i16 undef, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> poison, i16 undef, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> poison, i16 undef, i32 1
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> poison, i16 undef, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> poison, i16 undef, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_3 = insertelement <4 x i16> poison, i16 undef, i32 3
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_a = insertelement <8 x i16> poison, i16 undef, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = insertelement <8 x i16> poison, i16 undef, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_7 = insertelement <8 x i16> poison, i16 undef, i32 7
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_a = insertelement <16 x i16> poison, i16 undef, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = insertelement <16 x i16> poison, i16 undef, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_7 = insertelement <16 x i16> poison, i16 undef, i32 7
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_8 = insertelement <16 x i16> poison, i16 undef, i32 8
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_15 = insertelement <16 x i16> poison, i16 undef, i32 15
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_a = insertelement <32 x i16> poison, i16 undef, i32 %arg
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = insertelement <32 x i16> poison, i16 undef, i32 0
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_7 = insertelement <32 x i16> poison, i16 undef, i32 7
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_8 = insertelement <32 x i16> poison, i16 undef, i32 8
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_15 = insertelement <32 x i16> poison, i16 undef, i32 15
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_16 = insertelement <32 x i16> poison, i16 undef, i32 16
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_24 = insertelement <32 x i16> poison, i16 undef, i32 24
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_31 = insertelement <32 x i16> poison, i16 undef, i32 31
; CI-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; GFX89-SIZE-LABEL: 'insert_i16_poison'
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_a = insertelement <2 x i16> poison, i16 undef, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2i16_0 = insertelement <2 x i16> poison, i16 undef, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> poison, i16 undef, i32 1
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_a = insertelement <4 x i16> poison, i16 undef, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4i16_0 = insertelement <4 x i16> poison, i16 undef, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_3 = insertelement <4 x i16> poison, i16 undef, i32 3
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_a = insertelement <8 x i16> poison, i16 undef, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8i16_0 = insertelement <8 x i16> poison, i16 undef, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_7 = insertelement <8 x i16> poison, i16 undef, i32 7
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_a = insertelement <16 x i16> poison, i16 undef, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16i16_0 = insertelement <16 x i16> poison, i16 undef, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_7 = insertelement <16 x i16> poison, i16 undef, i32 7
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_8 = insertelement <16 x i16> poison, i16 undef, i32 8
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_15 = insertelement <16 x i16> poison, i16 undef, i32 15
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_a = insertelement <32 x i16> poison, i16 undef, i32 %arg
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32i16_0 = insertelement <32 x i16> poison, i16 undef, i32 0
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_7 = insertelement <32 x i16> poison, i16 undef, i32 7
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_8 = insertelement <32 x i16> poison, i16 undef, i32 8
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_15 = insertelement <32 x i16> poison, i16 undef, i32 15
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_16 = insertelement <32 x i16> poison, i16 undef, i32 16
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_24 = insertelement <32 x i16> poison, i16 undef, i32 24
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_31 = insertelement <32 x i16> poison, i16 undef, i32 31
; GFX89-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %v2i16_a = insertelement <2 x i16> poison, i16 undef, i32 %arg
  %v2i16_0 = insertelement <2 x i16> poison, i16 undef, i32 0
  %v2i16_1 = insertelement <2 x i16> poison, i16 undef, i32 1

  %v4i16_a = insertelement <4 x i16> poison, i16 undef, i32 %arg
  %v4i16_0 = insertelement <4 x i16> poison, i16 undef, i32 0
  %v4i16_3 = insertelement <4 x i16> poison, i16 undef, i32 3

  %v8i16_a = insertelement <8 x i16> poison, i16 undef, i32 %arg
  %v8i16_0 = insertelement <8 x i16> poison, i16 undef, i32 0
  %v8i16_7 = insertelement <8 x i16> poison, i16 undef, i32 7

  %v16i16_a  = insertelement <16 x i16> poison, i16 undef, i32 %arg
  %v16i16_0  = insertelement <16 x i16> poison, i16 undef, i32 0
  %v16i16_7  = insertelement <16 x i16> poison, i16 undef, i32 7
  %v16i16_8  = insertelement <16 x i16> poison, i16 undef, i32 8
  %v16i16_15 = insertelement <16 x i16> poison, i16 undef, i32 15

  %v32i16_a  = insertelement <32 x i16> poison, i16 undef, i32 %arg
  %v32i16_0  = insertelement <32 x i16> poison, i16 undef, i32 0
  %v32i16_7  = insertelement <32 x i16> poison, i16 undef, i32 7
  %v32i16_8  = insertelement <32 x i16> poison, i16 undef, i32 8
  %v32i16_15 = insertelement <32 x i16> poison, i16 undef, i32 15
  %v32i16_16 = insertelement <32 x i16> poison, i16 undef, i32 16
  %v32i16_24 = insertelement <32 x i16> poison, i16 undef, i32 24
  %v32i16_31 = insertelement <32 x i16> poison, i16 undef, i32 31

  ret i32 undef
}

define i32 @insert_i8_poison(i32 %arg) {
; ALL-LABEL: 'insert_i8_poison'
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_a = insertelement <2 x i8> poison, i8 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> poison, i8 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_3 = insertelement <2 x i8> poison, i8 undef, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_a = insertelement <4 x i8> poison, i8 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> poison, i8 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_3 = insertelement <4 x i8> poison, i8 undef, i32 3
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_a = insertelement <8 x i8> poison, i8 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = insertelement <8 x i8> poison, i8 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_7 = insertelement <8 x i8> poison, i8 undef, i32 7
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_a = insertelement <16 x i8> poison, i8 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = insertelement <16 x i8> poison, i8 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_8 = insertelement <16 x i8> poison, i8 undef, i32 8
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_15 = insertelement <16 x i8> poison, i8 undef, i32 15
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_a = insertelement <32 x i8> poison, i8 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = insertelement <32 x i8> poison, i8 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_7 = insertelement <32 x i8> poison, i8 undef, i32 7
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_8 = insertelement <32 x i8> poison, i8 undef, i32 8
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_15 = insertelement <32 x i8> poison, i8 undef, i32 15
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_24 = insertelement <32 x i8> poison, i8 undef, i32 24
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_31 = insertelement <32 x i8> poison, i8 undef, i32 31
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_a = insertelement <64 x i8> poison, i8 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = insertelement <64 x i8> poison, i8 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_7 = insertelement <64 x i8> poison, i8 undef, i32 7
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_8 = insertelement <64 x i8> poison, i8 undef, i32 8
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_15 = insertelement <64 x i8> poison, i8 undef, i32 15
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_24 = insertelement <64 x i8> poison, i8 undef, i32 24
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_31 = insertelement <64 x i8> poison, i8 undef, i32 31
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_32 = insertelement <64 x i8> poison, i8 undef, i32 32
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_48 = insertelement <64 x i8> poison, i8 undef, i32 48
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_63 = insertelement <64 x i8> poison, i8 undef, i32 63
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 undef
;
; ALL-SIZE-LABEL: 'insert_i8_poison'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_a = insertelement <2 x i8> poison, i8 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> poison, i8 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_3 = insertelement <2 x i8> poison, i8 undef, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_a = insertelement <4 x i8> poison, i8 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> poison, i8 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_3 = insertelement <4 x i8> poison, i8 undef, i32 3
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_a = insertelement <8 x i8> poison, i8 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = insertelement <8 x i8> poison, i8 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_7 = insertelement <8 x i8> poison, i8 undef, i32 7
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_a = insertelement <16 x i8> poison, i8 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = insertelement <16 x i8> poison, i8 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_8 = insertelement <16 x i8> poison, i8 undef, i32 8
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_15 = insertelement <16 x i8> poison, i8 undef, i32 15
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_a = insertelement <32 x i8> poison, i8 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = insertelement <32 x i8> poison, i8 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_7 = insertelement <32 x i8> poison, i8 undef, i32 7
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_8 = insertelement <32 x i8> poison, i8 undef, i32 8
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_15 = insertelement <32 x i8> poison, i8 undef, i32 15
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_24 = insertelement <32 x i8> poison, i8 undef, i32 24
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_31 = insertelement <32 x i8> poison, i8 undef, i32 31
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_a = insertelement <64 x i8> poison, i8 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = insertelement <64 x i8> poison, i8 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_7 = insertelement <64 x i8> poison, i8 undef, i32 7
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_8 = insertelement <64 x i8> poison, i8 undef, i32 8
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_15 = insertelement <64 x i8> poison, i8 undef, i32 15
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_24 = insertelement <64 x i8> poison, i8 undef, i32 24
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_31 = insertelement <64 x i8> poison, i8 undef, i32 31
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_32 = insertelement <64 x i8> poison, i8 undef, i32 32
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_48 = insertelement <64 x i8> poison, i8 undef, i32 48
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_63 = insertelement <64 x i8> poison, i8 undef, i32 63
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %v2i8_a   = insertelement <2 x i8> poison, i8 undef, i32 %arg
  %v2i8_0   = insertelement <2 x i8> poison, i8 undef, i32 0
  %v2i8_3   = insertelement <2 x i8> poison, i8 undef, i32 1

  %v4i8_a   = insertelement <4 x i8> poison, i8 undef, i32 %arg
  %v4i8_0   = insertelement <4 x i8> poison, i8 undef, i32 0
  %v4i8_3   = insertelement <4 x i8> poison, i8 undef, i32 3

  %v8i8_a   = insertelement <8 x i8> poison, i8 undef, i32 %arg
  %v8i8_0   = insertelement <8 x i8> poison, i8 undef, i32 0
  %v8i8_7   = insertelement <8 x i8> poison, i8 undef, i32 7

  %v16i8_a  = insertelement <16 x i8> poison, i8 undef, i32 %arg
  %v16i8_0  = insertelement <16 x i8> poison, i8 undef, i32 0
  %v16i8_8  = insertelement <16 x i8> poison, i8 undef, i32 8
  %v16i8_15 = insertelement <16 x i8> poison, i8 undef, i32 15

  %v32i8_a  = insertelement <32 x i8> poison, i8 undef, i32 %arg
  %v32i8_0  = insertelement <32 x i8> poison, i8 undef, i32 0
  %v32i8_7  = insertelement <32 x i8> poison, i8 undef, i32 7
  %v32i8_8  = insertelement <32 x i8> poison, i8 undef, i32 8
  %v32i8_15 = insertelement <32 x i8> poison, i8 undef, i32 15
  %v32i8_24 = insertelement <32 x i8> poison, i8 undef, i32 24
  %v32i8_31 = insertelement <32 x i8> poison, i8 undef, i32 31

  %v64i8_a  = insertelement <64 x i8> poison, i8 undef, i32 %arg
  %v64i8_0  = insertelement <64 x i8> poison, i8 undef, i32 0
  %v64i8_7  = insertelement <64 x i8> poison, i8 undef, i32 7
  %v64i8_8  = insertelement <64 x i8> poison, i8 undef, i32 8
  %v64i8_15 = insertelement <64 x i8> poison, i8 undef, i32 15
  %v64i8_24 = insertelement <64 x i8> poison, i8 undef, i32 24
  %v64i8_31 = insertelement <64 x i8> poison, i8 undef, i32 31
  %v64i8_32 = insertelement <64 x i8> poison, i8 undef, i32 32
  %v64i8_48 = insertelement <64 x i8> poison, i8 undef, i32 48
  %v64i8_63 = insertelement <64 x i8> poison, i8 undef, i32 63

  ret i32 undef
}

define i32 @insert_i1_poison(i32 %arg) {
; ALL-LABEL: 'insert_i1_poison'
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i1_a = insertelement <2 x i1> poison, i1 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i1_0 = insertelement <2 x i1> poison, i1 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i1_1 = insertelement <2 x i1> poison, i1 undef, i32 1
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i1_a = insertelement <4 x i1> poison, i1 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i1_0 = insertelement <4 x i1> poison, i1 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i1_2 = insertelement <4 x i1> poison, i1 undef, i32 2
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i1_a = insertelement <8 x i1> poison, i1 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i1_0 = insertelement <8 x i1> poison, i1 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i1_4 = insertelement <8 x i1> poison, i1 undef, i32 4
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i1_a = insertelement <16 x i1> poison, i1 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i1_0 = insertelement <16 x i1> poison, i1 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i1_8 = insertelement <16 x i1> poison, i1 undef, i32 8
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i1_15 = insertelement <16 x i1> poison, i1 undef, i32 15
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_a = insertelement <32 x i1> poison, i1 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_0 = insertelement <32 x i1> poison, i1 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_7 = insertelement <32 x i1> poison, i1 undef, i32 7
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_8 = insertelement <32 x i1> poison, i1 undef, i32 8
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_15 = insertelement <32 x i1> poison, i1 undef, i32 15
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_24 = insertelement <32 x i1> poison, i1 undef, i32 24
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_31 = insertelement <32 x i1> poison, i1 undef, i32 31
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_a = insertelement <64 x i1> poison, i1 undef, i32 %arg
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_0 = insertelement <64 x i1> poison, i1 undef, i32 0
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_7 = insertelement <64 x i1> poison, i1 undef, i32 7
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_8 = insertelement <64 x i1> poison, i1 undef, i32 8
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_15 = insertelement <64 x i1> poison, i1 undef, i32 15
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_24 = insertelement <64 x i1> poison, i1 undef, i32 24
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_31 = insertelement <64 x i1> poison, i1 undef, i32 31
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_32 = insertelement <64 x i1> poison, i1 undef, i32 32
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_48 = insertelement <64 x i1> poison, i1 undef, i32 48
; ALL-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_63 = insertelement <64 x i1> poison, i1 undef, i32 63
; ALL-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: ret i32 undef
;
; ALL-SIZE-LABEL: 'insert_i1_poison'
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i1_a = insertelement <2 x i1> poison, i1 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i1_0 = insertelement <2 x i1> poison, i1 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i1_1 = insertelement <2 x i1> poison, i1 undef, i32 1
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i1_a = insertelement <4 x i1> poison, i1 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i1_0 = insertelement <4 x i1> poison, i1 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i1_2 = insertelement <4 x i1> poison, i1 undef, i32 2
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i1_a = insertelement <8 x i1> poison, i1 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i1_0 = insertelement <8 x i1> poison, i1 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i1_4 = insertelement <8 x i1> poison, i1 undef, i32 4
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i1_a = insertelement <16 x i1> poison, i1 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i1_0 = insertelement <16 x i1> poison, i1 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i1_8 = insertelement <16 x i1> poison, i1 undef, i32 8
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i1_15 = insertelement <16 x i1> poison, i1 undef, i32 15
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_a = insertelement <32 x i1> poison, i1 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_0 = insertelement <32 x i1> poison, i1 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_7 = insertelement <32 x i1> poison, i1 undef, i32 7
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_8 = insertelement <32 x i1> poison, i1 undef, i32 8
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_15 = insertelement <32 x i1> poison, i1 undef, i32 15
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_24 = insertelement <32 x i1> poison, i1 undef, i32 24
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i1_31 = insertelement <32 x i1> poison, i1 undef, i32 31
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_a = insertelement <64 x i1> poison, i1 undef, i32 %arg
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_0 = insertelement <64 x i1> poison, i1 undef, i32 0
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_7 = insertelement <64 x i1> poison, i1 undef, i32 7
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_8 = insertelement <64 x i1> poison, i1 undef, i32 8
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_15 = insertelement <64 x i1> poison, i1 undef, i32 15
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_24 = insertelement <64 x i1> poison, i1 undef, i32 24
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_31 = insertelement <64 x i1> poison, i1 undef, i32 31
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_32 = insertelement <64 x i1> poison, i1 undef, i32 32
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_48 = insertelement <64 x i1> poison, i1 undef, i32 48
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i1_63 = insertelement <64 x i1> poison, i1 undef, i32 63
; ALL-SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %v2i1_a  = insertelement <2 x i1> poison, i1 undef, i32 %arg
  %v2i1_0  = insertelement <2 x i1> poison, i1 undef, i32 0
  %v2i1_1  = insertelement <2 x i1> poison, i1 undef, i32 1

  %v4i1_a  = insertelement <4 x i1> poison, i1 undef, i32 %arg
  %v4i1_0  = insertelement <4 x i1> poison, i1 undef, i32 0
  %v4i1_2  = insertelement <4 x i1> poison, i1 undef, i32 2

  %v8i1_a  = insertelement <8 x i1> poison, i1 undef, i32 %arg
  %v8i1_0  = insertelement <8 x i1> poison, i1 undef, i32 0
  %v8i1_4  = insertelement <8 x i1> poison, i1 undef, i32 4

  %v16i1_a  = insertelement <16 x i1> poison, i1 undef, i32 %arg
  %v16i1_0  = insertelement <16 x i1> poison, i1 undef, i32 0
  %v16i1_8  = insertelement <16 x i1> poison, i1 undef, i32 8
  %v16i1_15 = insertelement <16 x i1> poison, i1 undef, i32 15

  %v32i1_a  = insertelement <32 x i1> poison, i1 undef, i32 %arg
  %v32i1_0  = insertelement <32 x i1> poison, i1 undef, i32 0
  %v32i1_7  = insertelement <32 x i1> poison, i1 undef, i32 7
  %v32i1_8  = insertelement <32 x i1> poison, i1 undef, i32 8
  %v32i1_15 = insertelement <32 x i1> poison, i1 undef, i32 15
  %v32i1_24 = insertelement <32 x i1> poison, i1 undef, i32 24
  %v32i1_31 = insertelement <32 x i1> poison, i1 undef, i32 31

  %v64i1_a  = insertelement <64 x i1> poison, i1 undef, i32 %arg
  %v64i1_0  = insertelement <64 x i1> poison, i1 undef, i32 0
  %v64i1_7  = insertelement <64 x i1> poison, i1 undef, i32 7
  %v64i1_8  = insertelement <64 x i1> poison, i1 undef, i32 8
  %v64i1_15 = insertelement <64 x i1> poison, i1 undef, i32 15
  %v64i1_24 = insertelement <64 x i1> poison, i1 undef, i32 24
  %v64i1_31 = insertelement <64 x i1> poison, i1 undef, i32 31
  %v64i1_32 = insertelement <64 x i1> poison, i1 undef, i32 32
  %v64i1_48 = insertelement <64 x i1> poison, i1 undef, i32 48
  %v64i1_63 = insertelement <64 x i1> poison, i1 undef, i32 63

  ret i32 undef
}
