; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i32_stride8_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride8_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm3 = mem[0],zero
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE-NEXT:    movsd {{.*#+}} xmm3 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm4 = mem[0],zero
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm3[0]
; SSE-NEXT:    movhlps {{.*#+}} xmm1 = xmm0[1],xmm1[1]
; SSE-NEXT:    movhlps {{.*#+}} xmm3 = xmm2[1],xmm3[1]
; SSE-NEXT:    movaps %xmm3, 48(%rax)
; SSE-NEXT:    movaps %xmm1, 32(%rax)
; SSE-NEXT:    movaps %xmm5, 16(%rax)
; SSE-NEXT:    movaps %xmm4, (%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride8_vf2:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm4 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i32_stride8_vf2:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX2-ONLY-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-ONLY-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-ONLY-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX2-ONLY-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovsd {{.*#+}} xmm4 = mem[0],zero
; AVX2-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm1
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[1,3],ymm1[1,3],ymm0[5,7],ymm1[5,7]
; AVX2-ONLY-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm2, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride8_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm4 = mem[0],zero
; AVX512-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm4[0],xmm3[0]
; AVX512-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX512-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    vinsertf64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512-NEXT:    vmovaps {{.*#+}} zmm1 = [0,2,4,6,8,10,12,14,1,3,5,7,9,11,13,15]
; AVX512-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm0, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <2 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <2 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <2 x i32>, ptr %in.vecptr6, align 64
  %in.vec7 = load <2 x i32>, ptr %in.vecptr7, align 64
  %1 = shufflevector <2 x i32> %in.vec0, <2 x i32> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i32> %in.vec2, <2 x i32> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <2 x i32> %in.vec4, <2 x i32> %in.vec5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <2 x i32> %in.vec6, <2 x i32> %in.vec7, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %5 = shufflevector <4 x i32> %1, <4 x i32> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %6 = shufflevector <4 x i32> %3, <4 x i32> %4, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %7 = shufflevector <8 x i32> %5, <8 x i32> %6, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %interleaved.vec = shufflevector <16 x i32> %7, <16 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  store <16 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride8_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride8_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm5
; SSE-NEXT:    movaps (%rdx), %xmm1
; SSE-NEXT:    movaps (%rcx), %xmm6
; SSE-NEXT:    movaps (%r8), %xmm2
; SSE-NEXT:    movaps (%r9), %xmm7
; SSE-NEXT:    movaps (%r11), %xmm8
; SSE-NEXT:    movaps (%r10), %xmm9
; SSE-NEXT:    movaps %xmm1, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE-NEXT:    movaps %xmm4, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm10[0]
; SSE-NEXT:    movaps %xmm8, %xmm11
; SSE-NEXT:    unpcklps {{.*#+}} xmm11 = xmm11[0],xmm9[0],xmm11[1],xmm9[1]
; SSE-NEXT:    movaps %xmm2, %xmm12
; SSE-NEXT:    unpcklps {{.*#+}} xmm12 = xmm12[0],xmm7[0],xmm12[1],xmm7[1]
; SSE-NEXT:    movaps %xmm12, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm11[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm11[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm10[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm6[2],xmm1[3],xmm6[3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm5[2],xmm0[3],xmm5[3]
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm9[2],xmm8[3],xmm9[3]
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm7[2],xmm2[3],xmm7[3]
; SSE-NEXT:    movaps %xmm2, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm8[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm8[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps %xmm2, 112(%rax)
; SSE-NEXT:    movaps %xmm6, 80(%rax)
; SSE-NEXT:    movaps %xmm5, 64(%rax)
; SSE-NEXT:    movaps %xmm4, 32(%rax)
; SSE-NEXT:    movaps %xmm12, 48(%rax)
; SSE-NEXT:    movaps %xmm13, 16(%rax)
; SSE-NEXT:    movaps %xmm3, (%rax)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride8_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm2
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm3
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm4
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovaps (%r11), %xmm6
; AVX1-ONLY-NEXT:    vmovaps (%r10), %xmm7
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm8
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm9
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm7, %ymm6
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm9[0],ymm6[0],ymm9[2],ymm6[2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm5 = ymm4[0],ymm8[0],ymm4[1],ymm8[1],ymm4[4],ymm8[4],ymm4[5],ymm8[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[0,1],ymm7[2,0],ymm5[4,5],ymm7[6,4]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm3[0],xmm2[0]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm6[0],ymm9[0],ymm6[1],ymm9[1],ymm6[4],ymm9[4],ymm6[5],ymm9[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm8[1,0],ymm4[1,0],ymm8[5,4],ymm4[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm10[2,0],ymm7[2,3],ymm10[6,4],ymm7[6,7]
; AVX1-ONLY-NEXT:    vinsertps {{.*#+}} xmm10 = xmm0[1],xmm1[1],zero,zero
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0,1],xmm11[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm9[1],ymm6[1],ymm9[3],ymm6[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm4[2],ymm8[2],ymm4[3],ymm8[3],ymm4[6],ymm8[6],ymm4[7],ymm8[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm11[0,1],ymm10[2,0],ymm11[4,5],ymm10[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm11 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vinsertps {{.*#+}} xmm12 = zero,zero,xmm2[2],xmm3[2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0,1],xmm12[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm6[2],ymm9[2],ymm6[3],ymm9[3],ymm6[6],ymm9[6],ymm6[7],ymm9[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm4 = ymm8[3,0],ymm4[3,0],ymm8[7,4],ymm4[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm4 = ymm4[2,0],ymm6[2,3],ymm4[6,4],ymm6[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm1[3,0],xmm0[3,0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, (%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i32_stride8_vf4:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm0
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm5
; AVX2-ONLY-NEXT:    vmovaps (%r11), %xmm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm8
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%r9), %ymm5, %ymm5
; AVX2-ONLY-NEXT:    vinsertf128 $1, (%r10), %ymm6, %ymm7
; AVX2-ONLY-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [17179869184,17179869184,17179869184,17179869184]
; AVX2-ONLY-NEXT:    vpermps %ymm7, %ymm6, %ymm9
; AVX2-ONLY-NEXT:    vpermps %ymm5, %ymm6, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm9[6,7]
; AVX2-ONLY-NEXT:    vmovaps {{.*#+}} xmm9 = <u,u,0,4>
; AVX2-ONLY-NEXT:    vpermps %ymm8, %ymm9, %ymm9
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm9 = xmm10[0,1],xmm9[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd {{.*#+}} ymm9 = [21474836481,21474836481,21474836481,21474836481]
; AVX2-ONLY-NEXT:    vpermps %ymm7, %ymm9, %ymm10
; AVX2-ONLY-NEXT:    vpermps %ymm5, %ymm9, %ymm9
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vmovaps {{.*#+}} xmm10 = <1,5,u,u>
; AVX2-ONLY-NEXT:    vpermps %ymm2, %ymm10, %ymm10
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0,1],xmm11[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2,3],ymm9[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd {{.*#+}} ymm10 = [25769803778,25769803778,25769803778,25769803778]
; AVX2-ONLY-NEXT:    vpermps %ymm7, %ymm10, %ymm11
; AVX2-ONLY-NEXT:    vpermps %ymm5, %ymm10, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vmovaps {{.*#+}} xmm11 = <u,u,2,6>
; AVX2-ONLY-NEXT:    vpermps %ymm8, %ymm11, %ymm8
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm8[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm10[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastsd {{.*#+}} ymm4 = [30064771075,30064771075,30064771075,30064771075]
; AVX2-ONLY-NEXT:    vpermps %ymm7, %ymm4, %ymm7
; AVX2-ONLY-NEXT:    vpermps %ymm5, %ymm4, %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vmovaps {{.*#+}} xmm5 = <3,7,u,u>
; AVX2-ONLY-NEXT:    vpermps %ymm2, %ymm5, %ymm2
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm2[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 64(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 32(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, (%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride8_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vmovdqa (%r11), %xmm3
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vinserti128 $1, (%r10), %ymm3, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%r9), %ymm2, %ymm2
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [0,4,8,12,16,20,24,28,1,5,9,13,17,21,25,29]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [2,6,10,14,18,22,26,30,3,7,11,15,19,23,27,31]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm2, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <4 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <4 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <4 x i32>, ptr %in.vecptr6, align 64
  %in.vec7 = load <4 x i32>, ptr %in.vecptr7, align 64
  %1 = shufflevector <4 x i32> %in.vec0, <4 x i32> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %in.vec2, <4 x i32> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <4 x i32> %in.vec4, <4 x i32> %in.vec5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <4 x i32> %in.vec6, <4 x i32> %in.vec7, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = shufflevector <8 x i32> %1, <8 x i32> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %6 = shufflevector <8 x i32> %3, <8 x i32> %4, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %7 = shufflevector <16 x i32> %5, <16 x i32> %6, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %interleaved.vec = shufflevector <32 x i32> %7, <32 x i32> poison, <32 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  store <32 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride8_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride8_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $56, %rsp
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm3
; SSE-NEXT:    movaps (%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm9
; SSE-NEXT:    movaps (%rcx), %xmm8
; SSE-NEXT:    movaps (%r8), %xmm5
; SSE-NEXT:    movaps 16(%r8), %xmm7
; SSE-NEXT:    movaps (%r9), %xmm1
; SSE-NEXT:    movaps (%r10), %xmm14
; SSE-NEXT:    movaps 16(%r10), %xmm15
; SSE-NEXT:    movaps (%rax), %xmm4
; SSE-NEXT:    movaps 16(%rax), %xmm10
; SSE-NEXT:    movaps %xmm4, %xmm2
; SSE-NEXT:    movaps %xmm4, %xmm11
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm14[0]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm9[0]
; SSE-NEXT:    movaps %xmm3, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm11[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0,2]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm8[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm0[2],xmm3[3],xmm0[3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,2]
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm0
; SSE-NEXT:    movaps %xmm10, %xmm4
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm15[0]
; SSE-NEXT:    movaps 16(%r9), %xmm10
; SSE-NEXT:    movaps %xmm7, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm10[0],xmm13[1],xmm10[1]
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rdx), %xmm0
; SSE-NEXT:    movaps 16(%rcx), %xmm12
; SSE-NEXT:    movaps %xmm12, %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm0[0]
; SSE-NEXT:    movaps 16(%rdi), %xmm2
; SSE-NEXT:    movaps 16(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm11[2,0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm10[2],xmm7[3],xmm10[3]
; SSE-NEXT:    movaps %xmm15, %xmm10
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm4[1]
; SSE-NEXT:    movaps %xmm7, %xmm11
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm10[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm12[1]
; SSE-NEXT:    movaps %xmm2, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm1[0,2]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm14[1,1]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm1[2,0]
; SSE-NEXT:    movaps %xmm5, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm9[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,3],xmm1[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[3,3],xmm4[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm6 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[2,3],xmm14[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[3,3],xmm5[3,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm4 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,3],xmm9[0,2]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm15[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,3],xmm1[2,0]
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,3],xmm1[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[3,3],xmm9[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm15[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm12[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,3],xmm0[0,2]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm2, 224(%rax)
; SSE-NEXT:    movaps %xmm7, 240(%rax)
; SSE-NEXT:    movaps %xmm3, 160(%rax)
; SSE-NEXT:    movaps %xmm13, 176(%rax)
; SSE-NEXT:    movaps %xmm4, 96(%rax)
; SSE-NEXT:    movaps %xmm6, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps %xmm8, 48(%rax)
; SSE-NEXT:    movaps %xmm10, 192(%rax)
; SSE-NEXT:    movaps %xmm11, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    addq $56, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride8_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm3
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm5
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm4
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %ymm6
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm7
; AVX1-ONLY-NEXT:    vmovaps (%r9), %ymm8
; AVX1-ONLY-NEXT:    vmovaps (%r10), %ymm9
; AVX1-ONLY-NEXT:    vmovaps (%rax), %ymm10
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm9[0],ymm10[0],ymm9[1],ymm10[1],ymm9[4],ymm10[4],ymm9[5],ymm10[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm8[1,0],ymm7[1,0],ymm8[5,4],ymm7[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[2,0],ymm0[2,3],ymm1[6,4],ymm0[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm4[0],ymm6[0],ymm4[1],ymm6[1],ymm4[4],ymm6[4],ymm4[5],ymm6[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm5[1,0],ymm3[1,0],ymm5[5,4],ymm3[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm9[2],ymm10[2],ymm9[3],ymm10[3],ymm9[6],ymm10[6],ymm9[7],ymm10[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm8[3,0],ymm7[3,0],ymm8[7,4],ymm7[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[2,0],ymm1[2,3],ymm2[6,4],ymm1[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm4[2],ymm6[2],ymm4[3],ymm6[3],ymm4[6],ymm6[6],ymm4[7],ymm6[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm11 = ymm5[3,0],ymm3[3,0],ymm5[7,4],ymm3[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm11 = ymm11[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm11, %xmm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm11[0,1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm10[1],ymm9[1],ymm10[3],ymm9[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm7[2],ymm8[2],ymm7[3],ymm8[3],ymm7[6],ymm8[6],ymm7[7],ymm8[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm11[0,1],ymm2[2,0],ymm11[4,5],ymm2[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm11 = ymm3[2],ymm5[2],ymm3[3],ymm5[3],ymm3[6],ymm5[6],ymm3[7],ymm5[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm11, %xmm11
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm6[1],ymm4[1],ymm6[3],ymm4[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm12 = ymm12[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm12, %xmm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0,1],xmm12[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm10[0],ymm9[0],ymm10[2],ymm9[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm7[0],ymm8[0],ymm7[1],ymm8[1],ymm7[4],ymm8[4],ymm7[5],ymm8[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2,0],ymm7[4,5],ymm9[6,4]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm3[0],ymm5[0],ymm3[1],ymm5[1],ymm3[4],ymm5[4],ymm3[5],ymm5[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm6[0],ymm4[0],ymm6[2],ymm4[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm4
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm5
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm10
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm11
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm6
; AVX1-ONLY-NEXT:    vmovaps (%r10), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm13
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm14
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm15 = xmm14[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0],xmm13[1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0,1,2,3,4,5],ymm8[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm15 = xmm11[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0],xmm10[1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0,1],xmm9[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0,1,2,3],ymm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm15 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm15[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm15 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm11[2],xmm10[2],xmm11[3],xmm10[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm15 = xmm0[1],xmm15[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm15[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm11[0],xmm10[0],xmm11[1],xmm10[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm10[0],xmm9[0]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm14[0],xmm13[0],xmm14[1],xmm13[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm11 = xmm12[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],ymm11[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm4[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm6[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm7[0,1,2],xmm4[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, (%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 32(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i32_stride8_vf8:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa (%rsi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa (%rcx), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa (%r8), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa (%r9), %ymm6
; AVX2-ONLY-NEXT:    vmovdqa (%r10), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa (%rax), %ymm9
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm7 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX2-ONLY-NEXT:    vpbroadcastd 20(%r8), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm6[5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm10 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 20(%rcx), %ymm11
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm10 = xmm10[0,1,2],xmm11[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm11 = ymm1[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm11[0],ymm2[1],ymm11[2,3,4],ymm2[5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm11, %xmm11
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm10 = xmm11[0,1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm10[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 28(%r10), %ymm10
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm9 = ymm10[2],ymm9[2],ymm10[3],ymm9[3],ymm10[6],ymm9[6],ymm10[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm10 = ymm5[2],ymm6[2],ymm5[3],ymm6[3],ymm5[6],ymm6[6],ymm5[7],ymm6[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm9 = ymm10[1],ymm9[1],ymm10[3],ymm9[3]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm11 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm11, %xmm12
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm1 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm12[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm9[4,5,6,7]
; AVX2-ONLY-NEXT:    vpbroadcastd 24(%rax), %ymm9
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5,6],ymm9[7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm10[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm9 = ymm11[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm9[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm5 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm5[0],ymm7[0],ymm5[2],ymm7[2]
; AVX2-ONLY-NEXT:    vpbroadcastd 16(%rsi), %xmm6
; AVX2-ONLY-NEXT:    vpbroadcastd 16(%rdi), %ymm7
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm6[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqa (%rcx), %xmm4
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %xmm5
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm6 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vmovdqa (%rsi), %xmm9
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %xmm10
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm7 = xmm10[1,1,1,1]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0],xmm9[1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm8 = xmm7[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vmovdqa (%rax), %xmm6
; AVX2-ONLY-NEXT:    vmovdqa (%r10), %xmm7
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm11 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX2-ONLY-NEXT:    vmovdqa (%r9), %xmm12
; AVX2-ONLY-NEXT:    vmovdqa (%r8), %xmm13
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[1,1,1,1]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm14 = xmm14[0],xmm12[1],xmm14[2,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm14[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm11 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm14 = xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm15 = xmm14[2,3,2,3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm15[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm15 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} xmm0 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} xmm15 = xmm0[1],xmm15[1]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm11 = ymm15[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm9 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX2-ONLY-NEXT:    vpbroadcastd %xmm4, %xmm10
; AVX2-ONLY-NEXT:    vpbroadcastd %xmm5, %xmm15
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm15[0],xmm10[0],xmm15[1],xmm10[1]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm9 = xmm9[0,1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm10 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX2-ONLY-NEXT:    vpbroadcastd %xmm6, %xmm12
; AVX2-ONLY-NEXT:    vpbroadcastd %xmm7, %xmm13
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm12, %ymm0, %ymm12
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm9 = ymm9[0,1,2,3],ymm10[4,5,6,7]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm4[2,3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} xmm4 = xmm6[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm7[0,1,2],xmm4[3]
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm14, %ymm0, %ymm5
; AVX2-ONLY-NEXT:    vinserti128 $1, %xmm4, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm5[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm9, (%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm11, 96(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm8, 32(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm3, 128(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm2, 192(%rax)
; AVX2-ONLY-NEXT:    vmovdqa %ymm1, 224(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i32_stride8_vf8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512F-NEXT:    vmovdqa (%r8), %ymm2
; AVX512F-NEXT:    vmovdqa (%r11), %ymm3
; AVX512F-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512F-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512F-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512F-NEXT:    vinserti64x4 $1, (%r10), %zmm3, %zmm3
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,0,8,16,24,u,u,u,u,1,9,17,25>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <0,8,16,24,u,u,u,u,1,9,17,25,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm5
; AVX512F-NEXT:    movb $-52, %cl
; AVX512F-NEXT:    kmovw %ecx, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,2,10,18,26,u,u,u,u,3,11,19,27>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <2,10,18,26,u,u,u,u,3,11,19,27,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,4,12,20,28,u,u,u,u,5,13,21,29>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <4,12,20,28,u,u,u,u,5,13,21,29,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,6,14,22,30,u,u,u,u,7,15,23,31>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <6,14,22,30,u,u,u,u,7,15,23,31,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm7, 128(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm6, 64(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride8_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512BW-NEXT:    vmovdqa (%r11), %ymm3
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512BW-NEXT:    vinserti64x4 $1, (%r10), %zmm3, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,0,8,16,24,u,u,u,u,1,9,17,25>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <0,8,16,24,u,u,u,u,1,9,17,25,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm5
; AVX512BW-NEXT:    movb $-52, %cl
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm5 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,2,10,18,26,u,u,u,u,3,11,19,27>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <2,10,18,26,u,u,u,u,3,11,19,27,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,4,12,20,28,u,u,u,u,5,13,21,29>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <4,12,20,28,u,u,u,u,5,13,21,29,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,6,14,22,30,u,u,u,u,7,15,23,31>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <6,14,22,30,u,u,u,u,7,15,23,31,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <8 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <8 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <8 x i32>, ptr %in.vecptr6, align 64
  %in.vec7 = load <8 x i32>, ptr %in.vecptr7, align 64
  %1 = shufflevector <8 x i32> %in.vec0, <8 x i32> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i32> %in.vec2, <8 x i32> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <8 x i32> %in.vec4, <8 x i32> %in.vec5, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <8 x i32> %in.vec6, <8 x i32> %in.vec7, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %5 = shufflevector <16 x i32> %1, <16 x i32> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %6 = shufflevector <16 x i32> %3, <16 x i32> %4, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %7 = shufflevector <32 x i32> %5, <32 x i32> %6, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %interleaved.vec = shufflevector <64 x i32> %7, <64 x i32> poison, <64 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 48, i32 56, i32 1, i32 9, i32 17, i32 25, i32 33, i32 41, i32 49, i32 57, i32 2, i32 10, i32 18, i32 26, i32 34, i32 42, i32 50, i32 58, i32 3, i32 11, i32 19, i32 27, i32 35, i32 43, i32 51, i32 59, i32 4, i32 12, i32 20, i32 28, i32 36, i32 44, i32 52, i32 60, i32 5, i32 13, i32 21, i32 29, i32 37, i32 45, i32 53, i32 61, i32 6, i32 14, i32 22, i32 30, i32 38, i32 46, i32 54, i32 62, i32 7, i32 15, i32 23, i32 31, i32 39, i32 47, i32 55, i32 63>
  store <64 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride8_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride8_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $216, %rsp
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm9
; SSE-NEXT:    movaps 16(%rdi), %xmm10
; SSE-NEXT:    movaps (%rsi), %xmm4
; SSE-NEXT:    movaps 16(%rsi), %xmm1
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps 16(%rdx), %xmm0
; SSE-NEXT:    movaps (%rcx), %xmm3
; SSE-NEXT:    movaps (%r8), %xmm11
; SSE-NEXT:    movaps (%r9), %xmm6
; SSE-NEXT:    movaps (%r10), %xmm5
; SSE-NEXT:    movaps (%rax), %xmm7
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    movaps %xmm9, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm4[0],xmm13[1],xmm4[1]
; SSE-NEXT:    movaps %xmm13, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm5[0]
; SSE-NEXT:    movaps %xmm11, %xmm14
; SSE-NEXT:    unpcklps {{.*#+}} xmm14 = xmm14[0],xmm6[0],xmm14[1],xmm6[1]
; SSE-NEXT:    movaps %xmm14, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,3],xmm8[2,0]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm5[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,3],xmm8[2,0]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm3[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm4[2],xmm9[3],xmm4[3]
; SSE-NEXT:    movaps %xmm9, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm8[0,2]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm7[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm11, %xmm6
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm4[0,2]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rcx), %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    movaps 16(%r10), %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm7[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm5[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movaps %xmm10, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm1[0],xmm6[1],xmm1[1]
; SSE-NEXT:    movaps %xmm6, %xmm5
; SSE-NEXT:    movaps %xmm6, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rax), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm3[0]
; SSE-NEXT:    movaps 16(%r8), %xmm11
; SSE-NEXT:    movaps 16(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm9
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm6[0],xmm9[1],xmm6[1]
; SSE-NEXT:    movaps %xmm9, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm1[2],xmm10[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm4[1]
; SSE-NEXT:    movaps %xmm10, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm1[0,2]
; SSE-NEXT:    movaps %xmm5, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm1[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm3[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdx), %xmm1
; SSE-NEXT:    movaps 32(%rcx), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movaps 32(%rdi), %xmm14
; SSE-NEXT:    movaps 32(%rsi), %xmm2
; SSE-NEXT:    movaps %xmm14, %xmm15
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm2[0],xmm15[1],xmm2[1]
; SSE-NEXT:    movaps %xmm15, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r10), %xmm0
; SSE-NEXT:    movaps 32(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm0[0]
; SSE-NEXT:    movaps 32(%r8), %xmm9
; SSE-NEXT:    movaps 32(%r9), %xmm6
; SSE-NEXT:    movaps %xmm9, %xmm11
; SSE-NEXT:    unpcklps {{.*#+}} xmm11 = xmm11[0],xmm6[0],xmm11[1],xmm6[1]
; SSE-NEXT:    movaps %xmm11, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm5[2,0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm14 = xmm14[2],xmm2[2],xmm14[3],xmm2[3]
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; SSE-NEXT:    movaps %xmm14, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm2[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm6[2],xmm9[3],xmm6[3]
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm4[1]
; SSE-NEXT:    movaps %xmm9, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm2[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm3[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,3],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm0[0,2]
; SSE-NEXT:    movaps 48(%rdx), %xmm1
; SSE-NEXT:    movaps 48(%rcx), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm0
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE-NEXT:    movaps 48(%rdi), %xmm4
; SSE-NEXT:    movaps 48(%rsi), %xmm12
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm12[0],xmm5[1],xmm12[1]
; SSE-NEXT:    movaps %xmm5, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r10), %xmm0
; SSE-NEXT:    movaps 48(%rax), %xmm6
; SSE-NEXT:    movaps %xmm6, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movaps 48(%r8), %xmm3
; SSE-NEXT:    movaps 48(%r9), %xmm13
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm13[0],xmm8[1],xmm13[1]
; SSE-NEXT:    movaps %xmm8, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm7, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm2[2,0]
; SSE-NEXT:    movaps %xmm6, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm2[2,0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm4 = xmm4[2],xmm12[2],xmm4[3],xmm12[3]
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; SSE-NEXT:    movaps %xmm4, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm2[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm13[2],xmm3[3],xmm13[3]
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm6[1]
; SSE-NEXT:    movaps %xmm3, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm2[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm7[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,3],xmm1[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm6[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,3],xmm0[0,2]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm3, 496(%rax)
; SSE-NEXT:    movaps %xmm4, 480(%rax)
; SSE-NEXT:    movaps %xmm13, 464(%rax)
; SSE-NEXT:    movaps %xmm12, 448(%rax)
; SSE-NEXT:    movaps %xmm8, 432(%rax)
; SSE-NEXT:    movaps %xmm5, 416(%rax)
; SSE-NEXT:    movaps %xmm10, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps %xmm9, 368(%rax)
; SSE-NEXT:    movaps %xmm14, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps %xmm11, 304(%rax)
; SSE-NEXT:    movaps %xmm15, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $216, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride8_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $264, %rsp # imm = 0x108
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm7
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm9
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %ymm4
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %ymm5
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %ymm6
; AVX1-ONLY-NEXT:    vmovaps 32(%r10), %ymm11
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %ymm12
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm12[1],ymm11[1],ymm12[3],ymm11[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm5[2],ymm6[2],ymm5[3],ymm6[3],ymm5[6],ymm6[6],ymm5[7],ymm6[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm10[0,1],ymm2[2,0],ymm10[4,5],ymm2[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm4[1],ymm3[1],ymm4[3],ymm3[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0,1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm10[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm11[2],ymm12[2],ymm11[3],ymm12[3],ymm11[6],ymm12[6],ymm11[7],ymm12[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm6[3,0],ymm5[3,0],ymm6[7,4],ymm5[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm10[2,0],ymm2[2,3],ymm10[6,4],ymm2[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm13 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm13[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm10[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm12[0],ymm11[0],ymm12[2],ymm11[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm10 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm10[0,1],ymm2[2,0],ymm10[4,5],ymm2[6,4]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm2 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm4[0],ymm3[0],ymm4[2],ymm3[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm2[0,1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm13[0,1,2,3],ymm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm10
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm13 = ymm11[0],ymm12[0],ymm11[1],ymm12[1],ymm11[4],ymm12[4],ymm11[5],ymm12[5]
; AVX1-ONLY-NEXT:    vmovaps (%r9), %ymm11
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm5 = ymm6[1,0],ymm5[1,0],ymm6[5,4],ymm5[5,4]
; AVX1-ONLY-NEXT:    vmovaps (%r10), %ymm12
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm5 = ymm5[2,0],ymm13[2,3],ymm5[6,4],ymm13[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rax), %ymm13
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm13[1],ymm12[1],ymm13[3],ymm12[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm10[2],ymm11[2],ymm10[3],ymm11[3],ymm10[6],ymm11[6],ymm10[7],ymm11[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,0],ymm1[4,5],ymm0[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm7[2],ymm8[2],ymm7[3],ymm8[3],ymm7[6],ymm8[6],ymm7[7],ymm8[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm2[1],ymm9[1],ymm2[3],ymm9[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm12[2],ymm13[2],ymm12[3],ymm13[3],ymm12[6],ymm13[6],ymm12[7],ymm13[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm11[3,0],ymm10[3,0],ymm11[7,4],ymm10[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[2,0],ymm0[2,3],ymm1[6,4],ymm0[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm9[2],ymm2[2],ymm9[3],ymm2[3],ymm9[6],ymm2[6],ymm9[7],ymm2[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm8[3,0],ymm7[3,0],ymm8[7,4],ymm7[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm13[0],ymm12[0],ymm13[2],ymm12[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm10[0],ymm11[0],ymm10[1],ymm11[1],ymm10[4],ymm11[4],ymm10[5],ymm11[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2,0],ymm1[4,5],ymm0[6,4]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm7[0],ymm8[0],ymm7[1],ymm8[1],ymm7[4],ymm8[4],ymm7[5],ymm8[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm2[0],ymm9[0],ymm2[2],ymm9[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm12[0],ymm13[0],ymm12[1],ymm13[1],ymm12[4],ymm13[4],ymm12[5],ymm13[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm11[1,0],ymm10[1,0],ymm11[5,4],ymm10[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[2,0],ymm0[2,3],ymm1[6,4],ymm0[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm9[0],ymm2[0],ymm9[1],ymm2[1],ymm9[4],ymm2[4],ymm9[5],ymm2[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm8[1,0],ymm7[1,0],ymm8[5,4],ymm7[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r10), %xmm1
; AVX1-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm15
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm13
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm13[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0],xmm15[1],xmm3[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm11
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm11[1,1,1,1]
; AVX1-ONLY-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0],xmm5[1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm0
; AVX1-ONLY-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm14
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm14[0],xmm0[0],xmm14[1],xmm0[1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],xmm12[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm11[0],xmm5[0],xmm11[1],xmm5[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm3[0],xmm12[0]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm13[0],xmm15[0],xmm13[1],xmm15[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm9
; AVX1-ONLY-NEXT:    vmovaps 32(%r10), %xmm8
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm9[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm8[0,1,2],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm7
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm5
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm10
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm12 = xmm10[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm12 = xmm0[0,1,2],xmm12[3]
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm12 = xmm1[0,1],xmm12[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm12[0,1,2,3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm12 = xmm0[2],xmm10[2],xmm0[3],xmm10[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm12[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm12 = xmm8[2],xmm9[2],xmm8[3],xmm9[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm0[0],xmm10[0],xmm0[1],xmm10[1]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm8[0],xmm9[0],xmm8[1],xmm9[1]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm5[0],xmm6[0],xmm5[1],xmm6[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm9 = xmm8[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm9
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm9[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm9[0],xmm4[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0],xmm3[1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm5[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0],xmm6[1],xmm3[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm11, %xmm3 # 16-byte Folded Reload
; AVX1-ONLY-NEXT:    # xmm3 = xmm11[2],mem[2],xmm11[3],mem[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm13[2],xmm15[2],xmm13[3],xmm15[3]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm9[2,2,2,2]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm8[0,1,2],xmm5[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm10[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm14[0,1,2],xmm6[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1],xmm6[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm14[2],xmm10[2],xmm14[3],xmm10[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm6[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm8[2],xmm9[2],xmm8[3],xmm9[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 96(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 64(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 288(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 352(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 320(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX1-ONLY-NEXT:    addq $264, %rsp # imm = 0x108
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i32_stride8_vf16:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $296, %rsp # imm = 0x128
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %ymm7
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa (%rsi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 32(%rsi), %ymm2
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %ymm6
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdx), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 32(%rcx), %ymm10
; AVX2-ONLY-NEXT:    vmovdqa 32(%r8), %ymm11
; AVX2-ONLY-NEXT:    vmovdqa 32(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 32(%r10), %ymm9
; AVX2-ONLY-NEXT:    vmovdqa 32(%rax), %ymm12
; AVX2-ONLY-NEXT:    vpbroadcastd 56(%rax), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0,1,2,3,4,5,6],ymm0[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm3, %xmm13
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm14 = ymm5[2],ymm10[2],ymm5[3],ymm10[3],ymm5[6],ymm10[6],ymm5[7],ymm10[7]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm15 = ymm14[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm13 = xmm13[0,1],xmm15[2,3]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm15 = ymm11[2],ymm4[2],ymm11[3],ymm4[3],ymm11[6],ymm4[6],ymm11[7],ymm4[7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm15[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm13[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 60(%r10), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm0[2],ymm12[2],ymm0[3],ymm12[3],ymm0[6],ymm12[6],ymm0[7],ymm12[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm13 = ymm15[1],ymm0[1],ymm15[3],ymm0[3]
; AVX2-ONLY-NEXT:    vmovdqa (%rcx), %ymm0
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm14 = xmm3[0,1],xmm14[2,3]
; AVX2-ONLY-NEXT:    vmovdqa (%r8), %ymm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm14[0,1,2,3],ymm13[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm12 = ymm9[0],ymm12[0],ymm9[1],ymm12[1],ymm9[4],ymm12[4],ymm9[5],ymm12[5]
; AVX2-ONLY-NEXT:    vpbroadcastd 48(%rsi), %xmm9
; AVX2-ONLY-NEXT:    vpbroadcastd 48(%rdi), %ymm13
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm13 = xmm13[0],xmm9[0],xmm13[1],xmm9[1]
; AVX2-ONLY-NEXT:    vmovdqa (%r9), %ymm9
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm10 = ymm5[0],ymm10[0],ymm5[1],ymm10[1],ymm5[4],ymm10[4],ymm5[5],ymm10[5]
; AVX2-ONLY-NEXT:    vmovdqa (%r10), %ymm5
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm11 = ymm11[0],ymm4[0],ymm11[1],ymm4[1],ymm11[4],ymm4[4],ymm11[5],ymm4[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm11 = ymm11[0],ymm12[0],ymm11[2],ymm12[2]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm10 = ymm10[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm10 = xmm13[0,1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 52(%r8), %ymm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm10[0,1,2,3,4],ymm4[5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm10 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 52(%rcx), %ymm11
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm10 = xmm10[0,1,2],xmm11[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm1 = ymm1[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3,4],ymm2[5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 24(%rax), %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm5[0,1,2,3,4,5,6],ymm1[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm7[2],ymm8[2],ymm7[3],ymm8[3],ymm7[6],ymm8[6],ymm7[7],ymm8[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm10 = ymm6[2],ymm0[2],ymm6[3],ymm0[3],ymm6[6],ymm0[6],ymm6[7],ymm0[7]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm11 = ymm10[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],xmm11[2,3]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm11 = ymm3[2],ymm9[2],ymm3[3],ymm9[3],ymm3[6],ymm9[6],ymm3[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm11[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovdqa (%rax), %ymm1
; AVX2-ONLY-NEXT:    vpbroadcastd 28(%r10), %ymm4
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm4[2],ymm1[2],ymm4[3],ymm1[3],ymm4[6],ymm1[6],ymm4[7],ymm1[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm11[1],ymm4[1],ymm11[3],ymm4[3]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm2 = ymm2[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm4[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm1 = ymm5[0],ymm1[0],ymm5[1],ymm1[1],ymm5[4],ymm1[4],ymm5[5],ymm1[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm2 = ymm3[0],ymm9[0],ymm3[1],ymm9[1],ymm3[4],ymm9[4],ymm3[5],ymm9[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm2 = ymm2[0],ymm1[0],ymm2[2],ymm1[2]
; AVX2-ONLY-NEXT:    vpbroadcastd 16(%rsi), %xmm3
; AVX2-ONLY-NEXT:    vpbroadcastd 16(%rdi), %ymm4
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm0 = ymm6[0],ymm0[0],ymm6[1],ymm0[1],ymm6[4],ymm0[4],ymm6[5],ymm0[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm3[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 20(%r8), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm9[5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm1 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 20(%rcx), %ymm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm2 = ymm7[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm8[1],ymm2[2,3,4],ymm8[5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm1
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm15
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm15[0],xmm1[0],xmm15[1],xmm1[1]
; AVX2-ONLY-NEXT:    vmovaps %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm2
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm4
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm4[1,1,1,1]
; AVX2-ONLY-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vmovaps %xmm2, %xmm5
; AVX2-ONLY-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm11
; AVX2-ONLY-NEXT:    vmovaps (%r10), %xmm12
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm12[0],xmm11[0],xmm12[1],xmm11[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm6
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm14
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm14[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0],xmm6[1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm0
; AVX2-ONLY-NEXT:    vbroadcastss %xmm15, %xmm1
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vbroadcastss %xmm11, %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm12, %xmm2
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm14[0],xmm6[0],xmm14[1],xmm6[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm8
; AVX2-ONLY-NEXT:    vmovaps 32(%r10), %xmm5
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm8[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm5[0,1,2],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %xmm10
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm9
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vmovaps 32(%rcx), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm1[0,1,2],xmm13[3]
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm3
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm0[0,1],xmm13[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm13[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm7[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm7 = xmm5[2],xmm8[2],xmm5[3],xmm8[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm6[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm0
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm6
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm6[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vbroadcastss %xmm8, %xmm6
; AVX2-ONLY-NEXT:    vbroadcastss %xmm5, %xmm13
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm13[0],xmm6[0],xmm13[1],xmm6[1]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm9[0],xmm10[0],xmm9[1],xmm10[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm13
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm13[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm0[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm3[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0],xmm4[1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm5[0],xmm8[0],xmm5[1],xmm8[1]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm9[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0],xmm10[1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; AVX2-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1, %xmm1 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm1 = xmm1[2],mem[2],xmm1[3],mem[3]
; AVX2-ONLY-NEXT:    vunpckhps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm2 # 16-byte Folded Reload
; AVX2-ONLY-NEXT:    # xmm2 = xmm14[2],mem[2],xmm14[3],mem[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm11[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm12[0,1,2],xmm3[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Reload
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm5[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm15[0,1,2],xmm4[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm1[0,1],xmm4[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm15[2],xmm5[2],xmm15[3],xmm5[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm4[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps %ymm1, 96(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm3, 64(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm6, 256(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 352(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-ONLY-NEXT:    addq $296, %rsp # imm = 0x128
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i32_stride8_vf16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512F-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512F-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512F-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512F-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512F-NEXT:    vmovdqa64 (%r9), %zmm6
; AVX512F-NEXT:    vmovdqa64 (%r11), %zmm7
; AVX512F-NEXT:    vmovdqa64 (%r10), %zmm8
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,u,u,0,16,u,u,u,u,u,u,1,17>
; AVX512F-NEXT:    vpermi2d %zmm8, %zmm7, %zmm4
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,u,u,0,16,u,u,u,u,u,u,1,17,u,u>
; AVX512F-NEXT:    vpermi2d %zmm6, %zmm5, %zmm9
; AVX512F-NEXT:    movb $-120, %cl
; AVX512F-NEXT:    kmovw %ecx, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm9 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,0,16,u,u,u,u,u,u,1,17,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm10
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <0,16,u,u,u,u,u,u,1,17,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512F-NEXT:    movb $34, %cl
; AVX512F-NEXT:    kmovw %ecx, %k2
; AVX512F-NEXT:    vmovdqa64 %zmm10, %zmm4 {%k2}
; AVX512F-NEXT:    movb $-52, %cl
; AVX512F-NEXT:    kmovw %ecx, %k3
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm4 {%k3}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,u,u,u,u,2,18,u,u,u,u,u,u,3,19>
; AVX512F-NEXT:    vpermi2d %zmm8, %zmm7, %zmm9
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,u,u,2,18,u,u,u,u,u,u,3,19,u,u>
; AVX512F-NEXT:    vpermi2d %zmm6, %zmm5, %zmm10
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm10 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,2,18,u,u,u,u,u,u,3,19,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm11
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <2,18,u,u,u,u,u,u,3,19,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm9
; AVX512F-NEXT:    vmovdqa64 %zmm11, %zmm9 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm10, %zmm9 {%k3}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,u,u,u,u,4,20,u,u,u,u,u,u,5,21>
; AVX512F-NEXT:    vpermi2d %zmm8, %zmm7, %zmm10
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,u,u,4,20,u,u,u,u,u,u,5,21,u,u>
; AVX512F-NEXT:    vpermi2d %zmm6, %zmm5, %zmm11
; AVX512F-NEXT:    vmovdqa64 %zmm10, %zmm11 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,4,20,u,u,u,u,u,u,5,21,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <4,20,u,u,u,u,u,u,5,21,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm10
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm10 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm11, %zmm10 {%k3}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,u,u,u,u,6,22,u,u,u,u,u,u,7,23>
; AVX512F-NEXT:    vpermi2d %zmm8, %zmm7, %zmm11
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,6,22,u,u,u,u,u,u,7,23,u,u>
; AVX512F-NEXT:    vpermi2d %zmm6, %zmm5, %zmm12
; AVX512F-NEXT:    vmovdqa64 %zmm11, %zmm12 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,u,6,22,u,u,u,u,u,u,7,23,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm13
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <6,22,u,u,u,u,u,u,7,23,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm11
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm11 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm11 {%k3}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,u,u,8,24,u,u,u,u,u,u,9,25>
; AVX512F-NEXT:    vpermi2d %zmm8, %zmm7, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,u,u,u,8,24,u,u,u,u,u,u,9,25,u,u>
; AVX512F-NEXT:    vpermi2d %zmm6, %zmm5, %zmm13
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm13 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,8,24,u,u,u,u,u,u,9,25,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <8,24,u,u,u,u,u,u,9,25,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm14 {%k3}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,u,u,10,26,u,u,u,u,u,u,11,27>
; AVX512F-NEXT:    vpermi2d %zmm8, %zmm7, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,u,u,u,10,26,u,u,u,u,u,u,11,27,u,u>
; AVX512F-NEXT:    vpermi2d %zmm6, %zmm5, %zmm13
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm13 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,10,26,u,u,u,u,u,u,11,27,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <10,26,u,u,u,u,u,u,11,27,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm15
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm15 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm15 {%k3}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,u,u,12,28,u,u,u,u,u,u,13,29>
; AVX512F-NEXT:    vpermi2d %zmm8, %zmm7, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,u,u,u,12,28,u,u,u,u,u,u,13,29,u,u>
; AVX512F-NEXT:    vpermi2d %zmm6, %zmm5, %zmm13
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm13 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,12,28,u,u,u,u,u,u,13,29,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <12,28,u,u,u,u,u,u,13,29,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm16
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm16 {%k3}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,u,u,14,30,u,u,u,u,u,u,15,31>
; AVX512F-NEXT:    vpermi2d %zmm8, %zmm7, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,u,u,14,30,u,u,u,u,u,u,15,31,u,u>
; AVX512F-NEXT:    vpermi2d %zmm6, %zmm5, %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,14,30,u,u,u,u,u,u,15,31,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <14,30,u,u,u,u,u,u,15,31,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm2 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm2 {%k3}
; AVX512F-NEXT:    vmovdqa64 %zmm2, 448(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm16, 384(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm15, 320(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm14, 256(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm11, 192(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride8_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r11
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm6
; AVX512BW-NEXT:    vmovdqa64 (%r11), %zmm7
; AVX512BW-NEXT:    vmovdqa64 (%r10), %zmm8
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,u,u,0,16,u,u,u,u,u,u,1,17>
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm7, %zmm4
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,u,u,0,16,u,u,u,u,u,u,1,17,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm5, %zmm9
; AVX512BW-NEXT:    movb $-120, %cl
; AVX512BW-NEXT:    kmovd %ecx, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm9 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,0,16,u,u,u,u,u,u,1,17,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm10
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <0,16,u,u,u,u,u,u,1,17,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm4
; AVX512BW-NEXT:    movb $34, %cl
; AVX512BW-NEXT:    kmovd %ecx, %k2
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm4 {%k2}
; AVX512BW-NEXT:    movb $-52, %cl
; AVX512BW-NEXT:    kmovd %ecx, %k3
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm4 {%k3}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,u,u,u,u,2,18,u,u,u,u,u,u,3,19>
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm7, %zmm9
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,u,u,2,18,u,u,u,u,u,u,3,19,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm5, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,2,18,u,u,u,u,u,u,3,19,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm11
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <2,18,u,u,u,u,u,u,3,19,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm9 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm9 {%k3}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,u,u,u,u,4,20,u,u,u,u,u,u,5,21>
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm7, %zmm10
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,u,u,4,20,u,u,u,u,u,u,5,21,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm5, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm11 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,4,20,u,u,u,u,u,u,5,21,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <4,20,u,u,u,u,u,u,5,21,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm10 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm10 {%k3}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,u,u,u,u,6,22,u,u,u,u,u,u,7,23>
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm7, %zmm11
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,6,22,u,u,u,u,u,u,7,23,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm5, %zmm12
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm12 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,u,6,22,u,u,u,u,u,u,7,23,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm13
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <6,22,u,u,u,u,u,u,7,23,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm11 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm11 {%k3}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,u,u,8,24,u,u,u,u,u,u,9,25>
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm7, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,u,u,u,8,24,u,u,u,u,u,u,9,25,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm5, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm13 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,8,24,u,u,u,u,u,u,9,25,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <8,24,u,u,u,u,u,u,9,25,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm14 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm14 {%k3}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,u,u,10,26,u,u,u,u,u,u,11,27>
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm7, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,u,u,u,10,26,u,u,u,u,u,u,11,27,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm5, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm13 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,10,26,u,u,u,u,u,u,11,27,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <10,26,u,u,u,u,u,u,11,27,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm15
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm15 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm15 {%k3}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,u,u,12,28,u,u,u,u,u,u,13,29>
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm7, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm13 = <u,u,u,u,12,28,u,u,u,u,u,u,13,29,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm5, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm13 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,12,28,u,u,u,u,u,u,13,29,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <12,28,u,u,u,u,u,u,13,29,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm16 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm16 {%k3}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,u,u,14,30,u,u,u,u,u,u,15,31>
; AVX512BW-NEXT:    vpermi2d %zmm8, %zmm7, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,u,u,14,30,u,u,u,u,u,u,15,31,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm6, %zmm5, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,14,30,u,u,u,u,u,u,15,31,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm2, %zmm5
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <14,30,u,u,u,u,u,u,15,31,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm2 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm2 {%k3}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 448(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 384(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <16 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <16 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <16 x i32>, ptr %in.vecptr6, align 64
  %in.vec7 = load <16 x i32>, ptr %in.vecptr7, align 64
  %1 = shufflevector <16 x i32> %in.vec0, <16 x i32> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i32> %in.vec2, <16 x i32> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <16 x i32> %in.vec4, <16 x i32> %in.vec5, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <16 x i32> %in.vec6, <16 x i32> %in.vec7, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %5 = shufflevector <32 x i32> %1, <32 x i32> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %6 = shufflevector <32 x i32> %3, <32 x i32> %4, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %7 = shufflevector <64 x i32> %5, <64 x i32> %6, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %interleaved.vec = shufflevector <128 x i32> %7, <128 x i32> poison, <128 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 80, i32 96, i32 112, i32 1, i32 17, i32 33, i32 49, i32 65, i32 81, i32 97, i32 113, i32 2, i32 18, i32 34, i32 50, i32 66, i32 82, i32 98, i32 114, i32 3, i32 19, i32 35, i32 51, i32 67, i32 83, i32 99, i32 115, i32 4, i32 20, i32 36, i32 52, i32 68, i32 84, i32 100, i32 116, i32 5, i32 21, i32 37, i32 53, i32 69, i32 85, i32 101, i32 117, i32 6, i32 22, i32 38, i32 54, i32 70, i32 86, i32 102, i32 118, i32 7, i32 23, i32 39, i32 55, i32 71, i32 87, i32 103, i32 119, i32 8, i32 24, i32 40, i32 56, i32 72, i32 88, i32 104, i32 120, i32 9, i32 25, i32 41, i32 57, i32 73, i32 89, i32 105, i32 121, i32 10, i32 26, i32 42, i32 58, i32 74, i32 90, i32 106, i32 122, i32 11, i32 27, i32 43, i32 59, i32 75, i32 91, i32 107, i32 123, i32 12, i32 28, i32 44, i32 60, i32 76, i32 92, i32 108, i32 124, i32 13, i32 29, i32 45, i32 61, i32 77, i32 93, i32 109, i32 125, i32 14, i32 30, i32 46, i32 62, i32 78, i32 94, i32 110, i32 126, i32 15, i32 31, i32 47, i32 63, i32 79, i32 95, i32 111, i32 127>
  store <128 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride8_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride8_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $728, %rsp # imm = 0x2D8
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm9
; SSE-NEXT:    movaps 16(%rdi), %xmm10
; SSE-NEXT:    movaps (%rsi), %xmm3
; SSE-NEXT:    movaps 16(%rsi), %xmm1
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps 16(%rdx), %xmm0
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps (%r8), %xmm11
; SSE-NEXT:    movaps (%r9), %xmm6
; SSE-NEXT:    movaps (%r10), %xmm5
; SSE-NEXT:    movaps (%rax), %xmm7
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm2[0]
; SSE-NEXT:    movaps %xmm9, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm3[0],xmm13[1],xmm3[1]
; SSE-NEXT:    movaps %xmm13, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm5[0]
; SSE-NEXT:    movaps %xmm11, %xmm14
; SSE-NEXT:    unpcklps {{.*#+}} xmm14 = xmm14[0],xmm6[0],xmm14[1],xmm6[1]
; SSE-NEXT:    movaps %xmm14, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,3],xmm8[2,0]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm5[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,3],xmm8[2,0]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm4[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm3[2],xmm9[3],xmm3[3]
; SSE-NEXT:    movaps %xmm9, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm8[0,2]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm7[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm11, %xmm6
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rcx), %xmm6
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm4[3,3]
; SSE-NEXT:    movaps 16(%r10), %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,3],xmm7[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm5[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE-NEXT:    movaps %xmm10, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm2[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rax), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm3[0]
; SSE-NEXT:    movaps 16(%r8), %xmm11
; SSE-NEXT:    movaps 16(%r9), %xmm5
; SSE-NEXT:    movaps %xmm11, %xmm9
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm5[0],xmm9[1],xmm5[1]
; SSE-NEXT:    movaps %xmm9, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm4[2,0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm4[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm4[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm1[2],xmm10[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[0,2]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm5[2],xmm11[3],xmm5[3]
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE-NEXT:    movaps %xmm11, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[0,2]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm6[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm3[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdx), %xmm0
; SSE-NEXT:    movaps 32(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 32(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r10), %xmm1
; SSE-NEXT:    movaps 32(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 32(%r8), %xmm11
; SSE-NEXT:    movaps 32(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm0
; SSE-NEXT:    movaps 48(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 48(%rdi), %xmm8
; SSE-NEXT:    movaps 48(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r10), %xmm1
; SSE-NEXT:    movaps 48(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 48(%r8), %xmm11
; SSE-NEXT:    movaps 48(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm0
; SSE-NEXT:    movaps 64(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 64(%rdi), %xmm8
; SSE-NEXT:    movaps 64(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r10), %xmm1
; SSE-NEXT:    movaps 64(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 64(%r8), %xmm11
; SSE-NEXT:    movaps 64(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm0
; SSE-NEXT:    movaps 80(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 80(%rdi), %xmm8
; SSE-NEXT:    movaps 80(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r10), %xmm1
; SSE-NEXT:    movaps 80(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 80(%r8), %xmm11
; SSE-NEXT:    movaps 80(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm0
; SSE-NEXT:    movaps 96(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 96(%rdi), %xmm12
; SSE-NEXT:    movaps 96(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm12, %xmm15
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm3[0],xmm15[1],xmm3[1]
; SSE-NEXT:    movaps %xmm15, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r10), %xmm1
; SSE-NEXT:    movaps 96(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 96(%r8), %xmm7
; SSE-NEXT:    movaps 96(%r9), %xmm9
; SSE-NEXT:    movaps %xmm7, %xmm11
; SSE-NEXT:    unpcklps {{.*#+}} xmm11 = xmm11[0],xmm9[0],xmm11[1],xmm9[1]
; SSE-NEXT:    movaps %xmm11, %xmm6
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm5[2,0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm12 = xmm12[2],xmm3[2],xmm12[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm12, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm9[2],xmm7[3],xmm9[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm7, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,3],xmm0[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm1[0,2]
; SSE-NEXT:    movaps 112(%rdx), %xmm2
; SSE-NEXT:    movaps 112(%rcx), %xmm6
; SSE-NEXT:    movaps %xmm6, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movaps 112(%rdi), %xmm0
; SSE-NEXT:    movaps 112(%rsi), %xmm13
; SSE-NEXT:    movaps %xmm0, %xmm9
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm13[0],xmm9[1],xmm13[1]
; SSE-NEXT:    movaps %xmm9, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r10), %xmm1
; SSE-NEXT:    movaps 112(%rax), %xmm5
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm1[0]
; SSE-NEXT:    movaps 112(%r8), %xmm3
; SSE-NEXT:    movaps 112(%r9), %xmm14
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm14[0],xmm8[1],xmm14[1]
; SSE-NEXT:    movaps %xmm8, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm4[2,0]
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm4[2,0]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm4[2,0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm13[2],xmm0[3],xmm13[3]
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm6[1]
; SSE-NEXT:    movaps %xmm0, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm4[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm14[2],xmm3[3],xmm14[3]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm5[1]
; SSE-NEXT:    movaps %xmm3, %xmm14
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,1],xmm4[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm6[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,3],xmm2[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm5[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,3],xmm1[0,2]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm3, 1008(%rax)
; SSE-NEXT:    movaps %xmm0, 992(%rax)
; SSE-NEXT:    movaps %xmm14, 976(%rax)
; SSE-NEXT:    movaps %xmm13, 960(%rax)
; SSE-NEXT:    movaps %xmm8, 944(%rax)
; SSE-NEXT:    movaps %xmm9, 928(%rax)
; SSE-NEXT:    movaps %xmm10, 912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rax)
; SSE-NEXT:    movaps %xmm7, 880(%rax)
; SSE-NEXT:    movaps %xmm12, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps %xmm11, 816(%rax)
; SSE-NEXT:    movaps %xmm15, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $728, %rsp # imm = 0x2D8
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride8_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $648, %rsp # imm = 0x288
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm3
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm4
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm5
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %ymm6
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm8
; AVX1-ONLY-NEXT:    vmovaps (%r9), %ymm10
; AVX1-ONLY-NEXT:    vmovaps (%r10), %ymm11
; AVX1-ONLY-NEXT:    vmovaps (%rax), %ymm12
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm12[0],ymm11[0],ymm12[2],ymm11[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm9 = ymm8[0],ymm10[0],ymm8[1],ymm10[1],ymm8[4],ymm10[4],ymm8[5],ymm10[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm9[0,1],ymm7[2,0],ymm9[4,5],ymm7[6,4]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm9 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm9, %xmm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm6[0],ymm5[0],ymm6[2],ymm5[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm9 = xmm9[0,1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1,2,3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm11[0],ymm12[0],ymm11[1],ymm12[1],ymm11[4],ymm12[4],ymm11[5],ymm12[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[1,0],ymm8[1,0],ymm10[5,4],ymm8[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm9[2,0],ymm7[2,3],ymm9[6,4],ymm7[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm9 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm9, %xmm9
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm13 = ymm4[1,0],ymm3[1,0],ymm4[5,4],ymm3[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm9 = xmm13[0,1],xmm9[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm9[0,1,2,3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm12[1],ymm11[1],ymm12[3],ymm11[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm8[2],ymm10[2],ymm8[3],ymm10[3],ymm8[6],ymm10[6],ymm8[7],ymm10[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm9 = ymm9[0,1],ymm7[2,0],ymm9[4,5],ymm7[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm6[1],ymm5[1],ymm6[3],ymm5[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm7[0,1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %ymm7
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm13[0,1,2,3],ymm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %ymm9
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm12 = ymm11[2],ymm12[2],ymm11[3],ymm12[3],ymm11[6],ymm12[6],ymm11[7],ymm12[7]
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %ymm11
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm10[3,0],ymm8[3,0],ymm10[7,4],ymm8[7,4]
; AVX1-ONLY-NEXT:    vmovaps 32(%r10), %ymm8
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm12 = ymm10[2,0],ymm12[2,3],ymm10[6,4],ymm12[6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %ymm10
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm5 = ymm5[2],ymm6[2],ymm5[3],ymm6[3],ymm5[6],ymm6[6],ymm5[7],ymm6[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[3,0],ymm3[3,0],ymm4[7,4],ymm3[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm12[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm10[0],ymm8[0],ymm10[2],ymm8[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm4 = ymm9[0],ymm11[0],ymm9[1],ymm11[1],ymm9[4],ymm11[4],ymm9[5],ymm11[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,0],ymm4[4,5],ymm3[6,4]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm7[0],ymm2[0],ymm7[2],ymm2[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm8[0],ymm10[0],ymm8[1],ymm10[1],ymm8[4],ymm10[4],ymm8[5],ymm10[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm4 = ymm11[1,0],ymm9[1,0],ymm11[5,4],ymm9[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[2,0],ymm3[2,3],ymm4[6,4],ymm3[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm4 = ymm2[0],ymm7[0],ymm2[1],ymm7[1],ymm2[4],ymm7[4],ymm2[5],ymm7[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm5 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm5[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm10[1],ymm8[1],ymm10[3],ymm8[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm9[2],ymm11[2],ymm9[3],ymm11[3],ymm9[6],ymm11[6],ymm9[7],ymm11[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,0],ymm4[4,5],ymm3[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm7[1],ymm2[1],ymm7[3],ymm2[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm8[2],ymm10[2],ymm8[3],ymm10[3],ymm8[6],ymm10[6],ymm8[7],ymm10[7]
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %ymm4
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm8 = ymm11[3,0],ymm9[3,0],ymm11[7,4],ymm9[7,4]
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %ymm5
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm8 = ymm8[2,0],ymm6[2,3],ymm8[6,4],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %ymm6
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm2[2],ymm7[2],ymm2[3],ymm7[3],ymm2[6],ymm7[6],ymm2[7],ymm7[7]
; AVX1-ONLY-NEXT:    vmovaps 64(%r10), %ymm2
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %ymm0
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[0,1],ymm1[2,0],ymm7[4,5],ymm1[6,4]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm7[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[4],ymm0[4],ymm2[5],ymm0[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm6[1,0],ymm5[1,0],ymm6[5,4],ymm5[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[2,0],ymm1[2,3],ymm7[6,4],ymm1[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm4[1,0],ymm3[1,0],ymm4[5,4],ymm3[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm7[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm5[2],ymm6[2],ymm5[3],ymm6[3],ymm5[6],ymm6[6],ymm5[7],ymm6[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[0,1],ymm1[2,0],ymm7[4,5],ymm1[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm7[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[6],ymm0[6],ymm2[7],ymm0[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm6[3,0],ymm5[3,0],ymm6[7,4],ymm5[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,0],ymm0[2,3],ymm1[6,4],ymm0[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm5 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %ymm0
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[3,0],ymm3[3,0],ymm4[7,4],ymm3[7,4]
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %ymm1
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vmovaps 96(%r10), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rax), %ymm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm3[0,1],ymm2[2,0],ymm3[4,5],ymm2[6,4]
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %ymm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[2,0],ymm6[2,3],ymm7[6,4],ymm6[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm3[1,0],ymm2[1,0],ymm3[5,4],ymm2[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm5[1],ymm4[1],ymm5[3],ymm4[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,0],ymm7[4,5],ymm6[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,0],ymm4[2,3],ymm0[6,4],ymm4[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[3,0],ymm2[3,0],ymm3[7,4],ymm2[7,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm10
; AVX1-ONLY-NEXT:    vmovaps (%r10), %xmm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm1[0],xmm10[0],xmm1[1],xmm10[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm0[0],xmm9[0],xmm0[1],xmm9[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm11[0],xmm8[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm11[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm0[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0],xmm9[1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm8 = xmm3[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0],xmm2[1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm9[2],xmm0[3],xmm9[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm10[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm1[0,1,2],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm6[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm7[0,1,2],xmm4[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm0[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],xmm10[2],xmm1[3],xmm10[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm8
; AVX1-ONLY-NEXT:    vmovaps 32(%r10), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm7[0],xmm8[0],xmm7[1],xmm8[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm2[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm10
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm2[0],xmm10[0],xmm2[1],xmm10[1]
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm15 = xmm15[0],xmm6[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm15[0,1,2,3],ymm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm15 = xmm0[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0],xmm1[1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm15[0,1],xmm6[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm15 = xmm3[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0],xmm4[1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm15[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm8[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm7[0,1,2],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm10[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm2[0,1,2],xmm4[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm0[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm2[2],xmm10[2],xmm2[3],xmm10[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm7[2],xmm8[2],xmm7[3],xmm8[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %xmm4
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 64(%r10), %xmm8
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm10[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %xmm15
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %xmm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm15[0],xmm3[1],xmm15[1]
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm14 = xmm14[0],xmm2[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm14[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm0[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm14 = xmm14[0],xmm1[1],xmm14[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm14[0,1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm4[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm14 = xmm14[0],xmm5[1],xmm14[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm14[0,1,2,3,4,5],ymm10[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm2[0,1,2,3],ymm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm7[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm8[0,1,2],xmm1[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm15[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm3[0,1,2],xmm4[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm0[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm3[2],xmm15[2],xmm3[3],xmm15[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %xmm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm3[0],xmm5[0],xmm3[1],xmm5[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 96(%rax), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 96(%r10), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm7[0],xmm4[0],xmm7[1],xmm4[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm8[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm0[0,1,2,3,4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %xmm14
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %xmm15
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm13 = xmm13[0],xmm2[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm13[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = xmm0[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm13[0],xmm1[1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm13[0,1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = xmm3[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm13[0],xmm5[1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1,2,3,4,5],ymm8[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm4[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm7[0,1,2],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm14[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm15[0,1,2],xmm5[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm0[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm7[2],xmm4[2],xmm7[3],xmm4[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 832(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 800(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 768(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, 608(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 576(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 544(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm12, 512(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX1-ONLY-NEXT:    addq $648, %rsp # imm = 0x288
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i32_stride8_vf32:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $648, %rsp # imm = 0x288
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 32(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa (%rsi), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %ymm6
; AVX2-ONLY-NEXT:    vmovdqa 32(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa (%rcx), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa (%r8), %ymm10
; AVX2-ONLY-NEXT:    vmovdqa (%r9), %ymm12
; AVX2-ONLY-NEXT:    vmovdqa (%rax), %ymm9
; AVX2-ONLY-NEXT:    vmovdqa (%r10), %ymm11
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm7 = ymm9[0],ymm11[0],ymm9[1],ymm11[1],ymm9[4],ymm11[4],ymm9[5],ymm11[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm13 = ymm10[0],ymm12[0],ymm10[1],ymm12[1],ymm10[4],ymm12[4],ymm10[5],ymm12[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm13 = ymm13[0],ymm7[0],ymm13[2],ymm7[2]
; AVX2-ONLY-NEXT:    vpbroadcastd 16(%rsi), %xmm14
; AVX2-ONLY-NEXT:    vpbroadcastd 16(%rdi), %ymm15
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm15 = ymm6[0],ymm8[0],ymm6[1],ymm8[1],ymm6[4],ymm8[4],ymm6[5],ymm8[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm14 = xmm14[0,1],xmm15[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm14[0,1,2,3],ymm13[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 20(%r8), %ymm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3,4],ymm12[5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 20(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1,2],xmm14[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm14 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0],ymm5[1],ymm14[2,3,4],ymm5[5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm14 = xmm14[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 32(%r8), %ymm7
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm14[0,1,2,3],ymm13[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 24(%r10), %ymm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm9[0,1,2,3,4,5,6],ymm13[7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%r9), %ymm9
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm12 = ymm10[2],ymm12[2],ymm10[3],ymm12[3],ymm10[6],ymm12[6],ymm10[7],ymm12[7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%rax), %ymm10
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm8 = ymm6[2],ymm8[2],ymm6[3],ymm8[3],ymm6[6],ymm8[6],ymm6[7],ymm8[7]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm6 = ymm8[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 32(%r10), %ymm6
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm12[0,1,2,3,4,5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm13[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 28(%rax), %ymm5
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm5 = ymm5[2],ymm11[2],ymm5[3],ymm11[3],ymm5[6],ymm11[6],ymm5[7],ymm11[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm5 = ymm12[1],ymm5[1],ymm12[3],ymm5[3]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],xmm8[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm4 = ymm10[0],ymm6[0],ymm10[1],ymm6[1],ymm10[4],ymm6[4],ymm10[5],ymm6[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm5 = ymm7[0],ymm9[0],ymm7[1],ymm9[1],ymm7[4],ymm9[4],ymm7[5],ymm9[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX2-ONLY-NEXT:    vpbroadcastd 48(%rsi), %xmm8
; AVX2-ONLY-NEXT:    vpbroadcastd 48(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm8 = xmm11[0],xmm8[0],xmm11[1],xmm8[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm11 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm8 = xmm8[0,1],xmm11[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm8[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 52(%r8), %ymm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4],ymm9[5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm4 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 52(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1,2],xmm8[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm8 = ymm0[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0],ymm1[1],ymm8[2,3,4],ymm1[5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm8 = xmm8[0,1],xmm4[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdx), %ymm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm8[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 56(%r10), %ymm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm10[0,1,2,3,4,5,6],ymm5[7]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rcx), %ymm5
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm9 = ymm7[2],ymm9[2],ymm7[3],ymm9[3],ymm7[6],ymm9[6],ymm7[7],ymm9[7]
; AVX2-ONLY-NEXT:    vmovdqa 64(%r8), %ymm7
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm10 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm0
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm1 = ymm3[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 64(%r9), %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm9[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 60(%rax), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm0[2],ymm6[2],ymm0[3],ymm6[3],ymm0[6],ymm6[6],ymm0[7],ymm6[7]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rax), %ymm2
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm9[1],ymm0[1],ymm9[3],ymm0[3]
; AVX2-ONLY-NEXT:    vmovdqa 64(%r10), %ymm0
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm8 = ymm10[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm8[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 80(%rsi), %xmm3
; AVX2-ONLY-NEXT:    vpbroadcastd 80(%rdi), %ymm6
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm6 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm3[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm6 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[4],ymm0[4],ymm2[5],ymm0[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm7[0],ymm1[0],ymm7[1],ymm1[1],ymm7[4],ymm1[4],ymm7[5],ymm1[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm8[0],ymm6[0],ymm8[2],ymm6[2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 84(%r8), %ymm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm1[5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm6 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 84(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm6 = xmm6[0,1,2],xmm8[3]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 64(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm10 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm9[1],ymm10[2,3,4],ymm9[5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm6 = xmm10[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 88(%r10), %ymm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm3[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm7[2],ymm1[2],ymm7[3],ymm1[3],ymm7[6],ymm1[6],ymm7[7],ymm1[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm3, %xmm5
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 92(%rax), %ymm2
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[6],ymm0[6],ymm2[7],ymm0[7]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 112(%rsi), %xmm2
; AVX2-ONLY-NEXT:    vpbroadcastd 112(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 96(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 96(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 96(%rax), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 96(%r10), %ymm6
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm7 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 116(%r8), %ymm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm4[5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 116(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1,2],xmm8[3]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 96(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm10 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm9[1],ymm10[2,3,4],ymm9[5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm7[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 120(%r10), %ymm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3,4,5,6],ymm2[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm1
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm5 = ymm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 124(%rax), %ymm1
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm1[2],ymm6[2],ymm1[3],ymm6[3],ymm1[6],ymm6[6],ymm1[7],ymm6[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm2[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm0
; AVX2-ONLY-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps (%r10), %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm8
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm9
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0],xmm4[1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm9[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm8[1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1,2],xmm6[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm5[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rcx), %xmm0
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps 32(%r10), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %xmm8
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm9
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0],xmm4[1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm9[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm8[1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1,2],xmm6[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm5[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rcx), %xmm6
; AVX2-ONLY-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm6, %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm9 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps 64(%r10), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 64(%rax), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %xmm7
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm7[0],xmm0[0],xmm7[1],xmm0[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm8 = xmm5[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0],xmm4[1],xmm8[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm1[0],xmm6[0],xmm1[1],xmm6[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0,1],xmm15[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm7[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm14 = xmm14[0],xmm0[1],xmm14[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm8[0,1,2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm3[0,1,2],xmm5[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm6[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm7[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],xmm6[2],xmm1[3],xmm6[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm1[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 96(%rcx), %xmm4
; AVX2-ONLY-NEXT:    vbroadcastss %xmm4, %xmm0
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm1
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %xmm6
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm14[0],xmm6[0],xmm14[1],xmm6[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm1[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vmovaps 96(%r10), %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm15
; AVX2-ONLY-NEXT:    vmovaps 96(%rax), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm13
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm13[0],xmm15[0],xmm13[1],xmm15[1]
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %xmm15
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm0[0],xmm15[0],xmm0[1],xmm15[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm13
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3,4,5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm5[0,1,2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm14[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0],xmm6[1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],xmm12[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm11 = xmm0[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0],xmm15[1],xmm11[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm14[2],xmm6[2],xmm14[3],xmm6[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm11 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm11 = xmm1[0,1,2],xmm11[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm12 = xmm4[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm12 = xmm3[0,1,2],xmm12[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm12 = xmm6[0,1],xmm12[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm6[1],xmm3[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 832(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 800(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 768(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 608(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 576(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 544(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 512(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-ONLY-NEXT:    addq $648, %rsp # imm = 0x288
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i32_stride8_vf32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    subq $2056, %rsp # imm = 0x808
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512F-NEXT:    vmovdqa64 (%r9), %zmm13
; AVX512F-NEXT:    vmovdqa64 (%r10), %zmm2
; AVX512F-NEXT:    vmovdqa64 64(%r10), %zmm0
; AVX512F-NEXT:    vmovdqa64 (%rax), %zmm30
; AVX512F-NEXT:    vmovdqa64 64(%rax), %zmm17
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,u,u,u,u,u,2,18,u,u,u,u,u,u,3,19>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512F-NEXT:    vpermt2d %zmm30, %zmm3, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,2,18,u,u,u,u,u,u,3,19,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm4, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,u,u,u,u,0,16,u,u,u,u,u,u,1,17>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512F-NEXT:    vpermt2d %zmm30, %zmm5, %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <u,u,u,u,0,16,u,u,u,u,u,u,1,17,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm6, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,u,u,u,u,6,22,u,u,u,u,u,u,7,23>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512F-NEXT:    vpermt2d %zmm30, %zmm7, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,u,u,u,6,22,u,u,u,u,u,u,7,23,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm8, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,u,u,u,u,4,20,u,u,u,u,u,u,5,21>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm30, %zmm9, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,u,u,4,20,u,u,u,u,u,u,5,21,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm10, %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,u,u,u,u,10,26,u,u,u,u,u,u,11,27>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512F-NEXT:    vpermt2d %zmm30, %zmm11, %zmm12
; AVX512F-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,10,26,u,u,u,u,u,u,11,27,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm12, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <u,u,u,u,u,u,8,24,u,u,u,u,u,u,9,25>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm15
; AVX512F-NEXT:    vpermt2d %zmm30, %zmm14, %zmm15
; AVX512F-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <u,u,u,u,8,24,u,u,u,u,u,u,9,25,u,u>
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <u,u,u,u,u,u,14,30,u,u,u,u,u,u,15,31>
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512F-NEXT:    vpermt2d %zmm30, %zmm16, %zmm18
; AVX512F-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm31 = <u,u,u,u,u,u,12,28,u,u,u,u,u,u,13,29>
; AVX512F-NEXT:    vpermt2d %zmm30, %zmm31, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm15, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm17, %zmm0, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm17, %zmm0, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm17, %zmm0, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm17, %zmm0, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm17, %zmm0, %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm17, %zmm0, %zmm14
; AVX512F-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm17, %zmm0, %zmm16
; AVX512F-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm17, %zmm31, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm21 = <u,u,u,u,14,30,u,u,u,u,u,u,15,31,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm31
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm21, %zmm31
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,u,u,12,28,u,u,u,u,u,u,13,29,u,u>
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm1, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512F-NEXT:    vmovdqa64 64(%r9), %zmm0
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm13, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm13, %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm13, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm13, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm13, %zmm12
; AVX512F-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm13, %zmm15
; AVX512F-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm13, %zmm21
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm13
; AVX512F-NEXT:    vmovdqa64 (%rdx), %zmm9
; AVX512F-NEXT:    vmovdqa64 (%rcx), %zmm1
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm27 = <u,u,2,18,u,u,u,u,u,u,3,19,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm29
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm27, %zmm29
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <u,u,0,16,u,u,u,u,u,u,1,17,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm28, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm22 = <u,u,6,22,u,u,u,u,u,u,7,23,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm22, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm23 = <u,u,4,20,u,u,u,u,u,u,5,21,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm23, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm24 = <u,u,10,26,u,u,u,u,u,u,11,27,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm24, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm25 = <u,u,8,24,u,u,u,u,u,u,9,25,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm25, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm26 = <u,u,14,30,u,u,u,u,u,u,15,31,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm30
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm26, %zmm30
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm19 = <u,u,12,28,u,u,u,u,u,u,13,29,u,u,u,u>
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm19, %zmm9
; AVX512F-NEXT:    vmovdqa64 64(%rdx), %zmm2
; AVX512F-NEXT:    vmovdqa64 64(%rcx), %zmm0
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm2, %zmm27
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm2, %zmm28
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm2, %zmm22
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm2, %zmm23
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm2, %zmm24
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm2, %zmm25
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm2, %zmm26
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm19, %zmm2
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm17
; AVX512F-NEXT:    vmovdqa64 (%rsi), %zmm19
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <2,18,u,u,u,u,u,u,3,19,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm20
; AVX512F-NEXT:    vpermt2d %zmm19, %zmm11, %zmm20
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <0,16,u,u,u,u,u,u,1,17,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm18
; AVX512F-NEXT:    vpermt2d %zmm19, %zmm8, %zmm18
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <6,22,u,u,u,u,u,u,7,23,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm16
; AVX512F-NEXT:    vpermt2d %zmm19, %zmm7, %zmm16
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <4,20,u,u,u,u,u,u,5,21,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm15
; AVX512F-NEXT:    vpermt2d %zmm19, %zmm6, %zmm15
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <10,26,u,u,u,u,u,u,11,27,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512F-NEXT:    vpermt2d %zmm19, %zmm5, %zmm14
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <8,24,u,u,u,u,u,u,9,25,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm12
; AVX512F-NEXT:    vpermt2d %zmm19, %zmm4, %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <14,30,u,u,u,u,u,u,15,31,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm19, %zmm1, %zmm10
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <12,28,u,u,u,u,u,u,13,29,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermt2d %zmm19, %zmm3, %zmm17
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %zmm19
; AVX512F-NEXT:    vmovdqa64 64(%rsi), %zmm0
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm19, %zmm11
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm19, %zmm8
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm19, %zmm7
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm19, %zmm6
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm19, %zmm5
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm19, %zmm4
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm19, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm3, %zmm19
; AVX512F-NEXT:    movb $-120, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-NEXT:    movb $34, %al
; AVX512F-NEXT:    kmovw %eax, %k2
; AVX512F-NEXT:    vmovdqa64 %zmm29, %zmm20 {%k2}
; AVX512F-NEXT:    movb $-52, %al
; AVX512F-NEXT:    kmovw %eax, %k3
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm20 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm18 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm16 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm15 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm14 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm12 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm30, %zmm10 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm10 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm9, %zmm17 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm17 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm27, %zmm11 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm28, %zmm8 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm22, %zmm7 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm6 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm5 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm4 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm26, %zmm1 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm21, %zmm1 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm19 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm13, %zmm19 {%k3}
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    vmovdqa64 %zmm19, 896(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm1, 960(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm4, 768(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm5, 832(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm6, 640(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm7, 704(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm8, 512(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm11, 576(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm17, 384(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm10, 448(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm12, 256(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm14, 320(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm15, 128(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm16, 192(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm18, (%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512F-NEXT:    addq $2056, %rsp # imm = 0x808
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride8_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $2056, %rsp # imm = 0x808
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm13
; AVX512BW-NEXT:    vmovdqa64 (%r10), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%r10), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rax), %zmm30
; AVX512BW-NEXT:    vmovdqa64 64(%rax), %zmm17
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,u,u,u,u,u,2,18,u,u,u,u,u,u,3,19>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm30, %zmm3, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,2,18,u,u,u,u,u,u,3,19,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm5
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm4, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,u,u,u,u,0,16,u,u,u,u,u,u,1,17>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512BW-NEXT:    vpermt2d %zmm30, %zmm5, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <u,u,u,u,0,16,u,u,u,u,u,u,1,17,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm6, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,u,u,u,u,6,22,u,u,u,u,u,u,7,23>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512BW-NEXT:    vpermt2d %zmm30, %zmm7, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,u,u,u,6,22,u,u,u,u,u,u,7,23,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm8, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,u,u,u,u,4,20,u,u,u,u,u,u,5,21>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm30, %zmm9, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,u,u,4,20,u,u,u,u,u,u,5,21,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm11
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm10, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,u,u,u,u,10,26,u,u,u,u,u,u,11,27>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm12
; AVX512BW-NEXT:    vpermt2d %zmm30, %zmm11, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <u,u,u,u,10,26,u,u,u,u,u,u,11,27,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm14
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm12, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm14 = <u,u,u,u,u,u,8,24,u,u,u,u,u,u,9,25>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm15
; AVX512BW-NEXT:    vpermt2d %zmm30, %zmm14, %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <u,u,u,u,8,24,u,u,u,u,u,u,9,25,u,u>
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm16 = <u,u,u,u,u,u,14,30,u,u,u,u,u,u,15,31>
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm18
; AVX512BW-NEXT:    vpermt2d %zmm30, %zmm16, %zmm18
; AVX512BW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm31 = <u,u,u,u,u,u,12,28,u,u,u,u,u,u,13,29>
; AVX512BW-NEXT:    vpermt2d %zmm30, %zmm31, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm15, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm17, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm17, %zmm0, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm17, %zmm0, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm17, %zmm0, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm17, %zmm0, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm17, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm17, %zmm0, %zmm16
; AVX512BW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm17, %zmm31, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm21 = <u,u,u,u,14,30,u,u,u,u,u,u,15,31,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm31
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm21, %zmm31
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,u,u,12,28,u,u,u,u,u,u,13,29,u,u>
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm13
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm13, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm13, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm13, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm13, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm13, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm13, %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm13, %zmm21
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm13
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm9
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm1
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm27 = <u,u,2,18,u,u,u,u,u,u,3,19,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm29
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm27, %zmm29
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm28 = <u,u,0,16,u,u,u,u,u,u,1,17,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm28, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm22 = <u,u,6,22,u,u,u,u,u,u,7,23,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm22, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm23 = <u,u,4,20,u,u,u,u,u,u,5,21,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm23, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm24 = <u,u,10,26,u,u,u,u,u,u,11,27,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm24, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm25 = <u,u,8,24,u,u,u,u,u,u,9,25,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm25, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm26 = <u,u,14,30,u,u,u,u,u,u,15,31,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm30
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm26, %zmm30
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm19 = <u,u,12,28,u,u,u,u,u,u,13,29,u,u,u,u>
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm19, %zmm9
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm27
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm28
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm22
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm23
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm24
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm25
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm2, %zmm26
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm19, %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm17
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm19
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <2,18,u,u,u,u,u,u,3,19,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm20
; AVX512BW-NEXT:    vpermt2d %zmm19, %zmm11, %zmm20
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <0,16,u,u,u,u,u,u,1,17,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm18
; AVX512BW-NEXT:    vpermt2d %zmm19, %zmm8, %zmm18
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <6,22,u,u,u,u,u,u,7,23,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm16
; AVX512BW-NEXT:    vpermt2d %zmm19, %zmm7, %zmm16
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <4,20,u,u,u,u,u,u,5,21,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm15
; AVX512BW-NEXT:    vpermt2d %zmm19, %zmm6, %zmm15
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <10,26,u,u,u,u,u,u,11,27,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512BW-NEXT:    vpermt2d %zmm19, %zmm5, %zmm14
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <8,24,u,u,u,u,u,u,9,25,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm12
; AVX512BW-NEXT:    vpermt2d %zmm19, %zmm4, %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <14,30,u,u,u,u,u,u,15,31,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm19, %zmm1, %zmm10
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <12,28,u,u,u,u,u,u,13,29,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermt2d %zmm19, %zmm3, %zmm17
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm19
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm19, %zmm11
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm19, %zmm8
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm19, %zmm7
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm19, %zmm6
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm19, %zmm5
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm19, %zmm4
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm19, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm3, %zmm19
; AVX512BW-NEXT:    movb $-120, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    movb $34, %al
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm20 {%k2}
; AVX512BW-NEXT:    movb $-52, %al
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm20 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm18 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm16 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm16 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm15 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm14 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm14 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm12 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm12 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm10 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm10 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm17 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm17 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm27, %zmm11 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm28, %zmm8 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm7 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm6 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm5 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm4 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm1 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm1 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm19 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm19 {%k3}
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 896(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 960(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 768(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 832(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 640(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 704(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 512(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 576(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 384(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 448(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, (%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512BW-NEXT:    addq $2056, %rsp # imm = 0x808
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <32 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <32 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <32 x i32>, ptr %in.vecptr6, align 64
  %in.vec7 = load <32 x i32>, ptr %in.vecptr7, align 64
  %1 = shufflevector <32 x i32> %in.vec0, <32 x i32> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i32> %in.vec2, <32 x i32> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <32 x i32> %in.vec4, <32 x i32> %in.vec5, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <32 x i32> %in.vec6, <32 x i32> %in.vec7, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %5 = shufflevector <64 x i32> %1, <64 x i32> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %6 = shufflevector <64 x i32> %3, <64 x i32> %4, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %7 = shufflevector <128 x i32> %5, <128 x i32> %6, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %interleaved.vec = shufflevector <256 x i32> %7, <256 x i32> poison, <256 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 192, i32 224, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 193, i32 225, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 194, i32 226, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 195, i32 227, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 196, i32 228, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 197, i32 229, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 198, i32 230, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 199, i32 231, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 200, i32 232, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 201, i32 233, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 202, i32 234, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 203, i32 235, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 204, i32 236, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 205, i32 237, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 206, i32 238, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 207, i32 239, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 208, i32 240, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 209, i32 241, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 210, i32 242, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 211, i32 243, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 212, i32 244, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 213, i32 245, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 214, i32 246, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 215, i32 247, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 216, i32 248, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 217, i32 249, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 218, i32 250, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 219, i32 251, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 220, i32 252, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 221, i32 253, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 222, i32 254, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191, i32 223, i32 255>
  store <256 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride8_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %in.vecptr6, ptr %in.vecptr7, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride8_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1752, %rsp # imm = 0x6D8
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; SSE-NEXT:    movaps (%rdi), %xmm9
; SSE-NEXT:    movaps 16(%rdi), %xmm10
; SSE-NEXT:    movaps (%rsi), %xmm2
; SSE-NEXT:    movaps 16(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm3
; SSE-NEXT:    movaps 16(%rdx), %xmm1
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps (%r8), %xmm11
; SSE-NEXT:    movaps (%r9), %xmm5
; SSE-NEXT:    movaps (%r10), %xmm6
; SSE-NEXT:    movaps (%rax), %xmm7
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm3[0]
; SSE-NEXT:    movaps %xmm9, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm2[0],xmm13[1],xmm2[1]
; SSE-NEXT:    movaps %xmm13, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm6[0]
; SSE-NEXT:    movaps %xmm11, %xmm14
; SSE-NEXT:    unpcklps {{.*#+}} xmm14 = xmm14[0],xmm5[0],xmm14[1],xmm5[1]
; SSE-NEXT:    movaps %xmm14, %xmm12
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,1],xmm8[2,0]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,3],xmm8[2,0]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm6[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[2,3],xmm8[2,0]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm4[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm2[2],xmm9[3],xmm2[3]
; SSE-NEXT:    movaps %xmm9, %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm8[0,2]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm2
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm5[2],xmm11[3],xmm5[3]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm2[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rcx), %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm4[3,3]
; SSE-NEXT:    movaps 16(%r10), %xmm2
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm3[0,2]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[3,3],xmm7[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm6[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm1[0]
; SSE-NEXT:    movaps %xmm10, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; SSE-NEXT:    movaps %xmm6, %xmm4
; SSE-NEXT:    movaps %xmm6, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 16(%rax), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm2[0]
; SSE-NEXT:    movaps 16(%r8), %xmm11
; SSE-NEXT:    movaps 16(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm9
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm6[0],xmm9[1],xmm6[1]
; SSE-NEXT:    movaps %xmm9, %xmm8
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm4[2,0]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm4[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm4[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm0[2],xmm10[3],xmm0[3]
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; SSE-NEXT:    movaps %xmm10, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE-NEXT:    movaps %xmm11, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm0[0,2]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm5[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm3[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm2[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rdx), %xmm0
; SSE-NEXT:    movaps 32(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 32(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r10), %xmm1
; SSE-NEXT:    movaps 32(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 32(%r8), %xmm11
; SSE-NEXT:    movaps 32(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm0
; SSE-NEXT:    movaps 48(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 48(%rdi), %xmm8
; SSE-NEXT:    movaps 48(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r10), %xmm1
; SSE-NEXT:    movaps 48(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 48(%r8), %xmm11
; SSE-NEXT:    movaps 48(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm0
; SSE-NEXT:    movaps 64(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 64(%rdi), %xmm8
; SSE-NEXT:    movaps 64(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r10), %xmm1
; SSE-NEXT:    movaps 64(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 64(%r8), %xmm11
; SSE-NEXT:    movaps 64(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm0
; SSE-NEXT:    movaps 80(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 80(%rdi), %xmm8
; SSE-NEXT:    movaps 80(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r10), %xmm1
; SSE-NEXT:    movaps 80(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 80(%r8), %xmm11
; SSE-NEXT:    movaps 80(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm0
; SSE-NEXT:    movaps 96(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 96(%rdi), %xmm8
; SSE-NEXT:    movaps 96(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r10), %xmm1
; SSE-NEXT:    movaps 96(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 96(%r8), %xmm11
; SSE-NEXT:    movaps 96(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdx), %xmm0
; SSE-NEXT:    movaps 112(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 112(%rdi), %xmm8
; SSE-NEXT:    movaps 112(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r10), %xmm1
; SSE-NEXT:    movaps 112(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 112(%r8), %xmm11
; SSE-NEXT:    movaps 112(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdx), %xmm0
; SSE-NEXT:    movaps 128(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 128(%rdi), %xmm8
; SSE-NEXT:    movaps 128(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%r10), %xmm1
; SSE-NEXT:    movaps 128(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 128(%r8), %xmm11
; SSE-NEXT:    movaps 128(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdx), %xmm0
; SSE-NEXT:    movaps 144(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 144(%rdi), %xmm8
; SSE-NEXT:    movaps 144(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%r10), %xmm1
; SSE-NEXT:    movaps 144(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 144(%r8), %xmm11
; SSE-NEXT:    movaps 144(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdx), %xmm0
; SSE-NEXT:    movaps 160(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 160(%rdi), %xmm8
; SSE-NEXT:    movaps 160(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%r10), %xmm1
; SSE-NEXT:    movaps 160(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 160(%r8), %xmm11
; SSE-NEXT:    movaps 160(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdx), %xmm0
; SSE-NEXT:    movaps 176(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 176(%rdi), %xmm8
; SSE-NEXT:    movaps 176(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%r10), %xmm1
; SSE-NEXT:    movaps 176(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 176(%r8), %xmm11
; SSE-NEXT:    movaps 176(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdx), %xmm0
; SSE-NEXT:    movaps 192(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 192(%rdi), %xmm8
; SSE-NEXT:    movaps 192(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%r10), %xmm1
; SSE-NEXT:    movaps 192(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 192(%r8), %xmm11
; SSE-NEXT:    movaps 192(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdx), %xmm0
; SSE-NEXT:    movaps 208(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 208(%rdi), %xmm8
; SSE-NEXT:    movaps 208(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm3[0],xmm5[1],xmm3[1]
; SSE-NEXT:    movaps %xmm5, %xmm4
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%r10), %xmm1
; SSE-NEXT:    movaps 208(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 208(%r8), %xmm11
; SSE-NEXT:    movaps 208(%r9), %xmm6
; SSE-NEXT:    movaps %xmm11, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm9
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm3[2],xmm8[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm6[2],xmm11[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm11, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm0[0,2]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm1[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%rdx), %xmm0
; SSE-NEXT:    movaps 224(%rcx), %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps 224(%rdi), %xmm12
; SSE-NEXT:    movaps 224(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm12, %xmm15
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm3[0],xmm15[1],xmm3[1]
; SSE-NEXT:    movaps %xmm15, %xmm4
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%r10), %xmm1
; SSE-NEXT:    movaps 224(%rax), %xmm4
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm1[0]
; SSE-NEXT:    movaps 224(%r8), %xmm8
; SSE-NEXT:    movaps 224(%r9), %xmm6
; SSE-NEXT:    movaps %xmm8, %xmm11
; SSE-NEXT:    unpcklps {{.*#+}} xmm11 = xmm11[0],xmm6[0],xmm11[1],xmm6[1]
; SSE-NEXT:    movaps %xmm11, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[2,3],xmm5[2,0]
; SSE-NEXT:    movaps %xmm4, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,3],xmm5[2,0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm12 = xmm12[2],xmm3[2],xmm12[3],xmm3[3]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm12, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm6[2],xmm8[3],xmm6[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; SSE-NEXT:    movaps %xmm8, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm3[0,2]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm2[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[2,3],xmm0[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm4[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,3],xmm1[0,2]
; SSE-NEXT:    movaps 240(%rdx), %xmm2
; SSE-NEXT:    movaps 240(%rcx), %xmm7
; SSE-NEXT:    movaps %xmm7, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movaps 240(%rdi), %xmm0
; SSE-NEXT:    movaps 240(%rsi), %xmm13
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm13[0],xmm5[1],xmm13[1]
; SSE-NEXT:    movaps %xmm5, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%r10), %xmm1
; SSE-NEXT:    movaps 240(%rax), %xmm6
; SSE-NEXT:    movaps %xmm6, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm1[0]
; SSE-NEXT:    movaps 240(%r8), %xmm4
; SSE-NEXT:    movaps 240(%r9), %xmm14
; SSE-NEXT:    movaps %xmm4, %xmm9
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm14[0],xmm9[1],xmm14[1]
; SSE-NEXT:    movaps %xmm9, %xmm10
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm7, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,3],xmm3[2,0]
; SSE-NEXT:    movaps %xmm6, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,3],xmm3[2,0]
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm13[2],xmm0[3],xmm13[3]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm7[1]
; SSE-NEXT:    movaps %xmm0, %xmm13
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm3[0,2]
; SSE-NEXT:    unpckhps {{.*#+}} xmm4 = xmm4[2],xmm14[2],xmm4[3],xmm14[3]
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm6[1]
; SSE-NEXT:    movaps %xmm4, %xmm14
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,1],xmm3[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm7[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,3],xmm2[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm6[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,3],xmm1[0,2]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm4, 2032(%rax)
; SSE-NEXT:    movaps %xmm0, 2016(%rax)
; SSE-NEXT:    movaps %xmm14, 2000(%rax)
; SSE-NEXT:    movaps %xmm13, 1984(%rax)
; SSE-NEXT:    movaps %xmm9, 1968(%rax)
; SSE-NEXT:    movaps %xmm5, 1952(%rax)
; SSE-NEXT:    movaps %xmm10, 1936(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1920(%rax)
; SSE-NEXT:    movaps %xmm8, 1904(%rax)
; SSE-NEXT:    movaps %xmm12, 1888(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1872(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1856(%rax)
; SSE-NEXT:    movaps %xmm11, 1840(%rax)
; SSE-NEXT:    movaps %xmm15, 1824(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1808(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1792(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1776(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1760(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1744(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1728(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1712(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1696(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1680(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1664(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1648(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1632(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1616(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1600(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1584(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1568(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1552(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1536(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1520(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1504(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1488(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1472(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1456(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1440(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1424(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1408(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1392(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1376(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1360(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1344(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1328(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1312(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $1752, %rsp # imm = 0x6D8
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride8_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $1672, %rsp # imm = 0x688
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %ymm3
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %ymm4
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %ymm5
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %ymm6
; AVX1-ONLY-NEXT:    vmovaps (%r8), %ymm7
; AVX1-ONLY-NEXT:    vmovaps (%r9), %ymm8
; AVX1-ONLY-NEXT:    vmovaps (%r10), %ymm11
; AVX1-ONLY-NEXT:    vmovaps (%rax), %ymm12
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm12[0],ymm11[0],ymm12[2],ymm11[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm10 = ymm7[0],ymm8[0],ymm7[1],ymm8[1],ymm7[4],ymm8[4],ymm7[5],ymm8[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2,0],ymm10[4,5],ymm9[6,4]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm10 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm13 = ymm6[0],ymm5[0],ymm6[2],ymm5[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0,1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2,3],ymm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm9 = ymm11[0],ymm12[0],ymm11[1],ymm12[1],ymm11[4],ymm12[4],ymm11[5],ymm12[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm8[1,0],ymm7[1,0],ymm8[5,4],ymm7[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm9 = ymm10[2,0],ymm9[2,3],ymm10[6,4],ymm9[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm10 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm13 = ymm4[1,0],ymm3[1,0],ymm4[5,4],ymm3[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm13[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1,2,3],ymm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm9, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm12[1],ymm11[1],ymm12[3],ymm11[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm10 = ymm7[2],ymm8[2],ymm7[3],ymm8[3],ymm7[6],ymm8[6],ymm7[7],ymm8[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm10[0,1],ymm9[2,0],ymm10[4,5],ymm9[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm9 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm9, %xmm9
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm6[1],ymm5[1],ymm6[3],ymm5[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm13, %xmm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm9[0,1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm13[0,1,2,3],ymm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %ymm10
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm12 = ymm11[2],ymm12[2],ymm11[3],ymm12[3],ymm11[6],ymm12[6],ymm11[7],ymm12[7]
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %ymm11
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm8 = ymm8[3,0],ymm7[3,0],ymm8[7,4],ymm7[7,4]
; AVX1-ONLY-NEXT:    vmovaps 32(%r10), %ymm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm12 = ymm8[2,0],ymm12[2,3],ymm8[6,4],ymm12[6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %ymm8
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm5 = ymm5[2],ymm6[2],ymm5[3],ymm6[3],ymm5[6],ymm6[6],ymm5[7],ymm6[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[3,0],ymm3[3,0],ymm4[7,4],ymm3[7,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm12[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm4 = ymm10[0],ymm11[0],ymm10[1],ymm11[1],ymm10[4],ymm11[4],ymm10[5],ymm11[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,0],ymm4[4,5],ymm3[6,4]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm9[0],ymm2[0],ymm9[2],ymm2[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm7[0],ymm8[0],ymm7[1],ymm8[1],ymm7[4],ymm8[4],ymm7[5],ymm8[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm4 = ymm11[1,0],ymm10[1,0],ymm11[5,4],ymm10[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[2,0],ymm3[2,3],ymm4[6,4],ymm3[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm4 = ymm2[0],ymm9[0],ymm2[1],ymm9[1],ymm2[4],ymm9[4],ymm2[5],ymm9[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm5 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm5[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm8[1],ymm7[1],ymm8[3],ymm7[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm10[2],ymm11[2],ymm10[3],ymm11[3],ymm10[6],ymm11[6],ymm10[7],ymm11[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[0,1],ymm3[2,0],ymm4[4,5],ymm3[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm9[1],ymm2[1],ymm9[3],ymm2[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm6 = ymm7[2],ymm8[2],ymm7[3],ymm8[3],ymm7[6],ymm8[6],ymm7[7],ymm8[7]
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %ymm4
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm11[3,0],ymm10[3,0],ymm11[7,4],ymm10[7,4]
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %ymm5
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm7[2,0],ymm6[2,3],ymm7[6,4],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %ymm6
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm2[2],ymm9[2],ymm2[3],ymm9[3],ymm2[6],ymm9[6],ymm2[7],ymm9[7]
; AVX1-ONLY-NEXT:    vmovaps 64(%r10), %ymm2
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %ymm0
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm8, %xmm8
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm1[0,1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm7[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm1 = ymm0[0],ymm2[0],ymm0[2],ymm2[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[0,1],ymm1[2,0],ymm7[4,5],ymm1[6,4]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm7[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[4],ymm0[4],ymm2[5],ymm0[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm6[1,0],ymm5[1,0],ymm6[5,4],ymm5[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[2,0],ymm1[2,3],ymm7[6,4],ymm1[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm4[1,0],ymm3[1,0],ymm4[5,4],ymm3[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm7[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm0[1],ymm2[1],ymm0[3],ymm2[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm5[2],ymm6[2],ymm5[3],ymm6[3],ymm5[6],ymm6[6],ymm5[7],ymm6[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm7[0,1],ymm1[2,0],ymm7[4,5],ymm1[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm7[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[6],ymm0[6],ymm2[7],ymm0[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm1 = ymm6[3,0],ymm5[3,0],ymm6[7,4],ymm5[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm1[2,0],ymm0[2,3],ymm1[6,4],ymm0[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm5 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %ymm0
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm3 = ymm4[3,0],ymm3[3,0],ymm4[7,4],ymm3[7,4]
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %ymm1
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm5, %xmm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vmovaps 96(%r10), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rax), %ymm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm3[0,1],ymm2[2,0],ymm3[4,5],ymm2[6,4]
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %ymm2
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %ymm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[2,0],ymm6[2,3],ymm7[6,4],ymm6[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm3[1,0],ymm2[1,0],ymm3[5,4],ymm2[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm5[1],ymm4[1],ymm5[3],ymm4[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,0],ymm7[4,5],ymm6[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,0],ymm4[2,3],ymm0[6,4],ymm4[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm1 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[3,0],ymm2[3,0],ymm3[7,4],ymm2[7,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r8), %ymm2
; AVX1-ONLY-NEXT:    vmovaps 128(%r9), %ymm3
; AVX1-ONLY-NEXT:    vmovaps 128(%r10), %ymm4
; AVX1-ONLY-NEXT:    vmovaps 128(%rax), %ymm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm1[0,1],ymm0[2,0],ymm1[4,5],ymm0[6,4]
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vmovaps 128(%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 128(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm3[1,0],ymm2[1,0],ymm3[5,4],ymm2[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[2,0],ymm6[2,3],ymm7[6,4],ymm6[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm5[1],ymm4[1],ymm5[3],ymm4[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,0],ymm7[4,5],ymm6[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[3,0],ymm2[3,0],ymm3[7,4],ymm2[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[2,0],ymm4[2,3],ymm2[6,4],ymm4[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm3 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%r8), %ymm2
; AVX1-ONLY-NEXT:    vmovaps 160(%r9), %ymm3
; AVX1-ONLY-NEXT:    vmovaps 160(%r10), %ymm4
; AVX1-ONLY-NEXT:    vmovaps 160(%rax), %ymm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm1[0,1],ymm0[2,0],ymm1[4,5],ymm0[6,4]
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vmovaps 160(%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 160(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm3[1,0],ymm2[1,0],ymm3[5,4],ymm2[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[2,0],ymm6[2,3],ymm7[6,4],ymm6[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm5[1],ymm4[1],ymm5[3],ymm4[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,0],ymm7[4,5],ymm6[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[3,0],ymm2[3,0],ymm3[7,4],ymm2[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[2,0],ymm4[2,3],ymm2[6,4],ymm4[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm3 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%r8), %ymm2
; AVX1-ONLY-NEXT:    vmovaps 192(%r9), %ymm3
; AVX1-ONLY-NEXT:    vmovaps 192(%r10), %ymm4
; AVX1-ONLY-NEXT:    vmovaps 192(%rax), %ymm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm1[0,1],ymm0[2,0],ymm1[4,5],ymm0[6,4]
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vmovaps 192(%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 192(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm3[1,0],ymm2[1,0],ymm3[5,4],ymm2[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[2,0],ymm6[2,3],ymm7[6,4],ymm6[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm5[1],ymm4[1],ymm5[3],ymm4[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,0],ymm7[4,5],ymm6[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[3,0],ymm2[3,0],ymm3[7,4],ymm2[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[2,0],ymm4[2,3],ymm2[6,4],ymm4[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm3 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 224(%r8), %ymm2
; AVX1-ONLY-NEXT:    vmovaps 224(%r9), %ymm3
; AVX1-ONLY-NEXT:    vmovaps 224(%r10), %ymm4
; AVX1-ONLY-NEXT:    vmovaps 224(%rax), %ymm5
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm1[0,1],ymm0[2,0],ymm1[4,5],ymm0[6,4]
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vmovaps 224(%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovaps 224(%rcx), %ymm9
; AVX1-ONLY-NEXT:    vunpcklpd {{.*#+}} ymm10 = ymm9[0],ymm8[0],ymm9[2],ymm8[2]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm7 = ymm3[1,0],ymm2[1,0],ymm3[5,4],ymm2[5,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[2,0],ymm6[2,3],ymm7[6,4],ymm6[6,7]
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} ymm7 = ymm8[0],ymm9[0],ymm8[1],ymm9[1],ymm8[4],ymm9[4],ymm8[5],ymm9[5]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm10 = ymm1[1,0],ymm0[1,0],ymm1[5,4],ymm0[5,4]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm5[1],ymm4[1],ymm5[3],ymm4[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,0],ymm7[4,5],ymm6[6,4]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm7 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm9[1],ymm8[1],ymm9[3],ymm8[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,1,2,0,4,5,6,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm10, %xmm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm7[0,1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm3[3,0],ymm2[3,0],ymm3[7,4],ymm2[7,4]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[2,0],ymm4[2,3],ymm2[6,4],ymm4[6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} ymm3 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} ymm0 = ymm1[3,0],ymm0[3,0],ymm1[7,4],ymm0[7,4]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[2,0,2,3,6,4,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps (%r9), %xmm2
; AVX1-ONLY-NEXT:    vmovaps (%r8), %xmm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vmovaps (%rax), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%r10), %xmm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps (%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps (%rdx), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm10
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm11[0],xmm8[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm11[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm10[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0],xmm9[1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm4[0,1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm8 = xmm3[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0],xmm2[1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm0[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm1[0,1,2],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm6[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm7[0,1,2],xmm5[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm4[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm4[1],xmm3[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 32(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 32(%r8), %xmm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 32(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 32(%r10), %xmm4
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 32(%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 32(%rdx), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm11[0],xmm8[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm11[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm10[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0],xmm9[1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm8 = xmm1[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0],xmm0[1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm3[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm4[0,1,2],xmm1[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm6[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm7[0,1,2],xmm5[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm2[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm2[1],xmm1[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 64(%r8), %xmm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 64(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 64(%r10), %xmm4
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 64(%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 64(%rdx), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm11[0],xmm8[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm11[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm10[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0],xmm9[1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm8 = xmm1[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0],xmm0[1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm3[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm4[0,1,2],xmm1[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm6[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm7[0,1,2],xmm5[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm2[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm2[1],xmm1[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 96(%r8), %xmm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 96(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 96(%r10), %xmm4
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 96(%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 96(%rdx), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm10
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm10[0],xmm9[0],xmm10[1],xmm9[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm11[0],xmm8[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm11[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm10[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0],xmm9[1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm2[0,1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm8 = xmm1[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0],xmm0[1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm10[2],xmm9[2],xmm10[3],xmm9[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm3[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm4[0,1,2],xmm1[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm6[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm7[0,1,2],xmm5[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm2[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm2[1],xmm1[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%r9), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 128(%r8), %xmm1
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 128(%rax), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 128(%r10), %xmm4
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm2[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 128(%rcx), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 128(%rdx), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm2
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm2[0],xmm9[0],xmm2[1],xmm9[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm11[0],xmm8[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm11[0,1,2,3],ymm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm2[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm9[1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm10[0,1],xmm8[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm1[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm0[1],xmm10[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm10[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm2[2],xmm9[2],xmm2[3],xmm9[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm3[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm4[0,1,2],xmm1[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm6[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm7[0,1,2],xmm5[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm2[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm2[1],xmm1[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%r9), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 160(%r8), %xmm4
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm4[0],xmm7[0],xmm4[1],xmm7[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 160(%rax), %xmm9
; AVX1-ONLY-NEXT:    vmovaps 160(%r10), %xmm8
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm8[0],xmm9[0],xmm8[1],xmm9[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm2[0,1,2,3,4,5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 160(%rcx), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 160(%rdx), %xmm2
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm15 = xmm15[0],xmm6[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm15[0,1,2,3],ymm10[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm10, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm15 = xmm0[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0],xmm1[1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm15[0,1],xmm6[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm15 = xmm4[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm15 = xmm15[0],xmm7[1],xmm15[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm15[0,1,2,3,4,5],ymm5[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm6[0,1,2,3],ymm5[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm4[2],xmm7[2],xmm4[3],xmm7[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm9[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm8[0,1,2],xmm4[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm3[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm2[0,1,2],xmm5[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm0[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1,2,3],ymm4[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm8[2],xmm9[2],xmm8[3],xmm9[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 192(%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 192(%r8), %xmm4
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vmovaps 192(%rax), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 192(%r10), %xmm8
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm9[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vmovaps 192(%rcx), %xmm15
; AVX1-ONLY-NEXT:    vmovaps 192(%rdx), %xmm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm15[0],xmm3[1],xmm15[1]
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm14 = xmm14[0],xmm2[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm14[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm0[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm14 = xmm14[0],xmm1[1],xmm14[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm14[0,1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm9
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm4[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm14 = xmm14[0],xmm5[1],xmm14[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm14[0,1,2,3,4,5],ymm9[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm2[0,1,2,3],ymm9[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm7[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm1 = xmm8[0,1,2],xmm1[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3,4,5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm4 = xmm15[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm3[0,1,2],xmm4[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm4 = xmm0[0,1],xmm4[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm3[2],xmm15[2],xmm3[3],xmm15[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX1-ONLY-NEXT:    vmovaps 224(%r9), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 224(%r8), %xmm3
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm3[0],xmm5[0],xmm3[1],xmm5[1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovaps 224(%rax), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 224(%r10), %xmm7
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm7[0],xmm4[0],xmm7[1],xmm4[1]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm8[0,1,0,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm14
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm0[0,1,2,3,4,5],ymm14[6,7]
; AVX1-ONLY-NEXT:    vmovaps 224(%rcx), %xmm14
; AVX1-ONLY-NEXT:    vmovaps 224(%rdx), %xmm15
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm13 = xmm13[0],xmm2[0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm13[0,1,2,3],ymm6[4,5,6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = xmm0[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm13[0],xmm1[1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm2 = xmm13[0,1],xmm2[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm13 = xmm3[1,1,1,1]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm13 = xmm13[0],xmm5[1],xmm13[2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1,2,3,4,5],ymm8[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm8[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm5[2],xmm3[3],xmm5[3]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm3 = xmm4[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm3 = xmm7[0,1,2],xmm3[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3,4,5],ymm3[6,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm14[2,2,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm15[0,1,2],xmm5[3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm0[0,1],xmm5[2,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; AVX1-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm7[2],xmm4[2],xmm7[3],xmm4[3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm4
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX1-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1888(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 1856(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 1824(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 1792(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, 1632(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 1600(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 1568(%rax)
; AVX1-ONLY-NEXT:    vmovaps %ymm12, 1536(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1312(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1120(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 2016(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1984(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1952(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1920(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1696(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1440(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX1-ONLY-NEXT:    addq $1672, %rsp # imm = 0x688
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-ONLY-LABEL: store_i32_stride8_vf64:
; AVX2-ONLY:       # %bb.0:
; AVX2-ONLY-NEXT:    subq $1672, %rsp # imm = 0x688
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdi), %ymm0
; AVX2-ONLY-NEXT:    vmovdqa (%rdi), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 32(%rsi), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa (%rsi), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 32(%rdx), %ymm2
; AVX2-ONLY-NEXT:    vmovdqa (%rdx), %ymm6
; AVX2-ONLY-NEXT:    vmovdqa 32(%rcx), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa (%rcx), %ymm7
; AVX2-ONLY-NEXT:    vmovdqa (%r8), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa (%r9), %ymm11
; AVX2-ONLY-NEXT:    vmovdqa (%r10), %ymm10
; AVX2-ONLY-NEXT:    vmovdqa (%rax), %ymm12
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm9 = ymm10[0],ymm12[0],ymm10[1],ymm12[1],ymm10[4],ymm12[4],ymm10[5],ymm12[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm13 = ymm8[0],ymm11[0],ymm8[1],ymm11[1],ymm8[4],ymm11[4],ymm8[5],ymm11[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm13 = ymm13[0],ymm9[0],ymm13[2],ymm9[2]
; AVX2-ONLY-NEXT:    vpbroadcastd 16(%rsi), %xmm14
; AVX2-ONLY-NEXT:    vpbroadcastd 16(%rdi), %ymm15
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm15 = ymm6[0],ymm7[0],ymm6[1],ymm7[1],ymm6[4],ymm7[4],ymm6[5],ymm7[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm15 = ymm15[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm14 = xmm14[0,1],xmm15[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm14[0,1,2,3],ymm13[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 20(%r8), %ymm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3,4],ymm11[5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],ymm9[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm9 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 20(%rcx), %ymm14
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm9 = xmm9[0,1,2],xmm14[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm14 = ymm4[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm14 = ymm14[0],ymm5[1],ymm14[2,3,4],ymm5[5],ymm14[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm14, %xmm14
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm14 = xmm14[0,1],xmm9[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 32(%r8), %ymm9
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm14[0,1,2,3],ymm13[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm13, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 24(%rax), %ymm13
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm10[0,1,2,3,4,5,6],ymm13[7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%r9), %ymm10
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm11 = ymm8[2],ymm11[2],ymm8[3],ymm11[3],ymm8[6],ymm11[6],ymm8[7],ymm11[7]
; AVX2-ONLY-NEXT:    vmovdqa 32(%r10), %ymm8
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm5
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm7 = ymm6[2],ymm7[2],ymm6[3],ymm7[3],ymm6[6],ymm7[6],ymm6[7],ymm7[7]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm6 = ymm7[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 32(%rax), %ymm6
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm13 = ymm11[0,1,2,3,4,5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm13[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 28(%r10), %ymm5
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm5 = ymm5[2],ymm12[2],ymm5[3],ymm12[3],ymm5[6],ymm12[6],ymm5[7],ymm12[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm5 = ymm11[1],ymm5[1],ymm11[3],ymm5[3]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm4 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm4 = ymm8[0],ymm6[0],ymm8[1],ymm6[1],ymm8[4],ymm6[4],ymm8[5],ymm6[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm5 = ymm9[0],ymm10[0],ymm9[1],ymm10[1],ymm9[4],ymm10[4],ymm9[5],ymm10[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm5 = ymm5[0],ymm4[0],ymm5[2],ymm4[2]
; AVX2-ONLY-NEXT:    vpbroadcastd 48(%rsi), %xmm7
; AVX2-ONLY-NEXT:    vpbroadcastd 48(%rdi), %ymm11
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm7 = xmm11[0],xmm7[0],xmm11[1],xmm7[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm11 = ymm2[0],ymm3[0],ymm2[1],ymm3[1],ymm2[4],ymm3[4],ymm2[5],ymm3[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm11 = ymm11[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1],xmm11[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm7[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 52(%r8), %ymm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4],ymm10[5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm4[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm4 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 52(%rcx), %ymm7
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm4 = xmm4[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm7 = ymm0[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm7 = ymm7[0],ymm1[1],ymm7[2,3,4],ymm1[5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm7, %xmm7
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1],xmm4[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdx), %ymm4
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm5 = ymm7[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 56(%rax), %ymm5
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5,6],ymm5[7]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rcx), %ymm5
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm9 = ymm9[2],ymm10[2],ymm9[3],ymm10[3],ymm9[6],ymm10[6],ymm9[7],ymm10[7]
; AVX2-ONLY-NEXT:    vmovdqa 64(%r8), %ymm7
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm10 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm0
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm2[2],ymm3[2],ymm2[3],ymm3[3],ymm2[6],ymm3[6],ymm2[7],ymm3[7]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm1 = ymm3[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 64(%r9), %ymm1
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm9[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 60(%r10), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm0[2],ymm6[2],ymm0[3],ymm6[3],ymm0[6],ymm6[6],ymm0[7],ymm6[7]
; AVX2-ONLY-NEXT:    vmovdqa 64(%r10), %ymm2
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm9[1],ymm0[1],ymm9[3],ymm0[3]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rax), %ymm0
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm8 = ymm10[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm8, %xmm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm8[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 80(%rsi), %xmm3
; AVX2-ONLY-NEXT:    vpbroadcastd 80(%rdi), %ymm6
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm3 = xmm6[0],xmm3[0],xmm6[1],xmm3[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm6 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm6 = ymm6[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm3[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm6 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[4],ymm0[4],ymm2[5],ymm0[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm7[0],ymm1[0],ymm7[1],ymm1[1],ymm7[4],ymm1[4],ymm7[5],ymm1[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm8[0],ymm6[0],ymm8[2],ymm6[2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 84(%r8), %ymm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4],ymm1[5],ymm3[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm6 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 84(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm6 = xmm6[0,1,2],xmm8[3]
; AVX2-ONLY-NEXT:    vmovdqa 64(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 64(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm10 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm9[1],ymm10[2,3,4],ymm9[5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm6 = xmm10[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1,2,3],ymm3[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 88(%rax), %ymm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5,6],ymm3[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm7[2],ymm1[2],ymm7[3],ymm1[3],ymm7[6],ymm1[6],ymm7[7],ymm1[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm3, %xmm5
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm6 = ymm4[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm5 = xmm5[0,1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 92(%r10), %ymm2
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm2 = ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[6],ymm0[6],ymm2[7],ymm0[7]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdx), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rcx), %ymm1
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm3 = ymm3[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm3, %xmm3
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 112(%rsi), %xmm2
; AVX2-ONLY-NEXT:    vpbroadcastd 112(%rdi), %ymm3
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 96(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 96(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 96(%r10), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 96(%rax), %ymm6
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm7 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 116(%r8), %ymm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4],ymm4[5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 116(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1,2],xmm8[3]
; AVX2-ONLY-NEXT:    vmovdqa 96(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 96(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm10 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm9[1],ymm10[2,3,4],ymm9[5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm7[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 120(%rax), %ymm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0,1,2,3,4,5,6],ymm2[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm1
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm5 = ymm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0,1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm2 = ymm3[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 124(%r10), %ymm1
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm1[2],ymm6[2],ymm1[3],ymm6[3],ymm1[6],ymm6[6],ymm1[7],ymm6[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm3[1],ymm1[1],ymm3[3],ymm1[3]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm2[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 144(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vpbroadcastd 144(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vmovdqa 128(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa 128(%rcx), %ymm2
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 128(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 128(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 128(%r10), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 128(%rax), %ymm6
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm7 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 148(%r8), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm4[5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 148(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1,2],xmm8[3]
; AVX2-ONLY-NEXT:    vmovdqa 128(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 128(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm10 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm9[1],ymm10[2,3,4],ymm9[5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 152(%rax), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5,6],ymm0[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm2
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm5 = ymm1[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 156(%r10), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm0[2],ymm6[2],ymm0[3],ymm6[3],ymm0[6],ymm6[6],ymm0[7],ymm6[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 176(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vpbroadcastd 176(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa 160(%rcx), %ymm2
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 160(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 160(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 160(%r10), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 160(%rax), %ymm6
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm7 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 180(%r8), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm4[5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 180(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1,2],xmm8[3]
; AVX2-ONLY-NEXT:    vmovdqa 160(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 160(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm10 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm9[1],ymm10[2,3,4],ymm9[5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 184(%rax), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5,6],ymm0[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm2
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm5 = ymm1[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 188(%r10), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm0[2],ymm6[2],ymm0[3],ymm6[3],ymm0[6],ymm6[6],ymm0[7],ymm6[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 208(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vpbroadcastd 208(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa 192(%rcx), %ymm2
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 192(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 192(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 192(%r10), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 192(%rax), %ymm6
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm7 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 212(%r8), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm4[5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 212(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1,2],xmm8[3]
; AVX2-ONLY-NEXT:    vmovdqa 192(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 192(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm10 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm9[1],ymm10[2,3,4],ymm9[5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 216(%rax), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5,6],ymm0[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm2
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm5 = ymm1[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 220(%r10), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm0[2],ymm6[2],ymm0[3],ymm6[3],ymm0[6],ymm6[6],ymm0[7],ymm6[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 240(%rsi), %xmm0
; AVX2-ONLY-NEXT:    vpbroadcastd 240(%rdi), %ymm1
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vmovdqa 224(%rdx), %ymm1
; AVX2-ONLY-NEXT:    vmovdqa 224(%rcx), %ymm2
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm3 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,3]
; AVX2-ONLY-NEXT:    vmovdqa 224(%r8), %ymm3
; AVX2-ONLY-NEXT:    vmovdqa 224(%r9), %ymm4
; AVX2-ONLY-NEXT:    vmovdqa 224(%r10), %ymm5
; AVX2-ONLY-NEXT:    vmovdqa 224(%rax), %ymm6
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm7 = ymm5[0],ymm6[0],ymm5[1],ymm6[1],ymm5[4],ymm6[4],ymm5[5],ymm6[5]
; AVX2-ONLY-NEXT:    vpunpckldq {{.*#+}} ymm8 = ymm3[0],ymm4[0],ymm3[1],ymm4[1],ymm3[4],ymm4[4],ymm3[5],ymm4[5]
; AVX2-ONLY-NEXT:    vpunpcklqdq {{.*#+}} ymm8 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 244(%r8), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4],ymm4[5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vpmovzxdq {{.*#+}} xmm7 = mem[0],zero,mem[1],zero
; AVX2-ONLY-NEXT:    vpbroadcastd 244(%rcx), %ymm8
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm7[0,1,2],xmm8[3]
; AVX2-ONLY-NEXT:    vmovdqa 224(%rdi), %ymm8
; AVX2-ONLY-NEXT:    vmovdqa 224(%rsi), %ymm9
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm10 = ymm8[1,1,1,1,5,5,5,5]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm10 = ymm10[0],ymm9[1],ymm10[2,3,4],ymm9[5],ymm10[6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm10, %xmm10
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm7 = xmm10[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 248(%rax), %ymm0
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm5[0,1,2,3,4,5,6],ymm0[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm3 = ymm3[2],ymm4[2],ymm3[3],ymm4[3],ymm3[6],ymm4[6],ymm3[7],ymm4[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm4 = ymm8[2],ymm9[2],ymm8[3],ymm9[3],ymm8[6],ymm9[6],ymm8[7],ymm9[7]
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm1 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm4, %xmm2
; AVX2-ONLY-NEXT:    vpermq {{.*#+}} ymm5 = ymm1[2,2,2,2]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0,1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1,2,3,4,5],ymm0[6,7]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpbroadcastd 252(%r10), %ymm0
; AVX2-ONLY-NEXT:    vpunpckhdq {{.*#+}} ymm0 = ymm0[2],ymm6[2],ymm0[3],ymm6[3],ymm0[6],ymm6[6],ymm0[7],ymm6[7]
; AVX2-ONLY-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-ONLY-NEXT:    vpshufd {{.*#+}} ymm2 = ymm4[2,3,2,3,6,7,6,7]
; AVX2-ONLY-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} xmm1 = xmm2[0,1],xmm1[2,3]
; AVX2-ONLY-NEXT:    vpblendd {{.*#+}} ymm0 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps (%rcx), %xmm0
; AVX2-ONLY-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-ONLY-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps (%rsi), %xmm3
; AVX2-ONLY-NEXT:    vmovaps (%rdi), %xmm4
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm5[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps (%rax), %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vmovaps (%r10), %xmm5
; AVX2-ONLY-NEXT:    vbroadcastss %xmm5, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps (%r9), %xmm8
; AVX2-ONLY-NEXT:    vmovaps (%r8), %xmm9
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm4[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0],xmm3[1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm5[0],xmm2[0],xmm5[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm9[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm8[1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm5[0,1,2],xmm6[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm3[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm3[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm5[2],xmm2[2],xmm5[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm4[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 32(%rcx), %xmm0
; AVX2-ONLY-NEXT:    vmovaps 32(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps 32(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps 32(%rax), %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vmovaps 32(%r10), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps 32(%r8), %xmm8
; AVX2-ONLY-NEXT:    vmovaps 32(%r9), %xmm9
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm8[0],xmm9[0],xmm8[1],xmm9[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0],xmm4[1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm8[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm9[1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm8[2],xmm9[2],xmm8[3],xmm9[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1,2],xmm6[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm5[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 64(%rcx), %xmm0
; AVX2-ONLY-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 64(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps 64(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps 64(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 64(%r10), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps 64(%r8), %xmm8
; AVX2-ONLY-NEXT:    vmovaps 64(%r9), %xmm9
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm8[0],xmm9[0],xmm8[1],xmm9[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0],xmm4[1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm8[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm9[1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm8[2],xmm9[2],xmm8[3],xmm9[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1,2],xmm6[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm5[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 96(%rcx), %xmm0
; AVX2-ONLY-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-ONLY-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 96(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps 96(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps 96(%rax), %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vmovaps 96(%r10), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps 96(%r9), %xmm8
; AVX2-ONLY-NEXT:    vmovaps 96(%r8), %xmm9
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0],xmm4[1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm9[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm8[1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1,2],xmm6[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm5[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 128(%rcx), %xmm0
; AVX2-ONLY-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-ONLY-NEXT:    vmovaps 128(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 128(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps 128(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps 128(%rax), %xmm2
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vmovaps 128(%r10), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps 128(%r9), %xmm8
; AVX2-ONLY-NEXT:    vmovaps 128(%r8), %xmm9
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0],xmm4[1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm9[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm8[1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1,2],xmm6[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm5[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 160(%rcx), %xmm0
; AVX2-ONLY-NEXT:    vbroadcastss %xmm0, %xmm2
; AVX2-ONLY-NEXT:    vmovaps 160(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 160(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps 160(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps 160(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 160(%r10), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps 160(%r9), %xmm8
; AVX2-ONLY-NEXT:    vmovaps 160(%r8), %xmm9
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm5[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0],xmm4[1],xmm6[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm10 = xmm9[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm10 = xmm10[0],xmm8[1],xmm10[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm10, %ymm0, %ymm10
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm10[0,1,2,3,4,5],ymm7[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm6 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm6 = xmm3[0,1,2],xmm6[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3,4,5],ymm6[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm0[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1,2,3],ymm6[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm4[1],xmm0[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm2 = xmm5[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-ONLY-NEXT:    vmovaps 192(%rcx), %xmm6
; AVX2-ONLY-NEXT:    vbroadcastss %xmm6, %xmm2
; AVX2-ONLY-NEXT:    vmovaps 192(%rdx), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm3
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vmovaps 192(%rsi), %xmm4
; AVX2-ONLY-NEXT:    vmovaps 192(%rdi), %xmm5
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm9 = xmm3[0,1],xmm2[2,3]
; AVX2-ONLY-NEXT:    vmovaps 192(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 192(%r10), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm7
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm8
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm8[0],xmm7[0],xmm8[1],xmm7[1]
; AVX2-ONLY-NEXT:    vmovaps 192(%r9), %xmm0
; AVX2-ONLY-NEXT:    vmovaps 192(%r8), %xmm7
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm7[0],xmm0[0],xmm7[1],xmm0[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm15[0,1,2,3,4,5],ymm8[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm9[0,1,2,3],ymm8[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm8 = xmm5[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0],xmm4[1],xmm8[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm1[0],xmm6[0],xmm1[1],xmm6[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm8 = xmm8[0,1],xmm15[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm15 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm14 = xmm7[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm14 = xmm14[0],xmm0[1],xmm14[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm14
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm8[0,1,2,3],ymm14[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm7[2],xmm0[2],xmm7[3],xmm0[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm3[0,1,2],xmm5[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm7
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1,2,3,4,5],ymm5[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm7 = xmm6[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm1[0,1,2],xmm7[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm7 = xmm4[0,1],xmm7[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm7[0,1,2,3],ymm5[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],xmm6[2],xmm1[3],xmm6[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm1[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm2[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm1[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    vmovaps 224(%rcx), %xmm4
; AVX2-ONLY-NEXT:    vbroadcastss %xmm4, %xmm0
; AVX2-ONLY-NEXT:    vmovaps 224(%rdx), %xmm3
; AVX2-ONLY-NEXT:    vbroadcastss %xmm3, %xmm1
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-ONLY-NEXT:    vmovaps 224(%rsi), %xmm6
; AVX2-ONLY-NEXT:    vmovaps 224(%rdi), %xmm14
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm14[0],xmm6[0],xmm14[1],xmm6[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm1[0,1],xmm0[2,3]
; AVX2-ONLY-NEXT:    vmovaps 224(%rax), %xmm2
; AVX2-ONLY-NEXT:    vmovaps 224(%r10), %xmm1
; AVX2-ONLY-NEXT:    vbroadcastss %xmm2, %xmm15
; AVX2-ONLY-NEXT:    vbroadcastss %xmm1, %xmm13
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm13[0],xmm15[0],xmm13[1],xmm15[1]
; AVX2-ONLY-NEXT:    vmovaps 224(%r9), %xmm15
; AVX2-ONLY-NEXT:    vmovaps 224(%r8), %xmm0
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm0[0],xmm15[0],xmm0[1],xmm15[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm13
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3,4,5],ymm13[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm13 = ymm5[0,1,2,3],ymm12[4,5,6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm5 = xmm14[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0],xmm6[1],xmm5[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm5 = xmm5[0,1],xmm12[2,3]
; AVX2-ONLY-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm0, %ymm12
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm11 = xmm0[1,1,1,1]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm11 = xmm11[0],xmm15[1],xmm11[2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],ymm12[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm14[2],xmm6[2],xmm14[3],xmm6[3]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm15[2],xmm0[3],xmm15[3]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm11 = xmm2[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm11 = xmm1[0,1,2],xmm11[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm11, %ymm0, %ymm11
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm12
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0,1,2,3,4,5],ymm11[6,7]
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm12 = xmm4[2,2,2,2]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm12 = xmm3[0,1,2],xmm12[3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} xmm12 = xmm6[0,1],xmm12[2,3]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0,1,2,3],ymm11[4,5,6,7]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; AVX2-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm6[1],xmm3[1]
; AVX2-ONLY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],xmm2[2],xmm1[3],xmm2[3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-ONLY-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX2-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1,2,3],ymm0[4,5,6,7]
; AVX2-ONLY-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1888(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm11, 1856(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm5, 1824(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm13, 1792(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm7, 1632(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm8, 1600(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm9, 1568(%rax)
; AVX2-ONLY-NEXT:    vmovaps %ymm10, 1536(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1312(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1120(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 2016(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1984(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1952(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1920(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1696(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1440(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-ONLY-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-ONLY-NEXT:    addq $1672, %rsp # imm = 0x688
; AVX2-ONLY-NEXT:    vzeroupper
; AVX2-ONLY-NEXT:    retq
;
; AVX512F-LABEL: store_i32_stride8_vf64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    subq $6152, %rsp # imm = 0x1808
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512F-NEXT:    vmovdqa64 (%r10), %zmm5
; AVX512F-NEXT:    vmovdqa64 64(%r10), %zmm4
; AVX512F-NEXT:    vmovdqa64 128(%r10), %zmm2
; AVX512F-NEXT:    vmovdqa64 (%rax), %zmm0
; AVX512F-NEXT:    vmovdqa64 64(%rax), %zmm1
; AVX512F-NEXT:    vmovdqa64 128(%rax), %zmm24
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,u,u,u,u,u,0,16,u,u,u,u,u,u,1,17>
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm7
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm3, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,u,u,u,u,2,18,u,u,u,u,u,u,3,19>
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm7
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm5, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,u,u,u,u,4,20,u,u,u,u,u,u,5,21>
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm7, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,u,u,u,u,u,6,22,u,u,u,u,u,u,7,23>
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm8, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,u,u,u,u,8,24,u,u,u,u,u,u,9,25>
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm9, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,u,u,u,u,10,26,u,u,u,u,u,u,11,27>
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm10, %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,u,u,u,u,12,28,u,u,u,u,u,u,13,29>
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm11, %zmm12
; AVX512F-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm26 = <u,u,u,u,u,u,14,30,u,u,u,u,u,u,15,31>
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm26, %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm3, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm5, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm7, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm8, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm9, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm10, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm11, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm1, %zmm26, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm24, %zmm3, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm24, %zmm5, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm24, %zmm7, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm24, %zmm8, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm24, %zmm9, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm24, %zmm10, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm24, %zmm11, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm24, %zmm26, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 192(%r10), %zmm1
; AVX512F-NEXT:    vmovdqa64 192(%rax), %zmm0
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm26, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 (%r8), %zmm25
; AVX512F-NEXT:    vmovdqa64 (%r9), %zmm0
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,u,u,0,16,u,u,u,u,u,u,1,17,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm2
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,u,u,u,2,18,u,u,u,u,u,u,3,19,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm3, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,4,20,u,u,u,u,u,u,5,21,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm4, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,u,u,6,22,u,u,u,u,u,u,7,23,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm5, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <u,u,u,u,8,24,u,u,u,u,u,u,9,25,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm6, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,u,u,10,26,u,u,u,u,u,u,11,27,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm7, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,u,u,u,12,28,u,u,u,u,u,u,13,29,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm8, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,u,u,14,30,u,u,u,u,u,u,15,31,u,u>
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm25
; AVX512F-NEXT:    vmovdqa64 64(%r8), %zmm24
; AVX512F-NEXT:    vmovdqa64 64(%r9), %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm2, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm3, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm4, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm5, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm6, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm7, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm8, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm24
; AVX512F-NEXT:    vmovdqa64 128(%r8), %zmm19
; AVX512F-NEXT:    vmovdqa64 128(%r9), %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm2, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm3, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm4, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm5, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm6, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm7, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm8, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm19
; AVX512F-NEXT:    vmovdqa64 192(%r8), %zmm23
; AVX512F-NEXT:    vmovdqa64 192(%r9), %zmm0
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm23, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm23, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm23, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm23, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm23, %zmm6
; AVX512F-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm23, %zmm7
; AVX512F-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm23, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm23
; AVX512F-NEXT:    vmovdqa64 (%rdx), %zmm7
; AVX512F-NEXT:    vmovdqa64 (%rcx), %zmm0
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,0,16,u,u,u,u,u,u,1,17,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm31
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm31
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,u,2,18,u,u,u,u,u,u,3,19,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm3, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,4,20,u,u,u,u,u,u,5,21,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm4, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,6,22,u,u,u,u,u,u,7,23,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm5, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,u,8,24,u,u,u,u,u,u,9,25,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm8, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,10,26,u,u,u,u,u,u,11,27,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm9, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,12,28,u,u,u,u,u,u,13,29,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm11, %zmm1
; AVX512F-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,14,30,u,u,u,u,u,u,15,31,u,u,u,u>
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm7
; AVX512F-NEXT:    vmovdqa64 64(%rdx), %zmm6
; AVX512F-NEXT:    vmovdqa64 64(%rcx), %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm2, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm3, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm4, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm5, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm8, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm9, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm11, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm6
; AVX512F-NEXT:    vmovdqa64 128(%rdx), %zmm14
; AVX512F-NEXT:    vmovdqa64 128(%rcx), %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm2, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm3, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm4, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm5, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm8, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm9, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm11, %zmm10
; AVX512F-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm14
; AVX512F-NEXT:    vmovdqa64 192(%rdx), %zmm17
; AVX512F-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm17, %zmm2
; AVX512F-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm17, %zmm3
; AVX512F-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm17, %zmm4
; AVX512F-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm17, %zmm5
; AVX512F-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm17, %zmm8
; AVX512F-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm17, %zmm9
; AVX512F-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm17, %zmm11
; AVX512F-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm1, %zmm17
; AVX512F-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512F-NEXT:    vmovdqa64 (%rsi), %zmm12
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <0,16,u,u,u,u,u,u,1,17,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm12, %zmm15, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <2,18,u,u,u,u,u,u,3,19,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm12, %zmm11, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <4,20,u,u,u,u,u,u,5,21,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm12, %zmm10, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <6,22,u,u,u,u,u,u,7,23,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm12, %zmm9, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <8,24,u,u,u,u,u,u,9,25,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm12, %zmm8, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <10,26,u,u,u,u,u,u,11,27,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm12, %zmm4, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <12,28,u,u,u,u,u,u,13,29,u,u,u,u,u,u>
; AVX512F-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm12, %zmm3, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <14,30,u,u,u,u,u,u,15,31,u,u,u,u,u,u>
; AVX512F-NEXT:    vpermt2d %zmm12, %zmm2, %zmm5
; AVX512F-NEXT:    vmovdqa64 64(%rdi), %zmm12
; AVX512F-NEXT:    vmovdqa64 64(%rsi), %zmm13
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm15, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm11, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm10, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm9, %zmm0
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm30
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm8, %zmm30
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm4, %zmm29
; AVX512F-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm3, %zmm28
; AVX512F-NEXT:    vpermt2d %zmm13, %zmm2, %zmm12
; AVX512F-NEXT:    vmovdqa64 128(%rdi), %zmm16
; AVX512F-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm27
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm15, %zmm27
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm26
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm11, %zmm26
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm22
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm10, %zmm22
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm21
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm9, %zmm21
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm20
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm8, %zmm20
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm18
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm4, %zmm18
; AVX512F-NEXT:    vmovdqa64 %zmm16, %zmm13
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm3, %zmm13
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm2, %zmm16
; AVX512F-NEXT:    vmovdqa64 192(%rdi), %zmm1
; AVX512F-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm15
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm11
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm10
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm9
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm8
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm4
; AVX512F-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512F-NEXT:    vpermt2d %zmm0, %zmm2, %zmm1
; AVX512F-NEXT:    movb $-120, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    movb $34, %al
; AVX512F-NEXT:    kmovw %eax, %k2
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512F-NEXT:    movb $-52, %al
; AVX512F-NEXT:    kmovw %eax, %k3
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512F-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm5 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm25, %zmm5 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm0 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512F-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm0 {%k3}
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm31 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm30 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm29 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm28 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm7, %zmm28 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm12 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm24, %zmm12 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm27 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm26 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm22 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm21 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm20 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm18 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm13 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm14, %zmm16 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm19, %zmm16 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm15 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm11 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm10 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm9 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm8 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm4 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k3}
; AVX512F-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm17, %zmm1 {%k2}
; AVX512F-NEXT:    vmovdqa64 %zmm23, %zmm1 {%k3}
; AVX512F-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512F-NEXT:    vmovdqa64 %zmm1, 1984(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm3, 1920(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm4, 1856(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm8, 1792(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm9, 1728(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm10, 1664(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm11, 1600(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm15, 1536(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm16, 1472(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm13, 1408(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm18, 1344(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm20, 1280(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm21, 1216(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm22, 1152(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm26, 1088(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm27, 1024(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm12, 960(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm28, 896(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm29, 832(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm30, 768(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm31, 704(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm2, 640(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm25, 576(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 512(%rax)
; AVX512F-NEXT:    vmovdqa64 %zmm5, 448(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512F-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 192(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512F-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vmovaps %zmm0, (%rax)
; AVX512F-NEXT:    addq $6152, %rsp # imm = 0x1808
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride8_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $6152, %rsp # imm = 0x1808
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %r10
; AVX512BW-NEXT:    vmovdqa64 (%r10), %zmm5
; AVX512BW-NEXT:    vmovdqa64 64(%r10), %zmm4
; AVX512BW-NEXT:    vmovdqa64 128(%r10), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rax), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rax), %zmm1
; AVX512BW-NEXT:    vmovdqa64 128(%rax), %zmm24
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,u,u,u,u,u,0,16,u,u,u,u,u,u,1,17>
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm6
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm3, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,u,u,u,u,2,18,u,u,u,u,u,u,3,19>
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm7
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm5, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,u,u,u,u,4,20,u,u,u,u,u,u,5,21>
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm8
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm7, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,u,u,u,u,u,6,22,u,u,u,u,u,u,7,23>
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,u,u,u,u,8,24,u,u,u,u,u,u,9,25>
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm9, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <u,u,u,u,u,u,10,26,u,u,u,u,u,u,11,27>
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm10, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,u,u,u,u,12,28,u,u,u,u,u,u,13,29>
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm12
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm11, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm26 = <u,u,u,u,u,u,14,30,u,u,u,u,u,u,15,31>
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm26, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm8, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm10, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm11, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm1, %zmm26, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm5, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm7, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm8, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm10, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm11, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm24, %zmm26, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 192(%r10), %zmm1
; AVX512BW-NEXT:    vmovdqa64 192(%rax), %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm26, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm25
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,u,u,0,16,u,u,u,u,u,u,1,17,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm2
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,u,u,u,2,18,u,u,u,u,u,u,3,19,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,u,u,4,20,u,u,u,u,u,u,5,21,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm4, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,u,u,6,22,u,u,u,u,u,u,7,23,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm5, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <u,u,u,u,8,24,u,u,u,u,u,u,9,25,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm6, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm7 = <u,u,u,u,10,26,u,u,u,u,u,u,11,27,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm7, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,u,u,u,12,28,u,u,u,u,u,u,13,29,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,u,u,14,30,u,u,u,u,u,u,15,31,u,u>
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm25
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm24
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm3, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm4, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm5, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm6, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm7, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm24
; AVX512BW-NEXT:    vmovdqa64 128(%r8), %zmm19
; AVX512BW-NEXT:    vmovdqa64 128(%r9), %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm3, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm4, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm5, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm6, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm7, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm19
; AVX512BW-NEXT:    vmovdqa64 192(%r8), %zmm23
; AVX512BW-NEXT:    vmovdqa64 192(%r9), %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm23, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm23, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm23, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm23, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm23, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm23, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm23, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm23
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm0
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,0,16,u,u,u,u,u,u,1,17,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm31
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,u,2,18,u,u,u,u,u,u,3,19,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <u,u,4,20,u,u,u,u,u,u,5,21,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm4, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = <u,u,6,22,u,u,u,u,u,u,7,23,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm5, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <u,u,8,24,u,u,u,u,u,u,9,25,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,u,10,26,u,u,u,u,u,u,11,27,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm9, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <u,u,12,28,u,u,u,u,u,u,13,29,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm1
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm11, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm1 = <u,u,14,30,u,u,u,u,u,u,15,31,u,u,u,u>
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm7
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm3, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm4, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm5, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm9, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm11, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm6
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %zmm14
; AVX512BW-NEXT:    vmovdqa64 128(%rcx), %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm3, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm4, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm5, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm9, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm10
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm11, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm14
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %zmm17
; AVX512BW-NEXT:    vmovdqa64 192(%rcx), %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm17, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm17, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm17, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm17, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm17, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm17, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm17, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm1, %zmm17
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm12
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <0,16,u,u,u,u,u,u,1,17,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm15, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm11 = <2,18,u,u,u,u,u,u,3,19,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm11, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm10 = <4,20,u,u,u,u,u,u,5,21,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm10, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <6,22,u,u,u,u,u,u,7,23,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm8 = <8,24,u,u,u,u,u,u,9,25,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm8, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = <10,26,u,u,u,u,u,u,11,27,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm4, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <12,28,u,u,u,u,u,u,13,29,u,u,u,u,u,u>
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = <14,30,u,u,u,u,u,u,15,31,u,u,u,u,u,u>
; AVX512BW-NEXT:    vpermt2d %zmm12, %zmm2, %zmm5
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm12
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm15, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm11, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm10, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm0
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm9, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm30
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm8, %zmm30
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm29
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm4, %zmm29
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm28
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm3, %zmm28
; AVX512BW-NEXT:    vpermt2d %zmm13, %zmm2, %zmm12
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm16
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm27
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm15, %zmm27
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm26
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm11, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm22
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm10, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm21
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm9, %zmm21
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm20
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm8, %zmm20
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm18
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm4, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm13
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm3, %zmm13
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm16
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm15
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm11
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm10
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm9
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm8
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm4
; AVX512BW-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512BW-NEXT:    vpermt2d %zmm0, %zmm2, %zmm1
; AVX512BW-NEXT:    movb $-120, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    movb $34, %al
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512BW-NEXT:    movb $-52, %al
; AVX512BW-NEXT:    kmovd %eax, %k3
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm5 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm5 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k3}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm25 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm25 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm0 {%k3}
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm31 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm30 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm29 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm29 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm28 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm28 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm24 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm12 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm12 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm27 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm26 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm22 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm22 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm21 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm20 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm18 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm13 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm13 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm16 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm16 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm15 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm15 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm11 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm10 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm9 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm8 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm4 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm3 {%k3}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm1 {%k2}
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm1 {%k3}
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 1984(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 1920(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 1856(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 1792(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 1728(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 1664(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 1600(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 1536(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 1472(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 1408(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 1344(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, 1280(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 1216(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, 1152(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm26, 1088(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 1024(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 960(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm28, 896(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 832(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm30, 768(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm31, 704(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 640(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 576(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 512(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 448(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 384(%rax)
; AVX512BW-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 192(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 128(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, (%rax)
; AVX512BW-NEXT:    addq $6152, %rsp # imm = 0x1808
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %in.vec0 = load <64 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i32>, ptr %in.vecptr2, align 64
  %in.vec3 = load <64 x i32>, ptr %in.vecptr3, align 64
  %in.vec4 = load <64 x i32>, ptr %in.vecptr4, align 64
  %in.vec5 = load <64 x i32>, ptr %in.vecptr5, align 64
  %in.vec6 = load <64 x i32>, ptr %in.vecptr6, align 64
  %in.vec7 = load <64 x i32>, ptr %in.vecptr7, align 64
  %1 = shufflevector <64 x i32> %in.vec0, <64 x i32> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i32> %in.vec2, <64 x i32> %in.vec3, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %3 = shufflevector <64 x i32> %in.vec4, <64 x i32> %in.vec5, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %4 = shufflevector <64 x i32> %in.vec6, <64 x i32> %in.vec7, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %5 = shufflevector <128 x i32> %1, <128 x i32> %2, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %6 = shufflevector <128 x i32> %3, <128 x i32> %4, <256 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  %7 = shufflevector <256 x i32> %5, <256 x i32> %6, <512 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255, i32 256, i32 257, i32 258, i32 259, i32 260, i32 261, i32 262, i32 263, i32 264, i32 265, i32 266, i32 267, i32 268, i32 269, i32 270, i32 271, i32 272, i32 273, i32 274, i32 275, i32 276, i32 277, i32 278, i32 279, i32 280, i32 281, i32 282, i32 283, i32 284, i32 285, i32 286, i32 287, i32 288, i32 289, i32 290, i32 291, i32 292, i32 293, i32 294, i32 295, i32 296, i32 297, i32 298, i32 299, i32 300, i32 301, i32 302, i32 303, i32 304, i32 305, i32 306, i32 307, i32 308, i32 309, i32 310, i32 311, i32 312, i32 313, i32 314, i32 315, i32 316, i32 317, i32 318, i32 319, i32 320, i32 321, i32 322, i32 323, i32 324, i32 325, i32 326, i32 327, i32 328, i32 329, i32 330, i32 331, i32 332, i32 333, i32 334, i32 335, i32 336, i32 337, i32 338, i32 339, i32 340, i32 341, i32 342, i32 343, i32 344, i32 345, i32 346, i32 347, i32 348, i32 349, i32 350, i32 351, i32 352, i32 353, i32 354, i32 355, i32 356, i32 357, i32 358, i32 359, i32 360, i32 361, i32 362, i32 363, i32 364, i32 365, i32 366, i32 367, i32 368, i32 369, i32 370, i32 371, i32 372, i32 373, i32 374, i32 375, i32 376, i32 377, i32 378, i32 379, i32 380, i32 381, i32 382, i32 383, i32 384, i32 385, i32 386, i32 387, i32 388, i32 389, i32 390, i32 391, i32 392, i32 393, i32 394, i32 395, i32 396, i32 397, i32 398, i32 399, i32 400, i32 401, i32 402, i32 403, i32 404, i32 405, i32 406, i32 407, i32 408, i32 409, i32 410, i32 411, i32 412, i32 413, i32 414, i32 415, i32 416, i32 417, i32 418, i32 419, i32 420, i32 421, i32 422, i32 423, i32 424, i32 425, i32 426, i32 427, i32 428, i32 429, i32 430, i32 431, i32 432, i32 433, i32 434, i32 435, i32 436, i32 437, i32 438, i32 439, i32 440, i32 441, i32 442, i32 443, i32 444, i32 445, i32 446, i32 447, i32 448, i32 449, i32 450, i32 451, i32 452, i32 453, i32 454, i32 455, i32 456, i32 457, i32 458, i32 459, i32 460, i32 461, i32 462, i32 463, i32 464, i32 465, i32 466, i32 467, i32 468, i32 469, i32 470, i32 471, i32 472, i32 473, i32 474, i32 475, i32 476, i32 477, i32 478, i32 479, i32 480, i32 481, i32 482, i32 483, i32 484, i32 485, i32 486, i32 487, i32 488, i32 489, i32 490, i32 491, i32 492, i32 493, i32 494, i32 495, i32 496, i32 497, i32 498, i32 499, i32 500, i32 501, i32 502, i32 503, i32 504, i32 505, i32 506, i32 507, i32 508, i32 509, i32 510, i32 511>
  %interleaved.vec = shufflevector <512 x i32> %7, <512 x i32> poison, <512 x i32> <i32 0, i32 64, i32 128, i32 192, i32 256, i32 320, i32 384, i32 448, i32 1, i32 65, i32 129, i32 193, i32 257, i32 321, i32 385, i32 449, i32 2, i32 66, i32 130, i32 194, i32 258, i32 322, i32 386, i32 450, i32 3, i32 67, i32 131, i32 195, i32 259, i32 323, i32 387, i32 451, i32 4, i32 68, i32 132, i32 196, i32 260, i32 324, i32 388, i32 452, i32 5, i32 69, i32 133, i32 197, i32 261, i32 325, i32 389, i32 453, i32 6, i32 70, i32 134, i32 198, i32 262, i32 326, i32 390, i32 454, i32 7, i32 71, i32 135, i32 199, i32 263, i32 327, i32 391, i32 455, i32 8, i32 72, i32 136, i32 200, i32 264, i32 328, i32 392, i32 456, i32 9, i32 73, i32 137, i32 201, i32 265, i32 329, i32 393, i32 457, i32 10, i32 74, i32 138, i32 202, i32 266, i32 330, i32 394, i32 458, i32 11, i32 75, i32 139, i32 203, i32 267, i32 331, i32 395, i32 459, i32 12, i32 76, i32 140, i32 204, i32 268, i32 332, i32 396, i32 460, i32 13, i32 77, i32 141, i32 205, i32 269, i32 333, i32 397, i32 461, i32 14, i32 78, i32 142, i32 206, i32 270, i32 334, i32 398, i32 462, i32 15, i32 79, i32 143, i32 207, i32 271, i32 335, i32 399, i32 463, i32 16, i32 80, i32 144, i32 208, i32 272, i32 336, i32 400, i32 464, i32 17, i32 81, i32 145, i32 209, i32 273, i32 337, i32 401, i32 465, i32 18, i32 82, i32 146, i32 210, i32 274, i32 338, i32 402, i32 466, i32 19, i32 83, i32 147, i32 211, i32 275, i32 339, i32 403, i32 467, i32 20, i32 84, i32 148, i32 212, i32 276, i32 340, i32 404, i32 468, i32 21, i32 85, i32 149, i32 213, i32 277, i32 341, i32 405, i32 469, i32 22, i32 86, i32 150, i32 214, i32 278, i32 342, i32 406, i32 470, i32 23, i32 87, i32 151, i32 215, i32 279, i32 343, i32 407, i32 471, i32 24, i32 88, i32 152, i32 216, i32 280, i32 344, i32 408, i32 472, i32 25, i32 89, i32 153, i32 217, i32 281, i32 345, i32 409, i32 473, i32 26, i32 90, i32 154, i32 218, i32 282, i32 346, i32 410, i32 474, i32 27, i32 91, i32 155, i32 219, i32 283, i32 347, i32 411, i32 475, i32 28, i32 92, i32 156, i32 220, i32 284, i32 348, i32 412, i32 476, i32 29, i32 93, i32 157, i32 221, i32 285, i32 349, i32 413, i32 477, i32 30, i32 94, i32 158, i32 222, i32 286, i32 350, i32 414, i32 478, i32 31, i32 95, i32 159, i32 223, i32 287, i32 351, i32 415, i32 479, i32 32, i32 96, i32 160, i32 224, i32 288, i32 352, i32 416, i32 480, i32 33, i32 97, i32 161, i32 225, i32 289, i32 353, i32 417, i32 481, i32 34, i32 98, i32 162, i32 226, i32 290, i32 354, i32 418, i32 482, i32 35, i32 99, i32 163, i32 227, i32 291, i32 355, i32 419, i32 483, i32 36, i32 100, i32 164, i32 228, i32 292, i32 356, i32 420, i32 484, i32 37, i32 101, i32 165, i32 229, i32 293, i32 357, i32 421, i32 485, i32 38, i32 102, i32 166, i32 230, i32 294, i32 358, i32 422, i32 486, i32 39, i32 103, i32 167, i32 231, i32 295, i32 359, i32 423, i32 487, i32 40, i32 104, i32 168, i32 232, i32 296, i32 360, i32 424, i32 488, i32 41, i32 105, i32 169, i32 233, i32 297, i32 361, i32 425, i32 489, i32 42, i32 106, i32 170, i32 234, i32 298, i32 362, i32 426, i32 490, i32 43, i32 107, i32 171, i32 235, i32 299, i32 363, i32 427, i32 491, i32 44, i32 108, i32 172, i32 236, i32 300, i32 364, i32 428, i32 492, i32 45, i32 109, i32 173, i32 237, i32 301, i32 365, i32 429, i32 493, i32 46, i32 110, i32 174, i32 238, i32 302, i32 366, i32 430, i32 494, i32 47, i32 111, i32 175, i32 239, i32 303, i32 367, i32 431, i32 495, i32 48, i32 112, i32 176, i32 240, i32 304, i32 368, i32 432, i32 496, i32 49, i32 113, i32 177, i32 241, i32 305, i32 369, i32 433, i32 497, i32 50, i32 114, i32 178, i32 242, i32 306, i32 370, i32 434, i32 498, i32 51, i32 115, i32 179, i32 243, i32 307, i32 371, i32 435, i32 499, i32 52, i32 116, i32 180, i32 244, i32 308, i32 372, i32 436, i32 500, i32 53, i32 117, i32 181, i32 245, i32 309, i32 373, i32 437, i32 501, i32 54, i32 118, i32 182, i32 246, i32 310, i32 374, i32 438, i32 502, i32 55, i32 119, i32 183, i32 247, i32 311, i32 375, i32 439, i32 503, i32 56, i32 120, i32 184, i32 248, i32 312, i32 376, i32 440, i32 504, i32 57, i32 121, i32 185, i32 249, i32 313, i32 377, i32 441, i32 505, i32 58, i32 122, i32 186, i32 250, i32 314, i32 378, i32 442, i32 506, i32 59, i32 123, i32 187, i32 251, i32 315, i32 379, i32 443, i32 507, i32 60, i32 124, i32 188, i32 252, i32 316, i32 380, i32 444, i32 508, i32 61, i32 125, i32 189, i32 253, i32 317, i32 381, i32 445, i32 509, i32 62, i32 126, i32 190, i32 254, i32 318, i32 382, i32 446, i32 510, i32 63, i32 127, i32 191, i32 255, i32 319, i32 383, i32 447, i32 511>
  store <512 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX1: {{.*}}
; AVX2: {{.*}}
; AVX2-FAST: {{.*}}
; AVX2-FAST-PERLANE: {{.*}}
; AVX2-SLOW: {{.*}}
; AVX512BW-FAST: {{.*}}
; AVX512BW-ONLY-FAST: {{.*}}
; AVX512BW-ONLY-SLOW: {{.*}}
; AVX512BW-SLOW: {{.*}}
; AVX512DQ-FAST: {{.*}}
; AVX512DQ-SLOW: {{.*}}
; AVX512DQBW-FAST: {{.*}}
; AVX512DQBW-SLOW: {{.*}}
; AVX512F-FAST: {{.*}}
; AVX512F-ONLY-FAST: {{.*}}
; AVX512F-ONLY-SLOW: {{.*}}
; AVX512F-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
