/*
 * Copyright (c) 2021,2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * This application is meant to be run to create a classlist file representing
 * common use.
 *
 * The classlist is produced by adding -XX:DumpLoadedClassList=classlist
 */
package build.tools.classlist;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.util.Scanner;

/**
 * The classlist generated by build.tools.classlist.HelloClasslist
 * may have non-deterministic contents, affected by Java thread execution order.
 * SortClasslist sorts the file to make the JDK image's contents more deterministic.
 */
public class SortClasslist {
    public static void main(String args[]) throws FileNotFoundException  {
        ArrayList<String> classes = new ArrayList<>();
        ArrayList<String> lambdas = new ArrayList<>();

        FileInputStream fis = new FileInputStream(args[0]);
        Scanner scanner = new Scanner(fis);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.startsWith("#")) {
                // Comments -- print them first without sorting. These appear only at the top
                // of the file.
                System.out.println(line);
            } else if (line.startsWith("@")) {
                // @lambda-form-invoker, @lambda-proxy, etc.
                lambdas.add(line);
            } else {
                // Class name line
                classes.add(line);
            }
        }

        Collections.sort(classes);
        Collections.sort(lambdas);

        for (String s : classes) {
            System.out.println(s);
        }
        for (String s : lambdas) {
            System.out.println(s);
        }
    }
}
