/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentArtifactAPIService ContentArtifactAPI service
type ContentArtifactAPIService service

type ContentArtifactAPIContentMavenArtifactCreateRequest struct {
	ctx context.Context
	ApiService *ContentArtifactAPIService
	mavenMavenArtifact *MavenMavenArtifact
}

func (r ContentArtifactAPIContentMavenArtifactCreateRequest) MavenMavenArtifact(mavenMavenArtifact MavenMavenArtifact) ContentArtifactAPIContentMavenArtifactCreateRequest {
	r.mavenMavenArtifact = &mavenMavenArtifact
	return r
}

func (r ContentArtifactAPIContentMavenArtifactCreateRequest) Execute() (*MavenMavenArtifactResponse, *http.Response, error) {
	return r.ApiService.ContentMavenArtifactCreateExecute(r)
}

/*
ContentMavenArtifactCreate Create a maven artifact

A ViewSet for MavenArtifact.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentArtifactAPIContentMavenArtifactCreateRequest
*/
func (a *ContentArtifactAPIService) ContentMavenArtifactCreate(ctx context.Context) ContentArtifactAPIContentMavenArtifactCreateRequest {
	return ContentArtifactAPIContentMavenArtifactCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return MavenMavenArtifactResponse
func (a *ContentArtifactAPIService) ContentMavenArtifactCreateExecute(r ContentArtifactAPIContentMavenArtifactCreateRequest) (*MavenMavenArtifactResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MavenMavenArtifactResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentArtifactAPIService.ContentMavenArtifactCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/maven/artifact/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.mavenMavenArtifact == nil {
		return localVarReturnValue, nil, reportError("mavenMavenArtifact is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.mavenMavenArtifact
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentArtifactAPIContentMavenArtifactListRequest struct {
	ctx context.Context
	ApiService *ContentArtifactAPIService
	artifactId *string
	filename *string
	groupId *string
	limit *int32
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	version *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where artifact_id matches value
func (r ContentArtifactAPIContentMavenArtifactListRequest) ArtifactId(artifactId string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.artifactId = &artifactId
	return r
}

// Filter results where filename matches value
func (r ContentArtifactAPIContentMavenArtifactListRequest) Filename(filename string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.filename = &filename
	return r
}

// Filter results where group_id matches value
func (r ContentArtifactAPIContentMavenArtifactListRequest) GroupId(groupId string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.groupId = &groupId
	return r
}

// Number of results to return per page.
func (r ContentArtifactAPIContentMavenArtifactListRequest) Limit(limit int32) ContentArtifactAPIContentMavenArtifactListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r ContentArtifactAPIContentMavenArtifactListRequest) Offset(offset int32) ContentArtifactAPIContentMavenArtifactListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;group_id&#x60; - Group id * &#x60;-group_id&#x60; - Group id (descending) * &#x60;artifact_id&#x60; - Artifact id * &#x60;-artifact_id&#x60; - Artifact id (descending) * &#x60;version&#x60; - Version * &#x60;-version&#x60; - Version (descending) * &#x60;filename&#x60; - Filename * &#x60;-filename&#x60; - Filename (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentArtifactAPIContentMavenArtifactListRequest) Ordering(ordering []string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentArtifactAPIContentMavenArtifactListRequest) PulpHrefIn(pulpHrefIn []string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentArtifactAPIContentMavenArtifactListRequest) PulpIdIn(pulpIdIn []string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository Version referenced by HREF
func (r ContentArtifactAPIContentMavenArtifactListRequest) RepositoryVersion(repositoryVersion string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentArtifactAPIContentMavenArtifactListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentArtifactAPIContentMavenArtifactListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// Filter results where version matches value
func (r ContentArtifactAPIContentMavenArtifactListRequest) Version(version string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.version = &version
	return r
}

// A list of fields to include in the response.
func (r ContentArtifactAPIContentMavenArtifactListRequest) Fields(fields []string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentArtifactAPIContentMavenArtifactListRequest) ExcludeFields(excludeFields []string) ContentArtifactAPIContentMavenArtifactListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentArtifactAPIContentMavenArtifactListRequest) Execute() (*PaginatedmavenMavenArtifactResponseList, *http.Response, error) {
	return r.ApiService.ContentMavenArtifactListExecute(r)
}

/*
ContentMavenArtifactList List maven artifacts

A ViewSet for MavenArtifact.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentArtifactAPIContentMavenArtifactListRequest
*/
func (a *ContentArtifactAPIService) ContentMavenArtifactList(ctx context.Context) ContentArtifactAPIContentMavenArtifactListRequest {
	return ContentArtifactAPIContentMavenArtifactListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedmavenMavenArtifactResponseList
func (a *ContentArtifactAPIService) ContentMavenArtifactListExecute(r ContentArtifactAPIContentMavenArtifactListRequest) (*PaginatedmavenMavenArtifactResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedmavenMavenArtifactResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentArtifactAPIService.ContentMavenArtifactList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/maven/artifact/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.artifactId != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "artifact_id", r.artifactId, "")
	}
	if r.filename != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "filename", r.filename, "")
	}
	if r.groupId != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "group_id", r.groupId, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.version != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version", r.version, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentArtifactAPIContentMavenArtifactReadRequest struct {
	ctx context.Context
	ApiService *ContentArtifactAPIService
	mavenMavenArtifactHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentArtifactAPIContentMavenArtifactReadRequest) Fields(fields []string) ContentArtifactAPIContentMavenArtifactReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentArtifactAPIContentMavenArtifactReadRequest) ExcludeFields(excludeFields []string) ContentArtifactAPIContentMavenArtifactReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentArtifactAPIContentMavenArtifactReadRequest) Execute() (*MavenMavenArtifactResponse, *http.Response, error) {
	return r.ApiService.ContentMavenArtifactReadExecute(r)
}

/*
ContentMavenArtifactRead Inspect a maven artifact

A ViewSet for MavenArtifact.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param mavenMavenArtifactHref
 @return ContentArtifactAPIContentMavenArtifactReadRequest
*/
func (a *ContentArtifactAPIService) ContentMavenArtifactRead(ctx context.Context, mavenMavenArtifactHref string) ContentArtifactAPIContentMavenArtifactReadRequest {
	return ContentArtifactAPIContentMavenArtifactReadRequest{
		ApiService: a,
		ctx: ctx,
		mavenMavenArtifactHref: mavenMavenArtifactHref,
	}
}

// Execute executes the request
//  @return MavenMavenArtifactResponse
func (a *ContentArtifactAPIService) ContentMavenArtifactReadExecute(r ContentArtifactAPIContentMavenArtifactReadRequest) (*MavenMavenArtifactResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MavenMavenArtifactResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentArtifactAPIService.ContentMavenArtifactRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{maven_maven_artifact_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"maven_maven_artifact_href"+"}", parameterValueToString(r.mavenMavenArtifactHref, "mavenMavenArtifactHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
