/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// RemotesUlnAPIService RemotesUlnAPI service
type RemotesUlnAPIService service

type RemotesUlnAPIRemotesRpmUlnAddRoleRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	rpmUlnRemoteHref string
	nestedRole *NestedRole
}

func (r RemotesUlnAPIRemotesRpmUlnAddRoleRequest) NestedRole(nestedRole NestedRole) RemotesUlnAPIRemotesRpmUlnAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RemotesUlnAPIRemotesRpmUlnAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnAddRoleExecute(r)
}

/*
RemotesRpmUlnAddRole Method for RemotesRpmUlnAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmUlnRemoteHref
 @return RemotesUlnAPIRemotesRpmUlnAddRoleRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnAddRole(ctx context.Context, rpmUlnRemoteHref string) RemotesUlnAPIRemotesRpmUlnAddRoleRequest {
	return RemotesUlnAPIRemotesRpmUlnAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmUlnRemoteHref: rpmUlnRemoteHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RemotesUlnAPIService) RemotesRpmUlnAddRoleExecute(r RemotesUlnAPIRemotesRpmUlnAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_uln_remote_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_uln_remote_href"+"}", parameterValueToString(r.rpmUlnRemoteHref, "rpmUlnRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesUlnAPIRemotesRpmUlnCreateRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	rpmUlnRemote *RpmUlnRemote
}

func (r RemotesUlnAPIRemotesRpmUlnCreateRequest) RpmUlnRemote(rpmUlnRemote RpmUlnRemote) RemotesUlnAPIRemotesRpmUlnCreateRequest {
	r.rpmUlnRemote = &rpmUlnRemote
	return r
}

func (r RemotesUlnAPIRemotesRpmUlnCreateRequest) Execute() (*RpmUlnRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnCreateExecute(r)
}

/*
RemotesRpmUlnCreate Create an uln remote

A ViewSet for UlnRemote.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesUlnAPIRemotesRpmUlnCreateRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnCreate(ctx context.Context) RemotesUlnAPIRemotesRpmUlnCreateRequest {
	return RemotesUlnAPIRemotesRpmUlnCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return RpmUlnRemoteResponse
func (a *RemotesUlnAPIService) RemotesRpmUlnCreateExecute(r RemotesUlnAPIRemotesRpmUlnCreateRequest) (*RpmUlnRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RpmUlnRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/rpm/uln/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmUlnRemote == nil {
		return localVarReturnValue, nil, reportError("rpmUlnRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmUlnRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesUlnAPIRemotesRpmUlnDeleteRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	rpmUlnRemoteHref string
}

func (r RemotesUlnAPIRemotesRpmUlnDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnDeleteExecute(r)
}

/*
RemotesRpmUlnDelete Delete an uln remote

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmUlnRemoteHref
 @return RemotesUlnAPIRemotesRpmUlnDeleteRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnDelete(ctx context.Context, rpmUlnRemoteHref string) RemotesUlnAPIRemotesRpmUlnDeleteRequest {
	return RemotesUlnAPIRemotesRpmUlnDeleteRequest{
		ApiService: a,
		ctx: ctx,
		rpmUlnRemoteHref: rpmUlnRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesUlnAPIService) RemotesRpmUlnDeleteExecute(r RemotesUlnAPIRemotesRpmUlnDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_uln_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_uln_remote_href"+"}", parameterValueToString(r.rpmUlnRemoteHref, "rpmUlnRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesUlnAPIRemotesRpmUlnListRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	pulpLastUpdated *time.Time
	pulpLastUpdatedGt *time.Time
	pulpLastUpdatedGte *time.Time
	pulpLastUpdatedLt *time.Time
	pulpLastUpdatedLte *time.Time
	pulpLastUpdatedRange *[]time.Time
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r RemotesUlnAPIRemotesRpmUlnListRequest) Limit(limit int32) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RemotesUlnAPIRemotesRpmUlnListRequest) Name(name string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RemotesUlnAPIRemotesRpmUlnListRequest) NameContains(nameContains string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RemotesUlnAPIRemotesRpmUlnListRequest) NameIcontains(nameIcontains string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RemotesUlnAPIRemotesRpmUlnListRequest) NameIn(nameIn []string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RemotesUlnAPIRemotesRpmUlnListRequest) NameStartswith(nameStartswith string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RemotesUlnAPIRemotesRpmUlnListRequest) Offset(offset int32) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;url&#x60; - Url * &#x60;-url&#x60; - Url (descending) * &#x60;ca_cert&#x60; - Ca cert * &#x60;-ca_cert&#x60; - Ca cert (descending) * &#x60;client_cert&#x60; - Client cert * &#x60;-client_cert&#x60; - Client cert (descending) * &#x60;client_key&#x60; - Client key * &#x60;-client_key&#x60; - Client key (descending) * &#x60;tls_validation&#x60; - Tls validation * &#x60;-tls_validation&#x60; - Tls validation (descending) * &#x60;username&#x60; - Username * &#x60;-username&#x60; - Username (descending) * &#x60;password&#x60; - Password * &#x60;-password&#x60; - Password (descending) * &#x60;proxy_url&#x60; - Proxy url * &#x60;-proxy_url&#x60; - Proxy url (descending) * &#x60;proxy_username&#x60; - Proxy username * &#x60;-proxy_username&#x60; - Proxy username (descending) * &#x60;proxy_password&#x60; - Proxy password * &#x60;-proxy_password&#x60; - Proxy password (descending) * &#x60;download_concurrency&#x60; - Download concurrency * &#x60;-download_concurrency&#x60; - Download concurrency (descending) * &#x60;max_retries&#x60; - Max retries * &#x60;-max_retries&#x60; - Max retries (descending) * &#x60;policy&#x60; - Policy * &#x60;-policy&#x60; - Policy (descending) * &#x60;total_timeout&#x60; - Total timeout * &#x60;-total_timeout&#x60; - Total timeout (descending) * &#x60;connect_timeout&#x60; - Connect timeout * &#x60;-connect_timeout&#x60; - Connect timeout (descending) * &#x60;sock_connect_timeout&#x60; - Sock connect timeout * &#x60;-sock_connect_timeout&#x60; - Sock connect timeout (descending) * &#x60;sock_read_timeout&#x60; - Sock read timeout * &#x60;-sock_read_timeout&#x60; - Sock read timeout (descending) * &#x60;headers&#x60; - Headers * &#x60;-headers&#x60; - Headers (descending) * &#x60;rate_limit&#x60; - Rate limit * &#x60;-rate_limit&#x60; - Rate limit (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RemotesUlnAPIRemotesRpmUlnListRequest) Ordering(ordering []string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RemotesUlnAPIRemotesRpmUlnListRequest) PulpHrefIn(pulpHrefIn []string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RemotesUlnAPIRemotesRpmUlnListRequest) PulpIdIn(pulpIdIn []string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RemotesUlnAPIRemotesRpmUlnListRequest) PulpLabelSelect(pulpLabelSelect string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where pulp_last_updated matches value
func (r RemotesUlnAPIRemotesRpmUlnListRequest) PulpLastUpdated(pulpLastUpdated time.Time) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.pulpLastUpdated = &pulpLastUpdated
	return r
}

// Filter results where pulp_last_updated is greater than value
func (r RemotesUlnAPIRemotesRpmUlnListRequest) PulpLastUpdatedGt(pulpLastUpdatedGt time.Time) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.pulpLastUpdatedGt = &pulpLastUpdatedGt
	return r
}

// Filter results where pulp_last_updated is greater than or equal to value
func (r RemotesUlnAPIRemotesRpmUlnListRequest) PulpLastUpdatedGte(pulpLastUpdatedGte time.Time) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.pulpLastUpdatedGte = &pulpLastUpdatedGte
	return r
}

// Filter results where pulp_last_updated is less than value
func (r RemotesUlnAPIRemotesRpmUlnListRequest) PulpLastUpdatedLt(pulpLastUpdatedLt time.Time) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.pulpLastUpdatedLt = &pulpLastUpdatedLt
	return r
}

// Filter results where pulp_last_updated is less than or equal to value
func (r RemotesUlnAPIRemotesRpmUlnListRequest) PulpLastUpdatedLte(pulpLastUpdatedLte time.Time) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.pulpLastUpdatedLte = &pulpLastUpdatedLte
	return r
}

// Filter results where pulp_last_updated is between two comma separated values
func (r RemotesUlnAPIRemotesRpmUlnListRequest) PulpLastUpdatedRange(pulpLastUpdatedRange []time.Time) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.pulpLastUpdatedRange = &pulpLastUpdatedRange
	return r
}

// A list of fields to include in the response.
func (r RemotesUlnAPIRemotesRpmUlnListRequest) Fields(fields []string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesUlnAPIRemotesRpmUlnListRequest) ExcludeFields(excludeFields []string) RemotesUlnAPIRemotesRpmUlnListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesUlnAPIRemotesRpmUlnListRequest) Execute() (*PaginatedrpmUlnRemoteResponseList, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnListExecute(r)
}

/*
RemotesRpmUlnList List uln remotes

A ViewSet for UlnRemote.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesUlnAPIRemotesRpmUlnListRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnList(ctx context.Context) RemotesUlnAPIRemotesRpmUlnListRequest {
	return RemotesUlnAPIRemotesRpmUlnListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedrpmUlnRemoteResponseList
func (a *RemotesUlnAPIService) RemotesRpmUlnListExecute(r RemotesUlnAPIRemotesRpmUlnListRequest) (*PaginatedrpmUlnRemoteResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedrpmUlnRemoteResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/rpm/uln/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.pulpLastUpdated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated", r.pulpLastUpdated, "")
	}
	if r.pulpLastUpdatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gt", r.pulpLastUpdatedGt, "")
	}
	if r.pulpLastUpdatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gte", r.pulpLastUpdatedGte, "")
	}
	if r.pulpLastUpdatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lt", r.pulpLastUpdatedLt, "")
	}
	if r.pulpLastUpdatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lte", r.pulpLastUpdatedLte, "")
	}
	if r.pulpLastUpdatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__range", r.pulpLastUpdatedRange, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesUlnAPIRemotesRpmUlnListRolesRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	rpmUlnRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesUlnAPIRemotesRpmUlnListRolesRequest) Fields(fields []string) RemotesUlnAPIRemotesRpmUlnListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesUlnAPIRemotesRpmUlnListRolesRequest) ExcludeFields(excludeFields []string) RemotesUlnAPIRemotesRpmUlnListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesUlnAPIRemotesRpmUlnListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnListRolesExecute(r)
}

/*
RemotesRpmUlnListRoles Method for RemotesRpmUlnListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmUlnRemoteHref
 @return RemotesUlnAPIRemotesRpmUlnListRolesRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnListRoles(ctx context.Context, rpmUlnRemoteHref string) RemotesUlnAPIRemotesRpmUlnListRolesRequest {
	return RemotesUlnAPIRemotesRpmUlnListRolesRequest{
		ApiService: a,
		ctx: ctx,
		rpmUlnRemoteHref: rpmUlnRemoteHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *RemotesUlnAPIService) RemotesRpmUlnListRolesExecute(r RemotesUlnAPIRemotesRpmUlnListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_uln_remote_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_uln_remote_href"+"}", parameterValueToString(r.rpmUlnRemoteHref, "rpmUlnRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	rpmUlnRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest) Fields(fields []string) RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest) ExcludeFields(excludeFields []string) RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnMyPermissionsExecute(r)
}

/*
RemotesRpmUlnMyPermissions Method for RemotesRpmUlnMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmUlnRemoteHref
 @return RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnMyPermissions(ctx context.Context, rpmUlnRemoteHref string) RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest {
	return RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		rpmUlnRemoteHref: rpmUlnRemoteHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *RemotesUlnAPIService) RemotesRpmUlnMyPermissionsExecute(r RemotesUlnAPIRemotesRpmUlnMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_uln_remote_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_uln_remote_href"+"}", parameterValueToString(r.rpmUlnRemoteHref, "rpmUlnRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesUlnAPIRemotesRpmUlnPartialUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	rpmUlnRemoteHref string
	patchedrpmUlnRemote *PatchedrpmUlnRemote
}

func (r RemotesUlnAPIRemotesRpmUlnPartialUpdateRequest) PatchedrpmUlnRemote(patchedrpmUlnRemote PatchedrpmUlnRemote) RemotesUlnAPIRemotesRpmUlnPartialUpdateRequest {
	r.patchedrpmUlnRemote = &patchedrpmUlnRemote
	return r
}

func (r RemotesUlnAPIRemotesRpmUlnPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnPartialUpdateExecute(r)
}

/*
RemotesRpmUlnPartialUpdate Update an uln remote

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmUlnRemoteHref
 @return RemotesUlnAPIRemotesRpmUlnPartialUpdateRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnPartialUpdate(ctx context.Context, rpmUlnRemoteHref string) RemotesUlnAPIRemotesRpmUlnPartialUpdateRequest {
	return RemotesUlnAPIRemotesRpmUlnPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rpmUlnRemoteHref: rpmUlnRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesUlnAPIService) RemotesRpmUlnPartialUpdateExecute(r RemotesUlnAPIRemotesRpmUlnPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_uln_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_uln_remote_href"+"}", parameterValueToString(r.rpmUlnRemoteHref, "rpmUlnRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedrpmUlnRemote == nil {
		return localVarReturnValue, nil, reportError("patchedrpmUlnRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedrpmUlnRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesUlnAPIRemotesRpmUlnReadRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	rpmUlnRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesUlnAPIRemotesRpmUlnReadRequest) Fields(fields []string) RemotesUlnAPIRemotesRpmUlnReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesUlnAPIRemotesRpmUlnReadRequest) ExcludeFields(excludeFields []string) RemotesUlnAPIRemotesRpmUlnReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesUlnAPIRemotesRpmUlnReadRequest) Execute() (*RpmUlnRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnReadExecute(r)
}

/*
RemotesRpmUlnRead Inspect an uln remote

A ViewSet for UlnRemote.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmUlnRemoteHref
 @return RemotesUlnAPIRemotesRpmUlnReadRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnRead(ctx context.Context, rpmUlnRemoteHref string) RemotesUlnAPIRemotesRpmUlnReadRequest {
	return RemotesUlnAPIRemotesRpmUlnReadRequest{
		ApiService: a,
		ctx: ctx,
		rpmUlnRemoteHref: rpmUlnRemoteHref,
	}
}

// Execute executes the request
//  @return RpmUlnRemoteResponse
func (a *RemotesUlnAPIService) RemotesRpmUlnReadExecute(r RemotesUlnAPIRemotesRpmUlnReadRequest) (*RpmUlnRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *RpmUlnRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_uln_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_uln_remote_href"+"}", parameterValueToString(r.rpmUlnRemoteHref, "rpmUlnRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesUlnAPIRemotesRpmUlnRemoveRoleRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	rpmUlnRemoteHref string
	nestedRole *NestedRole
}

func (r RemotesUlnAPIRemotesRpmUlnRemoveRoleRequest) NestedRole(nestedRole NestedRole) RemotesUlnAPIRemotesRpmUlnRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RemotesUlnAPIRemotesRpmUlnRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnRemoveRoleExecute(r)
}

/*
RemotesRpmUlnRemoveRole Method for RemotesRpmUlnRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmUlnRemoteHref
 @return RemotesUlnAPIRemotesRpmUlnRemoveRoleRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnRemoveRole(ctx context.Context, rpmUlnRemoteHref string) RemotesUlnAPIRemotesRpmUlnRemoveRoleRequest {
	return RemotesUlnAPIRemotesRpmUlnRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		rpmUlnRemoteHref: rpmUlnRemoteHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RemotesUlnAPIService) RemotesRpmUlnRemoveRoleExecute(r RemotesUlnAPIRemotesRpmUlnRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_uln_remote_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_uln_remote_href"+"}", parameterValueToString(r.rpmUlnRemoteHref, "rpmUlnRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesUlnAPIRemotesRpmUlnUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesUlnAPIService
	rpmUlnRemoteHref string
	rpmUlnRemote *RpmUlnRemote
}

func (r RemotesUlnAPIRemotesRpmUlnUpdateRequest) RpmUlnRemote(rpmUlnRemote RpmUlnRemote) RemotesUlnAPIRemotesRpmUlnUpdateRequest {
	r.rpmUlnRemote = &rpmUlnRemote
	return r
}

func (r RemotesUlnAPIRemotesRpmUlnUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesRpmUlnUpdateExecute(r)
}

/*
RemotesRpmUlnUpdate Update an uln remote

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param rpmUlnRemoteHref
 @return RemotesUlnAPIRemotesRpmUlnUpdateRequest
*/
func (a *RemotesUlnAPIService) RemotesRpmUlnUpdate(ctx context.Context, rpmUlnRemoteHref string) RemotesUlnAPIRemotesRpmUlnUpdateRequest {
	return RemotesUlnAPIRemotesRpmUlnUpdateRequest{
		ApiService: a,
		ctx: ctx,
		rpmUlnRemoteHref: rpmUlnRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesUlnAPIService) RemotesRpmUlnUpdateExecute(r RemotesUlnAPIRemotesRpmUlnUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesUlnAPIService.RemotesRpmUlnUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{rpm_uln_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"rpm_uln_remote_href"+"}", parameterValueToString(r.rpmUlnRemoteHref, "rpmUlnRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.rpmUlnRemote == nil {
		return localVarReturnValue, nil, reportError("rpmUlnRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.rpmUlnRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
