set(vcSlnFile "${RunCMake_TEST_BINARY_DIR}/AddPackageToDefault.sln")
if(NOT EXISTS "${vcSlnFile}")
  set(RunCMake_TEST_FAILED "Project file ${vcSlnFile} does not exist.")
  return()
endif()

set(packageGuidFound FALSE)
set(packageGuid "")
set(packageInBuild FALSE)
file(STRINGS "${vcSlnFile}" lines)
foreach(line IN LISTS lines)
  if(NOT packageGuidFound)
    if(line MATCHES "^Project.*\"PACKAGE.vcx?proj\".*\"{([A-F0-9-]+)}\"$")
      set(packageGuidFound TRUE)
      set(packageGuid ${CMAKE_MATCH_1})
    endif()
  else()
    if(line MATCHES ".*{${packageGuid}}.*")
      if(line MATCHES "^[ \t]*{${packageGuid}}\\..*\\.Build.0 = .*$")
          set(packageInBuild TRUE)
      endif()
    endif()
  endif()
endforeach()

if(NOT packageInBuild)
  set(RunCMake_TEST_FAILED "PACKAGE is not in default build")
  return()
endif()
