package native

const (
	_CONTEXT_AMD64               = 0x100000
	_CONTEXT_CONTROL             = (_CONTEXT_AMD64 | 0x1)
	_CONTEXT_INTEGER             = (_CONTEXT_AMD64 | 0x2)
	_CONTEXT_SEGMENTS            = (_CONTEXT_AMD64 | 0x4)
	_CONTEXT_FLOATING_POINT      = (_CONTEXT_AMD64 | 0x8)
	_CONTEXT_DEBUG_REGISTERS     = (_CONTEXT_AMD64 | 0x10)
	_CONTEXT_FULL                = (_CONTEXT_CONTROL | _CONTEXT_INTEGER | _CONTEXT_FLOATING_POINT)
	_CONTEXT_ALL                 = (_CONTEXT_CONTROL | _CONTEXT_INTEGER | _CONTEXT_SEGMENTS | _CONTEXT_FLOATING_POINT | _CONTEXT_DEBUG_REGISTERS)
	_CONTEXT_EXCEPTION_ACTIVE    = 0x8000000
	_CONTEXT_SERVICE_ACTIVE      = 0x10000000
	_CONTEXT_EXCEPTION_REQUEST   = 0x40000000
	_CONTEXT_EXCEPTION_REPORTING = 0x80000000
)

type _DEBUG_EVENT struct {
	DebugEventCode uint32
	ProcessId      uint32
	ThreadId       uint32
	_              uint32 // to align Union properly
	U              [160]byte
}
