/* handle.c generated by valac 0.52.4, the Vala compiler
 * generated from handle.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2016 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2016-2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define TYPE_HANDLE (handle_get_type ())
#define HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HANDLE, Handle))
#define HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HANDLE, HandleClass))
#define IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HANDLE))
#define IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HANDLE))
#define HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HANDLE, HandleClass))

typedef struct _Handle Handle;
typedef struct _HandleClass HandleClass;
typedef struct _HandlePrivate HandlePrivate;
enum  {
	HANDLE_0_PROPERTY,
	HANDLE_NUM_PROPERTIES
};
static GParamSpec* handle_properties[HANDLE_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	HANDLE_MOVE_BEGIN_SIGNAL,
	HANDLE_MOVE_END_SIGNAL,
	HANDLE_NUM_SIGNALS
};
static guint handle_signals[HANDLE_NUM_SIGNALS] = {0};

struct _Handle {
	GtkEventBox parent_instance;
	HandlePrivate * priv;
};

struct _HandleClass {
	GtkEventBoxClass parent_class;
};

struct _HandlePrivate {
	gboolean m_move_begined;
	GdkRectangle m_workarea;
	GdkPoint m_press_pos;
};

static gint Handle_private_offset;
static gpointer handle_parent_class = NULL;

GType handle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Handle, g_object_unref)
Handle* handle_new (void);
Handle* handle_construct (GType object_type);
static void handle_real_realize (GtkWidget* base);
static gboolean handle_real_button_press_event (GtkWidget* base,
                                         GdkEventButton* event);
static gboolean handle_real_button_release_event (GtkWidget* base,
                                           GdkEventButton* event);
static gboolean handle_real_motion_notify_event (GtkWidget* base,
                                          GdkEventMotion* event);
static gboolean handle_real_draw (GtkWidget* base,
                           cairo_t* cr);
static void handle_finalize (GObject * obj);
static GType handle_get_type_once (void);

static inline gpointer
handle_get_instance_private (Handle* self)
{
	return G_STRUCT_MEMBER_P (self, Handle_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Handle*
handle_construct (GType object_type)
{
	Handle * self = NULL;
	GdkEventMask mask = 0U;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (Handle*) g_object_new (object_type, "name", "IBusHandle", NULL);
	gtk_widget_set_size_request ((GtkWidget*) self, 6, -1);
	mask = ((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_BUTTON1_MOTION_MASK;
	gtk_widget_set_events ((GtkWidget*) self, (gint) mask);
	self->priv->m_move_begined = FALSE;
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	{
		gtk_css_provider_load_from_data (css_provider, "#IBusHandle { background-color: gray }", (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("handle.vala:53: Parse error in Handle: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	context = _tmp4_;
	gtk_style_context_add_provider (context, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (context);
	_g_object_unref0 (css_provider);
	return self;
}

Handle*
handle_new (void)
{
	return handle_construct (TYPE_HANDLE);
}

static void
handle_real_realize (GtkWidget* base)
{
	Handle * self;
	self = (Handle*) base;
	GTK_WIDGET_CLASS (handle_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_event_box_get_type (), GtkEventBox));
}

static gboolean
handle_real_button_press_event (GtkWidget* base,
                                GdkEventButton* event)
{
	Handle * self;
	GdkRectangle _tmp0_ = {0};
	gint x = 0;
	gint y = 0;
	GtkWindow* toplevel = NULL;
	GtkWidget* _tmp64_;
	GtkWindow* _tmp65_;
	GtkWindow* _tmp66_;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gboolean result = FALSE;
	self = (Handle*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	memset (&_tmp0_, 0, sizeof (GdkRectangle));
	_tmp0_.x = 0;
	_tmp0_.y = 0;
	_tmp0_.width = G_MAXINT;
	_tmp0_.height = G_MAXINT;
	self->priv->m_workarea = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			GdkWindow* root = NULL;
			GdkWindow* _tmp2_;
			GdkWindow* _tmp3_;
			GdkAtom property = 0U;
			GdkAtom type = 0U;
			GdkAtom actual_type = 0U;
			gint format = 0;
			guchar* data = NULL;
			gint data_length1 = 0;
			gint _data_size_ = 0;
			gboolean _result_ = FALSE;
			GdkWindow* _tmp4_;
			GdkAtom _tmp5_ = 0U;
			gint _tmp6_ = 0;
			guint8* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gboolean _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gint index = 0;
			guchar* _tmp14_;
			gint _tmp14__length1;
			guchar _tmp15_;
			guchar* _tmp16_;
			gint _tmp16__length1;
			guchar _tmp17_;
			guchar* _tmp18_;
			gint _tmp18__length1;
			guchar _tmp19_;
			guchar* _tmp20_;
			gint _tmp20__length1;
			guchar _tmp21_;
			GdkWindow* _tmp22_;
			GdkAtom _tmp23_ = 0U;
			gint _tmp24_ = 0;
			guint8* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gboolean _tmp27_;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			gboolean _tmp30_ = FALSE;
			gint i = 0;
			guchar* _tmp32_;
			gint _tmp32__length1;
			guchar _tmp33_;
			guchar* _tmp34_;
			gint _tmp34__length1;
			guchar _tmp35_;
			guchar* _tmp36_;
			gint _tmp36__length1;
			guchar _tmp37_;
			guchar* _tmp38_;
			gint _tmp38__length1;
			guchar _tmp39_;
			guchar* _tmp40_;
			gint _tmp40__length1;
			guchar _tmp41_;
			guchar* _tmp42_;
			gint _tmp42__length1;
			guchar _tmp43_;
			guchar* _tmp44_;
			gint _tmp44__length1;
			guchar _tmp45_;
			guchar* _tmp46_;
			gint _tmp46__length1;
			guchar _tmp47_;
			guchar* _tmp48_;
			gint _tmp48__length1;
			guchar _tmp49_;
			guchar* _tmp50_;
			gint _tmp50__length1;
			guchar _tmp51_;
			guchar* _tmp52_;
			gint _tmp52__length1;
			guchar _tmp53_;
			guchar* _tmp54_;
			gint _tmp54__length1;
			guchar _tmp55_;
			guchar* _tmp56_;
			gint _tmp56__length1;
			guchar _tmp57_;
			guchar* _tmp58_;
			gint _tmp58__length1;
			guchar _tmp59_;
			guchar* _tmp60_;
			gint _tmp60__length1;
			guchar _tmp61_;
			guchar* _tmp62_;
			gint _tmp62__length1;
			guchar _tmp63_;
			if (!_tmp1_) {
				if (!FALSE) {
					break;
				}
			}
			_tmp1_ = FALSE;
			_tmp2_ = gdk_get_default_root_window ();
			_tmp3_ = _g_object_ref0 (_tmp2_);
			root = _tmp3_;
			property = gdk_atom_intern ("_NET_CURRENT_DESKTOP", FALSE);
			type = gdk_atom_intern ("CARDINAL", FALSE);
			_tmp4_ = root;
			_tmp9_ = gdk_property_get (_tmp4_, property, type, (gulong) 0, (gulong) G_MAXLONG, 0, &_tmp5_, &_tmp6_, &_tmp8_, &_tmp7_);
			actual_type = _tmp5_;
			format = _tmp6_;
			data = (g_free (data), NULL);
			data = _tmp7_;
			data_length1 = _tmp8_;
			_data_size_ = data_length1;
			_result_ = _tmp9_;
			if (!_result_) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = actual_type != type;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				_tmp11_ = format != 32;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				guchar* _tmp13_;
				gint _tmp13__length1;
				_tmp13_ = data;
				_tmp13__length1 = data_length1;
				_tmp10_ = _tmp13__length1 != 4;
			}
			if (_tmp10_) {
				data = (g_free (data), NULL);
				_g_object_unref0 (root);
				break;
			}
			_tmp14_ = data;
			_tmp14__length1 = data_length1;
			_tmp15_ = _tmp14_[0];
			_tmp16_ = data;
			_tmp16__length1 = data_length1;
			_tmp17_ = _tmp16_[1];
			_tmp18_ = data;
			_tmp18__length1 = data_length1;
			_tmp19_ = _tmp18_[2];
			_tmp20_ = data;
			_tmp20__length1 = data_length1;
			_tmp21_ = _tmp20_[3];
			index = (gint) (((_tmp15_ | (_tmp17_ << 8)) | (_tmp19_ << 16)) | (_tmp21_ << 24));
			property = gdk_atom_intern ("_NET_WORKAREA", FALSE);
			type = gdk_atom_intern ("CARDINAL", FALSE);
			_tmp22_ = root;
			_tmp27_ = gdk_property_get (_tmp22_, property, type, (gulong) 0, (gulong) G_MAXLONG, 0, &_tmp23_, &_tmp24_, &_tmp26_, &_tmp25_);
			actual_type = _tmp23_;
			format = _tmp24_;
			data = (g_free (data), NULL);
			data = _tmp25_;
			data_length1 = _tmp26_;
			_data_size_ = data_length1;
			_result_ = _tmp27_;
			if (!_result_) {
				_tmp30_ = TRUE;
			} else {
				_tmp30_ = actual_type != type;
			}
			if (_tmp30_) {
				_tmp29_ = TRUE;
			} else {
				_tmp29_ = format != 32;
			}
			if (_tmp29_) {
				_tmp28_ = TRUE;
			} else {
				guchar* _tmp31_;
				gint _tmp31__length1;
				_tmp31_ = data;
				_tmp31__length1 = data_length1;
				_tmp28_ = _tmp31__length1 < ((index + 1) * 16);
			}
			if (_tmp28_) {
				data = (g_free (data), NULL);
				_g_object_unref0 (root);
				break;
			}
			i = (index * 4) * 4;
			_tmp32_ = data;
			_tmp32__length1 = data_length1;
			_tmp33_ = _tmp32_[i];
			_tmp34_ = data;
			_tmp34__length1 = data_length1;
			_tmp35_ = _tmp34_[i + 1];
			_tmp36_ = data;
			_tmp36__length1 = data_length1;
			_tmp37_ = _tmp36_[i + 2];
			_tmp38_ = data;
			_tmp38__length1 = data_length1;
			_tmp39_ = _tmp38_[i + 3];
			self->priv->m_workarea.x = (gint) (((_tmp33_ | (_tmp35_ << 8)) | (_tmp37_ << 16)) | (_tmp39_ << 24));
			i += 4;
			_tmp40_ = data;
			_tmp40__length1 = data_length1;
			_tmp41_ = _tmp40_[i];
			_tmp42_ = data;
			_tmp42__length1 = data_length1;
			_tmp43_ = _tmp42_[i + 1];
			_tmp44_ = data;
			_tmp44__length1 = data_length1;
			_tmp45_ = _tmp44_[i + 2];
			_tmp46_ = data;
			_tmp46__length1 = data_length1;
			_tmp47_ = _tmp46_[i + 3];
			self->priv->m_workarea.y = (gint) (((_tmp41_ | (_tmp43_ << 8)) | (_tmp45_ << 16)) | (_tmp47_ << 24));
			i += 4;
			_tmp48_ = data;
			_tmp48__length1 = data_length1;
			_tmp49_ = _tmp48_[i];
			_tmp50_ = data;
			_tmp50__length1 = data_length1;
			_tmp51_ = _tmp50_[i + 1];
			_tmp52_ = data;
			_tmp52__length1 = data_length1;
			_tmp53_ = _tmp52_[i + 2];
			_tmp54_ = data;
			_tmp54__length1 = data_length1;
			_tmp55_ = _tmp54_[i + 3];
			self->priv->m_workarea.width = (gint) (((_tmp49_ | (_tmp51_ << 8)) | (_tmp53_ << 16)) | (_tmp55_ << 24));
			i += 4;
			_tmp56_ = data;
			_tmp56__length1 = data_length1;
			_tmp57_ = _tmp56_[i];
			_tmp58_ = data;
			_tmp58__length1 = data_length1;
			_tmp59_ = _tmp58_[i + 1];
			_tmp60_ = data;
			_tmp60__length1 = data_length1;
			_tmp61_ = _tmp60_[i + 2];
			_tmp62_ = data;
			_tmp62__length1 = data_length1;
			_tmp63_ = _tmp62_[i + 3];
			self->priv->m_workarea.height = (gint) (((_tmp57_ | (_tmp59_ << 8)) | (_tmp61_ << 16)) | (_tmp63_ << 24));
			data = (g_free (data), NULL);
			_g_object_unref0 (root);
		}
	}
	self->priv->m_move_begined = TRUE;
	_tmp64_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_window_get_type (), GtkWindow));
	toplevel = _tmp65_;
	_tmp66_ = toplevel;
	gtk_window_get_position (_tmp66_, &_tmp67_, &_tmp68_);
	x = _tmp67_;
	y = _tmp68_;
	self->priv->m_press_pos.x = ((gint) event->x_root) - x;
	self->priv->m_press_pos.y = ((gint) event->y_root) - y;
	g_signal_emit (self, handle_signals[HANDLE_MOVE_BEGIN_SIGNAL], 0);
	result = TRUE;
	_g_object_unref0 (toplevel);
	return result;
}

static gboolean
handle_real_button_release_event (GtkWidget* base,
                                  GdkEventButton* event)
{
	Handle * self;
	GdkWindow* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	gboolean result = FALSE;
	self = (Handle*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	self->priv->m_move_begined = FALSE;
	self->priv->m_press_pos.x = 0;
	self->priv->m_press_pos.y = 0;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gdk_cursor_new_for_display (_tmp1_, GDK_FLEUR);
	_tmp3_ = _tmp2_;
	gdk_window_set_cursor (_tmp0_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_signal_emit (self, handle_signals[HANDLE_MOVE_END_SIGNAL], 0);
	result = TRUE;
	return result;
}

static gboolean
handle_real_motion_notify_event (GtkWidget* base,
                                 GdkEventMotion* event)
{
	Handle * self;
	GtkWindow* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWindow* _tmp1_;
	gint x = 0;
	GdkPoint _tmp2_;
	gint y = 0;
	GdkPoint _tmp3_;
	gboolean _tmp4_ = FALSE;
	GdkRectangle _tmp5_;
	gboolean _tmp8_ = FALSE;
	GdkRectangle _tmp9_;
	gint w = 0;
	gint h = 0;
	GtkWindow* _tmp12_;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	GdkRectangle _tmp16_;
	GdkRectangle _tmp17_;
	gboolean _tmp22_ = FALSE;
	GdkRectangle _tmp23_;
	GdkRectangle _tmp24_;
	GtkWindow* _tmp29_;
	gboolean result = FALSE;
	self = (Handle*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->m_move_begined) {
		result = FALSE;
		return result;
	}
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
	toplevel = _tmp1_;
	_tmp2_ = self->priv->m_press_pos;
	x = (gint) (event->x_root - _tmp2_.x);
	_tmp3_ = self->priv->m_press_pos;
	y = (gint) (event->y_root - _tmp3_.y);
	_tmp5_ = self->priv->m_workarea;
	if (x < _tmp5_.x) {
		GdkRectangle _tmp6_;
		_tmp6_ = self->priv->m_workarea;
		_tmp4_ = x > (_tmp6_.x - 16);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GdkRectangle _tmp7_;
		_tmp7_ = self->priv->m_workarea;
		x = _tmp7_.x;
	}
	_tmp9_ = self->priv->m_workarea;
	if (y < _tmp9_.y) {
		GdkRectangle _tmp10_;
		_tmp10_ = self->priv->m_workarea;
		_tmp8_ = y > (_tmp10_.y - 16);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GdkRectangle _tmp11_;
		_tmp11_ = self->priv->m_workarea;
		y = _tmp11_.y;
	}
	_tmp12_ = toplevel;
	gtk_window_get_size (_tmp12_, &_tmp13_, &_tmp14_);
	w = _tmp13_;
	h = _tmp14_;
	_tmp16_ = self->priv->m_workarea;
	_tmp17_ = self->priv->m_workarea;
	if ((x + w) > (_tmp16_.x + _tmp17_.width)) {
		GdkRectangle _tmp18_;
		GdkRectangle _tmp19_;
		_tmp18_ = self->priv->m_workarea;
		_tmp19_ = self->priv->m_workarea;
		_tmp15_ = (x + w) < ((_tmp18_.x + _tmp19_.width) + 16);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GdkRectangle _tmp20_;
		GdkRectangle _tmp21_;
		_tmp20_ = self->priv->m_workarea;
		_tmp21_ = self->priv->m_workarea;
		x = (_tmp20_.x + _tmp21_.width) - w;
	}
	_tmp23_ = self->priv->m_workarea;
	_tmp24_ = self->priv->m_workarea;
	if ((y + h) > (_tmp23_.y + _tmp24_.height)) {
		GdkRectangle _tmp25_;
		GdkRectangle _tmp26_;
		_tmp25_ = self->priv->m_workarea;
		_tmp26_ = self->priv->m_workarea;
		_tmp22_ = (y + h) < ((_tmp25_.y + _tmp26_.height) + 16);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		GdkRectangle _tmp27_;
		GdkRectangle _tmp28_;
		_tmp27_ = self->priv->m_workarea;
		_tmp28_ = self->priv->m_workarea;
		y = (_tmp27_.y + _tmp28_.height) - w;
	}
	_tmp29_ = toplevel;
	gtk_window_move (_tmp29_, x, y);
	result = TRUE;
	_g_object_unref0 (toplevel);
	return result;
}

static gboolean
handle_real_draw (GtkWidget* base,
                  cairo_t* cr)
{
	Handle * self;
	GdkWindow* _tmp0_;
	gboolean result = FALSE;
	self = (Handle*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	if (gtk_cairo_should_draw_window (cr, _tmp0_)) {
		GtkStyleContext* context = NULL;
		GtkStyleContext* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkAllocation allocation = {0};
		GtkAllocation _tmp3_ = {0};
		GtkStyleContext* _tmp4_;
		GtkAllocation _tmp5_;
		GtkAllocation _tmp6_;
		GtkAllocation _tmp7_;
		GtkAllocation _tmp8_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		context = _tmp2_;
		gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
		allocation = _tmp3_;
		_tmp4_ = context;
		_tmp5_ = allocation;
		_tmp6_ = allocation;
		_tmp7_ = allocation;
		_tmp8_ = allocation;
		gtk_render_handle (_tmp4_, cr, (gdouble) _tmp5_.x, (gdouble) (_tmp6_.y + ((_tmp7_.height - 40) / 2)), (gdouble) _tmp8_.width, 40.0);
		_g_object_unref0 (context);
	}
	result = FALSE;
	return result;
}

static void
handle_class_init (HandleClass * klass,
                   gpointer klass_data)
{
	handle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Handle_private_offset);
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) handle_real_realize;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) handle_real_button_press_event;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) handle_real_button_release_event;
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) handle_real_motion_notify_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) handle_real_draw;
	G_OBJECT_CLASS (klass)->finalize = handle_finalize;
	handle_signals[HANDLE_MOVE_BEGIN_SIGNAL] = g_signal_new ("move-begin", TYPE_HANDLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	handle_signals[HANDLE_MOVE_END_SIGNAL] = g_signal_new ("move-end", TYPE_HANDLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
handle_instance_init (Handle * self,
                      gpointer klass)
{
	self->priv = handle_get_instance_private (self);
}

static void
handle_finalize (GObject * obj)
{
	Handle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HANDLE, Handle);
	G_OBJECT_CLASS (handle_parent_class)->finalize (obj);
}

static GType
handle_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HandleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) handle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Handle), 0, (GInstanceInitFunc) handle_instance_init, NULL };
	GType handle_type_id;
	handle_type_id = g_type_register_static (gtk_event_box_get_type (), "Handle", &g_define_type_info, 0);
	Handle_private_offset = g_type_add_instance_private (handle_type_id, sizeof (HandlePrivate));
	return handle_type_id;
}

GType
handle_get_type (void)
{
	static volatile gsize handle_type_id__volatile = 0;
	if (g_once_init_enter (&handle_type_id__volatile)) {
		GType handle_type_id;
		handle_type_id = handle_get_type_once ();
		g_once_init_leave (&handle_type_id__volatile, handle_type_id);
	}
	return handle_type_id__volatile;
}

