/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.lang.reflect.Method;
import java.util.Hashtable;
import netscape.ldap.LDAPException;

class DynamicInvoker {
    private static Hashtable<String, Method> m_methodLookup = new Hashtable();

    DynamicInvoker() {
    }

    static Object invokeMethod(Object obj, String packageName, String methodName, Object[] args, String[] argNames) throws LDAPException {
        try {
            Method m = DynamicInvoker.getMethod(packageName, methodName, argNames);
            if (m != null) {
                return m.invoke(obj, args);
            }
        }
        catch (Exception e) {
            throw new LDAPException("Invoking " + methodName + ": " + e.toString(), 89);
        }
        return null;
    }

    static Method getMethod(String packageName, String methodName, String[] args) throws LDAPException {
        try {
            String key;
            Method method = null;
            Object suffix = "";
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    suffix = (String)suffix + args[i].getClass().getName();
                }
            }
            if ((method = m_methodLookup.get(key = packageName + "." + methodName + "." + (String)suffix)) != null) {
                return method;
            }
            Class<?> c = Class.forName(packageName);
            Method[] m = c.getMethods();
            for (int i = 0; i < m.length; ++i) {
                Class<?>[] params = m[i].getParameterTypes();
                if (!m[i].getName().equals(methodName) || !DynamicInvoker.signatureCorrect(params, args)) continue;
                m_methodLookup.put(key, m[i]);
                return m[i];
            }
            throw new LDAPException("Method " + methodName + " not found in " + packageName);
        }
        catch (ClassNotFoundException e) {
            throw new LDAPException("Class " + packageName + " not found");
        }
    }

    private static boolean signatureCorrect(Class<?>[] params, String[] args) {
        if (args == null) {
            return true;
        }
        if (params.length != args.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getName().equals(args[i])) continue;
            return false;
        }
        return true;
    }
}

