// Code generated by interstellar. DO NOT EDIT.
// Compatible with leonis RTL tag 0710

#ifndef NBL_UPA_H
#define NBL_UPA_H 1

#include <linux/types.h>

#define NBL_UPA_BASE (0x0008C000)

#define NBL_UPA_INT_STATUS_ADDR  (0x8c000)
#define NBL_UPA_INT_STATUS_DEPTH (1)
#define NBL_UPA_INT_STATUS_WIDTH (32)
#define NBL_UPA_INT_STATUS_DWLEN (1)
union upa_int_status_u {
	struct upa_int_status {
		u32 fatal_err:1;         /* [0] Default:0x0 RWC */
		u32 fifo_underflow:1;    /* [1] Default:0x0 RWC */
		u32 fifo_overflow:1;     /* [2] Default:0x0 RWC */
		u32 fsm_err:1;           /* [3] Default:0x0 RWC */
		u32 cif_err:1;           /* [4] Default:0x0 RWC */
		u32 rsv1:1;              /* [5] Default:0x0 RO */
		u32 cfg_err:1;           /* [6] Default:0x0 RWC */
		u32 ucor_err:1;          /* [7] Default:0x0 RWC */
		u32 cor_err:1;           /* [8] Default:0x0 RWC */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_INT_STATUS_DWLEN];
} __packed;

#define NBL_UPA_INT_MASK_ADDR  (0x8c004)
#define NBL_UPA_INT_MASK_DEPTH (1)
#define NBL_UPA_INT_MASK_WIDTH (32)
#define NBL_UPA_INT_MASK_DWLEN (1)
union upa_int_mask_u {
	struct upa_int_mask {
		u32 fatal_err:1;         /* [0] Default:0x0 RW */
		u32 fifo_underflow:1;    /* [1] Default:0x0 RW */
		u32 fifo_overflow:1;     /* [2] Default:0x0 RW */
		u32 fsm_err:1;           /* [3] Default:0x0 RW */
		u32 cif_err:1;           /* [4] Default:0x0 RW */
		u32 rsv1:1;              /* [5] Default:0x0 RO */
		u32 cfg_err:1;           /* [6] Default:0x0 RW */
		u32 ucor_err:1;          /* [7] Default:0x0 RW */
		u32 cor_err:1;           /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_INT_MASK_DWLEN];
} __packed;

#define NBL_UPA_INT_SET_ADDR  (0x8c008)
#define NBL_UPA_INT_SET_DEPTH (1)
#define NBL_UPA_INT_SET_WIDTH (32)
#define NBL_UPA_INT_SET_DWLEN (1)
union upa_int_set_u {
	struct upa_int_set {
		u32 fatal_err:1;         /* [0] Default:0x0 WO */
		u32 fifo_underflow:1;    /* [1] Default:0x0 WO */
		u32 fifo_overflow:1;     /* [2] Default:0x0 WO */
		u32 fsm_err:1;           /* [3] Default:0x0 WO */
		u32 cif_err:1;           /* [4] Default:0x0 WO */
		u32 rsv1:1;              /* [5] Default:0x0 RO */
		u32 cfg_err:1;           /* [6] Default:0x0 WO */
		u32 ucor_err:1;          /* [7] Default:0x0 WO */
		u32 cor_err:1;           /* [8] Default:0x0 WO */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_INT_SET_DWLEN];
} __packed;

#define NBL_UPA_INIT_DONE_ADDR  (0x8c00c)
#define NBL_UPA_INIT_DONE_DEPTH (1)
#define NBL_UPA_INIT_DONE_WIDTH (32)
#define NBL_UPA_INIT_DONE_DWLEN (1)
union upa_init_done_u {
	struct upa_init_done {
		u32 done:1;              /* [0] Default:0x0 RO */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_INIT_DONE_DWLEN];
} __packed;

#define NBL_UPA_CIF_ERR_INFO_ADDR  (0x8c040)
#define NBL_UPA_CIF_ERR_INFO_DEPTH (1)
#define NBL_UPA_CIF_ERR_INFO_WIDTH (32)
#define NBL_UPA_CIF_ERR_INFO_DWLEN (1)
union upa_cif_err_info_u {
	struct upa_cif_err_info {
		u32 addr:30;             /* [29:0] Default:0x0 RO */
		u32 wr_err:1;            /* [30] Default:0x0 RO */
		u32 ucor_err:1;          /* [31] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_CIF_ERR_INFO_DWLEN];
} __packed;

#define NBL_UPA_CFG_ERR_INFO_ADDR  (0x8c050)
#define NBL_UPA_CFG_ERR_INFO_DEPTH (1)
#define NBL_UPA_CFG_ERR_INFO_WIDTH (32)
#define NBL_UPA_CFG_ERR_INFO_DWLEN (1)
union upa_cfg_err_info_u {
	struct upa_cfg_err_info {
		u32 id0:2;               /* [1:0] Default:0x0 RO */
		u32 rsv:30;              /* [31:2] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_CFG_ERR_INFO_DWLEN];
} __packed;

#define NBL_UPA_CAR_CTRL_ADDR  (0x8c100)
#define NBL_UPA_CAR_CTRL_DEPTH (1)
#define NBL_UPA_CAR_CTRL_WIDTH (32)
#define NBL_UPA_CAR_CTRL_DWLEN (1)
union upa_car_ctrl_u {
	struct upa_car_ctrl {
		u32 sctr_car:1;          /* [0] Default:0x1 RW */
		u32 rctr_car:1;          /* [1] Default:0x1 RW */
		u32 rc_car:1;            /* [2] Default:0x1 RW */
		u32 tbl_rc_car:1;        /* [3] Default:0x1 RW */
		u32 rsv:28;              /* [31:4] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_CAR_CTRL_DWLEN];
} __packed;

#define NBL_UPA_INIT_START_ADDR  (0x8c180)
#define NBL_UPA_INIT_START_DEPTH (1)
#define NBL_UPA_INIT_START_WIDTH (32)
#define NBL_UPA_INIT_START_DWLEN (1)
union upa_init_start_u {
	struct upa_init_start {
		u32 start:1;             /* [0] Default:0x0 WO */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_INIT_START_DWLEN];
} __packed;

#define NBL_UPA_LAYO_CKSUM0_CTRL_ADDR  (0x8c1b0)
#define NBL_UPA_LAYO_CKSUM0_CTRL_DEPTH (4)
#define NBL_UPA_LAYO_CKSUM0_CTRL_WIDTH (32)
#define NBL_UPA_LAYO_CKSUM0_CTRL_DWLEN (1)
union upa_layo_cksum0_ctrl_u {
	struct upa_layo_cksum0_ctrl {
		u32 data:32;             /* [31:0] Default:0xFFFFFFFF RW */
	} __packed info;
	u32 data[NBL_UPA_LAYO_CKSUM0_CTRL_DWLEN];
} __packed;
#define NBL_UPA_LAYO_CKSUM0_CTRL_REG(r) (NBL_UPA_LAYO_CKSUM0_CTRL_ADDR + \
		(NBL_UPA_LAYO_CKSUM0_CTRL_DWLEN * 4) * (r))

#define NBL_UPA_LAYI_CKSUM0_CTRL_ADDR  (0x8c1c0)
#define NBL_UPA_LAYI_CKSUM0_CTRL_DEPTH (4)
#define NBL_UPA_LAYI_CKSUM0_CTRL_WIDTH (32)
#define NBL_UPA_LAYI_CKSUM0_CTRL_DWLEN (1)
union upa_layi_cksum0_ctrl_u {
	struct upa_layi_cksum0_ctrl {
		u32 data:32;             /* [31:0] Default:0xFFFFFFFF RW */
	} __packed info;
	u32 data[NBL_UPA_LAYI_CKSUM0_CTRL_DWLEN];
} __packed;
#define NBL_UPA_LAYI_CKSUM0_CTRL_REG(r) (NBL_UPA_LAYI_CKSUM0_CTRL_ADDR + \
		(NBL_UPA_LAYI_CKSUM0_CTRL_DWLEN * 4) * (r))

#define NBL_UPA_FWD_TYPE_STAGE_0_ADDR  (0x8c1d0)
#define NBL_UPA_FWD_TYPE_STAGE_0_DEPTH (1)
#define NBL_UPA_FWD_TYPE_STAGE_0_WIDTH (32)
#define NBL_UPA_FWD_TYPE_STAGE_0_DWLEN (1)
union upa_fwd_type_stage_0_u {
	struct upa_fwd_type_stage_0 {
		u32 tbl:32;              /* [31:0] Default:0xF3FFFFF2 RW */
	} __packed info;
	u32 data[NBL_UPA_FWD_TYPE_STAGE_0_DWLEN];
} __packed;

#define NBL_UPA_FWD_TYPE_STAGE_1_ADDR  (0x8c1d4)
#define NBL_UPA_FWD_TYPE_STAGE_1_DEPTH (1)
#define NBL_UPA_FWD_TYPE_STAGE_1_WIDTH (32)
#define NBL_UPA_FWD_TYPE_STAGE_1_DWLEN (1)
union upa_fwd_type_stage_1_u {
	struct upa_fwd_type_stage_1 {
		u32 tbl:32;              /* [31:0] Default:0xFFFFFFFF RW */
	} __packed info;
	u32 data[NBL_UPA_FWD_TYPE_STAGE_1_DWLEN];
} __packed;

#define NBL_UPA_FWD_TYPE_STAGE_2_ADDR  (0x8c1d8)
#define NBL_UPA_FWD_TYPE_STAGE_2_DEPTH (1)
#define NBL_UPA_FWD_TYPE_STAGE_2_WIDTH (32)
#define NBL_UPA_FWD_TYPE_STAGE_2_DWLEN (1)
union upa_fwd_type_stage_2_u {
	struct upa_fwd_type_stage_2 {
		u32 tbl:32;              /* [31:0] Default:0xFFFFFFFF RW */
	} __packed info;
	u32 data[NBL_UPA_FWD_TYPE_STAGE_2_DWLEN];
} __packed;

#define NBL_UPA_FWD_TYPE_BYPASS_0_ADDR  (0x8c1e0)
#define NBL_UPA_FWD_TYPE_BYPASS_0_DEPTH (1)
#define NBL_UPA_FWD_TYPE_BYPASS_0_WIDTH (32)
#define NBL_UPA_FWD_TYPE_BYPASS_0_DWLEN (1)
union upa_fwd_type_bypass_0_u {
	struct upa_fwd_type_bypass_0 {
		u32 tbl:8;               /* [7:0] Default:0x80 RW */
		u32 rsv:24;              /* [31:8] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_FWD_TYPE_BYPASS_0_DWLEN];
} __packed;

#define NBL_UPA_FWD_TYPE_BYPASS_1_ADDR  (0x8c1e4)
#define NBL_UPA_FWD_TYPE_BYPASS_1_DEPTH (1)
#define NBL_UPA_FWD_TYPE_BYPASS_1_WIDTH (32)
#define NBL_UPA_FWD_TYPE_BYPASS_1_DWLEN (1)
union upa_fwd_type_bypass_1_u {
	struct upa_fwd_type_bypass_1 {
		u32 tbl:8;               /* [7:0] Default:0x80 RW */
		u32 rsv:24;              /* [31:8] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_FWD_TYPE_BYPASS_1_DWLEN];
} __packed;

#define NBL_UPA_FWD_TYPE_BYPASS_2_ADDR  (0x8c1e8)
#define NBL_UPA_FWD_TYPE_BYPASS_2_DEPTH (1)
#define NBL_UPA_FWD_TYPE_BYPASS_2_WIDTH (32)
#define NBL_UPA_FWD_TYPE_BYPASS_2_DWLEN (1)
union upa_fwd_type_bypass_2_u {
	struct upa_fwd_type_bypass_2 {
		u32 tbl:8;               /* [7:0] Default:0x80 RW */
		u32 rsv:24;              /* [31:8] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_FWD_TYPE_BYPASS_2_DWLEN];
} __packed;

#define NBL_UPA_DPORT_EXTRACT_ADDR  (0x8c1ec)
#define NBL_UPA_DPORT_EXTRACT_DEPTH (1)
#define NBL_UPA_DPORT_EXTRACT_WIDTH (32)
#define NBL_UPA_DPORT_EXTRACT_DWLEN (1)
union upa_dport_extract_u {
	struct upa_dport_extract {
		u32 id:6;                /* [5:0] Default:0x9 RW */
		u32 rsv:26;              /* [31:6] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_DPORT_EXTRACT_DWLEN];
} __packed;

#define NBL_UPA_LAYO_PHV_ADDR  (0x8c1f0)
#define NBL_UPA_LAYO_PHV_DEPTH (1)
#define NBL_UPA_LAYO_PHV_WIDTH (32)
#define NBL_UPA_LAYO_PHV_DWLEN (1)
union upa_layo_phv_u {
	struct upa_layo_phv {
		u32 len:7;               /* [6:0] Default:0x46 RW */
		u32 change_en:1;         /* [7] Default:0x1 RW */
		u32 rsv:24;              /* [31:8] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_LAYO_PHV_DWLEN];
} __packed;

#define NBL_UPA_L4S_PAD_ADDR  (0x8c1f4)
#define NBL_UPA_L4S_PAD_DEPTH (1)
#define NBL_UPA_L4S_PAD_WIDTH (32)
#define NBL_UPA_L4S_PAD_DWLEN (1)
union upa_l4s_pad_u {
	struct upa_l4s_pad {
		u32 p_length:7;          /* [6:0] Default:0x3C RW */
		u32 en:1;                /* [7] Default:0x0 RW */
		u32 rsv:24;              /* [31:8] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_L4S_PAD_DWLEN];
} __packed;

#define NBL_UPA_LAYO_FLAG_ADDR  (0x8c1f8)
#define NBL_UPA_LAYO_FLAG_DEPTH (1)
#define NBL_UPA_LAYO_FLAG_WIDTH (32)
#define NBL_UPA_LAYO_FLAG_DWLEN (1)
union upa_layo_flag_u {
	struct upa_layo_flag {
		u32 mask:32;             /* [31:0] Default:0x00 RW */
	} __packed info;
	u32 data[NBL_UPA_LAYO_FLAG_DWLEN];
} __packed;

#define NBL_UPA_IP_EXT_PROTOCOL_ADDR  (0x8c1fc)
#define NBL_UPA_IP_EXT_PROTOCOL_DEPTH (1)
#define NBL_UPA_IP_EXT_PROTOCOL_WIDTH (32)
#define NBL_UPA_IP_EXT_PROTOCOL_DWLEN (1)
union upa_ip_ext_protocol_u {
	struct upa_ip_ext_protocol {
		u32 tcp:8;               /* [7:0] Default:0x6 RW */
		u32 udp:8;               /* [15:8] Default:0x11 RW */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_IP_EXT_PROTOCOL_DWLEN];
} __packed;

#define NBL_UPA_L3V6_ML_DA_ADDR  (0x8c204)
#define NBL_UPA_L3V6_ML_DA_DEPTH (1)
#define NBL_UPA_L3V6_ML_DA_WIDTH (32)
#define NBL_UPA_L3V6_ML_DA_DWLEN (1)
union upa_l3v6_ml_da_u {
	struct upa_l3v6_ml_da {
		u32 ml_da:16;            /* [15:0] Default:0x3333 RW */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_L3V6_ML_DA_DWLEN];
} __packed;

#define NBL_UPA_NEXT_KEY_ADDR  (0x8c208)
#define NBL_UPA_NEXT_KEY_DEPTH (1)
#define NBL_UPA_NEXT_KEY_WIDTH (32)
#define NBL_UPA_NEXT_KEY_DWLEN (1)
union upa_next_key_u {
	struct upa_next_key {
		u32 key_b:8;             /* [7:0] Default:0x10 RW */
		u32 key_a:8;             /* [15:8] Default:0x0C RW */
		u32 rsv:16;              /* [31:16] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_NEXT_KEY_DWLEN];
} __packed;

#define NBL_UPA_L3_ML_DA_ADDR  (0x8c20c)
#define NBL_UPA_L3_ML_DA_DEPTH (1)
#define NBL_UPA_L3_ML_DA_WIDTH (32)
#define NBL_UPA_L3_ML_DA_DWLEN (1)
union upa_l3_ml_da_u {
	struct upa_l3_ml_da {
		u32 ml_da_0:16;          /* [15:0] Default:0x5e00 RW */
		u32 ml_da_1:16;          /* [31:16] Default:0x0100 RW */
	} __packed info;
	u32 data[NBL_UPA_L3_ML_DA_DWLEN];
} __packed;

#define NBL_UPA_CK_CTRL_ADDR  (0x8c210)
#define NBL_UPA_CK_CTRL_DEPTH (1)
#define NBL_UPA_CK_CTRL_WIDTH (32)
#define NBL_UPA_CK_CTRL_DWLEN (1)
union upa_ck_ctrl_u {
	struct upa_ck_ctrl {
		u32 tcp_csum_en:1;       /* [0] Default:0x1 RW */
		u32 udp_csum_en:1;       /* [1] Default:0x1 RW */
		u32 sctp_crc32c_en:1;    /* [2] Default:0x1 RW */
		u32 ipv4_ck_en:1;        /* [3] Default:0x1 RW */
		u32 ipv6_ck_en:1;        /* [4] Default:0x1 RW */
		u32 DA_ck_en:1;          /* [5] Default:0x1 RW */
		u32 ipv6_ext_en:1;       /* [6] Default:0x0 RW */
		u32 vlan_error_en:1;     /* [7] Default:0x1 RW */
		u32 ctrl_p_en:1;         /* [8] Default:0x0 RW */
		u32 ip_tlen_ck_en:1;     /* [9] Default:0x0 RW */
		u32 not_uc_p_plck_aux_en:1; /* [10] Default:0x0 RW */
		u32 sctp_crc_plck_aux_en:1; /* [11] Default:0x1 RW */
		u32 tcp_csum_offset_id:2; /* [13:12] Default:0x2 RW */
		u32 udp_csum_offset_id:2; /* [15:14] Default:0x2 RW */
		u32 sctp_crc32c_offset_id:2; /* [17:16] Default:0x2 RW */
		u32 ipv4_ck_offset_id:2; /* [19:18] Default:0x1 RW */
		u32 ipv6_ck_offset_id:2; /* [21:20] Default:0x1 RW */
		u32 DA_ck_offset_id:2;   /* [23:22] Default:0x0 RW */
		u32 plck_offset_id:2;    /* [25:24] Default:0x3 RW */
		u32 rsv:6;               /* [31:26] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_CK_CTRL_DWLEN];
} __packed;

#define NBL_UPA_MC_INDEX_ADDR  (0x8c214)
#define NBL_UPA_MC_INDEX_DEPTH (1)
#define NBL_UPA_MC_INDEX_WIDTH (32)
#define NBL_UPA_MC_INDEX_DWLEN (1)
union upa_mc_index_u {
	struct upa_mc_index {
		u32 l2_mc_index:5;       /* [4:0] Default:0x8 RW */
		u32 rsv2:3;              /* [7:5] Default:0x00 RO */
		u32 l3_mc_index:5;       /* [12:8] Default:0x9 RW */
		u32 rsv1:3;              /* [15:13] Default:0x00 RO */
		u32 ctrl_p_index:5;      /* [20:16] Default:0xF RW */
		u32 rsv:11;              /* [31:21] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_MC_INDEX_DWLEN];
} __packed;

#define NBL_UPA_CTRL_P_DA_ADDR  (0x8c218)
#define NBL_UPA_CTRL_P_DA_DEPTH (1)
#define NBL_UPA_CTRL_P_DA_WIDTH (32)
#define NBL_UPA_CTRL_P_DA_DWLEN (1)
union upa_ctrl_p_da_u {
	struct upa_ctrl_p_da {
		u32 ctrl_da_0:16;        /* [15:0] Default:0xC200 RW */
		u32 ctrl_da_1:16;        /* [31:16] Default:0x0180 RW */
	} __packed info;
	u32 data[NBL_UPA_CTRL_P_DA_DWLEN];
} __packed;

#define NBL_UPA_VLAN_INDEX_ADDR  (0x8c220)
#define NBL_UPA_VLAN_INDEX_DEPTH (1)
#define NBL_UPA_VLAN_INDEX_WIDTH (32)
#define NBL_UPA_VLAN_INDEX_DWLEN (1)
union upa_vlan_index_u {
	struct upa_vlan_index {
		u32 i_vlan2_index:5;     /* [4:0] Default:0x7 RW */
		u32 rsv3:3;              /* [7:5] Default:0x00 RO */
		u32 i_vlan1_index:5;     /* [12:8] Default:0x6 RW */
		u32 rsv2:3;              /* [15:13] Default:0x00 RO */
		u32 o_vlan2_index:5;     /* [20:16] Default:0x11 RW */
		u32 rsv1:3;              /* [23:21] Default:0x0 RO */
		u32 o_vlan1_index:5;     /* [28:24] Default:0x10 RW */
		u32 rsv:3;               /* [31:29] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_VLAN_INDEX_DWLEN];
} __packed;

#define NBL_UPA_PRI_VLAN_INDEX_ADDR  (0x8c224)
#define NBL_UPA_PRI_VLAN_INDEX_DEPTH (1)
#define NBL_UPA_PRI_VLAN_INDEX_WIDTH (32)
#define NBL_UPA_PRI_VLAN_INDEX_DWLEN (1)
union upa_pri_vlan_index_u {
	struct upa_pri_vlan_index {
		u32 int_vlan2:7;         /* [6:0] Default:0x30 RW */
		u32 rsv3:1;              /* [7] Default:0x0 RO */
		u32 int_vlan1:7;         /* [14:8] Default:0x2E RW */
		u32 rsv2:1;              /* [15] Default:0x0 RO */
		u32 ext_vlan2:7;         /* [22:16] Default:0x10 RW */
		u32 rsv1:1;              /* [23] Default:0x0 RO */
		u32 ext_vlan1:7;         /* [30:24] Default:0xE RW */
		u32 rsv:1;               /* [31] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_PRI_VLAN_INDEX_DWLEN];
} __packed;

#define NBL_UPA_PRI_DSCP_INDEX_ADDR  (0x8c228)
#define NBL_UPA_PRI_DSCP_INDEX_DEPTH (1)
#define NBL_UPA_PRI_DSCP_INDEX_WIDTH (32)
#define NBL_UPA_PRI_DSCP_INDEX_DWLEN (1)
union upa_pri_dscp_index_u {
	struct upa_pri_dscp_index {
		u32 int_dscp:7;          /* [6:0] Default:0x32 RW */
		u32 rsv3:1;              /* [7] Default:0x0 RO */
		u32 ext_dscp:7;          /* [14:8] Default:0x12 RW */
		u32 rsv2:1;              /* [15] Default:0x0 RO */
		u32 ipv4_flag:5;         /* [20:16] Default:0x1 RW */
		u32 rsv1:3;              /* [23:21] Default:0x0 RO */
		u32 ipv6_flag:5;         /* [28:24] Default:0x2 RW */
		u32 rsv:3;               /* [31:29] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_PRI_DSCP_INDEX_DWLEN];
} __packed;

#define NBL_UPA_RDMA_INDEX_ADDR  (0x8c22c)
#define NBL_UPA_RDMA_INDEX_DEPTH (1)
#define NBL_UPA_RDMA_INDEX_WIDTH (32)
#define NBL_UPA_RDMA_INDEX_DWLEN (1)
union upa_rdma_index_u {
	struct upa_rdma_index {
		u32 ext_qpn:7;           /* [6:0] Default:0x42 RW */
		u32 rsv1:1;              /* [7] Default:0x0 RO */
		u32 rdma_index:5;        /* [12:8] Default:0xA RW */
		u32 rsv:19;              /* [31:13] Default:0x00 RO */
	} __packed info;
	u32 data[NBL_UPA_RDMA_INDEX_DWLEN];
} __packed;

#define NBL_UPA_PRI_SEL_CONF_ADDR  (0x8c230)
#define NBL_UPA_PRI_SEL_CONF_DEPTH (5)
#define NBL_UPA_PRI_SEL_CONF_WIDTH (32)
#define NBL_UPA_PRI_SEL_CONF_DWLEN (1)
union upa_pri_sel_conf_u {
	struct upa_pri_sel_conf {
		u32 pri_sel:5;           /* [4:0] Default:0x0 RW */
		u32 pri_default:3;       /* [7:5] Default:0x0 RW */
		u32 pri_disen:1;         /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_PRI_SEL_CONF_DWLEN];
} __packed;
#define NBL_UPA_PRI_SEL_CONF_REG(r) (NBL_UPA_PRI_SEL_CONF_ADDR + \
		(NBL_UPA_PRI_SEL_CONF_DWLEN * 4) * (r))

#define NBL_UPA_ERROR_DROP_ADDR  (0x8c248)
#define NBL_UPA_ERROR_DROP_DEPTH (1)
#define NBL_UPA_ERROR_DROP_WIDTH (32)
#define NBL_UPA_ERROR_DROP_DWLEN (1)
union upa_error_drop_u {
	struct upa_error_drop {
		u32 en:7;                /* [6:0] Default:0x0 RW */
		u32 rsv:25;              /* [31:7] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_ERROR_DROP_DWLEN];
} __packed;

#define NBL_UPA_ERROR_CODE_ADDR  (0x8c24c)
#define NBL_UPA_ERROR_CODE_DEPTH (1)
#define NBL_UPA_ERROR_CODE_WIDTH (32)
#define NBL_UPA_ERROR_CODE_DWLEN (1)
union upa_error_code_u {
	struct upa_error_code {
		u32 no:32;               /* [31:0] Default:0x09123456 RW */
	} __packed info;
	u32 data[NBL_UPA_ERROR_CODE_DWLEN];
} __packed;

#define NBL_UPA_PTYPE_SCAN_ADDR  (0x8c250)
#define NBL_UPA_PTYPE_SCAN_DEPTH (1)
#define NBL_UPA_PTYPE_SCAN_WIDTH (32)
#define NBL_UPA_PTYPE_SCAN_DWLEN (1)
union upa_ptype_scan_u {
	struct upa_ptype_scan {
		u32 en:1;                /* [0] Default:0x0 RW */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_PTYPE_SCAN_DWLEN];
} __packed;

#define NBL_UPA_PTYPE_SCAN_TH_ADDR  (0x8c254)
#define NBL_UPA_PTYPE_SCAN_TH_DEPTH (1)
#define NBL_UPA_PTYPE_SCAN_TH_WIDTH (32)
#define NBL_UPA_PTYPE_SCAN_TH_DWLEN (1)
union upa_ptype_scan_th_u {
	struct upa_ptype_scan_th {
		u32 th:32;               /* [31:00] Default:0x40 RW */
	} __packed info;
	u32 data[NBL_UPA_PTYPE_SCAN_TH_DWLEN];
} __packed;

#define NBL_UPA_PTYPE_SCAN_MASK_ADDR  (0x8c258)
#define NBL_UPA_PTYPE_SCAN_MASK_DEPTH (1)
#define NBL_UPA_PTYPE_SCAN_MASK_WIDTH (32)
#define NBL_UPA_PTYPE_SCAN_MASK_DWLEN (1)
union upa_ptype_scan_mask_u {
	struct upa_ptype_scan_mask {
		u32 addr:8;              /* [7:0] Default:0x0 RW */
		u32 en:1;                /* [8] Default:0x0 RW */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_PTYPE_SCAN_MASK_DWLEN];
} __packed;

#define NBL_UPA_PTYPE_INSERT_SEARCH_ADDR  (0x8c25c)
#define NBL_UPA_PTYPE_INSERT_SEARCH_DEPTH (1)
#define NBL_UPA_PTYPE_INSERT_SEARCH_WIDTH (32)
#define NBL_UPA_PTYPE_INSERT_SEARCH_DWLEN (1)
union upa_ptype_insert_search_u {
	struct upa_ptype_insert_search {
		u32 ctrl:1;              /* [0] Default:0x0 WO */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_PTYPE_INSERT_SEARCH_DWLEN];
} __packed;

#define NBL_UPA_PTYPE_INSERT_SEARCH_0_ADDR  (0x8c260)
#define NBL_UPA_PTYPE_INSERT_SEARCH_0_DEPTH (1)
#define NBL_UPA_PTYPE_INSERT_SEARCH_0_WIDTH (32)
#define NBL_UPA_PTYPE_INSERT_SEARCH_0_DWLEN (1)
union upa_ptype_insert_search_0_u {
	struct upa_ptype_insert_search_0 {
		u32 key0:32;             /* [31:00] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPA_PTYPE_INSERT_SEARCH_0_DWLEN];
} __packed;

#define NBL_UPA_PTYPE_INSERT_SEARCH_1_ADDR  (0x8c264)
#define NBL_UPA_PTYPE_INSERT_SEARCH_1_DEPTH (1)
#define NBL_UPA_PTYPE_INSERT_SEARCH_1_WIDTH (32)
#define NBL_UPA_PTYPE_INSERT_SEARCH_1_DWLEN (1)
union upa_ptype_insert_search_1_u {
	struct upa_ptype_insert_search_1 {
		u32 key1:32;             /* [31:00] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPA_PTYPE_INSERT_SEARCH_1_DWLEN];
} __packed;

#define NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_ADDR  (0x8c268)
#define NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_DEPTH (1)
#define NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_WIDTH (32)
#define NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_DWLEN (1)
union upa_ptype_insert_search_result_u {
	struct upa_ptype_insert_search_result {
		u32 result:8;            /* [7:0] Default:0x0 RO */
		u32 hit:1;               /* [8] Default:0x0 RO */
		u32 rsv:23;              /* [31:9] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_DWLEN];
} __packed;

#define NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_ACK_ADDR  (0x8c270)
#define NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_ACK_DEPTH (1)
#define NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_ACK_WIDTH (32)
#define NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_ACK_DWLEN (1)
union upa_ptype_insert_search_result_ack_u {
	struct upa_ptype_insert_search_result_ack {
		u32 vld:1;               /* [0] Default:0x0 RC */
		u32 rsv:31;              /* [31:1] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_PTYPE_INSERT_SEARCH_RESULT_ACK_DWLEN];
} __packed;

#define NBL_UPA_CFG_TEST_ADDR  (0x8c80c)
#define NBL_UPA_CFG_TEST_DEPTH (1)
#define NBL_UPA_CFG_TEST_WIDTH (32)
#define NBL_UPA_CFG_TEST_DWLEN (1)
union upa_cfg_test_u {
	struct upa_cfg_test {
		u32 test:32;             /* [31:00] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPA_CFG_TEST_DWLEN];
} __packed;

#define NBL_UPA_BP_STATE_ADDR  (0x8cb00)
#define NBL_UPA_BP_STATE_DEPTH (1)
#define NBL_UPA_BP_STATE_WIDTH (32)
#define NBL_UPA_BP_STATE_DWLEN (1)
union upa_bp_state_u {
	struct upa_bp_state {
		u32 pa_rmux_data_bp:1;   /* [0] Default:0x0 RO */
		u32 pa_rmux_info_bp:1;   /* [1] Default:0x0 RO */
		u32 store_pa_data_bp:1;  /* [2] Default:0x0 RO */
		u32 store_pa_info_bp:1;  /* [3] Default:0x0 RO */
		u32 rx_data_fifo_afull:1; /* [4] Default:0x0 RO */
		u32 rx_info_fifo_afull:1; /* [5] Default:0x0 RO */
		u32 rx_ctrl_fifo_afull:1; /* [6] Default:0x0 RO */
		u32 cinf1_fifo_afull:1;  /* [7] Default:0x0 RO */
		u32 ctrl_cinf1_fifo_afull:1; /* [8] Default:0x0 RO */
		u32 layo_info_fifo_afull:1; /* [9] Default:0x0 RO */
		u32 cinf2_fifo_afull:1;  /* [10] Default:0x0 RO */
		u32 ctrl_cinf2_fifo_afull:1; /* [11] Default:0x0 RO */
		u32 layi_info_fifo_afull:1; /* [12] Default:0x0 RO */
		u32 rsv:19;              /* [31:13] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_BP_STATE_DWLEN];
} __packed;

#define NBL_UPA_BP_HISTORY_ADDR  (0x8cb04)
#define NBL_UPA_BP_HISTORY_DEPTH (1)
#define NBL_UPA_BP_HISTORY_WIDTH (32)
#define NBL_UPA_BP_HISTORY_DWLEN (1)
union upa_bp_history_u {
	struct upa_bp_history {
		u32 pa_rmux_data_bp:1;   /* [0] Default:0x0 RC */
		u32 pa_rmux_info_bp:1;   /* [1] Default:0x0 RC */
		u32 store_pa_data_bp:1;  /* [2] Default:0x0 RC */
		u32 store_pa_info_bp:1;  /* [3] Default:0x0 RC */
		u32 rx_data_fifo_afull:1; /* [4] Default:0x0 RC */
		u32 rx_info_fifo_afull:1; /* [5] Default:0x0 RC */
		u32 rx_ctrl_fifo_afull:1; /* [6] Default:0x0 RC */
		u32 cinf1_fifo_afull:1;  /* [7] Default:0x0 RC */
		u32 ctrl_cinf1_fifo_afull:1; /* [8] Default:0x0 RC */
		u32 layo_info_fifo_afull:1; /* [9] Default:0x0 RC */
		u32 cinf2_fifo_afull:1;  /* [10] Default:0x0 RC */
		u32 ctrl_cinf2_fifo_afull:1; /* [11] Default:0x0 RC */
		u32 layi_info_fifo_afull:1; /* [12] Default:0x0 RC */
		u32 rsv:19;              /* [31:13] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_BP_HISTORY_DWLEN];
} __packed;

#define NBL_UPA_PRI_CONF_TABLE_ADDR  (0x8e000)
#define NBL_UPA_PRI_CONF_TABLE_DEPTH (40)
#define NBL_UPA_PRI_CONF_TABLE_WIDTH (32)
#define NBL_UPA_PRI_CONF_TABLE_DWLEN (1)
union upa_pri_conf_table_u {
	struct upa_pri_conf_table {
		u32 pri0:4;              /* [3:0] Default:0x0 RW */
		u32 pri1:4;              /* [7:4] Default:0x0 RW */
		u32 pri2:4;              /* [11:8] Default:0x0 RW */
		u32 pri3:4;              /* [15:12] Default:0x0 RW */
		u32 pri4:4;              /* [19:16] Default:0x0 RW */
		u32 pri5:4;              /* [23:20] Default:0x0 RW */
		u32 pri6:4;              /* [27:24] Default:0x0 RW */
		u32 pri7:4;              /* [31:28] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPA_PRI_CONF_TABLE_DWLEN];
} __packed;
#define NBL_UPA_PRI_CONF_TABLE_REG(r) (NBL_UPA_PRI_CONF_TABLE_ADDR + \
		(NBL_UPA_PRI_CONF_TABLE_DWLEN * 4) * (r))

#define NBL_UPA_KEY_TCAM_ADDR  (0x8f000)
#define NBL_UPA_KEY_TCAM_DEPTH (256)
#define NBL_UPA_KEY_TCAM_WIDTH (64)
#define NBL_UPA_KEY_TCAM_DWLEN (2)
union upa_key_tcam_u {
	struct upa_key_tcam {
		u32 key_b:16;            /* [15:0] Default:0x0 RW */
		u32 key_a:16;            /* [31:16] Default:0x0 RW */
		u32 key_valid:1;         /* [32] Default:0x0 RW */
		u32 rsv:31;              /* [63:33] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_KEY_TCAM_DWLEN];
} __packed;
#define NBL_UPA_KEY_TCAM_REG(r) (NBL_UPA_KEY_TCAM_ADDR + \
		(NBL_UPA_KEY_TCAM_DWLEN * 4) * (r))

#define NBL_UPA_MASK_TCAM_ADDR  (0x8f800)
#define NBL_UPA_MASK_TCAM_DEPTH (256)
#define NBL_UPA_MASK_TCAM_WIDTH (32)
#define NBL_UPA_MASK_TCAM_DWLEN (1)
union upa_mask_tcam_u {
	struct upa_mask_tcam {
		u32 mask_b:16;           /* [15:0] Default:0x0 RW */
		u32 mask_a:16;           /* [31:16] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPA_MASK_TCAM_DWLEN];
} __packed;
#define NBL_UPA_MASK_TCAM_REG(r) (NBL_UPA_MASK_TCAM_ADDR + \
		(NBL_UPA_MASK_TCAM_DWLEN * 4) * (r))

#define NBL_UPA_ACT_TABLE_ADDR  (0x90000)
#define NBL_UPA_ACT_TABLE_DEPTH (256)
#define NBL_UPA_ACT_TABLE_WIDTH (128)
#define NBL_UPA_ACT_TABLE_DWLEN (4)
union upa_act_table_u {
	struct upa_act_table {
		u32 flag_control_0:8;    /* [7:0] Default:0x0 RW */
		u32 flag_control_1:8;    /* [15:8] Default:0x0 RW */
		u32 flag_control_2:8;    /* [23:16] Default:0x0 RW */
		u32 legality_check:8;    /* [31:24] Default:0x0 RW */
		u32 nxt_off_B:8;         /* [39:32] Default:0x0 RW */
		u32 nxt_off_A:8;         /* [47:40] Default:0x0 RW */
		u32 protocol_header_off:8; /* [55:48] Default:0x0 RW */
		u32 payload_length:8;    /* [63:56] Default:0x0 RW */
		u32 mask:8;              /* [71:64] Default:0x0 RW */
		u32 nxt_stg:4;           /* [75:72] Default:0x0 RW */
		u32 rsv_l:32;            /* [127:76] Default:0x0 RO */
		u32 rsv_h:20;            /* [127:76] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_ACT_TABLE_DWLEN];
} __packed;
#define NBL_UPA_ACT_TABLE_REG(r) (NBL_UPA_ACT_TABLE_ADDR + \
		(NBL_UPA_ACT_TABLE_DWLEN * 4) * (r))

#define NBL_UPA_EXT_CONF_TABLE_ADDR  (0x91000)
#define NBL_UPA_EXT_CONF_TABLE_DEPTH (1024)
#define NBL_UPA_EXT_CONF_TABLE_WIDTH (32)
#define NBL_UPA_EXT_CONF_TABLE_DWLEN (1)
union upa_ext_conf_table_u {
	struct upa_ext_conf_table {
		u32 dst_offset:8;        /* [7:0] Default:0x0 RW */
		u32 source_offset:6;     /* [13:8] Default:0x0 RW */
		u32 mode_start_off:2;    /* [15:14] Default:0x0 RW */
		u32 lx_sel:2;            /* [17:16] Default:0x0 RW */
		u32 mode_sel:1;          /* [18] Default:0x0 RW */
		u32 op_en:1;             /* [19] Default:0x0 RW */
		u32 rsv:8;               /* [31:24] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_EXT_CONF_TABLE_DWLEN];
} __packed;
#define NBL_UPA_EXT_CONF_TABLE_REG(r) (NBL_UPA_EXT_CONF_TABLE_ADDR + \
		(NBL_UPA_EXT_CONF_TABLE_DWLEN * 4) * (r))

#define NBL_UPA_EXT_INDEX_TCAM_ADDR  (0x92000)
#define NBL_UPA_EXT_INDEX_TCAM_DEPTH (64)
#define NBL_UPA_EXT_INDEX_TCAM_WIDTH (64)
#define NBL_UPA_EXT_INDEX_TCAM_DWLEN (2)
union upa_ext_index_tcam_u {
	struct upa_ext_index_tcam {
		u32 type_index:32;       /* [31:0] Default:0x0 RW */
		u32 type_valid:1;        /* [32] Default:0x0 RW */
		u32 rsv:31;              /* [63:33] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_EXT_INDEX_TCAM_DWLEN];
} __packed;
#define NBL_UPA_EXT_INDEX_TCAM_REG(r) (NBL_UPA_EXT_INDEX_TCAM_ADDR + \
		(NBL_UPA_EXT_INDEX_TCAM_DWLEN * 4) * (r))

#define NBL_UPA_EXT_INDEX_TCAM_MASK_ADDR  (0x92200)
#define NBL_UPA_EXT_INDEX_TCAM_MASK_DEPTH (64)
#define NBL_UPA_EXT_INDEX_TCAM_MASK_WIDTH (32)
#define NBL_UPA_EXT_INDEX_TCAM_MASK_DWLEN (1)
union upa_ext_index_tcam_mask_u {
	struct upa_ext_index_tcam_mask {
		u32 mask:32;             /* [31:0] Default:0x0 RW */
	} __packed info;
	u32 data[NBL_UPA_EXT_INDEX_TCAM_MASK_DWLEN];
} __packed;
#define NBL_UPA_EXT_INDEX_TCAM_MASK_REG(r) (NBL_UPA_EXT_INDEX_TCAM_MASK_ADDR + \
		(NBL_UPA_EXT_INDEX_TCAM_MASK_DWLEN * 4) * (r))

#define NBL_UPA_EXT_INDEX_TABLE_ADDR  (0x92300)
#define NBL_UPA_EXT_INDEX_TABLE_DEPTH (64)
#define NBL_UPA_EXT_INDEX_TABLE_WIDTH (32)
#define NBL_UPA_EXT_INDEX_TABLE_DWLEN (1)
union upa_ext_index_table_u {
	struct upa_ext_index_table {
		u32 p_index:3;           /* [2:0] Default:0x0 RW */
		u32 rsv:29;              /* [31:3] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_EXT_INDEX_TABLE_DWLEN];
} __packed;
#define NBL_UPA_EXT_INDEX_TABLE_REG(r) (NBL_UPA_EXT_INDEX_TABLE_ADDR + \
		(NBL_UPA_EXT_INDEX_TABLE_DWLEN * 4) * (r))

#define NBL_UPA_TYPE_INDEX_TCAM_ADDR  (0x94000)
#define NBL_UPA_TYPE_INDEX_TCAM_DEPTH (256)
#define NBL_UPA_TYPE_INDEX_TCAM_WIDTH (256)
#define NBL_UPA_TYPE_INDEX_TCAM_DWLEN (8)
union upa_type_index_tcam_u {
	struct upa_type_index_tcam {
		u32 layi_x:32;           /* [31:0] Default:0xFFFFFFFF RW */
		u32 layo_x:32;           /* [63:32] Default:0xFFFFFFFF RW */
		u32 layi_y:32;           /* [95:64] Default:0xFFFFFFFF RW */
		u32 layo_y:32;           /* [127:96] Default:0xFFFFFFFF RW */
		u32 type_valid:1;        /* [128] Default:0x0 RW */
		u32 rsv_l:32;            /* [255:129] Default:0x0 RO */
		u32 rsv_h:31;            /* [255:129] Default:0x0 RO */
		u32 rsv_arr[2];          /* [255:129] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_TYPE_INDEX_TCAM_DWLEN];
} __packed;
#define NBL_UPA_TYPE_INDEX_TCAM_REG(r) (NBL_UPA_TYPE_INDEX_TCAM_ADDR + \
		(NBL_UPA_TYPE_INDEX_TCAM_DWLEN * 4) * (r))

#define NBL_UPA_PACKET_TYPE_TABLE_ADDR  (0x96000)
#define NBL_UPA_PACKET_TYPE_TABLE_DEPTH (256)
#define NBL_UPA_PACKET_TYPE_TABLE_WIDTH (32)
#define NBL_UPA_PACKET_TYPE_TABLE_DWLEN (1)
union upa_packet_type_table_u {
	struct upa_packet_type_table {
		u32 p_type:8;            /* [7:0] Default:0x0 RW */
		u32 rsv:24;              /* [31:8] Default:0x0 RO */
	} __packed info;
	u32 data[NBL_UPA_PACKET_TYPE_TABLE_DWLEN];
} __packed;
#define NBL_UPA_PACKET_TYPE_TABLE_REG(r) (NBL_UPA_PACKET_TYPE_TABLE_ADDR + \
		(NBL_UPA_PACKET_TYPE_TABLE_DWLEN * 4) * (r))

#endif
