; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128:n8:16:32:64"

define i32 @test1(i32 %A, i1 %b) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    ret i32 [[A:%.*]]
; CHECK:       BB2:
; CHECK-NEXT:    ret i32 [[A]]
;
BB0:
  br i1 %b, label %BB1, label %BB2

BB1:
  ; Combine away one argument PHI nodes
  %B = phi i32 [ %A, %BB0 ]
  ret i32 %B

BB2:
  ret i32 %A
}

define i32 @test2(i32 %A, i1 %b) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       BB2:
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
BB0:
  br i1 %b, label %BB1, label %BB2

BB1:
  br label %BB2

BB2:
  ; Combine away PHI nodes with same values
  %B = phi i32 [ %A, %BB0 ], [ %A, %BB1 ]
  ret i32 %B
}

define i32 @test3(i32 %A, i1 %b) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
BB0:
  br label %Loop

Loop:
  ; PHI has same value always.
  %B = phi i32 [ %A, %BB0 ], [ %B, %Loop ]
  br i1 %b, label %Loop, label %Exit

Exit:
  ret i32 %B
}

define i32 @test4(i1 %b) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    ret i32 7
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[L2:%.*]], label [[LOOP:%.*]]
; CHECK:       L2:
; CHECK-NEXT:    br label [[LOOP]]
;
BB0:
  ; Loop is unreachable
  ret i32 7

Loop:           ; preds = %L2, %Loop
  ; PHI has same value always.
  %B = phi i32 [ %B, %L2 ], [ %B, %Loop ]
  br i1 %b, label %L2, label %Loop

L2:             ; preds = %Loop
  br label %Loop
}

define i32 @test5(i32 %A, i1 %b) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 [[A:%.*]]
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  ; PHI has same value always.
  %B = phi i32 [ %A, %BB0 ], [ undef, %Loop ]
  br i1 %b, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i32 %B
}

define i32 @test6(i16 %A, i1 %b) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       BB2:
; CHECK-NEXT:    [[B:%.*]] = zext i16 [[A:%.*]] to i32
; CHECK-NEXT:    ret i32 [[B]]
;
BB0:
  %X = zext i16 %A to i32
  br i1 %b, label %BB1, label %BB2

BB1:
  %Y = zext i16 %A to i32
  br label %BB2

BB2:
  ;; Suck casts into phi
  %B = phi i32 [ %X, %BB0 ], [ %Y, %BB1 ]
  ret i32 %B
}

define i32 @test7(i32 %A, i1 %b) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 0
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  ; PHI is dead.
  %B = phi i32 [ %A, %BB0 ], [ %C, %Loop ]
  %C = add i32 %B, 123
  br i1 %b, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i32 0
}

define i32* @test8({ i32, i32 } *%A, i1 %b) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       BB2:
; CHECK-NEXT:    [[B:%.*]] = getelementptr { i32, i32 }, { i32, i32 }* [[A:%.*]], i64 0, i32 1
; CHECK-NEXT:    ret i32* [[B]]
;
BB0:
  %X = getelementptr inbounds { i32, i32 }, { i32, i32 } *%A, i32 0, i32 1
  br i1 %b, label %BB1, label %BB2

BB1:
  %Y = getelementptr { i32, i32 }, { i32, i32 } *%A, i32 0, i32 1
  br label %BB2

BB2:
  ;; Suck GEPs into phi
  %B = phi i32* [ %X, %BB0 ], [ %Y, %BB1 ]
  ret i32* %B
}

define i32 @test9(i32* %A, i32* %B) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32* [[A:%.*]], null
; CHECK-NEXT:    br i1 [[C]], label [[BB1:%.*]], label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    br label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[E_IN:%.*]] = phi i32* [ [[B:%.*]], [[BB]] ], [ [[A]], [[BB1]] ]
; CHECK-NEXT:    [[E:%.*]] = load i32, i32* [[E_IN]], align 1
; CHECK-NEXT:    ret i32 [[E]]
;
entry:
  %c = icmp eq i32* %A, null
  br i1 %c, label %bb1, label %bb

bb:
  %C = load i32, i32* %B, align 1
  br label %bb2

bb1:
  %D = load i32, i32* %A, align 1
  br label %bb2

bb2:
  %E = phi i32 [ %C, %bb ], [ %D, %bb1 ]
  ret i32 %E

}

define i32 @test10(i32* %A, i32* %B) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32* [[A:%.*]], null
; CHECK-NEXT:    br i1 [[C]], label [[BB1:%.*]], label [[BB:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    br label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[E_IN:%.*]] = phi i32* [ [[B:%.*]], [[BB]] ], [ [[A]], [[BB1]] ]
; CHECK-NEXT:    [[E:%.*]] = load i32, i32* [[E_IN]], align 16
; CHECK-NEXT:    ret i32 [[E]]
;
entry:
  %c = icmp eq i32* %A, null
  br i1 %c, label %bb1, label %bb

bb:
  %C = load i32, i32* %B, align 16
  br label %bb2

bb1:
  %D = load i32, i32* %A, align 32
  br label %bb2

bb2:
  %E = phi i32 [ %C, %bb ], [ %D, %bb1 ]
  ret i32 %E
}


; PR1777
declare i1 @test11a()

define i1 @test11() {
; CHECK-LABEL: @test11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = call i1 @test11a()
; CHECK-NEXT:    br i1 [[B]], label [[ONE:%.*]], label [[TWO:%.*]]
; CHECK:       one:
; CHECK-NEXT:    [[C:%.*]] = call i1 @test11a()
; CHECK-NEXT:    br i1 [[C]], label [[TWO]], label [[END:%.*]]
; CHECK:       two:
; CHECK-NEXT:    [[D:%.*]] = call i1 @test11a()
; CHECK-NEXT:    br i1 [[D]], label [[ONE]], label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[Z:%.*]] = call i1 @test11a()
; CHECK-NEXT:    ret i1 [[Z]]
;
entry:
  %a = alloca i32
  %i = ptrtoint i32* %a to i64
  %b = call i1 @test11a()
  br i1 %b, label %one, label %two

one:
  %x = phi i64 [%i, %entry], [%y, %two]
  %c = call i1 @test11a()
  br i1 %c, label %two, label %end

two:
  %y = phi i64 [%i, %entry], [%x, %one]
  %d = call i1 @test11a()
  br i1 %d, label %one, label %end

end:
  %f = phi i64 [ %x, %one], [%y, %two]
  ; Change the %f to %i, and the optimizer suddenly becomes a lot smarter
  ; even though %f must equal %i at this point
  %g = inttoptr i64 %f to i32*
  store i32 10, i32* %g
  %z = call i1 @test11a()
  ret i1 %z
}


define i64 @test12(i1 %cond, i8* %Ptr, i64 %Val) {
; CHECK-LABEL: @test12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[END:%.*]], label [[TWO:%.*]]
; CHECK:       two:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[T869_0_OFF64:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[VAL:%.*]], [[TWO]] ]
; CHECK-NEXT:    [[T41:%.*]] = ptrtoint i8* [[PTR:%.*]] to i64
; CHECK-NEXT:    [[T2:%.*]] = add i64 [[T869_0_OFF64]], [[T41]]
; CHECK-NEXT:    ret i64 [[T2]]
;
entry:
  %t41 = ptrtoint i8* %Ptr to i64
  %t42 = zext i64 %t41 to i128
  br i1 %cond, label %end, label %two

two:
  %t36 = zext i64 %Val to i128            ; <i128> [#uses=1]
  %t37 = shl i128 %t36, 64                    ; <i128> [#uses=1]
  %ins39 = or i128 %t42, %t37                 ; <i128> [#uses=1]
  br label %end

end:
  %t869.0 = phi i128 [ %t42, %entry ], [ %ins39, %two ]
  %t32 = trunc i128 %t869.0 to i64            ; <i64> [#uses=1]
  %t29 = lshr i128 %t869.0, 64                ; <i128> [#uses=1]
  %t30 = trunc i128 %t29 to i64               ; <i64> [#uses=1]

  %t2 = add i64 %t32, %t30
  ret i64 %t2
}

declare void @test13f(double, i32)

define void @test13(i1 %cond, i32 %V1, double %Vald) {
; CHECK-LABEL: @test13(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[END:%.*]], label [[TWO:%.*]]
; CHECK:       two:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[TMP0:%.*]] = phi double [ 0.000000e+00, [[ENTRY:%.*]] ], [ [[VALD:%.*]], [[TWO]] ]
; CHECK-NEXT:    call void @test13f(double [[TMP0]], i32 [[V1:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  %t42 = zext i32 %V1 to i128
  br i1 %cond, label %end, label %two

two:
  %Val = bitcast double %Vald to i64
  %t36 = zext i64 %Val to i128            ; <i128> [#uses=1]
  %t37 = shl i128 %t36, 64                    ; <i128> [#uses=1]
  %ins39 = or i128 %t42, %t37                 ; <i128> [#uses=1]
  br label %end

end:
  %t869.0 = phi i128 [ %t42, %entry ], [ %ins39, %two ]
  %t32 = trunc i128 %t869.0 to i32
  %t29 = lshr i128 %t869.0, 64                ; <i128> [#uses=1]
  %t30 = trunc i128 %t29 to i64               ; <i64> [#uses=1]
  %t31 = bitcast i64 %t30 to double

  call void @test13f(double %t31, i32 %t32)
  ret void
}

define i640 @test14a(i320 %A, i320 %B, i1 %b1) {
; CHECK-LABEL: @test14a(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    [[C_IN:%.*]] = phi i320 [ [[A:%.*]], [[BB0:%.*]] ], [ [[B:%.*]], [[LOOP]] ]
; CHECK-NEXT:    br i1 [[B1:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    [[C:%.*]] = zext i320 [[C_IN]] to i640
; CHECK-NEXT:    ret i640 [[C]]
;
BB0:
  %a = zext i320 %A to i640
  %b = zext i320 %B to i640
  br label %Loop

Loop:
  %C = phi i640 [ %a, %BB0 ], [ %b, %Loop ]
  br i1 %b1, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i640 %C
}

define i160 @test14b(i320 %pA, i320 %pB, i1 %b1) {
; CHECK-LABEL: @test14b(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    [[A:%.*]] = trunc i320 [[PA:%.*]] to i160
; CHECK-NEXT:    [[B:%.*]] = trunc i320 [[PB:%.*]] to i160
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    [[C:%.*]] = phi i160 [ [[A]], [[BB0:%.*]] ], [ [[B]], [[LOOP]] ]
; CHECK-NEXT:    br i1 [[B1:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i160 [[C]]
;
BB0:
  %a = trunc i320 %pA to i160
  %b = trunc i320 %pB to i160
  br label %Loop

Loop:
  %C = phi i160 [ %a, %BB0 ], [ %b, %Loop ]
  br i1 %b1, label %Loop, label %Exit

Exit:           ; preds = %Loop
  ret i160 %C
}

declare i64 @test15a(i64)

define i64 @test15b(i64 %A, i1 %b) {
; CHECK-LABEL: @test15b(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[B:%.*]], label [[ONE:%.*]], label [[TWO:%.*]]
; CHECK:       one:
; CHECK-NEXT:    [[X_OFF64:%.*]] = phi i64 [ [[A:%.*]], [[ENTRY:%.*]] ], [ [[Y_OFF64:%.*]], [[TWO]] ]
; CHECK-NEXT:    [[C:%.*]] = call i64 @test15a(i64 [[X_OFF64]])
; CHECK-NEXT:    br label [[TWO]]
; CHECK:       two:
; CHECK-NEXT:    [[Y_OFF0:%.*]] = phi i64 [ [[A]], [[ENTRY]] ], [ [[C]], [[ONE]] ]
; CHECK-NEXT:    [[Y_OFF64]] = phi i64 [ [[A]], [[ENTRY]] ], [ 0, [[ONE]] ]
; CHECK-NEXT:    [[D:%.*]] = call i64 @test15a(i64 [[Y_OFF64]])
; CHECK-NEXT:    [[TMP0:%.*]] = and i64 [[D]], 1
; CHECK-NEXT:    [[D1_NOT:%.*]] = icmp eq i64 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[D1_NOT]], label [[END:%.*]], label [[ONE]]
; CHECK:       end:
; CHECK-NEXT:    ret i64 [[Y_OFF0]]
;
entry:
  %i0 = zext i64 %A to i128
  %i1 = shl i128 %i0, 64
  %i = or i128 %i1, %i0
  br i1 %b, label %one, label %two

one:
  %x = phi i128 [%i, %entry], [%y, %two]
  %x1 = lshr i128 %x, 64
  %x2 = trunc i128 %x1 to i64
  %c = call i64 @test15a(i64 %x2)
  %c1 = zext i64 %c to i128
  br label %two


two:
  %y = phi i128 [%i, %entry], [%c1, %one]
  %y1 = lshr i128 %y, 64
  %y2 = trunc i128 %y1 to i64
  %d = call i64 @test15a(i64 %y2)
  %d1 = trunc i64 %d to i1
  br i1 %d1, label %one, label %end


end:
  %g = trunc i128 %y to i64
  ret i64 %g
}

; PR6512 - Shouldn't merge loads from different addr spaces.
define i32 @test16(i32 addrspace(1)* %pointer1, i32 %flag, i32* %pointer2)
; CHECK-LABEL: @test16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[POINTER1_ADDR:%.*]] = alloca i32 addrspace(1)*, align 8
; CHECK-NEXT:    [[POINTER2_ADDR:%.*]] = alloca i32*, align 8
; CHECK-NEXT:    store i32 addrspace(1)* [[POINTER1:%.*]], i32 addrspace(1)** [[POINTER1_ADDR]], align 8
; CHECK-NEXT:    store i32* [[POINTER2:%.*]], i32** [[POINTER2_ADDR]], align 8
; CHECK-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[FLAG:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_NOT]], label [[IF_ELSE:%.*]], label [[IF_THEN:%.*]]
; CHECK:       return:
; CHECK-NEXT:    [[T7:%.*]] = load i32, i32* [[RETVAL]], align 4
; CHECK-NEXT:    ret i32 [[T7]]
; CHECK:       if.end:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi i32 [ [[T5:%.*]], [[IF_ELSE]] ], [ [[T2:%.*]], [[IF_THEN]] ]
; CHECK-NEXT:    store i32 [[STOREMERGE]], i32* [[RETVAL]], align 4
; CHECK-NEXT:    br label [[RETURN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[T1:%.*]] = load i32 addrspace(1)*, i32 addrspace(1)** [[POINTER1_ADDR]], align 8
; CHECK-NEXT:    [[T2]] = load i32, i32 addrspace(1)* [[T1]], align 4
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    [[T3:%.*]] = load i32*, i32** [[POINTER2_ADDR]], align 8
; CHECK-NEXT:    [[T5]] = load i32, i32* [[T3]], align 4
; CHECK-NEXT:    br label [[IF_END]]
;
nounwind {
entry:
  %retval = alloca i32, align 4                   ; <i32*> [#uses=2]
  %pointer1.addr = alloca i32 addrspace(1)*, align 4 ; <i32 addrspace(1)**>
  %flag.addr = alloca i32, align 4                ; <i32*> [#uses=2]
  %pointer2.addr = alloca i32*, align 4           ; <i32**> [#uses=2]
  %res = alloca i32, align 4                      ; <i32*> [#uses=4]
  store i32 addrspace(1)* %pointer1, i32 addrspace(1)** %pointer1.addr
  store i32 %flag, i32* %flag.addr
  store i32* %pointer2, i32** %pointer2.addr
  store i32 10, i32* %res
  %t = load i32, i32* %flag.addr                     ; <i32> [#uses=1]
  %tobool = icmp ne i32 %t, 0                   ; <i1> [#uses=1]
  br i1 %tobool, label %if.then, label %if.else

return:                                           ; preds = %if.end
  %t7 = load i32, i32* %retval                       ; <i32> [#uses=1]
  ret i32 %t7

if.end:                                           ; preds = %if.else, %if.then
  %t6 = load i32, i32* %res                          ; <i32> [#uses=1]
  store i32 %t6, i32* %retval
  br label %return

if.then:                                          ; preds = %entry
  %t1 = load i32 addrspace(1)*, i32 addrspace(1)** %pointer1.addr  ; <i32 addrspace(1)*>
  %arrayidx = getelementptr i32, i32 addrspace(1)* %t1, i32 0 ; <i32 addrspace(1)*> [#uses=1]
  %t2 = load i32, i32 addrspace(1)* %arrayidx        ; <i32> [#uses=1]
  store i32 %t2, i32* %res
  br label %if.end

if.else:                                          ; preds = %entry
  %t3 = load i32*, i32** %pointer2.addr               ; <i32*> [#uses=1]
  %arrayidx4 = getelementptr i32, i32* %t3, i32 0    ; <i32*> [#uses=1]
  %t5 = load i32, i32* %arrayidx4                    ; <i32> [#uses=1]
  store i32 %t5, i32* %res
  br label %if.end
}

; PR4413
declare i32 @ext()
define i32 @test17(i1 %a) {
; CHECK-LABEL: @test17(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[A:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call i32 @ext()
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ [[TMP0]], [[BB1]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  br i1 %a, label %bb1, label %bb2

bb1:        ; preds = %entry
  %0 = tail call i32 @ext()        ; <i32> [#uses=1]
  br label %bb2

bb2:        ; preds = %bb1, %entry
  %cond = phi i1 [ true, %bb1 ], [ false, %entry ]        ; <i1> [#uses=1]
  %val = phi i32 [ %0, %bb1 ], [ 0, %entry ]        ; <i32> [#uses=1]
  %res = select i1 %cond, i32 %val, i32 0        ; <i32> [#uses=1]
  ret i32 %res
}

; Atomic and non-atomic loads should not be combined.
define i32 @PR51435(i32* %ptr, i32* %atomic_ptr, i1 %c) {
; CHECK-LABEL: @PR51435(
; CHECK:       entry:
; CHECK-NEXT:    [[NON_ATOMIC:%.*]] = load i32, i32* %ptr, align 4
; CHECK:       if:
; CHECK-NEXT:    [[ATOMIC:%.*]] = load atomic i32, i32* %atomic_ptr acquire, align 4
; CHECK:       end:
; CHECK-NEXT:    [[COND:%.*]] = phi i32 [ [[NON_ATOMIC]], %entry ], [ [[ATOMIC]], %if ]
; CHECK-NEXT:    ret i32 [[COND]]
entry:
  %x = load i32, i32* %ptr, align 4
  br i1 %c, label %if, label %end

if:
  %y = load atomic i32, i32* %atomic_ptr acquire, align 4
  br label %end

end:
  %cond = phi i32 [ %x, %entry ], [ %y, %if ]
  ret i32 %cond
}

define i1 @test18(i1 %cond) {
; CHECK-LABEL: @test18(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    br label [[RET:%.*]]
; CHECK:       false:
; CHECK-NEXT:    br label [[RET]]
; CHECK:       ret:
; CHECK-NEXT:    ret i1 false
;
  %zero = alloca i32
  %one = alloca i32
  br i1 %cond, label %true, label %false
true:
  br label %ret
false:
  br label %ret
ret:
  %ptr = phi i32* [ %zero, %true ] , [ %one, %false ]
  %isnull = icmp eq i32* %ptr, null
  ret i1 %isnull
}

define i1 @test19(i1 %cond, double %x) {
; CHECK-LABEL: @test19(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    br label [[RET:%.*]]
; CHECK:       false:
; CHECK-NEXT:    br label [[RET]]
; CHECK:       ret:
; CHECK-NEXT:    ret i1 true
;
  br i1 %cond, label %true, label %false
true:
  br label %ret
false:
  br label %ret
ret:
  %p = phi double [ %x, %true ], [ 0x7FF0000000000000, %false ]; RHS = +infty
  %cmp = fcmp ule double %x, %p
  ret i1 %cmp
}

define i1 @test20(i1 %cond) {
; CHECK-LABEL: @test20(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    br label [[RET:%.*]]
; CHECK:       false:
; CHECK-NEXT:    br label [[RET]]
; CHECK:       ret:
; CHECK-NEXT:    ret i1 false
;
  %a = alloca i32
  %b = alloca i32
  %c = alloca i32
  br i1 %cond, label %true, label %false
true:
  br label %ret
false:
  br label %ret
ret:
  %p = phi i32* [ %a, %true ], [ %b, %false ]
  %r = icmp eq i32* %p, %c
  ret i1 %r
}

define i1 @test21(i1 %c1, i1 %c2) {
; CHECK-LABEL: @test21(
; CHECK-NEXT:    br i1 [[C1:%.*]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       false:
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       loop:
; CHECK-NEXT:    br i1 [[C2:%.*]], label [[RET:%.*]], label [[LOOP]]
; CHECK:       ret:
; CHECK-NEXT:    ret i1 false
;
  %a = alloca i32
  %b = alloca i32
  %c = alloca i32
  br i1 %c1, label %true, label %false
true:
  br label %loop
false:
  br label %loop
loop:
  %p = phi i32* [ %a, %true ], [ %b, %false ], [ %p, %loop ]
  %r = icmp eq i32* %p, %c
  br i1 %c2, label %ret, label %loop
ret:
  ret i1 %r
}

define void @test22() {
; CHECK-LABEL: @test22(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[PHI:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[Y:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[Y]] = add i32 [[PHI]], 1
; CHECK-NEXT:    [[O:%.*]] = or i32 [[Y]], [[PHI]]
; CHECK-NEXT:    [[E:%.*]] = icmp eq i32 [[O]], [[Y]]
; CHECK-NEXT:    br i1 [[E]], label [[LOOP]], label [[RET:%.*]]
; CHECK:       ret:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %phi = phi i32 [ 0, %entry ], [ %y, %loop ]
  %y = add i32 %phi, 1
  %o = or i32 %y, %phi
  %e = icmp eq i32 %o, %y
  br i1 %e, label %loop, label %ret
ret:
  ret void
}

define i32 @test23(i32 %A, i1 %pb, i32 * %P) {
; CHECK-LABEL: @test23(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    [[PHI_BO:%.*]] = add i32 [[A:%.*]], 19
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       Loop:
; CHECK-NEXT:    [[B:%.*]] = phi i32 [ [[PHI_BO]], [[BB0:%.*]] ], [ 61, [[LOOP]] ]
; CHECK-NEXT:    store i32 [[B]], i32* [[P:%.*]], align 4
; CHECK-NEXT:    br i1 [[PB:%.*]], label [[LOOP]], label [[EXIT:%.*]]
; CHECK:       Exit:
; CHECK-NEXT:    ret i32 [[B]]
;
BB0:
  br label %Loop

Loop:           ; preds = %Loop, %BB0
  ; PHI has same value always.
  %B = phi i32 [ %A, %BB0 ], [ 42, %Loop ]
  %D = add i32 %B, 19
  store i32 %D, i32* %P
  br i1 %pb, label %Loop, label %Exit

Exit:           ; preds = %Loop
  %E = add i32 %B, 19
  ret i32 %E
}

define i32 @test24(i32 %A, i1 %cond) {
; CHECK-LABEL: @test24(
; CHECK-NEXT:  BB0:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[BB2]]
; CHECK:       BB2:
; CHECK-NEXT:    [[C:%.*]] = add nuw i32 [[A:%.*]], 1
; CHECK-NEXT:    ret i32 [[C]]
;
BB0:
  %X = add nuw nsw i32 %A, 1
  br i1 %cond, label %BB1, label %BB2

BB1:
  %Y = add nuw i32 %A, 1
  br label %BB2

BB2:
  %C = phi i32 [ %X, %BB0 ], [ %Y, %BB1 ]
  ret i32 %C
}

; Same as test11, but used to be missed due to a bug.
declare i1 @test25a()

define i1 @test25() {
; CHECK-LABEL: @test25(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = call i1 @test25a()
; CHECK-NEXT:    br i1 [[B]], label [[ONE:%.*]], label [[TWO:%.*]]
; CHECK:       one:
; CHECK-NEXT:    [[C:%.*]] = call i1 @test25a()
; CHECK-NEXT:    br i1 [[C]], label [[TWO]], label [[END:%.*]]
; CHECK:       two:
; CHECK-NEXT:    [[D:%.*]] = call i1 @test25a()
; CHECK-NEXT:    br i1 [[D]], label [[ONE]], label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[Z:%.*]] = call i1 @test25a()
; CHECK-NEXT:    ret i1 [[Z]]
;
entry:
  %a = alloca i32
  %i = ptrtoint i32* %a to i64
  %b = call i1 @test25a()
  br i1 %b, label %one, label %two

one:
  %x = phi i64 [%y, %two], [%i, %entry]
  %c = call i1 @test25a()
  br i1 %c, label %two, label %end

two:
  %y = phi i64 [%x, %one], [%i, %entry]
  %d = call i1 @test25a()
  br i1 %d, label %one, label %end

end:
  %f = phi i64 [ %x, %one], [%y, %two]
  ; Change the %f to %i, and the optimizer suddenly becomes a lot smarter
  ; even though %f must equal %i at this point
  %g = inttoptr i64 %f to i32*
  store i32 10, i32* %g
  %z = call i1 @test25a()
  ret i1 %z
}

declare i1 @test26a()

define i1 @test26(i32 %n) {
; CHECK-LABEL: @test26(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = call i1 @test26a()
; CHECK-NEXT:    br label [[ONE:%.*]]
; CHECK:       one:
; CHECK-NEXT:    [[C:%.*]] = call i1 @test26a()
; CHECK-NEXT:    switch i32 [[N:%.*]], label [[END:%.*]] [
; CHECK-NEXT:    i32 2, label [[TWO:%.*]]
; CHECK-NEXT:    i32 3, label [[THREE:%.*]]
; CHECK-NEXT:    ]
; CHECK:       two:
; CHECK-NEXT:    [[D:%.*]] = call i1 @test26a()
; CHECK-NEXT:    switch i32 [[N]], label [[END]] [
; CHECK-NEXT:    i32 10, label [[ONE]]
; CHECK-NEXT:    i32 30, label [[THREE]]
; CHECK-NEXT:    ]
; CHECK:       three:
; CHECK-NEXT:    [[E:%.*]] = call i1 @test26a()
; CHECK-NEXT:    br i1 [[E]], label [[ONE]], label [[TWO]]
; CHECK:       end:
; CHECK-NEXT:    [[Z:%.*]] = call i1 @test26a()
; CHECK-NEXT:    ret i1 [[Z]]
;
entry:
  %a = alloca i32
  %i = ptrtoint i32* %a to i64
  %b = call i1 @test26a()
  br label %one

one:
  %x = phi i64 [%y, %two], [%w, %three], [%i, %entry]
  %c = call i1 @test26a()
  switch i32 %n, label %end [
  i32 2, label %two
  i32 3, label %three
  ]

two:
  %y = phi i64 [%x, %one], [%w, %three]
  %d = call i1 @test26a()
  switch i32 %n, label %end [
  i32 10, label %one
  i32 30, label %three
  ]

three:
  %w = phi i64 [%y, %two], [%x, %one]
  %e = call i1 @test26a()
  br i1 %e, label %one, label %two

end:
  %f = phi i64 [ %x, %one], [%y, %two]
  ; Change the %f to %i, and the optimizer suddenly becomes a lot smarter
  ; even though %f must equal %i at this point
  %g = inttoptr i64 %f to i32*
  store i32 10, i32* %g
  %z = call i1 @test26a()
  ret i1 %z
}

define i32 @test27(i1 %b) {
; CHECK-LABEL: @test27(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[DONE:%.*]]
; CHECK:       done:
; CHECK-NEXT:    ret i32 undef
;
entry:
  br label %done
done:
  %y = phi i32 [ undef, %entry ]
  ret i32 %y
}

; We should be able to fold the zexts to the other side of the phi
; even though there's a constant value input to the phi. This is
; because we can shrink that constant to the smaller phi type.

define i1 @PR24766(i8 %x1, i8 %x2, i8 %condition) {
; CHECK-LABEL: @PR24766(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[CONDITION:%.*]] to i32
; CHECK-NEXT:    switch i32 [[CONV]], label [[EPILOG:%.*]] [
; CHECK-NEXT:    i32 0, label [[SW1:%.*]]
; CHECK-NEXT:    i32 1, label [[SW2:%.*]]
; CHECK-NEXT:    ]
; CHECK:       sw1:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[X1:%.*]], [[X2:%.*]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw2:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sle i8 [[X1]], [[X2]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       epilog:
; CHECK-NEXT:    [[CONDITIONMET_SHRUNK:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ [[CMP2]], [[SW2]] ], [ [[CMP1]], [[SW1]] ]
; CHECK-NEXT:    ret i1 [[CONDITIONMET_SHRUNK]]
;
entry:
  %conv = sext i8 %condition to i32
  switch i32 %conv, label %epilog [
  i32 0, label %sw1
  i32 1, label %sw2
  ]

sw1:
  %cmp1 = icmp eq i8 %x1, %x2
  %frombool1 = zext i1 %cmp1 to i8
  br label %epilog

sw2:
  %cmp2 = icmp sle i8 %x1, %x2
  %frombool2 = zext i1 %cmp2 to i8
  br label %epilog

epilog:
  %conditionMet = phi i8 [ 0, %entry ], [ %frombool2, %sw2 ], [ %frombool1, %sw1 ]
  %tobool = icmp ne i8 %conditionMet, 0
  ret i1 %tobool

}

; Same as above (a phi with more than 2 operands), but no constants

define i1 @PR24766_no_constants(i8 %x1, i8 %x2, i8 %condition, i1 %another_condition) {
; CHECK-LABEL: @PR24766_no_constants(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[CONDITION:%.*]] to i32
; CHECK-NEXT:    switch i32 [[CONV]], label [[EPILOG:%.*]] [
; CHECK-NEXT:    i32 0, label [[SW1:%.*]]
; CHECK-NEXT:    i32 1, label [[SW2:%.*]]
; CHECK-NEXT:    ]
; CHECK:       sw1:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[X1:%.*]], [[X2:%.*]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw2:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sle i8 [[X1]], [[X2]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       epilog:
; CHECK-NEXT:    [[CONDITIONMET_IN:%.*]] = phi i1 [ [[ANOTHER_CONDITION:%.*]], [[ENTRY:%.*]] ], [ [[CMP2]], [[SW2]] ], [ [[CMP1]], [[SW1]] ]
; CHECK-NEXT:    ret i1 [[CONDITIONMET_IN]]
;
entry:
  %frombool0 = zext i1 %another_condition to i8
  %conv = sext i8 %condition to i32
  switch i32 %conv, label %epilog [
  i32 0, label %sw1
  i32 1, label %sw2
  ]

sw1:
  %cmp1 = icmp eq i8 %x1, %x2
  %frombool1 = zext i1 %cmp1 to i8
  br label %epilog

sw2:
  %cmp2 = icmp sle i8 %x1, %x2
  %frombool2 = zext i1 %cmp2 to i8
  br label %epilog

epilog:
  %conditionMet = phi i8 [ %frombool0, %entry ], [ %frombool2, %sw2 ], [ %frombool1, %sw1 ]
  %tobool = icmp ne i8 %conditionMet, 0
  ret i1 %tobool

}

; Same as above (a phi with more than 2 operands), but two constants

define i1 @PR24766_two_constants(i8 %x1, i8 %x2, i8 %condition) {
; CHECK-LABEL: @PR24766_two_constants(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[CONDITION:%.*]] to i32
; CHECK-NEXT:    switch i32 [[CONV]], label [[EPILOG:%.*]] [
; CHECK-NEXT:    i32 0, label [[SW1:%.*]]
; CHECK-NEXT:    i32 1, label [[SW2:%.*]]
; CHECK-NEXT:    ]
; CHECK:       sw1:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[X1:%.*]], [[X2:%.*]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw2:
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       epilog:
; CHECK-NEXT:    [[CONDITIONMET:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ true, [[SW2]] ], [ [[CMP1]], [[SW1]] ]
; CHECK-NEXT:    ret i1 [[CONDITIONMET]]
;
entry:
  %conv = sext i8 %condition to i32
  switch i32 %conv, label %epilog [
  i32 0, label %sw1
  i32 1, label %sw2
  ]

sw1:
  %cmp1 = icmp eq i8 %x1, %x2
  %frombool1 = zext i1 %cmp1 to i8
  br label %epilog

sw2:
  %cmp2 = icmp sle i8 %x1, %x2
  %frombool2 = zext i1 %cmp2 to i8
  br label %epilog

epilog:
  %conditionMet = phi i8 [ 0, %entry ], [ 1, %sw2 ], [ %frombool1, %sw1 ]
  %tobool = icmp ne i8 %conditionMet, 0
  ret i1 %tobool

}

; Same as above (a phi with more than 2 operands), but two constants and two variables

define i1 @PR24766_two_constants_two_var(i8 %x1, i8 %x2, i8 %condition) {
; CHECK-LABEL: @PR24766_two_constants_two_var(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = sext i8 [[CONDITION:%.*]] to i32
; CHECK-NEXT:    switch i32 [[CONV]], label [[EPILOG:%.*]] [
; CHECK-NEXT:    i32 0, label [[SW1:%.*]]
; CHECK-NEXT:    i32 1, label [[SW2:%.*]]
; CHECK-NEXT:    i32 2, label [[SW3:%.*]]
; CHECK-NEXT:    ]
; CHECK:       sw1:
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[X1:%.*]], [[X2:%.*]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw2:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sle i8 [[X1]], [[X2]]
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       sw3:
; CHECK-NEXT:    br label [[EPILOG]]
; CHECK:       epilog:
; CHECK-NEXT:    [[CONDITIONMET_SHRUNK:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ [[CMP2]], [[SW2]] ], [ [[CMP1]], [[SW1]] ], [ true, [[SW3]] ]
; CHECK-NEXT:    ret i1 [[CONDITIONMET_SHRUNK]]
;
entry:
  %conv = sext i8 %condition to i32
  switch i32 %conv, label %epilog [
  i32 0, label %sw1
  i32 1, label %sw2
  i32 2, label %sw3
  ]

sw1:
  %cmp1 = icmp eq i8 %x1, %x2
  %frombool1 = zext i1 %cmp1 to i8
  br label %epilog

sw2:
  %cmp2 = icmp sle i8 %x1, %x2
  %frombool2 = zext i1 %cmp2 to i8
  br label %epilog

sw3:
  %cmp3 = icmp sge i8 %x1, %x2
  %frombool3 = zext i1 %cmp3 to i8
  br label %epilog

epilog:
  %conditionMet = phi i8 [ 0, %entry ], [ %frombool2, %sw2 ], [ %frombool1, %sw1 ], [ 1, %sw3 ]
  %tobool = icmp ne i8 %conditionMet, 0
  ret i1 %tobool

}

define i1 @phi_allnonzeroconstant(i1 %c, i32 %a, i32 %b) {
; CHECK-LABEL: @phi_allnonzeroconstant(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret i1 false
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  br label %if.end

if.else:                                          ; preds = %entry
  call void @dummy()

  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  %x.0 = phi i32 [ 1, %if.then ], [ 2, %if.else ]
  %or = or i32 %x.0, %a
  %cmp1 = icmp eq i32 %or, 0
  ret i1 %cmp1
}

define i1 @phi_allnonzerononconstant(i1 %c, i32 %a, i32* nonnull %b1, i32* nonnull %b2) {
; CHECK-LABEL: @phi_allnonzerononconstant(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    call void @dummy()
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret i1 false
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  br label %if.end

if.else:                                          ; preds = %entry
  call void @dummy()

  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  %x.0 = phi i32* [ %b1, %if.then ], [ %b2, %if.else ]
  %cmp1 = icmp eq i32* %x.0, null
  ret i1 %cmp1
}

declare void @dummy()

define i1 @phi_knownnonzero_eq(i32 %n, i32 %s, i32* nocapture readonly %P) {
; CHECK-LABEL: @phi_knownnonzero_eq(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[A_0:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[A_0]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  %0 = load i32, i32* %P
  %cmp = icmp eq i32 %n, %0
  %1 = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  %a.0 = phi i32 [ %1,  %if.then ], [ %n, %entry ]
  %cmp1 = icmp eq i32 %a.0, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_ne(i32 %n, i32 %s, i32* nocapture readonly %P) {
; CHECK-LABEL: @phi_knownnonzero_ne(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[A_0:%.*]] = phi i32 [ 1, [[IF_THEN]] ], [ [[N]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[A_0]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  %0 = load i32, i32* %P
  %cmp = icmp eq i32 %n, %0
  %1 = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  %a.0 = phi i32 [ %1,  %if.then ], [ %n, %entry ]
  %cmp1 = icmp ne i32 %a.0, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_eq_2(i32 %n, i32 %s, i32* nocapture readonly %P) {
; CHECK-LABEL: @phi_knownnonzero_eq_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br i1 true, label [[IF_ELSE:%.*]], label [[IF_END]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[A_0:%.*]] = phi i32 [ 2, [[IF_ELSE]] ], [ [[N]], [[ENTRY:%.*]] ], [ 2, [[IF_THEN]] ]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[A_0]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.then, label %if.end

if.then:
  %tobool2 = icmp slt  i32 %n, %s
  br i1 %tobool2, label %if.else, label %if.end

if.else:                                          ; preds = %entry
  %0 = load i32, i32* %P
  %cmp = icmp eq i32 %n, %0
  %1 = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  %a.0 = phi i32 [ %1,  %if.else], [ %n, %entry ], [2, %if.then]
  %cmp1 = icmp eq i32 %a.0, 0
  ret i1  %cmp1
}

define i1 @phi_knownnonzero_ne_2(i32 %n, i32 %s, i32* nocapture readonly %P) {
; CHECK-LABEL: @phi_knownnonzero_ne_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp slt i32 [[N:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br i1 true, label [[IF_ELSE:%.*]], label [[IF_END]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    [[A_0:%.*]] = phi i32 [ 2, [[IF_ELSE]] ], [ [[N]], [[ENTRY:%.*]] ], [ 2, [[IF_THEN]] ]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[A_0]], 0
; CHECK-NEXT:    ret i1 [[CMP1]]
;
entry:
  %tobool = icmp slt  i32 %n, %s
  br i1 %tobool, label %if.then, label %if.end

if.then:
  %tobool2 = icmp slt  i32 %n, %s
  br i1 %tobool2, label %if.else, label %if.end

if.else:                                          ; preds = %entry
  %0 = load i32, i32* %P
  %cmp = icmp eq i32 %n, %0
  %1 = select i1 %cmp, i32 1, i32 2
  br label %if.end

if.end:                                           ; preds = %entry, %if.then
  %a.0 = phi i32 [ %1,  %if.else], [ %n, %entry ], [2, %if.then]
  %cmp1 = icmp ne i32 %a.0, 0
  ret i1  %cmp1
}

; This would crash trying to delete an instruction (conv)
; that still had uses because the user (the phi) was not
; updated to remove a use from an unreachable block (g.exit).

define void @main(i1 %cond, i16 %x) {
; CHECK-LABEL: @main(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[FOR_END:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    unreachable
; CHECK:       g.exit:
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.cond

for.cond:
  %p = phi double [ %conv, %g.exit ], [ undef, %entry ]
  br i1 %cond, label %for.end, label %for.body

for.body:
  %conv = sitofp i16 %x to double
  unreachable

g.exit:
  br label %for.cond

for.end:
  store double %p, double* undef
  ret void
}
