# OceanBase Development Guide

## About this guide

* **The target audience** of this guide is OceanBase contributors, both new and experienced.
* **The objective** of this guide is to help contributors become an expert of OceanBase, who is familiar with its design and implementation and thus is able to use it fluently in the real world as well as develop OceanBase itself deeply.

## The structure of this guide

At present, the guide is composed of the following parts:

1. **Get started**: Setting up the development environment, build and connect to the OceanBase server, the subsections are based on an imagined newbie user journey.
    1. [Install toolchain](toolchain.md)
    2. [Get the code, build and run](build-and-run.md)
    3. [Set up an IDE](ide-settings.md)
    4. [Coding Convensions](coding-convension.md)
    5. [Write and run unit tests](unittest.md)
    6. [Running MySQL test](mysqltest.md)
    7. [Debug](debug.md)
    8. [Commit code and submit a pull request](contributing.md)

    More information before you start a big feature developing, you should read content below and it can help you understand oceanbase better.
   
    1. [Logging System](logging.md)
    2. [Memory Management](memory.md)
    3. [Bais Data Structures](container.md)
    4. [Architecture](architecture.md)
    5. [Coding Standard](coding_standard.md)

3. **Contribute to OceanBase**: helps you quickly get involved in the OceanBase community, which illustrates what contributions you can make and how to quickly make one.

## User documents

This guide does _not_ contain user documents.

For user documents, please refer to [oceanbase-doc](https://github.com/oceanbase/oceanbase-doc).
