// Generated by CoffeeScript 2.5.1
var MixedDeclarationSet;

module.exports = MixedDeclarationSet = (function() {
  var self;

  class MixedDeclarationSet {
    static mix(...ruleSets) {
      var i, len, mixed, rules;
      mixed = new self();
      for (i = 0, len = ruleSets.length; i < len; i++) {
        rules = ruleSets[i];
        mixed.mixWithList(rules);
      }
      return mixed;
    }

    constructor() {
      this._declarations = {};
    }

    mixWithList(rules) {
      var i, len, rule;
      rules.sort(function(a, b) {
        return a.selector.priority > b.selector.priority;
      });
      for (i = 0, len = rules.length; i < len; i++) {
        rule = rules[i];
        this._mixWithRule(rule);
      }
      return this;
    }

    _mixWithRule(rule) {
      var dec, prop, ref;
      ref = rule.styles._declarations;
      for (prop in ref) {
        dec = ref[prop];
        this._mixWithDeclaration(dec);
      }
    }

    _mixWithDeclaration(dec) {
      var cur;
      cur = this._declarations[dec.prop];
      if ((cur != null) && cur.important && !dec.important) {
        return;
      }
      this._declarations[dec.prop] = dec;
    }

    get(prop) {
      if (prop == null) {
        return this._declarations;
      }
      if (this._declarations[prop] == null) {
        return null;
      }
      return this._declarations[prop].val;
    }

    toObject() {
      var dec, obj, prop, ref;
      obj = {};
      ref = this._declarations;
      for (prop in ref) {
        dec = ref[prop];
        obj[prop] = dec.val;
      }
      return obj;
    }

  };

  self = MixedDeclarationSet;

  return MixedDeclarationSet;

}).call(this);
