/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.selftests.kra;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.LogEventListener;
import com.netscape.certsrv.selftests.EDuplicateSelfTestException;
import com.netscape.certsrv.selftests.EInvalidSelfTestException;
import com.netscape.certsrv.selftests.EMissingSelfTestException;
import com.netscape.certsrv.selftests.ESelfTestException;
import com.netscape.cms.selftests.SelfTest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import com.netscape.kra.KeyRecoveryAuthority;
import java.security.PublicKey;
import java.util.Locale;
import org.dogtagpki.server.kra.KRAEngine;
import org.mozilla.jss.crypto.X509Certificate;

public class KRAPresence
extends SelfTest {
    public static final String PROP_KRA_SUB_ID = "SubId";
    private String mSubId = null;

    public void initSelfTest(SelfTestSubsystem subsystem, String instanceName, ConfigStore parameters) throws EDuplicateSelfTestException, EInvalidSelfTestException, EMissingSelfTestException {
        super.initSelfTest(subsystem, instanceName, parameters);
        try {
            this.mSubId = this.mConfig.getString(PROP_KRA_SUB_ID);
            if (this.mSubId == null) {
                this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_VALUES", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".SubId"}));
                throw new EMissingSelfTestException(PROP_KRA_SUB_ID);
            }
            this.mSubId = this.mSubId.trim();
        }
        catch (EBaseException e) {
            this.mSelfTestSubsystem.log(this.mSelfTestSubsystem.getSelfTestLogger(), CMS.getLogMessage((String)"SELFTESTS_MISSING_NAME", (Object[])new Object[]{this.getSelfTestName(), this.mPrefix + ".SubId"}));
            throw new EMissingSelfTestException(this.mPrefix, PROP_KRA_SUB_ID, null);
        }
    }

    public void startupSelfTest() throws ESelfTestException {
    }

    public void shutdownSelfTest() {
    }

    public String getSelfTestName() {
        return super.getSelfTestName();
    }

    public ConfigStore getSelfTestConfigStore() {
        return super.getSelfTestConfigStore();
    }

    public String getSelfTestDescription(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_SELFTESTS_KRA_PRESENCE_DESCRIPTION", (String[])new String[0]);
    }

    public void runSelfTest(LogEventListener logger) throws Exception {
        KRAEngine engine = KRAEngine.getInstance();
        KeyRecoveryAuthority kra = (KeyRecoveryAuthority)engine.getSubsystem(this.mSubId);
        if (kra == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_KRA_IS_NOT_PRESENT", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        X509Certificate kraCert = kra.getTransportCert();
        if (kraCert == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_KRA_IS_NOT_INITIALIZED", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        PublicKey kraPubKey = kraCert.getPublicKey();
        if (kraPubKey == null) {
            String logMessage = CMS.getLogMessage((String)"SELFTESTS_KRA_IS_CORRUPT", (Object[])new Object[]{this.getSelfTestName()});
            this.mSelfTestSubsystem.log(logger, logMessage);
            throw new Exception(logMessage);
        }
        String logMessage = CMS.getLogMessage((String)"SELFTESTS_KRA_IS_PRESENT", (Object[])new Object[]{this.getSelfTestName()});
        this.mSelfTestSubsystem.log(logger, logMessage);
    }
}

