/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.password;

import com.netscape.cmsutil.password.NuxwdogPasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import com.netscape.cmsutil.util.NuxwdogUtil;
import java.io.IOException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PasswordStore {
    public static Logger logger = LoggerFactory.getLogger(PasswordStore.class);
    protected String id;

    public static PasswordStore create(PasswordStoreConfig psc) throws Exception {
        String fileName;
        String className;
        if (NuxwdogUtil.startedByNuxwdog()) {
            className = NuxwdogPasswordStore.class.getName();
            fileName = null;
        } else {
            className = psc.getClassName();
            fileName = psc.getFileName();
        }
        Class<PasswordStore> clazz = Class.forName(className).asSubclass(PasswordStore.class);
        PasswordStore ps = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ps.setId(psc.getID());
        ps.init(fileName);
        return ps;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract void init(String var1) throws IOException;

    public abstract String getPassword(String var1, int var2);

    public abstract Enumeration<String> getTags();

    public abstract Object putPassword(String var1, String var2);

    public abstract void commit() throws IOException, ClassCastException, NullPointerException;
}

