/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.cms;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.connector.Connector;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.connector.HttpConnector;
import com.netscape.cmscore.connector.RemoteAuthority;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.dogtagpki.server.tps.TPSConfig;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    public static Logger logger = LoggerFactory.getLogger(ConnectionManager.class);
    private Hashtable<String, Connector> connectors;
    List<String> caList;

    public ConnectionManager() throws EBaseException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        TPSConfig conf = subsystem.getConfigStore();
        try {
            String caListString = conf.getString("connCAList");
            this.caList = Arrays.asList(caListString.split(","));
            logger.info("Revocation routing: " + caListString);
        }
        catch (EPropertyNotFound e) {
            logger.warn("Revocation routing not configured");
            return;
        }
    }

    public List<String> getCAList() {
        return this.caList;
    }

    public void initConnectors() throws EBaseException {
        logger.debug("ConnectionManager: initConnectors(): begins.");
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        TPSConfig conf = subsystem.getConfigStore();
        ConnectorsConfig connectorsConfig = conf.getConnectorsConfig();
        Enumeration connector_enu = connectorsConfig.getSubStoreNames().elements();
        this.connectors = new Hashtable();
        while (connector_enu.hasMoreElements()) {
            String connectorID = (String)connector_enu.nextElement();
            logger.debug("ConnectionManager: initConnectors(): initializing connector " + connectorID);
            ConnectorConfig connectorConfig = connectorsConfig.getConnectorConfig(connectorID);
            Connector conn = null;
            boolean enable = connectorConfig.getBoolean("enable", false);
            if (!enable) {
                logger.debug("ConnectionManager: initConnectors(): connector disabled.");
                continue;
            }
            logger.debug("ConnectionManager: initConnectors(): connector enabled.");
            conn = this.createConnector(connectorConfig);
            this.connectors.put(connectorID, conn);
            logger.debug("ConnectionManager: initConnectors(): connector " + connectorID + " initialized.");
        }
        logger.debug("ConnectionManager: initConnectors(): ends.");
    }

    private Connector createConnector(ConnectorConfig conf) throws EBaseException {
        HttpConnector connector = null;
        logger.debug("ConnectionManager: createConnector(): begins.");
        if (conf == null || conf.size() <= 0) {
            logger.error("ConnectionManager: createConnector(): conf null or empty.");
            throw new EBaseException("called with null config store");
        }
        String host = conf.getHost();
        if (host == null) {
            logger.error("ConnectionManager: createConnector(): host not found in config.");
            throw new EBaseException("host not found in config");
        }
        int port = conf.getPort();
        Hashtable<String, String> uris = new Hashtable<String, String>();
        ConfigStore uriSubstore = conf.getURIs();
        if (uriSubstore == null) {
            logger.error("ConnectionManager: createConnector(): uri(s) not found in config.");
            throw new EBaseException("uri(s) not found in config");
        }
        logger.debug("ConnectionManager: createConnector(): uriSubstore name=" + uriSubstore.getName() + " size =" + uriSubstore.size());
        Enumeration uri_enu = uriSubstore.getPropertyNames();
        while (uri_enu.hasMoreElements()) {
            String op = (String)uri_enu.nextElement();
            if (op == null || op.equals("")) continue;
            logger.debug("ConnectionManager: createConnector(): op name=" + op);
            String uriValue = uriSubstore.getString(op);
            if (uriValue == null || uriValue.equals("")) continue;
            logger.debug("ConnectionManager: createConnector(): uri value=" + uriValue);
            uris.put(op, uriValue);
        }
        String nickname = conf.getNickname();
        if (nickname == null) {
            logger.error("ConnectionManager: createConnector(): nickName not found in config");
            throw new EBaseException("nickName not found in config");
        }
        logger.debug("ConnectionManager: createConnector(): nickName=" + nickname);
        String clientCiphers = conf.getClientCiphers();
        int resendInterval = -1;
        int timeout = conf.getTimeout();
        RemoteAuthority remauthority = new RemoteAuthority(host, port, uris, timeout, "application/x-www-form-urlencoded");
        logger.debug("ConnectionManager: createConnector(): establishing HttpConnector");
        connector = timeout == 0 ? new HttpConnector(nickname, clientCiphers, remauthority, resendInterval, conf) : new HttpConnector(nickname, clientCiphers, remauthority, resendInterval, conf, timeout);
        connector.setCMSEngine((CMSEngine)TPSEngine.getInstance());
        connector.init();
        logger.debug("ConnectionManager: createConnector(): ends.");
        return connector;
    }

    public Connector getConnector(String connID) {
        logger.debug("ConnectionManager: getConnector(): returning connID=" + connID);
        return this.connectors.get(connID);
    }
}

