/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.processor;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.TokenAppletUpgradeEvent;
import com.netscape.certsrv.logging.event.TokenAuthEvent;
import com.netscape.certsrv.logging.event.TokenFormatEvent;
import com.netscape.certsrv.logging.event.TokenKeyChangeoverEvent;
import com.netscape.certsrv.tps.token.TokenStatus;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.logging.Auditor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagersConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.tps.TPSEngine;
import org.dogtagpki.server.tps.TPSEngineConfig;
import org.dogtagpki.server.tps.TPSSession;
import org.dogtagpki.server.tps.TPSSubsystem;
import org.dogtagpki.server.tps.TokenDBConfig;
import org.dogtagpki.server.tps.authentication.AuthUIParameter;
import org.dogtagpki.server.tps.authentication.TPSAuthenticator;
import org.dogtagpki.server.tps.channel.PlatformAndSecChannelProtoInfo;
import org.dogtagpki.server.tps.channel.SecureChannel;
import org.dogtagpki.server.tps.channel.SecureChannelProtocol;
import org.dogtagpki.server.tps.cms.CARemoteRequestHandler;
import org.dogtagpki.server.tps.cms.CARevokeCertResponse;
import org.dogtagpki.server.tps.cms.TKSComputeRandomDataResponse;
import org.dogtagpki.server.tps.cms.TKSComputeSessionKeyResponse;
import org.dogtagpki.server.tps.cms.TKSEncryptDataResponse;
import org.dogtagpki.server.tps.cms.TKSRemoteRequestHandler;
import org.dogtagpki.server.tps.config.ProfileDatabase;
import org.dogtagpki.server.tps.dbs.TPSCertRecord;
import org.dogtagpki.server.tps.dbs.TokenCertStatus;
import org.dogtagpki.server.tps.dbs.TokenRecord;
import org.dogtagpki.server.tps.main.ExternalRegAttrs;
import org.dogtagpki.server.tps.main.ExternalRegCertToRecover;
import org.dogtagpki.server.tps.mapping.FilterMappingParams;
import org.dogtagpki.server.tps.processor.AppletInfo;
import org.dogtagpki.tps.apdu.APDU;
import org.dogtagpki.tps.apdu.APDUResponse;
import org.dogtagpki.tps.apdu.GetDataAPDU;
import org.dogtagpki.tps.apdu.GetLifecycleAPDU;
import org.dogtagpki.tps.apdu.GetStatusAPDU;
import org.dogtagpki.tps.apdu.GetVersionAPDU;
import org.dogtagpki.tps.apdu.InitializeUpdateAPDU;
import org.dogtagpki.tps.apdu.ListObjectsAPDU;
import org.dogtagpki.tps.apdu.SelectAPDU;
import org.dogtagpki.tps.main.TPSBuffer;
import org.dogtagpki.tps.main.TPSException;
import org.dogtagpki.tps.msg.BeginOpMsg;
import org.dogtagpki.tps.msg.EndOpMsg;
import org.dogtagpki.tps.msg.ExtendedLoginRequestMsg;
import org.dogtagpki.tps.msg.ExtendedLoginResponseMsg;
import org.dogtagpki.tps.msg.LoginRequestMsg;
import org.dogtagpki.tps.msg.LoginResponseMsg;
import org.dogtagpki.tps.msg.NewPinRequestMsg;
import org.dogtagpki.tps.msg.NewPinResponseMsg;
import org.dogtagpki.tps.msg.StatusUpdateRequestMsg;
import org.dogtagpki.tps.msg.TPSMessage;
import org.dogtagpki.tps.msg.TokenPDURequestMsg;
import org.dogtagpki.tps.msg.TokenPDUResponseMsg;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.symkey.SessionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSProcessor {
    public static Logger logger = LoggerFactory.getLogger(TPSProcessor.class);
    public static final int RESULT_NO_ERROR = 0;
    public static final int RESULT_ERROR = -1;
    public static final int CPLC_DATA_SIZE = 47;
    public static final int CPLC_MSN_INDEX = 41;
    public static final int CPLC_MSN_SIZE = 4;
    public static final int INIT_UPDATE_DATA_SIZE = 28;
    public static final int INIT_UPDATE_DATA_SIZE_02 = 29;
    public static final int INIT_UPDATE_DATA_SIZE_03 = 32;
    public static final int DIVERSIFICATION_DATA_SIZE = 10;
    public static final int CARD_CRYPTOGRAM_OFFSET = 20;
    public static final int CARD_CRYPTOGRAM_OFFSET_GP211_SC03 = 21;
    public static final int CARD_CRYPTOGRAM_SIZE = 8;
    public static final int CARD_CHALLENGE_SIZE_GP211_SC02 = 6;
    public static final int CARD_CHALLENGE_OFFSET_GP211_SC03 = 13;
    public static final int SEQUENCE_COUNTER_OFFSET_GP211_SC02 = 12;
    public static final int SEQUENCE_COUNTER_SIZE_GP211_SC02 = 2;
    public static final int CARD_CHALLENGE_OFFSET = 12;
    public static final int CARD_CHALLENGE_OFFSET_GP211_SC02 = 14;
    public static final int CARD_CHALLENGE_SIZE = 8;
    protected boolean isExternalReg;
    protected TPSSession session;
    protected String selectedTokenType;
    protected String selectedKeySet;
    AuthToken authToken;
    List<String> ldapStringAttrs;
    protected String userid = null;
    protected String currentTokenOperation;
    protected BeginOpMsg beginMsg;
    private PlatformAndSecChannelProtoInfo platProtInfo;
    ProfileDatabase profileDatabase;

    public TPSProcessor(TPSSession session) {
        this.setSession(session);
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig engineConfig = engine.getConfig();
        this.profileDatabase = new ProfileDatabase();
        this.profileDatabase.setEngineConfig(engineConfig);
    }

    protected void setCurrentTokenOperation(String op) {
        this.currentTokenOperation = op;
    }

    protected void setSession(TPSSession session) {
        if (session == null) {
            throw new NullPointerException("TPS session is null");
        }
        this.session = session;
    }

    protected TPSSession getSession() {
        return this.session;
    }

    protected TokenRecord getTokenRecord() {
        TPSSession session = this.getSession();
        return session.getTokenRecord();
    }

    protected void setBeginMessage(BeginOpMsg msg) {
        this.beginMsg = msg;
    }

    public BeginOpMsg getBeginMessage() {
        return this.beginMsg;
    }

    protected void setSelectedTokenType(String theTokenType) {
        if (theTokenType == null) {
            throw new NullPointerException("TPSProcessor.setSelectedTokenType: Attempt to set invalid null token type!");
        }
        logger.debug("TPS_Processor.setSelectedTokenType: tokenType=" + theTokenType);
        this.selectedTokenType = theTokenType;
        TokenRecord tokenRecord = this.getTokenRecord();
        if (tokenRecord == null) {
            throw new NullPointerException("TPSProcessor.setSelectedTokenType: Can't find token record for token!");
        }
        tokenRecord.setType(this.selectedTokenType);
    }

    public String getSelectedTokenType() {
        return this.selectedTokenType;
    }

    protected void setSelectedKeySet(String theKeySet) {
        if (theKeySet == null) {
            throw new NullPointerException("TPSProcessor.setSelectedKeySet: Attempt to set invalid null key set!");
        }
        logger.debug("TPS_Processor.setSelectedKeySet: keySet=" + theKeySet);
        this.selectedKeySet = theKeySet;
    }

    public String getSelectedKeySet() {
        return this.selectedKeySet;
    }

    protected TPSBuffer extractTokenMSN(TPSBuffer cplc_data) throws TPSException {
        if (cplc_data == null || cplc_data.size() < 47) {
            throw new TPSException("TPSProcessor.extractTokenMSN: Can't extract token msn from cplc data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        TPSBuffer token_msn = cplc_data.substr(41, 4);
        return token_msn;
    }

    protected TPSBuffer extractTokenCUID(TPSBuffer cplc_data) throws TPSException {
        if (cplc_data == null || cplc_data.size() < 47) {
            logger.error("TPS_Processor.extractTokenCUID: cplc_data: invalid length.");
            throw new TPSException("TPSProcessor.extractTokenCUID: Can't extract cuid from cplc data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        TPSBuffer token1 = cplc_data.substr(3, 4);
        TPSBuffer token2 = cplc_data.substr(19, 2);
        TPSBuffer token3 = cplc_data.substr(15, 4);
        TPSBuffer token_cuid = new TPSBuffer();
        token_cuid.add(token1);
        token_cuid.add(token2);
        token_cuid.add(token3);
        return token_cuid;
    }

    protected APDUResponse selectApplet(byte p1, byte p2, TPSBuffer aid) throws IOException, TPSException {
        logger.debug("In TPS_Processor.SelectApplet.");
        if (aid == null || aid.size() == 0) {
            throw new TPSException("TPSProcessor.selectApplet: Invalid aid value!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        SelectAPDU select_apdu = new SelectAPDU(p1, p2, aid);
        return this.handleAPDURequest((APDU)select_apdu);
    }

    protected TPSBuffer getStatus() throws IOException, TPSException {
        logger.debug("In TPS_Processor.GetStatus.");
        GetStatusAPDU get_status_apdu = new GetStatusAPDU();
        return this.handleAPDURequest((APDU)get_status_apdu).getData();
    }

    public APDUResponse handleAPDURequest(APDU apdu) throws IOException, TPSException {
        if (apdu == null) {
            throw new TPSException("TPSProcessor.handleAPDURequest: invalid incoming apdu!");
        }
        TokenPDURequestMsg request_msg = new TokenPDURequestMsg(apdu);
        try {
            this.session.write((TPSMessage)request_msg);
        }
        catch (IOException e) {
            logger.error("TPS_Processor.HandleAPDURequest failed WriteMsg: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        TokenPDUResponseMsg response_msg = null;
        try {
            response_msg = (TokenPDUResponseMsg)this.session.read();
        }
        catch (IOException e) {
            logger.error("TPS_Processor.HandleAPDURequest failed ReadMsg: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return response_msg.getResponseAPDU();
    }

    protected TPSBuffer getCplcData() throws IOException, TPSException {
        logger.debug("In TPS_Processor. getCplcData");
        GetDataAPDU get_data_apdu = new GetDataAPDU();
        APDUResponse respApdu = this.handleAPDURequest((APDU)get_data_apdu);
        if (!respApdu.checkResult()) {
            throw new TPSException("TPSProcessor.getCplcData: Can't get data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        TPSBuffer cplcData = respApdu.getData();
        if (cplcData.size() != 47) {
            throw new TPSException("TPSProcessor.cplcData: Data invalid size!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        return respApdu.getData();
    }

    public TPSBuffer getData(byte[] identifier) throws TPSException, IOException {
        logger.debug("In TPSProcessor.getData: identifier: " + identifier);
        if (identifier == null || identifier.length != 2) {
            throw new TPSException("TPSProcessor.getData: Can't get data, invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        GetDataAPDU get_data_apdu = new GetDataAPDU(identifier);
        APDUResponse respApdu = this.handleAPDURequest((APDU)get_data_apdu);
        if (!respApdu.checkResult()) {
            throw new TPSException("TPSProcessor.getData: Can't get data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        return respApdu.getData();
    }

    protected TPSBuffer getAppletVersion() throws IOException, TPSException {
        logger.debug("In TPSProcessor.getAppletVersion");
        this.selectCoolKeyApplet();
        GetVersionAPDU get_version_apdu = new GetVersionAPDU();
        APDUResponse respApdu = this.handleAPDURequest((APDU)get_version_apdu);
        if (!respApdu.checkResult()) {
            logger.warn("TPSProcessor.getAppletVersion: No applet version found on card!");
            return null;
        }
        TPSBuffer apdu_data = respApdu.getData();
        if (apdu_data.size() != 6) {
            logger.error("TPSProcessor.getAppletVersion: incorrect return data size!");
            throw new TPSException("TPSProcessor.getAppletVersion: invalid applet version string returned!", EndOpMsg.TPSStatus.STATUS_ERROR_CANNOT_PERFORM_OPERATION);
        }
        TPSBuffer build_id = apdu_data.substr(0, 4);
        logger.debug("TPSProcessor.getAppletVersion: returning: " + build_id.toHexString());
        return build_id;
    }

    protected byte getLifecycleState() {
        byte resultState = -16;
        String method = "TPSProcessor.getLifecycleState:";
        logger.debug(method + " getLifecycleState: ");
        GetLifecycleAPDU getLifecycle = new GetLifecycleAPDU();
        try {
            this.selectCoolKeyApplet();
            APDUResponse response = this.handleAPDURequest((APDU)getLifecycle);
            if (!response.checkResult()) {
                return resultState;
            }
            TPSBuffer result = response.getResultDataNoCode();
            logger.debug(method + " result size: " + result.size());
            if (result.size() == 1) {
                resultState = result.at(0);
                logger.debug(method + " result: " + resultState);
            }
        }
        catch (IOException | TPSException e) {
            logger.warn(method + " problem getting state: " + e.getMessage(), e);
        }
        return resultState;
    }

    protected TPSBuffer encryptData(AppletInfo appletInfo, TPSBuffer keyInfo, TPSBuffer plaintextChallenge, String connId, int protocol) throws TPSException {
        TKSRemoteRequestHandler tks = null;
        TKSEncryptDataResponse data = null;
        try {
            tks = new TKSRemoteRequestHandler(connId, this.getSelectedKeySet());
            data = tks.encryptData(appletInfo.getKDD(), appletInfo.getCUID(), keyInfo, plaintextChallenge, protocol);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.encryptData: Erorr getting wrapped data from TKS!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        int status = data.getStatus();
        if (status != 0) {
            throw new TPSException("TPSProcessor.computeRandomData: Erorr getting wrapped data from TKS!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_ENROLL_PDU);
        }
        return data.getEncryptedData();
    }

    TPSBuffer computeRandomData(int dataSize, String connId) throws TPSException {
        TKSRemoteRequestHandler tks = null;
        TKSComputeRandomDataResponse data = null;
        try {
            tks = new TKSRemoteRequestHandler(connId);
            data = tks.computeRandomData(dataSize);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.computeRandomData: Erorr getting random data from TKS!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        int status = data.getStatus();
        if (status != 0) {
            throw new TPSException("TPSProcessor.computeRandomData: Erorr getting random data from TKS!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        return data.getRandomData();
    }

    protected TPSBuffer initializeUpdate(byte keyVersion, byte keyIndex, TPSBuffer randomData) throws IOException, TPSException {
        String method = "TPSProcessor.initializeUpdate:";
        logger.debug(method + " Entering...");
        InitializeUpdateAPDU initUpdate = new InitializeUpdateAPDU(keyVersion, keyIndex, randomData);
        boolean done = false;
        if (done) {
            throw new TPSException("TPSProcessor.initializeUpdate. debugging exit...");
        }
        APDUResponse resp = this.handleAPDURequest((APDU)initUpdate);
        if (!resp.checkResult()) {
            logger.error("TPSProcessor.initializeUpdate: Failed intializeUpdate!");
            throw new TPSException("TPSBuffer.initializeUpdate: Failed initializeUpdate!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        TPSBuffer data = resp.getResultDataNoCode();
        logger.debug(method + " data.size() " + data.size());
        if (data.size() != 28 && data.size() != 29 && data.size() != 32) {
            throw new TPSException("TPSBuffer.initializeUpdate: Invalid response from token!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        return data;
    }

    protected SecureChannel setupSecureChannel(AppletInfo appletInfo) throws TPSException, IOException {
        SecureChannel channel = null;
        logger.debug("TPSProcessor.setupSecureChannel: No arguments entering...");
        int defKeyVersion = this.getChannelDefKeyVersion();
        int defKeyIndex = this.getChannelDefKeyIndex();
        channel = this.setupSecureChannel((byte)defKeyVersion, (byte)defKeyIndex, this.getTKSConnectorID(), appletInfo);
        channel.externalAuthenticate();
        return channel;
    }

    protected SecureChannel setupSecureChannel(byte keyVersion, byte keyIndex, String connId, AppletInfo appletInfo) throws IOException, TPSException {
        logger.debug("TPSProcessor.setupSecureChannel: keyVersion: " + keyVersion + " keyIndex: " + keyIndex);
        if (appletInfo == null) {
            throw new TPSException("TPSProcessor.setupSecureChannel: invalid input data.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        TPSBuffer randomData = this.computeRandomData(8, connId);
        if (randomData != null) {
            logger.debug("TPSProcessor.setupSecureChannel: obtained randomData");
        }
        this.acquireChannelPlatformAndProtocolInfo();
        TPSBuffer initUpdateResp = this.initializeUpdate(keyVersion, keyIndex, randomData);
        TPSBuffer key_diversification_data = initUpdateResp.substr(0, 10);
        appletInfo.setKDD(key_diversification_data);
        TPSBuffer key_info_data = null;
        key_info_data = this.platProtInfo.isSCP03() ? initUpdateResp.substr(10, 3) : initUpdateResp.substr(10, 2);
        logger.debug("TPSProcessor.setupSecureChannel: key info data: " + key_info_data.toHexString());
        TokenRecord tokenRecord = this.getTokenRecord();
        TPSBuffer card_cryptogram = null;
        TPSBuffer sequenceCounter = null;
        card_cryptogram = initUpdateResp.substr(20, 8);
        logger.debug("TPSProcessor.setupSecureChannel: card cryptogram: extracted");
        TPSBuffer card_challenge = null;
        if (this.platProtInfo.isSCP02()) {
            sequenceCounter = initUpdateResp.substr(12, 2);
            card_challenge = initUpdateResp.substr(14, 6);
            card_cryptogram = initUpdateResp.substr(20, 8);
            logger.debug("TPSProcessor.setupSecureChannel 02: card cryptogram: extracted");
            logger.debug("TPSProcessor.setupSecureChannel 02: card challenge: extracted");
            logger.debug("TPSProcessor.setupSecureChannel 02: key Info , before massage: " + key_info_data.toHexString());
            key_info_data.setAt(1, (byte)1);
            logger.debug("TPSProcessor.setupSecureChannel 02: key Info , after massage: " + key_info_data.toHexString());
        } else if (this.platProtInfo.isSCP03()) {
            card_challenge = initUpdateResp.substr(13, 8);
            card_cryptogram = initUpdateResp.substr(21, 8);
        } else {
            card_challenge = initUpdateResp.substr(12, 8);
        }
        logger.debug("TPSProcessor.setupSecureChannel: card challenge: extracted");
        SecureChannel channel = null;
        try {
            channel = this.generateSecureChannel(connId, key_diversification_data, key_info_data, card_challenge, card_cryptogram, randomData, sequenceCounter, appletInfo);
            if (channel != null) {
                tokenRecord.setKeyInfo(key_info_data.toHexStringPlain());
            }
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.setupSecureChannel: Can't set up secure channel: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        return channel;
    }

    protected SecureChannel generateSecureChannel(String connId, TPSBuffer keyDiversificationData, TPSBuffer keyInfoData, TPSBuffer cardChallenge, TPSBuffer cardCryptogram, TPSBuffer hostChallenge, TPSBuffer sequenceCounter, AppletInfo appletInfo) throws EBaseException, TPSException, IOException {
        String method = "TPSProcessor.generateSecureChannel:";
        if (connId == null || keyDiversificationData == null || keyInfoData == null || cardChallenge == null || cardCryptogram == null || hostChallenge == null || appletInfo == null) {
            throw new TPSException("TPSProcessor.generateSecureChannel: Invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("TPSProcessor.generateSecureChannel: entering.. keyInfoData: " + keyInfoData.toHexString());
        logger.debug("TPSProcessor.generateSecureChannel: isSCP02: " + this.platProtInfo.isSCP02());
        TPSEngine engine = TPSEngine.getInstance();
        SecureChannel channel = null;
        TPSBuffer hostCryptogram = null;
        PK11SymKey sessionKey = null;
        PK11SymKey encSessionKey = null;
        TKSComputeSessionKeyResponse resp = null;
        TKSComputeSessionKeyResponse respEnc02 = null;
        TKSComputeSessionKeyResponse respDek02 = null;
        TKSComputeSessionKeyResponse respCMac02 = null;
        TKSComputeSessionKeyResponse respRMac02 = null;
        PK11SymKey encSessionKeySCP02 = null;
        PK11SymKey dekSessionKeySCP02 = null;
        PK11SymKey cmacSessionKeySCP02 = null;
        PK11SymKey rmacSessionKeySCP02 = null;
        PK11SymKey encSessionKeySCP03 = null;
        PK11SymKey macSessionKeySCP03 = null;
        PK11SymKey kekSessionKeySCP03 = null;
        Object rmacSessionKeySCP03 = null;
        SymmetricKey sharedSecret = null;
        boolean cuidOK = this.checkCUIDMatchesKDD(appletInfo.getCUIDhexStringPlain(), appletInfo.getKDDhexStringPlain());
        boolean isVersionInRange = this.checkCardGPKeyVersionIsInRange(appletInfo.getCUIDhexStringPlain(), appletInfo.getKDDhexStringPlain(), keyInfoData.toHexStringPlain());
        boolean doesVersionMatchTokenDB = this.checkCardGPKeyVersionMatchesTokenDB(appletInfo.getCUIDhexStringPlain(), appletInfo.getKDDhexStringPlain(), keyInfoData.toHexStringPlain());
        if (!cuidOK) {
            throw new TPSException("TPSProcessor.generateSecureChannel: cuid vs kdd matching policy not met!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        if (!isVersionInRange) {
            throw new TPSException("TPSProcessor.generateSecureChannel: key version is not within acceptable range!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        if (!doesVersionMatchTokenDB) {
            throw new TPSException("TPSProcessor.generateSecureChannel: key version from token does not match that of the token db!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        SecureChannelProtocol protocol = null;
        if (this.platProtInfo.isSCP01() || this.platProtInfo.isSCP02()) {
            protocol = new SecureChannelProtocol(1);
        } else if (this.platProtInfo.isSCP03()) {
            protocol = new SecureChannelProtocol(3);
        }
        String tokenName = "Internal Key Storage Token";
        CryptoManager cm = null;
        CryptoToken token = null;
        String sharedSecretName = null;
        try {
            sharedSecretName = this.getSharedSecretTransportKeyName(connId);
            SecureChannelProtocol.setSharedSecretKeyName(sharedSecretName);
            cm = protocol.getCryptoManger();
            token = protocol.returnTokenByName(tokenName, cm);
            sharedSecret = SecureChannelProtocol.getSymKeyByName(token, sharedSecretName);
        }
        catch (Exception e) {
            logger.error("TPSProcessor: " + e.getMessage(), (Throwable)e);
            throw new TPSException("TPSProcessor.generateSecureChannel: Can't get shared secret key!: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        if (this.platProtInfo.isGP201() || this.platProtInfo.isSCP01()) {
            resp = engine.computeSessionKey(keyDiversificationData, appletInfo.getCUID(), keyInfoData, cardChallenge, hostChallenge, cardCryptogram, connId, this.getSelectedTokenType(), this.getSelectedKeySet());
            hostCryptogram = resp.getHostCryptogram();
            if (hostCryptogram == null) {
                throw new TPSException("TPSProcessor.generateSecureChannel: No host cryptogram returned from token!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            try {
                TPSBuffer sessionKeyWrapped = resp.getSessionKey();
                TPSBuffer encSessionKeyWrapped = resp.getEncSessionKey();
                sessionKey = (PK11SymKey)protocol.unwrapWrappedSymKeyOnToken(token, sharedSecret, sessionKeyWrapped.toBytesArray(), false, SymmetricKey.DES3);
                if (sessionKey == null) {
                    logger.error("TPSProcessor.generateSecureChannel: Can't extract session key!");
                    throw new TPSException("TPSProcessor.generateSecureChannel: Can't extract session key!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
                }
                logger.debug("TPSProcessor.generateSecureChannel: retrieved session key: " + sessionKey);
                encSessionKey = (PK11SymKey)protocol.unwrapWrappedSymKeyOnToken(token, sharedSecret, encSessionKeyWrapped.toBytesArray(), false, SymmetricKey.DES3);
                if (encSessionKey == null) {
                    logger.error("TPSProcessor.generateSecureChannel: Can't extract enc session key!");
                    throw new TPSException("TPSProcessor.generateSecureChannel: Can't extract enc session key!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
                }
                logger.debug("TPSProcessor.generateSecureChannel: retrieved enc session key");
                TPSBuffer drmDesKey = null;
                TPSBuffer kekDesKey = null;
                TPSBuffer keyCheck = null;
                drmDesKey = resp.getDRM_Trans_DesKey();
                keyCheck = resp.getKeyCheck();
                kekDesKey = resp.getKekWrappedDesKey();
                if (this.checkServerSideKeyGen(connId)) {
                    logger.debug("TPSProcessor.generateSecureChannel: true for checkServerSideKeyGen");
                }
                channel = new SecureChannel(this, sessionKey, encSessionKey, drmDesKey, kekDesKey, keyCheck, keyDiversificationData, cardChallenge, cardCryptogram, hostChallenge, hostCryptogram, keyInfoData, this.platProtInfo);
            }
            catch (Exception e) {
                logger.error("TPSProcessor: " + e.getMessage(), (Throwable)e);
                throw new TPSException("TPSProcessor.generateSecureChannel: Problem extracting session keys! " + e, EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
        }
        if (this.platProtInfo.isSCP02()) {
            if (sequenceCounter == null) {
                throw new TPSException("TPSProcessor.generateSecureChannel: Invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            logger.debug("TPSProcessor.generateSecureChannel Trying secure channel protocol 02");
            respEnc02 = engine.computeSessionKeySCP02(keyDiversificationData, appletInfo.getCUID(), keyInfoData, sequenceCounter, new TPSBuffer(SecureChannel.ENCDerivationConstant), connId, this.getSelectedTokenType(), this.getSelectedKeySet());
            TPSBuffer encSessionKeyWrappedSCP02 = respEnc02.getSessionKey();
            encSessionKeySCP02 = SessionKey.UnwrapSessionKeyWithSharedSecret((String)tokenName, (PK11SymKey)((PK11SymKey)sharedSecret), (byte[])encSessionKeyWrappedSCP02.toBytesArray());
            if (encSessionKeySCP02 == null) {
                logger.error("TPSProcessor.generateSecureChannel: Can't extract the SCP02 enc session key!");
                throw new TPSException("TPSProcessor.generateSecureChannel: Can't the emc SCP02 session keys!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            respCMac02 = engine.computeSessionKeySCP02(keyDiversificationData, appletInfo.getCUID(), keyInfoData, sequenceCounter, new TPSBuffer(SecureChannel.C_MACDerivationConstant), connId, this.getSelectedTokenType(), this.getSelectedKeySet());
            TPSBuffer cmacSessionKeyWrappedSCP02 = respCMac02.getSessionKey();
            cmacSessionKeySCP02 = SessionKey.UnwrapSessionKeyWithSharedSecret((String)tokenName, (PK11SymKey)((PK11SymKey)sharedSecret), (byte[])cmacSessionKeyWrappedSCP02.toBytesArray());
            if (cmacSessionKeySCP02 == null) {
                logger.error("TPSProcessor.generateSecureChannel: Can't extract the SCP02 cmac session key!");
                throw new TPSException("TPSProcessor.generateSecureChannel: Can't the s,ac SCP02 session keys!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            respRMac02 = engine.computeSessionKeySCP02(keyDiversificationData, appletInfo.getCUID(), keyInfoData, sequenceCounter, new TPSBuffer(SecureChannel.R_MACDerivationConstant), connId, this.getSelectedTokenType(), this.getSelectedKeySet());
            TPSBuffer rmacSessionKeyWrappedSCP02 = respRMac02.getSessionKey();
            rmacSessionKeySCP02 = SessionKey.UnwrapSessionKeyWithSharedSecret((String)tokenName, (PK11SymKey)((PK11SymKey)sharedSecret), (byte[])rmacSessionKeyWrappedSCP02.toBytesArray());
            if (rmacSessionKeySCP02 == null) {
                logger.error("TPSProcessor.generateSecureChannel: Can't extract the SCP02 cmac session key!");
                throw new TPSException("TPSProcessor.generateSecureChannel: Can't the cmac SCP02 session keys!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            respDek02 = engine.computeSessionKeySCP02(keyDiversificationData, appletInfo.getCUID(), keyInfoData, sequenceCounter, new TPSBuffer(SecureChannel.DEKDerivationConstant), connId, this.getSelectedTokenType(), this.getSelectedKeySet());
            logger.debug("Past engine.computeSessionKeyData: After dek key request.");
            TPSBuffer dekSessionKeyWrappedSCP02 = respDek02.getSessionKey();
            dekSessionKeySCP02 = SessionKey.UnwrapSessionKeyWithSharedSecret((String)tokenName, (PK11SymKey)((PK11SymKey)sharedSecret), (byte[])dekSessionKeyWrappedSCP02.toBytesArray());
            if (dekSessionKeySCP02 == null) {
                logger.error("TPSProcessor.generateSecureChannel: Can't extract the SCP02 dek session key!");
                throw new TPSException("TPSProcessor.generateSecureChannel: Can't the dek SCP02 session keys!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            TPSBuffer drmDesKey = null;
            TPSBuffer kekDesKey = null;
            TPSBuffer keyCheck = null;
            drmDesKey = respDek02.getDRM_Trans_DesKey();
            kekDesKey = respDek02.getKekWrappedDesKey();
            keyCheck = respDek02.getKeyCheck();
            if (drmDesKey == null || kekDesKey == null) {
                logger.error("TPSProcessor.generateSecureChannel: Can't get drmDesKey or kekDesKey from TKS when processing the DEK session key!");
                throw new TPSException("TPSProcessor.generateSecureChannel: Can't get drmDesKey or kekDesKey from TKS when processing the DEK session key!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
            }
            channel = new SecureChannel(this, encSessionKeySCP02, cmacSessionKeySCP02, rmacSessionKeySCP02, dekSessionKeySCP02, drmDesKey, kekDesKey, keyCheck, keyDiversificationData, keyInfoData, sequenceCounter, hostChallenge, cardChallenge, cardCryptogram, this.platProtInfo);
            channel.setDekSessionKeyWrapped(dekSessionKeyWrappedSCP02);
        }
        if (this.platProtInfo.isSCP03()) {
            logger.debug("TPSProcessor.generateSecureChannel Trying secure channel protocol 03");
            resp = engine.computeSessionKeysSCP03(keyDiversificationData, appletInfo.getCUID(), keyInfoData, cardChallenge, hostChallenge, cardCryptogram, connId, this.getSelectedTokenType(), this.getSelectedKeySet());
            TPSBuffer encSessionKeyBuff = resp.getEncSessionKey();
            TPSBuffer kekSessionKeyBuff = resp.getKekSessionKey();
            TPSBuffer macSessionKeyBuff = resp.getMacSessionKey();
            TPSBuffer hostCryptogramBuff = resp.getHostCryptogram();
            TPSBuffer keyCheckBuff = resp.getKeyCheck();
            TPSBuffer drmDesKeyBuff = resp.getDRM_Trans_DesKey();
            TPSBuffer kekDesKeyBuff = resp.getKekWrappedDesKey();
            if (encSessionKeyBuff != null) {
                encSessionKeySCP03 = (PK11SymKey)protocol.unwrapWrappedSymKeyOnToken(token, sharedSecret, encSessionKeyBuff.toBytesArray(), false, SymmetricKey.AES);
            }
            if (macSessionKeyBuff != null) {
                macSessionKeySCP03 = (PK11SymKey)protocol.unwrapWrappedSymKeyOnToken(token, sharedSecret, macSessionKeyBuff.toBytesArray(), false, SymmetricKey.AES);
            }
            if (kekSessionKeyBuff != null) {
                kekSessionKeySCP03 = (PK11SymKey)protocol.unwrapWrappedSymKeyOnToken(token, sharedSecret, kekSessionKeyBuff.toBytesArray(), false, SymmetricKey.AES);
            }
            channel = new SecureChannel(this, encSessionKeySCP03, macSessionKeySCP03, kekSessionKeySCP03, drmDesKeyBuff, kekDesKeyBuff, keyCheckBuff, keyDiversificationData, cardChallenge, cardCryptogram, hostChallenge, hostCryptogramBuff, keyInfoData, this.platProtInfo);
        }
        if (channel == null) {
            throw new TPSException("TPSProcessor.generateSecureChannel: Can't create Secure Channel, possibly invalid secure channel protocol requested.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        return channel;
    }

    protected boolean checkUpdateAppletEncryption() throws TPSException {
        logger.debug("TPSProcessor.checkUpdateAppletEncryption entering...");
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String appletEncryptionConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".update.applet.encryption";
        logger.debug("TPSProcessor.checkUpdateAppletEncryption config to check: " + appletEncryptionConfig);
        boolean appletEncryption = false;
        try {
            appletEncryption = configStore.getBoolean(appletEncryptionConfig, false);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.checkUpdateAppletEncryption: internal error in getting value from config.");
        }
        logger.debug("TPSProcessor.checkUpdateAppletEncryption returning: " + appletEncryption);
        return appletEncryption;
    }

    protected int checkAndUpgradeApplet(AppletInfo appletInfo) throws TPSException, IOException {
        logger.debug("checkAndUpgradeApplet: entering..");
        String tksConnId = this.getTKSConnectorID();
        int upgraded = 0;
        if (this.checkForAppletUpdateEnabled()) {
            String targetAppletVersion = this.checkForAppletUpgrade("op." + this.currentTokenOperation);
            targetAppletVersion = targetAppletVersion.toLowerCase();
            String currentAppletVersion = this.formatCurrentAppletVersion(appletInfo);
            logger.debug("TPSProcessor.checkAndUpgradeApplet: currentAppletVersion: " + currentAppletVersion + " targetAppletVersion: " + targetAppletVersion);
            if (targetAppletVersion.compareTo(currentAppletVersion) != 0) {
                upgraded = 1;
                logger.debug("TPSProcessor.checkAndUpgradeApplet: Upgrading applet to : " + targetAppletVersion);
                this.upgradeApplet(appletInfo, "op." + this.currentTokenOperation, targetAppletVersion, this.getBeginMessage().getExtensions(), tksConnId, 5, 12);
            }
        }
        if (upgraded == 0) {
            logger.debug("TPSProcessor.checkAndUpgradeApplet: applet already at correct version or upgrade disabled.");
            this.selectCardManager();
            this.setupSecureChannel(appletInfo);
        }
        return upgraded;
    }

    protected void upgradeApplet(AppletInfo appletInfo, String operation, String new_version, Map<String, String> extensions, String connId, int startProgress, int endProgress) throws IOException, TPSException {
        TPSBuffer netkeyAIDBuff = null;
        TPSBuffer cardMgrAIDBuff = null;
        TPSBuffer netkeyPAIDBuff = null;
        netkeyAIDBuff = this.getNetkeyAID();
        netkeyPAIDBuff = this.getNetkeyPAID();
        cardMgrAIDBuff = this.getCardManagerAID();
        int channelBlockSize = this.getChannelBlockSize();
        int channelInstanceSize = this.getChannelInstanceSize();
        int channelAppletMemSize = this.getAppletMemorySize();
        int defKeyVersion = this.getChannelDefKeyVersion();
        int defKeyIndex = this.getChannelDefKeyIndex();
        byte[] appletData = null;
        TokenRecord tokenRecord = this.getTokenRecord();
        String directory = this.getAppletDirectory(operation);
        logger.debug("TPSProcessor.upgradeApplet: applet target directory: " + directory);
        String appletFileExt = this.getAppletExtension();
        String appletFilePath = directory + "/" + new_version + "." + appletFileExt;
        logger.debug("TPSProcessor.upgradeApplet: targe applet file name: " + appletFilePath);
        appletData = this.getAppletFileData(appletFilePath);
        APDUResponse select = this.selectApplet((byte)4, (byte)0, cardMgrAIDBuff);
        if (!select.checkResult()) {
            String logMsg = "Can't selelect the card manager!";
            this.auditAppletUpgrade(appletInfo, "failure", null, new_version, logMsg);
            throw new TPSException("TPSProcessor.upgradeApplet:" + logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        SecureChannel channel = this.setupSecureChannel((byte)defKeyVersion, (byte)defKeyIndex, connId, appletInfo);
        channel.externalAuthenticate();
        channel.deleteFileX(netkeyAIDBuff);
        channel.deleteFileX(netkeyPAIDBuff);
        channel.installLoad(netkeyPAIDBuff, cardMgrAIDBuff, appletData.length);
        TPSBuffer appletDataBuff = new TPSBuffer(appletData);
        channel.loadFile(appletDataBuff, channelBlockSize, startProgress, endProgress);
        channel.installApplet(netkeyPAIDBuff, netkeyAIDBuff, (byte)0, channelInstanceSize, channelAppletMemSize);
        select = this.selectApplet((byte)4, (byte)0, netkeyAIDBuff);
        if (!select.checkResult()) {
            String logMsg = "Cannot select newly created applet!";
            this.auditAppletUpgrade(appletInfo, "failure", channel.getKeyInfoData().toHexStringPlain(), new_version, logMsg);
            throw new TPSException("TPSProcessor.upgradeApplet: " + logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        this.auditAppletUpgrade(appletInfo, "success", channel.getKeyInfoData().toHexStringPlain(), new_version, null);
        tokenRecord.setAppletID(new_version);
    }

    public void selectCoolKeyApplet() throws TPSException, IOException {
        logger.debug("In selectCoolKeyApplet!");
        TPSBuffer netkeyAIDBuff = this.getNetkeyAID();
        APDUResponse select = this.selectApplet((byte)4, (byte)0, netkeyAIDBuff);
        if (!select.checkResult()) {
            logger.debug("TPSProcessor.selectCoolKeyApplet: Can't select coolkey, token may be blank.");
        }
    }

    protected byte[] getAppletFileData(String appletFilePath) throws IOException, TPSException {
        if (appletFilePath == null) {
            throw new TPSException("TPSProcessor.getAppletFileData: Invalid applet file name.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        byte[] contents = null;
        try {
            Path path = Paths.get(appletFilePath, new String[0]);
            contents = Files.readAllBytes(path);
        }
        catch (IOException e) {
            logger.error("TPSProcessor.getAppletFileData: IOException " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("PSProcessor.getAppletFileData: Exception: " + e.getMessage(), (Throwable)e);
            throw new TPSException("TPSProcessor.getAppletFileData: Exception: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        logger.debug("TPSProcessor.getAppletFileData: data: " + contents);
        return contents;
    }

    public TPSAuthenticator getAuthentication(String prefix, String tokenType) throws EBaseException {
        logger.debug("TPSProcessor.getAuthentication");
        Object logMsg = null;
        if (prefix.isEmpty() || tokenType.isEmpty()) {
            logMsg = "TPSProcessor.getAuthentication: missing parameters: prefix or tokenType";
            logger.error((String)logMsg);
            throw new EBaseException((String)logMsg);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String configName = prefix + "." + tokenType + ".auth.id";
        logger.debug("TPSProcessor.getAuthentication: getting config: " + configName);
        String authId = configStore.getString(configName);
        if (authId == null) {
            logMsg = "TPSProcessor.getAuthentication: config param not found:" + configName;
            logger.error((String)logMsg);
            throw new EBaseException((String)logMsg);
        }
        return this.getAuthentication(authId);
    }

    public TPSAuthenticator getAuthentication(String authId) throws EBaseException {
        logger.debug("TPSProcessor.getAuthentication");
        Object logMsg = null;
        if (authId.isEmpty()) {
            logMsg = "TPSProcessor.getAuthentication: missing parameters: authId";
            logger.error((String)logMsg);
            throw new EBaseException((String)logMsg);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        AuthenticationConfig authConfig = configStore.getAuthenticationConfig();
        AuthManagersConfig instancesConfig = authConfig.getAuthManagersConfig();
        TPSSubsystem subsystem = (TPSSubsystem)engine.getSubsystem("tps");
        TPSAuthenticator authInst = subsystem.getAuthenticationManager().getAuthInstance(authId);
        String authCredNameConf = authId + ".authCredName";
        logger.debug("TPSProcessor.getAuthentication: getting config: auths.instance." + authCredNameConf);
        String authCredName = instancesConfig.getString(authCredNameConf);
        if (authCredName == null) {
            logMsg = "TPSProcessor.getAuthentication: config param not found: auths.instance." + authCredNameConf;
            logger.error((String)logMsg);
            throw new EBaseException((String)logMsg);
        }
        authInst.setAuthCredName(authCredName);
        String authLdapStringAttrs = authId + ".ldapStringAttributes";
        logger.debug("TPSProcessor.getAuthentication: getting config: auths.instance." + authLdapStringAttrs);
        String authLdapStringAttributes = instancesConfig.getString(authLdapStringAttrs, "");
        if (authLdapStringAttributes != null && !authLdapStringAttributes.equals("")) {
            logMsg = "TPSProcessor.getAuthentication: got ldapStringAttributes... setting up";
            logger.debug((String)logMsg);
            this.ldapStringAttrs = Arrays.asList(authLdapStringAttributes.split(","));
        } else {
            logMsg = "TPSProcessor.getAuthentication: config param not set:" + authLdapStringAttributes;
            logger.debug((String)logMsg);
        }
        return authInst;
    }

    public void processAuthentication(String op, TPSAuthenticator userAuth, String cuid, TokenRecord tokenRecord) throws EBaseException, TPSException, IOException {
        String method = "TPSProcessor:processAuthentication:";
        if (op.equals("format")) {
            String opPrefix = "op.format";
        } else if (op.equals("enroll")) {
            String opPrefix = "op.enroll";
        } else {
            String opPrefix = "op.pinReset";
        }
        AuthCredentials userCred = this.requestUserId(op, cuid, userAuth, this.beginMsg.getExtensions());
        this.userid = (String)userCred.get(userAuth.getAuthCredName());
        logger.debug(method + op + " userCred (attempted) userid=" + this.userid);
        tokenRecord.setUserID(this.userid);
        this.authToken = this.authenticateUser(op, userAuth, userCred);
        this.userid = this.authToken.getInString("userid");
        tokenRecord.setUserID(this.userid);
        logger.debug(method + " auth token userid=" + this.userid);
    }

    public AuthToken authenticateUser(String op, TPSAuthenticator userAuth, AuthCredentials userCred) throws EBaseException, TPSException {
        String logMsg = null;
        if (op.isEmpty() || userAuth == null || userCred == null) {
            logMsg = "TPSProcessor.authenticateUser: missing parameter(s): op, userAuth, or userCred";
            logger.error(logMsg);
            throw new EBaseException(logMsg);
        }
        logger.debug("TPSProcessor.authenticateUser: op: " + op);
        AuthManager auth = userAuth.getAuthManager();
        try {
            this.authToken = auth.authenticate(userCred);
            if (this.authToken == null) {
                logger.error("TPSProcessor.authenticateUser: authentication failure with authToken null");
                throw new TPSException("TPS error user authentication failed.", EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN);
            }
            logger.debug("TPSProcessor.authenticateUser: authentication success");
            Enumeration n = this.authToken.getElements();
            while (n.hasMoreElements()) {
                String name = (String)n.nextElement();
                logger.debug("TPSProcessor.authenticateUser: got authToken val name:" + name);
            }
            return this.authToken;
        }
        catch (EBaseException e) {
            logger.error("TPSProcessor.authenticateUser: authentication failure: " + e, (Throwable)e);
            throw new TPSException("TPS error user authentication failed.", EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN);
        }
    }

    AuthCredentials requestUserId(String op, String cuid, TPSAuthenticator auth, Map<String, String> extensions) throws IOException, TPSException, EBaseException {
        AuthCredentials login;
        logger.debug("TPSProcessor.requestUserId");
        if (op.isEmpty() || cuid.isEmpty() || auth == null) {
            logger.error("TPSProcessor.requestUserId: missing parameter(s): op, cuid, or auth");
            throw new EBaseException("TPSProcessor.requestUserId: missing parameter(s): op, cuid, or auth");
        }
        if (extensions != null && extensions.get("extendedLoginRequest") != null) {
            String description;
            String title;
            String locale = extensions.get("locale");
            if (extensions.get("locale") == null) {
                locale = "en";
            }
            if ((title = auth.getUiTitle(locale)).isEmpty()) {
                title = auth.getUiTitle("en");
            }
            if ((description = auth.getUiDescription(locale)).isEmpty()) {
                description = auth.getUiTitle("en");
            }
            HashMap<String, AuthUIParameter> authParamSet = auth.getUiParamSet();
            HashSet<String> params = new HashSet<String>();
            for (Map.Entry<String, AuthUIParameter> entry : authParamSet.entrySet()) {
                params.add(auth.getUiParam(entry.getKey()).toString(locale));
                logger.debug("TPSProcessor.requestUserId: for extendedLoginRequest, added param: " + auth.getUiParam(entry.getKey()).toString(locale));
            }
            login = this.requestExtendedLogin(0, 0, params, title, description, auth);
        } else {
            login = this.requestLogin(0, 0, auth);
        }
        return login;
    }

    public AuthCredentials mapCredFromMsgResponse(TPSMessage response, TPSAuthenticator auth, boolean extendedLogin) throws EBaseException {
        String[] requiredCreds;
        logger.debug("TPSProcessor.mapCredFromMsgResponse");
        if (response == null || auth == null) {
            logger.error("TPSProcessor.mapCredFromMsgResponse: missing parameter(s): response or auth");
            throw new EBaseException("TPSProcessor.mapCredFromMsgResponse: missing parameter(s): response or auth");
        }
        AuthCredentials login = new AuthCredentials();
        AuthManager authManager = auth.getAuthManager();
        for (String cred : requiredCreds = authManager.getRequiredCreds()) {
            String name = auth.getCredMap(cred, extendedLogin);
            logger.debug("TPSProcessor.mapCredFromMsgResponse: cred=" + cred + " &name=" + name);
            login.set(cred, (Object)response.get(name));
        }
        return login;
    }

    public AuthCredentials requestExtendedLogin(int invalidPW, int blocked, Set<String> parameters, String title, String description, TPSAuthenticator auth) throws IOException, TPSException, EBaseException {
        logger.debug("TPSProcessor.requestExtendedLogin");
        if (parameters == null || title.isEmpty() || description.isEmpty() || auth == null) {
            logger.error("TPSProcessor.requestExtendedLogin: missing parameter(s): parameters, title, description, or auth");
            throw new EBaseException("TPSProcessor.requestExtendedLogin: missing parameter(s): parameters, title, description, or auth");
        }
        ExtendedLoginRequestMsg loginReq = new ExtendedLoginRequestMsg(invalidPW, blocked, parameters, title, description);
        try {
            this.session.write((TPSMessage)loginReq);
        }
        catch (IOException e) {
            logger.error("TPSProcessor.requestExtendedLogin failed WriteMsg: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.debug("TPSProcessor.requestExtendedLogin: extendedLoginRequest sent");
        ExtendedLoginResponseMsg loginResp = null;
        try {
            loginResp = (ExtendedLoginResponseMsg)this.session.read();
        }
        catch (IOException e) {
            logger.error("TPSProcessor.requestExtendedLogin failed ReadMsg: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        AuthCredentials login = this.mapCredFromMsgResponse((TPSMessage)loginResp, auth, true);
        return login;
    }

    public AuthCredentials requestLogin(int invalidPW, int blocked, TPSAuthenticator auth) throws IOException, TPSException, EBaseException {
        logger.debug("TPSProcessor.requestLogin");
        if (auth == null) {
            logger.error("TPSProcessor.requestLogin: missing parameter(s): parameters, title, description, or auth");
            throw new EBaseException("TPSProcessor.requestLogin: missing parameter(s): parameters, title, description, or auth");
        }
        LoginRequestMsg loginReq = new LoginRequestMsg(invalidPW, blocked);
        try {
            this.session.write((TPSMessage)loginReq);
        }
        catch (IOException e) {
            logger.error("TPSProcessor.requestLogin failed WriteMsg: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.debug("TPSProcessor.requestLogin: loginRequest sent");
        LoginResponseMsg loginResp = null;
        try {
            loginResp = (LoginResponseMsg)this.session.read();
        }
        catch (IOException e) {
            logger.error("TPSProcessor.requestLogin failed ReadMsg: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        AuthCredentials login = this.mapCredFromMsgResponse((TPSMessage)loginResp, auth, false);
        return login;
    }

    protected void fillTokenRecord(TokenRecord tokenRecord, AppletInfo appletInfo) throws TPSException {
        String method = "TPSProcessor.fillTokenRecord";
        logger.debug(method + ": begins");
        if (tokenRecord == null || appletInfo == null) {
            logger.error(method + ": params tokenRecord and appletInfo cannot be null");
            throw new TPSException(method + ": missing parameter(s): parameter appletInfo");
        }
        byte app_major_version = appletInfo.getAppMajorVersion();
        byte app_minor_version = appletInfo.getAppMinorVersion();
        TPSBuffer build_id = null;
        try {
            build_id = this.getAppletVersion();
        }
        catch (IOException e) {
            logger.warn(method + ": failed getting applet version:" + e.getMessage(), (Throwable)e);
        }
        if (build_id != null) {
            tokenRecord.setAppletID(Integer.toHexString(app_major_version) + "." + Integer.toHexString(app_minor_version) + "." + build_id.toHexStringPlain());
        }
        logger.debug(method + ": ends");
    }

    protected void fillTokenRecordDefaultPolicy(TokenRecord tokenRecord) throws TPSException {
        String method = "TPSProcessor.fillTokenRecordDefaultPolicy: ";
        try {
            TPSEngine engine = TPSEngine.getInstance();
            TPSEngineConfig configStore = engine.getConfig();
            TokenDBConfig tdbConfig = configStore.getTokenDBConfig();
            String defaultPolicy = tdbConfig.getString("defaultPolicy");
            logger.debug("{} default token policy: {}", (Object)method, (Object)defaultPolicy);
            tokenRecord.setPolicy(defaultPolicy);
        }
        catch (Exception e) {
            logger.debug("{}Problem with adding the default policy to the token.", (Object)method);
            throw new TPSException(e.toString(), EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
    }

    protected TokenRecord isTokenRecordPresent(AppletInfo appletInfo) throws TPSException {
        if (appletInfo == null) {
            throw new TPSException("TPSProcessor.isTokenRecordPresent: invalid input data.");
        }
        logger.debug("TPSProcessor.isTokenRecordPresent: " + appletInfo.getCUIDhexString());
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        TokenRecord tokenRecord = null;
        try {
            tokenRecord = tps.tdb.tdbGetTokenEntry(appletInfo.getCUIDhexStringPlain());
            logger.debug("TPSProcessor.isTokenRecordPresent: found token...");
        }
        catch (EDBRecordNotFoundException e) {
            logger.debug("TPSProcessor.isTokenRecordPresent: Token " + appletInfo.getCUIDhexStringPlain() + " not found, creating token in memory");
        }
        catch (Exception e) {
            logger.warn("TPSProcessor.isTokenRecordPresent: Unable to find token " + appletInfo.getCUIDhexStringPlain() + ": " + e.getMessage(), (Throwable)e);
        }
        return tokenRecord;
    }

    protected String getCAConnectorID() throws TPSException {
        return this.getCAConnectorID(null, null);
    }

    protected String getCAConnectorID(String enrollType, String keyType) throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String id = null;
        String config = null;
        String method = "TPSProcessor.getCAConnectorID:";
        if (keyType != null && enrollType != null) {
            config = "op." + this.currentTokenOperation + "." + this.selectedTokenType + "." + enrollType + "." + keyType + ".ca.conn";
            logger.debug(method + " getting config: " + (String)config);
        } else {
            config = "op.format." + this.selectedTokenType + ".ca.conn";
            logger.debug(method + " getting config: " + config);
        }
        try {
            id = configStore.getString(config);
        }
        catch (EBaseException e) {
            throw new TPSException(method + " Internal error finding config value:" + config, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug(method + " returning: " + id);
        return id;
    }

    protected boolean revokeCertsAtFormat() {
        String logMsg;
        String method = "revokeCertsAtFormat";
        logger.debug(method + ": begins");
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String configName = "op.format." + this.selectedTokenType + ".revokeCert";
        boolean revokeCert = false;
        try {
            logger.debug(method + ": getting config:" + configName);
            revokeCert = configStore.getBoolean(configName, false);
        }
        catch (EBaseException e) {
            logMsg = method + ": config not found: " + configName + "; default to false: " + e.getMessage();
            logger.warn(logMsg, (Throwable)e);
        }
        if (!revokeCert) {
            logMsg = method + ":  revokeCert = false";
            logger.debug(logMsg);
        }
        return revokeCert;
    }

    protected RevocationReason getRevocationReasonAtFormat() {
        String method = "getRevocationReasonAtFormat";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String configName = "op.format." + this.selectedTokenType + ".revokeCert.reason";
        logger.debug(method + " finding config: " + configName);
        RevocationReason revokeReason = RevocationReason.UNSPECIFIED;
        try {
            int revokeReasonInt = configStore.getInteger(configName);
            revokeReason = RevocationReason.valueOf((int)revokeReasonInt);
        }
        catch (EBaseException e) {
            String logMsg = method + ": config not found: " + configName + "; default to unspecified: " + e.getMessage();
            logger.warn(logMsg, (Throwable)e);
            revokeReason = RevocationReason.UNSPECIFIED;
        }
        return revokeReason;
    }

    protected void revokeCertificates(String cuid, RevocationReason revokeReason, String caConnId) throws TPSException {
        Object logMsg = "";
        String method = "TPSProcessor.revokeCertificates";
        if (cuid == null) {
            logMsg = "cuid null";
            logger.error("TPSProcessor.revokeCertificates:" + (String)logMsg);
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
        }
        logger.debug("TPSProcessor.revokeCertificates: begins for cuid:" + cuid);
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        boolean isTokenPresent = tps.tdb.isTokenPresent(cuid);
        if (!isTokenPresent) {
            logMsg = "TPSProcessor.revokeCertificates: token not found: " + cuid;
            logger.error((String)logMsg);
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
        }
        CARemoteRequestHandler caRH = null;
        try {
            caRH = new CARemoteRequestHandler(caConnId);
        }
        catch (EBaseException e) {
            logMsg = "TPSProcessor.revokeCertificates: getting CARemoteRequestHandler failure: " + e.getMessage();
            logger.error((String)logMsg, (Throwable)e);
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
        }
        Collection<TPSCertRecord> certRecords = tps.tdb.tdbGetCertRecordsByCUID(cuid);
        logger.debug("TPSProcessor.revokeCertificates: found " + certRecords.size() + " certs");
        for (TPSCertRecord cert : certRecords) {
            if (cert.getStatus().equals("revoked")) {
                logger.debug("TPSProcessor.revokeCertificates: cert " + cert.getSerialNumber() + " already revoked; remove from tokendb and move on");
                try {
                    tps.certDatabase.removeRecord(cert.getId());
                    continue;
                }
                catch (Exception e) {
                    logMsg = "TPSProcessor.revokeCertificates: removeRecord failed: " + e.getMessage();
                    logger.error((String)logMsg, (Throwable)e);
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
                }
            }
            String origin = cert.getOrigin();
            if (origin != null && !origin.equals(cuid)) {
                logger.debug("TPSProcessor.revokeCertificates: cert " + cert.getSerialNumber() + " originally created for this token: " + origin + " while current token: " + cuid + "; Remove from tokendb and skip the revoke");
                try {
                    tps.certDatabase.removeRecord(cert.getId());
                    continue;
                }
                catch (Exception e) {
                    logMsg = "TPSProcessor.revokeCertificates: removeRecord failed: " + e.getMessage();
                    logger.error((String)logMsg, (Throwable)e);
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
                }
            }
            if (origin == null) {
                logger.debug("TPSProcessor.revokeCertificates: tokenOrigin is not present in tokendb cert record");
            }
            if (cert.getStatus().equals(TokenCertStatus.ONHOLD.toString())) {
                logger.debug("TPSProcessor.revokeCertificates: cert " + cert.getSerialNumber() + " has status revoked_on_hold; remove from tokendb and move on");
                try {
                    tps.certDatabase.removeRecord(cert.getId());
                    continue;
                }
                catch (Exception e) {
                    logMsg = "TPSProcessor.revokeCertificates: removeRecord failed: " + e.getMessage();
                    logger.error((String)logMsg, (Throwable)e);
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
                }
            }
            String hexSerial = cert.getSerialNumber();
            if (hexSerial.length() >= 3 && hexSerial.startsWith("0x")) {
                String serial = hexSerial.substring(2);
                BigInteger bInt = new BigInteger(serial, 16);
                String serialStr = bInt.toString();
                logger.debug("TPSProcessor.revokeCertificates: found cert hex serial: " + serial + " dec serial:" + serialStr);
                try {
                    CARevokeCertResponse response = caRH.revokeCertificate(true, serialStr, cert.getCertificate(), revokeReason);
                    logger.debug("TPSProcessor.revokeCertificates: response status =" + response.getStatus());
                    this.auditRevoke(cuid, true, revokeReason.getCode(), String.valueOf(response.getStatus()), serialStr, caConnId, null);
                }
                catch (EBaseException e) {
                    logMsg = "TPSProcessor.revokeCertificates: revokeCertificate from CA failed: " + e.getMessage();
                    logger.error((String)logMsg, (Throwable)e);
                    this.auditRevoke(cuid, true, revokeReason.getCode(), "failure", serialStr, caConnId, null);
                    if (revokeReason == RevocationReason.CERTIFICATE_HOLD) {
                        tps.tdb.tdbActivity("format", this.session.getTokenRecord(), this.session.getIpAddress(), (String)logMsg, "failure");
                    } else {
                        tps.tdb.tdbActivity("format", this.session.getTokenRecord(), this.session.getIpAddress(), (String)logMsg, "failure");
                    }
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
                }
            } else {
                logMsg = "mulformed hex serial number :" + hexSerial;
                logger.error("TPSProcessor.revokeCertificates: " + (String)logMsg);
                tps.tdb.tdbActivity("format", this.session.getTokenRecord(), this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
            }
            logMsg = "Certificate " + hexSerial + " revoked";
            tps.tdb.tdbActivity("format", this.session.getTokenRecord(), this.session.getIpAddress(), (String)logMsg, "success");
            logger.debug("TPSProcessor.revokeCertificates: cert " + cert.getSerialNumber() + ": remove from tokendb");
            try {
                tps.certDatabase.removeRecord(cert.getId());
            }
            catch (Exception e) {
                logMsg = "removeRecord failed: " + e.getMessage();
                logger.error("TPSProcessor.revokeCertificates: " + (String)logMsg, (Throwable)e);
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_UPDATE_TOKENDB_FAILED);
            }
        }
        logger.debug("TPSProcessor.revokeCertificates: done for cuid:" + cuid);
    }

    public boolean allowRecoverInvalidCert() throws TPSException {
        String method = "TPSProcessor.allowRecoverInvalidCert:";
        boolean ret = true;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String configName = "externalReg.allowRecoverInvalidCert.enable";
        try {
            ret = configStore.getBoolean(configName, true);
        }
        catch (EBaseException e) {
            throw new TPSException(method + e.getMessage(), EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        return ret;
    }

    public boolean listCaseInsensitiveContains(String s, List<String> list) {
        for (String element : list) {
            if (!element.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    ExternalRegAttrs processExternalRegAttrs(String authId) throws NumberFormatException, EBaseException {
        String[] vals;
        String method = "processExternalRegAttrs";
        List<String> attributesToProcess = null;
        ExternalRegAttrs erAttrs = new ExternalRegAttrs(authId);
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String attributesToProcessStr = configStore.getString("auths.instance." + authId + ".externalReg.attributes", "");
        if (attributesToProcessStr.length() > 0) {
            attributesToProcess = Arrays.asList(attributesToProcessStr.split(","));
        }
        if (attributesToProcess == null) {
            return erAttrs;
        }
        if (this.listCaseInsensitiveContains(erAttrs.ldapAttrNameTokenType, attributesToProcess)) {
            logger.debug(method + ": getting from authToken: " + erAttrs.ldapAttrNameTokenType);
            vals = this.authToken.getInStringArray(erAttrs.ldapAttrNameTokenType);
            if (vals == null) {
                String configName = "externalReg.default.tokenType";
                String tVal = configStore.getString(configName, "externalRegAddToToken");
                logger.debug(method + ": set default tokenType: " + tVal);
                erAttrs.setTokenType(tVal);
            } else {
                logger.debug(method + ": retrieved tokenType: " + vals[0]);
                erAttrs.setTokenType(vals[0]);
            }
        }
        if (this.listCaseInsensitiveContains(erAttrs.ldapAttrNameTokenCUID, attributesToProcess)) {
            logger.debug(method + ": getting from authToken:" + erAttrs.ldapAttrNameTokenCUID);
            vals = this.authToken.getInStringArray(erAttrs.ldapAttrNameTokenCUID);
            if (vals != null) {
                logger.debug(method + ": retrieved cuid:" + vals[0]);
                erAttrs.setTokenCUID(vals[0]);
            } else {
                logger.debug(method + ": " + erAttrs.ldapAttrNameTokenCUID + " attribute not found");
            }
        }
        if (this.listCaseInsensitiveContains(erAttrs.ldapAttrNameRegistrationType, attributesToProcess)) {
            logger.debug(method + ": getting from authToken:" + erAttrs.ldapAttrNameRegistrationType);
            vals = this.authToken.getInStringArray(erAttrs.ldapAttrNameRegistrationType);
            if (vals != null) {
                logger.debug(method + ": retrieved registrationType:" + vals[0]);
                erAttrs.setRegistrationType(vals[0]);
            } else {
                logger.debug(method + ": registrationType attribute not found.");
                erAttrs.setRegistrationType(null);
            }
        }
        if (this.listCaseInsensitiveContains(erAttrs.ldapAttrNameCertsToRecover, attributesToProcess)) {
            logger.debug(method + ": getting from authToken:" + erAttrs.ldapAttrNameCertsToRecover);
            vals = this.authToken.getInStringArray(erAttrs.ldapAttrNameCertsToRecover);
            if (vals != null) {
                ArrayList<ExternalRegCertToRecover> retainableCerts = new ArrayList<ExternalRegCertToRecover>();
                for (String val : vals) {
                    logger.debug(method + ": retrieved certsToRecover:" + val);
                    String[] items = val.split(",");
                    if (items.length != 2 && items.length != 4) {
                        throw new EBaseException(method + ": certsToRecover format error");
                    }
                    ExternalRegCertToRecover erCert = new ExternalRegCertToRecover();
                    int i = 0;
                    for (i = 0; i < items.length; ++i) {
                        if (i == 0) {
                            logger.debug(method + "setting serial: " + items[i]);
                            erCert.setSerial(new BigInteger(items[i]));
                            continue;
                        }
                        if (i == 1) {
                            erCert.setCaConn(items[i]);
                            continue;
                        }
                        if (i == 2) {
                            logger.debug(method + "setting keyid: " + items[i]);
                            erCert.setKeyid(new BigInteger(items[i]));
                            continue;
                        }
                        if (i != 3) continue;
                        erCert.setKraConn(items[i]);
                    }
                    if (i < 3) {
                        erCert.setIsRetainable(true);
                        retainableCerts.add(erCert);
                        continue;
                    }
                    erAttrs.addCertToRecover(erCert);
                }
                if (!retainableCerts.isEmpty()) {
                    erAttrs.getCertsToRecover().addAll(retainableCerts);
                }
            } else {
                logger.debug(method + ": certsToRecover attribute " + erAttrs.ldapAttrNameCertsToRecover + " not found");
            }
        }
        return erAttrs;
    }

    protected void setExternalRegSelectedTokenType(ExternalRegAttrs erAttrs) throws TPSException {
        String method = "TPSProcessor.setExternalRegSelectedTokenType: ";
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        logger.debug(method + " begins");
        if (erAttrs == null || erAttrs.getTokenType() == null) {
            String configName = "externalReg.default.tokenType";
            logger.debug(method + "erAttrs null or externalReg user entry does not contain tokenType...setting to default config: " + configName);
            try {
                String tokenType = configStore.getString(configName, "externalRegAddToToken");
                logger.debug(method + " setting tokenType to default: " + tokenType);
                this.setSelectedTokenType(tokenType);
            }
            catch (EBaseException e) {
                logger.debug(method + " Internal Error obtaining mandatory config values: " + e.getMessage(), (Throwable)e);
                String logMsg = "TPS error getting config values from config store." + e.toString();
                tps.tdb.tdbActivity(this.currentTokenOperation, this.session.getTokenRecord(), this.session.getIpAddress(), logMsg, "failure");
                throw new TPSException(logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
        } else {
            logger.debug(method + " setting tokenType to tokenType attribute of user entry: " + erAttrs.getTokenType());
            this.setSelectedTokenType(erAttrs.getTokenType());
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void format(boolean skipAuth) throws TPSException, IOException {
        engine = TPSEngine.getInstance();
        configStore = engine.getConfig();
        configName = null;
        logMsg = null;
        appletVersion = null;
        TPSProcessor.logger.debug("TPSProcessor.format begins");
        tps = (TPSSubsystem)engine.getSubsystem("tps");
        appletInfo = null;
        tokenRecord = null;
        try {
            appletInfo = this.getAppletInfo();
            this.auditOpRequest("format", appletInfo, "success", null);
        }
        catch (TPSException e) {
            logMsg = e.toString();
            this.auditOpRequest("format", appletInfo, "failure", (String)logMsg);
            tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw e;
        }
        appletInfo.setAid(this.getCardManagerAID());
        TPSProcessor.logger.debug("TPSProcessor.format: token cuid: " + appletInfo.getCUIDhexStringPlain());
        isTokenPresent = false;
        tokenRecord = this.isTokenRecordPresent(appletInfo);
        if (tokenRecord == null) {
            TPSProcessor.logger.debug("TPSProcessor.format: token does not exist in tokendb... create one in memory");
            tokenRecord = new TokenRecord();
            tokenRecord.setId(appletInfo.getCUIDhexStringPlain());
        } else {
            TPSProcessor.logger.debug("TPSProcessor.format: found token...");
            isTokenPresent = true;
        }
        this.fillTokenRecord(tokenRecord, appletInfo);
        this.session.setTokenRecord(tokenRecord);
        cuid = appletInfo.getCUIDhexString();
        TPSProcessor.logger.debug("TPSProcessor.format: CUID hex string=" + appletInfo.getCUIDhexStringPlain());
        msn = appletInfo.getMSNString();
        major_version = appletInfo.getMajorVersion();
        minor_version = appletInfo.getMinorVersion();
        app_major_version = appletInfo.getAppMajorVersion();
        app_minor_version = appletInfo.getAppMinorVersion();
        TPSProcessor.logger.debug("TPSProcessor.format: major_version " + major_version + " minor_version: " + minor_version + " app_major_version: " + app_major_version + " app_minor_version: " + app_minor_version);
        tokenType = "tokenType";
        userCred = new AuthCredentials();
        if (this.isExternalReg) {
            TPSProcessor.logger.debug("In TPSProcessor.format isExternalReg: ON");
            configName = "externalReg.format.loginRequest.enable";
            try {
                requireLoginRequest = configStore.getBoolean((String)configName, false);
            }
            catch (EBaseException e) {
                TPSProcessor.logger.error("TPSProcessor.format: Internal Error obtaining mandatory config values: " + e.getMessage(), (Throwable)e);
                logMsg = "TPS error getting config values from config store." + e.toString();
                tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
            if (!requireLoginRequest) {
                TPSProcessor.logger.debug("In TPSProcessor.format: no Login required");
                configName = "externalReg.default.tokenType";
                try {
                    tokenType = configStore.getString((String)configName, "externalRegAddToToken");
                    this.setSelectedTokenType(tokenType);
                }
                catch (EBaseException e) {
                    TPSProcessor.logger.error("TPSProcessor.format: Internal Error obtaining mandatory config values: " + e.getMessage(), (Throwable)e);
                    logMsg = "TPS error getting config values from config store." + e.toString();
                    tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
                }
                TPSProcessor.logger.debug("In TPSProcessor.format: isExternalReg: setting tokenType to default first:" + tokenType);
            } else {
                TPSProcessor.logger.debug("In TPSProcessor.format: isExternalReg: calling requestUserId");
                configName = "externalReg.authId";
                try {
                    authId = configStore.getString((String)configName);
                }
                catch (EBaseException e) {
                    TPSProcessor.logger.error("TPSProcessor.format: Internal Error obtaining mandatory config values: " + e.getMessage(), (Throwable)e);
                    logMsg = "TPS error getting config values from config store." + e.toString();
                    tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
                }
                userAuth = null;
                try {
                    userAuth = this.getAuthentication(authId);
                    this.processAuthentication("format", userAuth, cuid, tokenRecord);
                    this.auditAuthSuccess(this.userid, this.currentTokenOperation, appletInfo, authId);
                }
                catch (Exception e) {
                    this.auditAuthFailure(this.userid, this.currentTokenOperation, appletInfo, userAuth != null ? userAuth.getID() : null);
                    TPSProcessor.logger.error("TPSProcessor.format:: authentication exception thrown: " + e.getMessage(), (Throwable)e);
                    logMsg = "authentication failed, status = STATUS_ERROR_LOGIN";
                    tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN);
                }
                try {
                    erAttrs = this.processExternalRegAttrs(authId);
                }
                catch (Exception ee) {
                    logMsg = "processExternalRegAttrs: " + ee.toString();
                    tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
                }
                this.session.setExternalRegAttrs(erAttrs);
                this.setExternalRegSelectedTokenType(erAttrs);
            }
            TPSProcessor.logger.debug("In TPSProcessor.format: isExternalReg: about to process keySet resolver");
            try {
                resolverInstName = this.getKeySetResolverInstanceName();
                if (resolverInstName.equals("none") || this.selectedKeySet != null) ** GOTO lbl129
                mappingParams = this.createFilterMappingParams(resolverInstName, appletInfo.getCUIDhexStringPlain(), appletInfo.getMSNString(), appletInfo.getMajorVersion(), appletInfo.getMinorVersion());
                subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                resolverInst = subsystem.getMappingResolverManager().getResolverInstance(resolverInstName);
                keySet = resolverInst.getResolvedMapping(mappingParams, "keySet");
                this.setSelectedKeySet(keySet);
                TPSProcessor.logger.debug("In TPSProcessor.format: resolved keySet: " + keySet);
            }
            catch (TPSException e) {
                logMsg = e.toString();
                tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
        } else {
            TPSProcessor.logger.debug("In TPSProcessor.format isExternalReg: OFF");
            try {
                resolverInstName = this.getResolverInstanceName();
                if (!resolverInstName.equals("none") && this.selectedKeySet == null) {
                    mappingParams = this.createFilterMappingParams(resolverInstName, appletInfo.getCUIDhexStringPlain(), msn, major_version, minor_version);
                    subsystem = (TPSSubsystem)engine.getSubsystem("tps");
                    resolverInst = subsystem.getMappingResolverManager().getResolverInstance(resolverInstName);
                    tokenType = resolverInst.getResolvedMapping(mappingParams);
                    this.setSelectedTokenType(tokenType);
                    TPSProcessor.logger.debug("In TPSProcessor.format: resolved tokenType: " + tokenType);
                }
            }
            catch (TPSException e) {
                logMsg = e.toString();
                tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
            TPSProcessor.logger.debug("TPSProcessor.format: calculated tokenType: " + tokenType);
        }
lbl129:
        // 3 sources

        if (!this.isExternalReg) {
            configName = "op.format." + tokenType + ".auth.enable";
            try {
                TPSProcessor.logger.debug("TPSProcessor.format: getting config: " + (String)configName);
                isAuthRequired = configStore.getBoolean((String)configName, true);
            }
            catch (EBaseException e) {
                info = " Internal Error obtaining mandatory config values. Error: " + e;
                this.auditFormatFailure(this.userid, appletInfo, info);
                TPSProcessor.logger.error("TPSProcessor.format: " + info, (Throwable)e);
                logMsg = "TPS error: " + info;
                tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
            if (isAuthRequired && !skipAuth) {
                userAuth = null;
                try {
                    userAuth = this.getAuthentication("op.format", tokenType);
                    this.processAuthentication("format", userAuth, cuid, tokenRecord);
                    this.auditAuthSuccess(this.userid, this.currentTokenOperation, appletInfo, userAuth != null ? userAuth.getID() : null);
                }
                catch (Exception e) {
                    this.auditAuthFailure(this.userid, this.currentTokenOperation, appletInfo, userAuth != null ? userAuth.getID() : null);
                    TPSProcessor.logger.error("TPSProcessor.format:: authentication exception thrown: " + e.getMessage(), (Throwable)e);
                    logMsg = "authentication failed, status = STATUS_ERROR_LOGIN";
                    tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                    throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN);
                }
            }
        }
        this.checkProfileStateOK();
        if (!isTokenPresent) ** GOTO lbl169
        TPSProcessor.logger.debug("TPSProcessor.format: token exists");
        newState = TokenStatus.FORMATTED;
        this.checkInvalidTokenStatus(tokenRecord, "format");
        if (tps.isOperationTransitionAllowed(tokenRecord, newState)) {
            TPSProcessor.logger.debug("TPSProcessor.format: token transition allowed " + tokenRecord.getTokenStatus() + " to " + newState);
        } else {
            info = " illegal transition attempted: " + tokenRecord.getTokenStatus() + " to " + newState;
            TPSProcessor.logger.error("TPSProcessor.format: token transition: " + info);
            logMsg = "Operation for CUID " + appletInfo.getCUIDhexStringPlain() + " Disabled. " + info;
            this.auditFormatFailure(this.userid, appletInfo, info);
            tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_DISABLED_TOKEN);
lbl169:
            // 1 sources

            this.checkAllowUnknownToken("format");
            tokenRecord.setTokenStatus(TokenStatus.UNFORMATTED);
            TPSProcessor.logger.debug("TPSProcessor.format: token does not exist");
            logMsg = "add token during format";
            try {
                tps.tdb.tdbAddTokenEntry(tokenRecord, TokenStatus.UNFORMATTED);
                tps.tdb.tdbActivity("add", tokenRecord, this.session.getIpAddress(), (String)logMsg, "success");
                this.fillTokenRecordDefaultPolicy(tokenRecord);
                TPSProcessor.logger.debug("TPSProcessor.format: token added");
            }
            catch (Exception e) {
                logMsg = (String)logMsg + ":" + e.toString();
                tps.tdb.tdbActivity("add", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_UPDATE_TOKENDB_FAILED);
            }
        }
        build_id = this.getAppletVersion();
        if (build_id == null) {
            this.checkAllowNoAppletToken("op.format");
        } else {
            appletVersion = this.formatCurrentAppletVersion(appletInfo);
        }
        appletRequiredVersion = this.checkForAppletUpgrade("op.format");
        TPSProcessor.logger.debug("TPSProcessor.format: appletVersion found: " + appletVersion + " requiredVersion: " + appletRequiredVersion);
        tksConnId = this.getTKSConnectorID();
        this.upgradeApplet(appletInfo, "op.format", appletRequiredVersion, this.beginMsg.getExtensions(), tksConnId, 10, 90);
        TPSProcessor.logger.debug("TPSProcessor.format: Completed applet upgrade.");
        this.writeIssuerInfoToToken(null, appletInfo);
        if (this.requiresStatusUpdate()) {
            this.statusUpdate(100, "PROGRESS_DONE");
        }
        try {
            channel = this.checkAndUpgradeSymKeys(appletInfo, tokenRecord);
        }
        catch (TPSException te) {
            this.auditKeyChangeover(appletInfo, "failure", null, this.getSymmetricKeysRequiredVersionHexString(), te.toString());
            throw te;
        }
        channel.externalAuthenticate();
        this.auditFormatSuccess(this.userid, appletInfo, channel.getKeyInfoData().toHexStringPlain());
        if (isTokenPresent && this.revokeCertsAtFormat()) {
            reason = this.getRevocationReasonAtFormat();
            caConnId = this.getCAConnectorID();
            try {
                this.revokeCertificates(tokenRecord.getId(), reason, caConnId);
            }
            catch (TPSException te) {
                failMsg = "revoke certificates failure";
                logMsg = failMsg + ":" + te.getMessage();
                TPSProcessor.logger.error("TPSProcessor.format: " + (String)logMsg, (Throwable)te);
                tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
            }
            catch (Exception ee) {
                failMsg = "revoke certificates failure";
                logMsg = failMsg + ":" + ee.getMessage();
                TPSProcessor.logger.error("TPSProcessor.format: " + (String)logMsg, (Throwable)ee);
                tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
                throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_REVOKE_CERTIFICATES_FAILED);
            }
        }
        try {
            tps.tdb.tdbRemoveCertificatesByCUID(tokenRecord.getId());
        }
        catch (Exception e) {
            logMsg = "Attempt to clean up record with tdbRemoveCertificatesByCUID failed; token probably clean; continue anyway:" + e.getMessage();
            TPSProcessor.logger.warn("TPSProcessor.format: " + (String)logMsg, (Throwable)e);
        }
        tokenRecord.setUserID(null);
        tokenRecord.setTokenStatus(TokenStatus.FORMATTED);
        logMsg = "token format operation";
        try {
            tps.tdb.tdbUpdateTokenEntry(tokenRecord);
            tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "success");
        }
        catch (Exception e) {
            logMsg = (String)logMsg + ":" + e.toString();
            tps.tdb.tdbActivity("format", tokenRecord, this.session.getIpAddress(), (String)logMsg, "failure");
            throw new TPSException((String)logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_UPDATE_TOKENDB_FAILED);
        }
        TPSProcessor.logger.debug("TPSProcessor.format:: ends");
    }

    protected void writeIssuerInfoToToken(SecureChannel origChannel, AppletInfo appletInfo) throws TPSException, IOException, UnsupportedEncodingException {
        if (this.checkIssuerInfoEnabled()) {
            String tksConnId = this.getTKSConnectorID();
            int defKeyIndex = this.getChannelDefKeyIndex();
            int defKeyVersion = this.getChannelDefKeyVersion();
            SecureChannel channel = null;
            if (origChannel != null) {
                channel = origChannel;
            } else {
                channel = this.setupSecureChannel((byte)defKeyVersion, (byte)defKeyIndex, tksConnId, appletInfo);
                channel.externalAuthenticate();
            }
            String issuer = this.getIssuerInfoValue();
            byte[] issuer_bytes = issuer.getBytes("US-ASCII");
            TPSBuffer issuerInfoBuff = new TPSBuffer(issuer_bytes);
            channel.setIssuerInfo(issuerInfoBuff);
        }
    }

    protected String getResolverInstanceName() throws TPSException {
        logger.debug("TPSProcessor.getResolverInstanceName: entering for operaiton : " + this.currentTokenOperation);
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String resolverInstName = null;
        String opPrefix = null;
        String opDefault = null;
        if (this.currentTokenOperation.equals("format")) {
            opPrefix = "op.format";
            opDefault = "formatMappingResolver";
        } else if (this.currentTokenOperation.equals("enroll")) {
            opDefault = "enrollMappingResolver";
            opPrefix = "op.enroll";
        } else if (this.currentTokenOperation.equals("pinReset")) {
            opDefault = "pinResetMappingResolver";
            opPrefix = "op.pinReset";
        } else {
            throw new TPSException("TPSProcessor.getResolverInstanceName: Invalid operation type, can not calculate resolver instance!", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        String config = opPrefix + ".mappingResolver";
        logger.debug("TPSProcessor.getResolverInstanceName: getting config: " + config);
        try {
            resolverInstName = configStore.getString(config, opDefault);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getResolverInstanceName: Internal error finding config value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcessor.getResolverInstanceName: returning: " + resolverInstName);
        return resolverInstName;
    }

    protected String getKeySetResolverInstanceName() throws TPSException {
        String method = "TPSProcessor.getKeySetResolverInstanceName: ";
        logger.debug(method + " begins");
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String resolverInstName = null;
        if (!this.isExternalReg) {
            logger.warn(method + "externalReg not enabled; keySet mapping currently only supported in externalReg.");
            return null;
        }
        String config = "externalReg.mappingResolver";
        logger.debug(method + " getting config: " + config);
        try {
            resolverInstName = configStore.getString(config, "none");
        }
        catch (EBaseException e) {
            throw new TPSException(e.getMessage(), EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (resolverInstName.equals("")) {
            resolverInstName = "none";
        }
        logger.debug(method + " returning: " + resolverInstName);
        return resolverInstName;
    }

    protected FilterMappingParams createFilterMappingParams(String resolverInstName, String cuid, String msn, byte major_version, byte minor_version) throws TPSException {
        String method = "TPSProcessor.createFilterMappingParams: ";
        FilterMappingParams mappingParams = new FilterMappingParams();
        try {
            mappingParams = new FilterMappingParams();
            logger.debug(method + " after new MappingFilterParams");
            mappingParams.set("fp_major_version", String.valueOf(major_version));
            mappingParams.set("fp_minor_version", String.valueOf(minor_version));
            mappingParams.set("fp_cuid", cuid);
            mappingParams.set("fp_msn", msn);
            if (this.beginMsg.getExtensions() != null) {
                mappingParams.set("fp_ext_tokenType", (String)this.beginMsg.getExtensions().get("tokenType"));
                mappingParams.set("fp_ext_tokenATR", (String)this.beginMsg.getExtensions().get("tokenATR"));
                mappingParams.set("fp_ext_keySet", (String)this.beginMsg.getExtensions().get("keySet"));
            }
            logger.debug(method + " MappingFilterParams set");
        }
        catch (Exception et) {
            logger.error(method + " exception: " + et.getMessage(), (Throwable)et);
            throw new TPSException(method + " failed.", EndOpMsg.TPSStatus.STATUS_ERROR_MAPPING_RESOLVER_FAILED);
        }
        return mappingParams;
    }

    protected String getIssuerInfoValue() throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String info = null;
        String config = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".issuerinfo.value";
        logger.debug("TPSProcessor.getIssuerInfoValue: getting config: " + config);
        try {
            info = configStore.getString(config, null);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getIssuerInfoValue: Internal error finding config value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (info == null) {
            throw new TPSException("TPSProcessor.getIssuerInfoValue: Can't find issuer info value in the config.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcessor.getIssuerInfoValue: returning: " + info);
        return info;
    }

    void checkProfileStateOK() throws TPSException {
        logger.debug("TPSProcessor.checkProfileStateOK()");
        String profileState = null;
        try {
            profileState = this.profileDatabase.getRecordStatus(this.selectedTokenType);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.checkProfileStateOK: internal error in getting profile state from config.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (!profileState.equals("Enabled")) {
            logger.error("TPSProcessor.checkProfileStateOK: profile specifically disabled.");
            throw new TPSException("TPSProcessor.checkProfileStateOK: profile disabled!", EndOpMsg.TPSStatus.STATUS_ERROR_DISABLED_TOKEN);
        }
    }

    protected boolean checkIssuerInfoEnabled() throws TPSException {
        logger.debug("TPSProcessor.checkIssuerEnabled entering...");
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String issuerEnabledConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".issuerinfo.enable";
        logger.debug("TPSProcessor.checkIssuerEnabled config to check: " + issuerEnabledConfig);
        boolean issuerInfoEnabled = false;
        try {
            issuerInfoEnabled = configStore.getBoolean(issuerEnabledConfig, false);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.checkIssuerInfo: internal error in getting value from config.");
        }
        logger.debug("TPSProcessor.checkIssuerEnabled returning: " + issuerInfoEnabled);
        return issuerInfoEnabled;
    }

    protected void checkIsExternalReg() throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String External_Reg_Cfg = "externalReg.enable";
        logger.debug("TPS_Processor.checkIsExternalReg: getting config:" + External_Reg_Cfg);
        try {
            logger.debug("In TPS_Processor.checkIsExternalReg.");
            this.isExternalReg = configStore.getBoolean(External_Reg_Cfg, false);
            logger.debug("In TPS_Processor.checkIsExternalReg. isExternalReg: " + this.isExternalReg);
        }
        catch (EBaseException e1) {
            logger.error("TPS_Processor.checkIsExternalReg: Internal Error obtaining mandatory config values: " + e1.getMessage(), (Throwable)e1);
            throw new TPSException("TPS error getting config values from config store.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
    }

    boolean checkServerSideKeyGen(String connId) throws TPSException {
        boolean result;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String profileConfig = "conn." + connId + "..serverKeygen";
        logger.debug("TPSProcessor.checkServerSideKeyGen: getting config: " + profileConfig);
        try {
            result = configStore.getBoolean(profileConfig, false);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor: checkServerSideKeyGen: Internal error obtaining config value!", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        return result;
    }

    void checkAllowNoAppletToken(String operation) throws TPSException {
        boolean allow = true;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String noAppletConfig = operation + "." + this.selectedTokenType + ".update.applet.emptyToken.enable";
        logger.debug("TPSProcessor.checkAllowNoAppletToken: getting config: " + noAppletConfig);
        try {
            allow = configStore.getBoolean(noAppletConfig, true);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.checkAllowNoAppletToken: Internal error getting config param.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (!allow) {
            throw new TPSException("TPSProcessor.checkAllowNoAppletToken: token without applet not permitted!", EndOpMsg.TPSStatus.STATUS_ERROR_DISABLED_TOKEN);
        }
    }

    boolean checkForAppletUpdateEnabled() throws TPSException {
        boolean enabled = false;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String appletUpdate = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".update.applet.enable";
        logger.debug("TPSProcessor.checkForAppletUpdateEnabled: getting config: " + appletUpdate);
        try {
            enabled = configStore.getBoolean(appletUpdate, false);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.checkForAppleUpdateEnabled: Can't find applet Update Enable. Internal error obtaining value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcessor.checkForAppletUpdateEnabled: returning " + enabled);
        return enabled;
    }

    protected String checkForAppletUpgrade(String operation) throws TPSException, IOException {
        String requiredVersion = null;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        this.acquireChannelPlatformAndProtocolInfo();
        int prot = this.getProtocol();
        logger.debug("TPSProcessor.checkForAppletUpgrad: protocol: " + prot);
        Object protString = "";
        if (prot > 1) {
            protString = ".prot." + prot;
        }
        String appletRequiredConfig = operation + "." + this.selectedTokenType + ".update.applet.requiredVersion" + (String)protString;
        logger.debug("TPSProcessor.checkForAppletUpgrade: getting config: " + appletRequiredConfig);
        try {
            requiredVersion = configStore.getString(appletRequiredConfig, null);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.checkForAppletUpgrade: Can't find applet required Version. Internal error obtaining version.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (requiredVersion == null) {
            throw new TPSException("TPSProcessor.checkForAppletUpgrade: Can't find applet required Version.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcessor.checkForAppletUpgrade: returning: " + requiredVersion);
        return requiredVersion;
    }

    protected void checkAllowUnknownToken(String operation) throws TPSException {
        boolean allow = true;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String unknownConfig = "op." + operation + ".allowUnknownToken";
        logger.debug("TPSProcessor.checkAllowUnknownToken: getting config: " + unknownConfig);
        try {
            allow = configStore.getBoolean(unknownConfig, true);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.checkAllowUnknownToken: Internal error getting config value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        if (!allow) {
            throw new TPSException("TPSProcessor.checkAllowUnknownToken: Unknown tokens not allowed for this operation!", EndOpMsg.TPSStatus.STATUS_ERROR_UNKNOWN_TOKEN);
        }
    }

    protected String getTKSConnectorID() throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String id = null;
        String config = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".tks.conn";
        logger.debug("TPSProcessor.getTKSConectorID: getting config: " + config);
        try {
            id = configStore.getString(config, "tks1");
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getTKSConnectorID: Internal error finding config value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcessor.getTKSConectorID: returning: " + id);
        return id;
    }

    protected TPSBuffer getNetkeyAID() throws TPSException {
        String NetKeyAID = null;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        logger.debug("TPSProcessor.getNetkeyAID: getting config: 627601FF000000");
        try {
            NetKeyAID = configStore.getString("applet.aid.netkey_instance", "627601FF000000");
        }
        catch (EBaseException e1) {
            logger.error("TPS_Processor.getNetkeyAID: Internal Error obtaining mandatory config values: " + e1.getMessage(), (Throwable)e1);
            throw new TPSException("TPS error getting config values from config store.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        TPSBuffer ret = new TPSBuffer(NetKeyAID);
        return ret;
    }

    protected TPSBuffer getNetkeyPAID() throws TPSException {
        String NetKeyPAID = null;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        logger.debug("TPSProcessor.getNetkeyPAID: getting config: 627601FF0000");
        try {
            NetKeyPAID = configStore.getString("applet.aid.netkey_file", "627601FF0000");
        }
        catch (EBaseException e1) {
            logger.error("TPS_Processor.getNetkeyAID: Internal Error obtaining mandatory config values: " + e1.getMessage(), (Throwable)e1);
            throw new TPSException("TPS error getting config values from config store.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        TPSBuffer ret = new TPSBuffer(NetKeyPAID);
        return ret;
    }

    protected TPSBuffer getCardManagerAID() throws TPSException {
        String cardMgrAID = null;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        logger.debug("TPSProcessor.getCardManagerAID: getting config: applet.aid.cardmgr_instance");
        try {
            cardMgrAID = configStore.getString("applet.aid.cardmgr_instance", "A0000000030000");
        }
        catch (EBaseException e1) {
            logger.error("TPS_Processor.getNetkeyAID: Internal Error obtaining mandatory config values: " + e1.getMessage(), (Throwable)e1);
            throw new TPSException("TPS error getting config values from config store.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        TPSBuffer ret = new TPSBuffer(cardMgrAID);
        return ret;
    }

    protected String getAppletExtension() throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String extension = null;
        String extensionConfig = "general.applet_ext";
        try {
            extension = configStore.getString(extensionConfig, "ijc");
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getAppletExtension: Internal error finding config value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcessor.getAppletExtension: returning: " + extension);
        return extension;
    }

    protected String getAppletDirectory(String operation) throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String directory = null;
        String directoryConfig = operation + "." + this.selectedTokenType + ".update.applet.directory";
        logger.debug("TPSProcessor.getAppletDirectory: getting config: " + directoryConfig);
        try {
            directory = configStore.getString(directoryConfig);
        }
        catch (EPropertyNotFound e) {
            throw new TPSException("TPSProcessor.getAppletDirectory: Required config param missing.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getAppletDirectory: Internal error finding config value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("getAppletDirectory: returning: " + directory);
        return directory;
    }

    protected int getChannelBlockSize() throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        int blockSize = 0;
        try {
            blockSize = configStore.getInteger("channel.blocksize", 242);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getChannelBlockSize: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcess.getChannelBlockSize: returning: " + blockSize);
        return blockSize;
    }

    protected int getChannelInstanceSize() throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        int instanceSize = 0;
        try {
            instanceSize = configStore.getInteger("channel.instanceSize", 18000);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getChannelInstanceSize: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcess.getChannelInstanceSize: returning: " + instanceSize);
        return instanceSize;
    }

    protected int getAppletMemorySize() throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        int memSize = 0;
        try {
            memSize = configStore.getInteger("channel.appletMemorySize", 5000);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getAppletMemorySize: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcess.getAppletMemorySize: returning: " + memSize);
        return memSize;
    }

    protected int getChannelDefKeyVersion() throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        int ver = 0;
        try {
            ver = configStore.getInteger("channel.defKeyVersion", 0);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getChannelDefKeyVersion: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcessor.getChannelDefKeyVersion: " + ver);
        return ver;
    }

    protected int getChannelDefKeyIndex() throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        int index = 0;
        try {
            index = configStore.getInteger("channel.defKeyIndex", 0);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getChannelDefKeyIndex: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcessor.getChannelDefKeyIndex: " + index);
        return index;
    }

    protected String getSharedSecretTransportKeyName(String connId) throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String sharedSecretName = null;
        try {
            String configName = "conn." + connId + ".tksSharedSymKeyName";
            logger.debug("TPSProcessor.getSharedSecretTransportKeyName: getting config:" + configName);
            sharedSecretName = configStore.getString(configName, "sharedSecret");
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getSharedSecretTransportKey: Internal error finding config value: " + e, EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("TPSProcessor.getSharedSecretTransportKeyName: calculated key name: " + sharedSecretName);
        return sharedSecretName;
    }

    protected PK11SymKey getSharedSecretTransportKey(String connId) throws TPSException, NotInitializedException {
        String sharedSecretName = this.getSharedSecretTransportKeyName(connId);
        logger.debug("TPSProcessor.getSharedSecretTransportKey: calculated key name: " + sharedSecretName);
        String symmKeys = null;
        boolean keyPresent = false;
        try {
            symmKeys = SessionKey.ListSymmetricKeys((String)"internal");
            logger.debug("TPSProcessor.getSharedSecretTransportKey: symmKeys List: " + symmKeys);
        }
        catch (Exception e) {
            logger.warn("TPSProcessor.getSharedSecretTransportKey: " + e.getMessage(), (Throwable)e);
        }
        for (String keyName : symmKeys.split(",")) {
            if (!sharedSecretName.equals(keyName)) continue;
            logger.debug("TPSProcessor.getSharedSecretTransportKey: shared secret key found!");
            keyPresent = true;
            break;
        }
        if (!keyPresent) {
            throw new TPSException("TPSProcessor.getSharedSecret: Can't find shared secret!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        String tokenName = "Internal Key Storage Token";
        PK11SymKey sharedSecret = SessionKey.GetSymKeyByName((String)tokenName, (String)sharedSecretName);
        logger.debug("TPSProcessor.getSharedSecret: SymKey returns: " + sharedSecret);
        return sharedSecret;
    }

    public boolean getIsExternalReg() {
        return this.isExternalReg;
    }

    public void process(BeginOpMsg beginMsg) throws TPSException, IOException {
        if (beginMsg == null) {
            throw new TPSException("TPSProcessor.process: invalid input data, not beginMsg provided.", EndOpMsg.TPSStatus.STATUS_ERROR_UPGRADE_APPLET);
        }
        this.setBeginMessage(beginMsg);
        this.setCurrentTokenOperation("format");
        this.checkIsExternalReg();
        this.format(false);
    }

    public void statusUpdate(int status, String info) throws IOException {
        if (!this.requiresStatusUpdate()) {
            return;
        }
        logger.debug("In TPSProcessor.statusUpdate status: " + status + " info: " + info);
        StatusUpdateRequestMsg statusUpdate = new StatusUpdateRequestMsg(status, info);
        this.session.write((TPSMessage)statusUpdate);
        this.session.read();
    }

    public boolean requiresStatusUpdate() {
        boolean result = false;
        String update = this.getBeginMessage().getExtension("statusUpdate");
        if (update != null && update.equals("true")) {
            result = true;
        }
        return result;
    }

    protected AppletInfo getAppletInfo() throws TPSException, IOException {
        AppletInfo result = null;
        logger.debug("TPSProcessor.getAppletInfo, entering ...");
        this.selectCardManager();
        TPSBuffer cplc_data = this.getCplcData();
        logger.debug("cplc_data: " + cplc_data.toHexString());
        TPSBuffer token_cuid = this.extractTokenCUID(cplc_data);
        TPSBuffer token_msn = this.extractTokenMSN(cplc_data);
        this.selectCoolKeyApplet();
        TPSBuffer token_status = this.getStatus();
        byte major_version = 0;
        byte minor_version = 0;
        byte app_major_version = 0;
        byte app_minor_version = 0;
        logger.debug("TPS_Processor.getAppletInfo: status: " + token_status.toHexString());
        if (token_status.size() >= 4) {
            major_version = token_status.at(0);
            minor_version = token_status.at(1);
            app_major_version = token_status.at(2);
            app_minor_version = token_status.at(3);
        }
        int free_mem = 0;
        int total_mem = 0;
        if (token_status.size() >= 12) {
            byte tot_high = token_status.at(6);
            byte tot_low = token_status.at(7);
            byte free_high = token_status.at(10);
            byte free_low = token_status.at(11);
            total_mem = (tot_high << 8) + tot_low;
            free_mem = (free_high << 8) + free_low;
        }
        result = new AppletInfo(major_version, minor_version, app_major_version, app_minor_version);
        result.setCUID(token_cuid);
        result.setMSN(token_msn);
        result.setTotalMem(total_mem);
        result.setFreeMem(free_mem);
        logger.debug("TPSProcessor.getAppletInfo: cuid: " + result.getCUIDhexString() + " msn: " + result.getMSNString() + " major version: " + result.getMajorVersion() + " minor version: " + result.getMinorVersion() + " App major version: " + result.getAppMajorVersion() + " App minor version: " + result.getAppMinorVersion());
        String currentAppletVersion = this.formatCurrentAppletVersion(result);
        if (currentAppletVersion != null) {
            logger.debug("TPSProcessor.getAppletInfo: current applet version = " + currentAppletVersion);
        }
        return result;
    }

    protected void selectCardManager() throws TPSException, IOException {
        logger.debug("TPSProcessor.selectCardManager: entering..");
        TPSBuffer aidBuf = this.getCardManagerAID();
        APDUResponse select = this.selectApplet((byte)4, (byte)0, aidBuf);
        if (!select.checkResult()) {
            throw new TPSException("TPSProcessor.selectCardManager: Can't selelect the card manager applet!", EndOpMsg.TPSStatus.STATUS_ERROR_CANNOT_ESTABLISH_COMMUNICATION);
        }
    }

    protected boolean checkSymmetricKeysEnabled() throws TPSException {
        boolean result = true;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String symmConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".update.symmetricKeys.enable";
        logger.debug("TPSProcessor.checkSymmetricKeysEnabled: getting config:" + symmConfig);
        try {
            result = configStore.getBoolean(symmConfig, true);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.checkSymmetricKeysEnabled: Internal error getting config value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        return result;
    }

    protected int getSymmetricKeysRequiredVersion() throws TPSException {
        int version = 0;
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String requiredVersionConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".update.symmetricKeys.requiredVersion";
        logger.debug("TPSProcessor.getSymmetricKeysRequiredVersion: getting config: " + requiredVersionConfig);
        try {
            version = configStore.getInteger(requiredVersionConfig, 0);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.getSymmetricKeysRequired: Internal error getting config value.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        logger.debug("TPSProcessor.getSymmetricKeysRequiredVersion: returning version: " + version);
        return version;
    }

    protected String getSymmetricKeysRequiredVersionHexString() throws TPSException {
        int requiredVersion = this.getSymmetricKeysRequiredVersion();
        byte[] nv = new byte[]{(byte)requiredVersion, 1};
        TPSBuffer newVersion = new TPSBuffer(nv);
        String newVersionStr = newVersion.toHexString();
        return newVersionStr;
    }

    protected SecureChannel checkAndUpgradeSymKeys(AppletInfo appletInfo, TokenRecord tokenRecord) throws TPSException, IOException {
        if (tokenRecord == null || appletInfo == null) {
            throw new TPSException("TPSProcessor.checkAndUpgradeSymKeys: invalid input data!");
        }
        TPSEngine eng = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)eng.getSubsystem("tps");
        SecureChannel channel = null;
        int defKeyVersion = 0;
        int defKeyIndex = this.getChannelDefKeyIndex();
        if (this.checkSymmetricKeysEnabled()) {
            logger.debug("TPSProcessor.checkAndUpgradeSymKeys: Symm key upgrade enabled.");
            int requiredVersion = this.getSymmetricKeysRequiredVersion();
            boolean failed = false;
            try {
                channel = this.setupSecureChannel((byte)requiredVersion, (byte)defKeyIndex, this.getTKSConnectorID(), appletInfo);
            }
            catch (TPSException e) {
                logger.debug("TPSProcessor.checkAndUpgradeSymKeys: failed to create secure channel with required version, we need to upgrade the keys.");
                failed = true;
            }
            if (failed) {
                this.selectCardManager();
                channel = this.setupSecureChannel(appletInfo);
                this.auditKeyChangeoverRequired(appletInfo, channel.getKeyInfoData().toHexStringPlain(), this.getSymmetricKeysRequiredVersionHexString(), null);
                String connId = this.getTKSConnectorID();
                TPSBuffer curKeyInfo = channel.getKeyInfoData();
                TPSEngine engine = TPSEngine.getInstance();
                int protocol = 1;
                if (channel.isSCP02()) {
                    protocol = 2;
                }
                if (channel.isSCP03()) {
                    protocol = 3;
                }
                byte[] nv = null;
                nv = protocol == 3 ? new byte[]{(byte)requiredVersion, curKeyInfo.at(1), curKeyInfo.at(2)} : new byte[]{(byte)requiredVersion, 1};
                TPSBuffer newVersion = new TPSBuffer(nv);
                boolean cuidOK = this.checkCUIDMatchesKDD(appletInfo.getCUIDhexStringPlain(), appletInfo.getKDDhexStringPlain());
                boolean isVersionInRange = this.checkCardGPKeyVersionIsInRange(appletInfo.getCUIDhexStringPlain(), appletInfo.getKDDhexStringPlain(), curKeyInfo.toHexStringPlain());
                boolean doesVersionMatchTokenDB = this.checkCardGPKeyVersionMatchesTokenDB(appletInfo.getCUIDhexStringPlain(), appletInfo.getKDDhexStringPlain(), curKeyInfo.toHexStringPlain());
                if (!cuidOK) {
                    throw new TPSException("TPSProcessor.generateSecureChannel: cuid vs kdd matching policy not met!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
                }
                if (!isVersionInRange) {
                    throw new TPSException("TPSProcessor.generateSecureChannel: key version is not within acceptable range!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
                }
                if (!doesVersionMatchTokenDB) {
                    throw new TPSException("TPSProcessor.generateSecureChannel: key version from token does not match that of the token db!", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
                }
                TPSBuffer keySetData = engine.createKeySetData(newVersion, curKeyInfo, protocol, appletInfo.getCUID(), channel.getKeyDiversificationData(), channel.getDekSessionKeyWrapped(), connId, this.getSelectedKeySet());
                logger.debug("TPSProcessor.checkAndUpgradeSymKeys: received new keySetData from TKS");
                byte curVersion = curKeyInfo.at(0);
                byte curIndex = curKeyInfo.at(1);
                boolean done = false;
                if (done) {
                    throw new TPSException("TPSProcessor.checkAndUpgradeSymKeys: end of progress.");
                }
                try {
                    channel.putKeys(curVersion, curIndex, keySetData);
                    tps.tdb.tdbActivity("key_changeover", tokenRecord, this.session.getIpAddress(), "Sent new GP Key Set to token", "success");
                }
                catch (TPSException e) {
                    logger.warn("TPSProcessor.checkAndUpgradeSymKeys: failed to put key: " + e.getMessage(), (Throwable)e);
                    logger.warn("TPSProcessor.checkAndUpgradeSymKeys: checking to see if this a SCP02 with 0xFF default key set.");
                    if (protocol == 2 && curVersion == -1) {
                        logger.debug("TPSProcessor.checkAndUpgradeSymKeys: failed to put key, but we have SCP02 and the 0xFF dev key, try again.");
                        byte[] nv_dev = new byte[]{1, 1};
                        TPSBuffer devKeySetData = engine.createKeySetData(new TPSBuffer(nv_dev), curKeyInfo, protocol, appletInfo.getCUID(), channel.getKeyDiversificationData(), channel.getDekSessionKeyWrapped(), connId, this.getSelectedKeySet());
                        logger.debug("TPSProcessor.checkAndUpgradeSymKeys: about to get rid of keyset 0xFF and replace it with keyset 0x1 with developer key set");
                        channel.putKeys((byte)0, (byte)1, devKeySetData);
                        logger.debug("TPSProcessor.checkAndUpgradeSymKeys: We've only upgraded to the dev key set on key set #01, will have to try again to upgrade to #02");
                    }
                    tps.tdb.tdbActivity("key_changeover", tokenRecord, this.session.getIpAddress(), "Failed to send new GP Key Set to token", "failure");
                    throw e;
                }
                String curVersionStr = curKeyInfo.toHexString();
                String newVersionStr = newVersion.toHexString();
                logger.debug("TPSProcessor.checkAndUpgradeSymKeys: changing token db keyInfo to: " + newVersion.toHexStringPlain());
                tokenRecord.setKeyInfo(newVersion.toHexStringPlain());
                logger.debug("TPSProcessor.checkAndUpgradeSymKeys: curVersionStr: " + curVersionStr + " newVersionStr: " + newVersionStr);
                this.selectCoolKeyApplet();
                channel = this.setupSecureChannel((byte)requiredVersion, (byte)defKeyIndex, this.getTKSConnectorID(), appletInfo);
                this.auditKeyChangeover(appletInfo, "success", curVersionStr, newVersionStr, null);
            } else {
                logger.debug("TPSProcessor.checkAndUpgradeSymeKeys: We are already at the desired key set, returning secure channel.");
            }
        } else {
            logger.debug("TPSProcessor.checkAndUpgradeSymKeys: Key changeover disabled in the configuration.");
            defKeyVersion = this.getChannelDefKeyVersion();
            channel = this.setupSecureChannel((byte)defKeyVersion, (byte)defKeyIndex, this.getTKSConnectorID(), appletInfo);
        }
        logger.debug("TPSProcessor.checkAndUpdradeSymKeys: Leaving successfully....");
        return channel;
    }

    protected TPSBuffer listObjects(byte seq) throws TPSException, IOException {
        TPSBuffer objects = null;
        ListObjectsAPDU listObjects = new ListObjectsAPDU(seq);
        APDUResponse respApdu = this.handleAPDURequest((APDU)listObjects);
        if (!respApdu.checkResult()) {
            logger.warn("TPSProcessor.listObjects: Bad response from ListObjects! Token possibly has no objects");
            return null;
        }
        objects = respApdu.getData();
        return objects;
    }

    protected String requestNewPin(int minLen, int maxLen) throws IOException, TPSException {
        logger.debug("TPSProcessor.requestNewPin: entering...");
        String newPin = null;
        NewPinRequestMsg new_pin_req = new NewPinRequestMsg(minLen, maxLen);
        this.session.write((TPSMessage)new_pin_req);
        NewPinResponseMsg new_pin_resp = (NewPinResponseMsg)this.session.read();
        newPin = new_pin_resp.get("new_pin");
        if (newPin.length() < minLen || newPin.length() > maxLen) {
            throw new TPSException("TPSProcessor.requestNewPin: new pin length outside of length contraints: min: " + minLen + " max: " + maxLen);
        }
        return newPin;
    }

    protected String mapPattern(LinkedHashMap<String, String> map, String inPattern) throws TPSException {
        Object result = "";
        if (inPattern == null || map == null) {
            throw new TPSException("TPSProcessor.mapPattern: Illegal input paramters!");
        }
        int delim = 36;
        Object pattern = inPattern;
        while (true) {
            String patternToMap = null;
            int firstPos = 0;
            int nextPos = 0;
            logger.debug("TPSProcessor.mapPattern: pattern =" + (String)pattern);
            String patternMapped = "";
            firstPos = ((String)pattern).indexOf(36);
            if (firstPos == -1 || (nextPos = ((String)pattern).indexOf(36, firstPos + 1)) - firstPos <= 1) break;
            patternToMap = ((String)pattern).substring(firstPos + 1, nextPos);
            String piece1 = "";
            if (firstPos >= 1) {
                piece1 = ((String)pattern).substring(0, firstPos);
            }
            String piece2 = "";
            if (nextPos < ((String)pattern).length() - 1) {
                piece2 = ((String)pattern).substring(nextPos + 1);
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!key.equalsIgnoreCase(patternToMap)) continue;
                logger.debug("TPSProcessor.mapPattern: found match: key: " + key + " mapped to: " + value);
                patternMapped = value;
                break;
            }
            pattern = result = piece1 + patternMapped + piece2;
        }
        String returnVal = ((String)result).isEmpty() ? inPattern : result;
        logger.debug("TPSProcessor.mapPattern: returning: {}", (Object)returnVal);
        return returnVal;
    }

    protected String formatCurrentAppletVersion(AppletInfo aInfo) throws TPSException, IOException {
        String method = "TPSProcessor.formatCurrentAppletVersion: ";
        logger.debug(method + " begins");
        if (aInfo == null) {
            throw new TPSException("TPSProcessor.formatCurrentAppletVersion: ");
        }
        if (aInfo.getFinalAppletVersion() != null) {
            return aInfo.getFinalAppletVersion();
        }
        TPSBuffer build_id = this.getAppletVersion();
        if (build_id == null) {
            logger.warn(method + " getAppletVersion returning null");
            return null;
        }
        String build_idStr = build_id.toHexStringPlain();
        Object finalVersion = aInfo.getAppMajorVersion() + "." + aInfo.getAppMinorVersion() + "." + build_idStr;
        finalVersion = ((String)finalVersion).toLowerCase();
        aInfo.setFinalAppletVersion((String)finalVersion);
        logger.debug(method + " returing: " + (String)finalVersion);
        return finalVersion;
    }

    protected void checkAndHandlePinReset(SecureChannel channel) throws TPSException, IOException {
        String stringName;
        int maxRetries;
        int maxLen;
        int minLen;
        logger.debug("TPSProcessor.checkAndHandlePinReset entering...");
        if (channel == null) {
            throw new TPSException("TPSProcessor.checkAndHandlePinReset: invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MAC_RESET_PIN_PDU);
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSEngineConfig configStore = engine.getConfig();
        String pinResetEnableConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".pinReset.enable";
        logger.debug("TPSProcessor.checkAndHandlePinReset config to check: " + pinResetEnableConfig);
        String minLenConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".pinReset.pin.minLen";
        logger.debug("TPSProcessor.checkAndHandlePinReset config to check: " + minLenConfig);
        String maxLenConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".pinReset.pin.maxLen";
        logger.debug("TPSProcessor.checkAndHandlePinReset config to check: " + maxLenConfig);
        String maxRetriesConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".pinReset.pin.maxRetries";
        logger.debug("TPSProcessor.checkAndHandlePinReset config to check: " + maxRetriesConfig);
        String pinStringConfig = "create_pin.string";
        logger.debug("TPSProcessor.checkAndHandlePinReset config to check: " + pinStringConfig);
        boolean enabled = false;
        try {
            enabled = configStore.getBoolean(pinResetEnableConfig, true);
            if (!enabled) {
                logger.debug("TPSProcessor.checkAndHandlePinReset:  Pin Reset not allowed by configuration, exiting...");
                return;
            }
            minLen = configStore.getInteger(minLenConfig, 4);
            maxLen = configStore.getInteger(maxLenConfig, 10);
            maxRetries = configStore.getInteger(maxRetriesConfig, 127);
            stringName = configStore.getString(pinStringConfig, "password");
            logger.debug("TPSProcessor.checkAndHandlePinReset: config vals: enabled: " + enabled + " minLen: " + minLen + " maxLen: " + maxLen);
        }
        catch (EBaseException e) {
            throw new TPSException("TPSProcessor.checkAndHandlePinReset: internal error in getting value from config.");
        }
        String new_pin = this.requestNewPin(minLen, maxLen);
        channel.createPin(0, maxRetries, stringName);
        channel.resetPin(0, new_pin);
    }

    protected void checkAndAuthenticateUser(AppletInfo appletInfo, String tokenType) throws TPSException {
        TokenRecord tokenRecord = this.getTokenRecord();
        String method = "checkAndAuthenticateUser";
        String opPrefix = null;
        opPrefix = "enroll".equals(this.currentTokenOperation) ? "op.enroll" : ("format".equals(this.currentTokenOperation) ? "op.format" : "op.pinReset");
        TPSEngine engine = TPSEngine.getInstance();
        if (!this.isExternalReg) {
            boolean isAuthRequired;
            String configName = opPrefix + "." + tokenType + ".auth.enable";
            TPSEngineConfig configStore = engine.getConfig();
            TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
            try {
                logger.debug("TPSProcessor.checkAndAuthenticateUser: getting config: " + configName);
                isAuthRequired = configStore.getBoolean(configName, true);
            }
            catch (EBaseException e) {
                logger.error("TPSProcessor.checkAndAuthenticateUser: Internal Error obtaining mandatory config values: " + e.getMessage(), (Throwable)e);
                throw new TPSException("TPS error getting config values from config store.", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
            }
            logger.debug(method + ": opPrefox: " + opPrefix);
            if (isAuthRequired) {
                TPSAuthenticator userAuth = null;
                try {
                    userAuth = this.getAuthentication(opPrefix, tokenType);
                    this.processAuthentication("enroll", userAuth, appletInfo.getCUIDhexString(), tokenRecord);
                    this.auditAuthSuccess(this.userid, this.currentTokenOperation, appletInfo, userAuth != null ? userAuth.getID() : null);
                }
                catch (Exception e) {
                    this.auditAuthFailure(this.userid, this.currentTokenOperation, appletInfo, userAuth != null ? userAuth.getID() : null);
                    logger.debug("TPSProcessor.checkAndAuthenticateUser:: authentication exception thrown: " + e);
                    String msg = "TPS error user authentication failed:" + e;
                    tps.tdb.tdbActivity("enrollment", tokenRecord, this.session.getIpAddress(), msg, "failure");
                    throw new TPSException(msg, EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN, (Throwable)e);
                }
            } else {
                throw new TPSException("TPSProcessor.checkAndAuthenticateUser: TPS enrollment must have authentication enabled.", EndOpMsg.TPSStatus.STATUS_ERROR_LOGIN);
            }
        }
    }

    public void acquireChannelPlatformAndProtocolInfo() throws TPSException, IOException {
        if (this.platProtInfo != null) {
            return;
        }
        this.platProtInfo = new PlatformAndSecChannelProtoInfo();
        try {
            this.gp211GetSecureChannelProtocolDetails();
        }
        catch (TPSException e) {
            logger.warn("TPSProcessor.acquireChannelPlatformProtocolInfo: Error getting gp211 protocol data, assume scp01: " + e.getMessage());
            this.platProtInfo.setPlatform("2.0.1");
            this.platProtInfo.setProtocol((byte)1);
        }
        if (this.platProtInfo.isSCP02() && this.platProtInfo.getImplementation() != 21) {
            throw new TPSException("SecureChannel.acquireChannelPlatformAndProtocolInfo card returning a non supported implementation for SCP02 " + this.platProtInfo.getImplementation());
        }
    }

    public void gp211GetSecureChannelProtocolDetails() throws TPSException, IOException {
        logger.debug("TPSProcessor.gp211GetSecureChannelProtocolDetails: Query card for secure channel protocol details for gp211.");
        TPSBuffer data = null;
        TPSBuffer keyData = null;
        this.selectCardManager();
        try {
            data = this.getData(SecureChannel.GP211_GET_DATA_CARD_DATA);
            keyData = this.getData(SecureChannel.GP211_GET_DATA_KEY_INFO);
        }
        catch (TPSException e) {
            logger.error("TPSProcessor.gp211GetSecureChannelProtocolDetails: Card can't understand GP211: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        if (data.size() < 5) {
            throw new TPSException("TPSProcessor.gp211GetSecureChannelProtocolDetails: invalide return data.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        logger.debug("TPSProcessor.gp211GetSecureChannelProtocolDetails: card data returned");
        int offset = 0;
        int totalLength = 0;
        int length = 0;
        if (data.at(offset) == 102) {
            int n = ++offset;
            ++offset;
            totalLength = data.getIntFrom1Byte(n);
            ++offset;
        } else {
            int n = ++offset;
            ++offset;
            totalLength = data.getIntFrom1Byte(n);
        }
        logger.debug("TPSProcessor.gp211GetSecureChannelProtocolDetails: totalLength: " + totalLength);
        if (totalLength == 0 || totalLength >= data.size()) {
            throw new TPSException("TPSProcessor.gp211GetSecureChannelProtocolDetails: Invalid return data.", EndOpMsg.TPSStatus.STATUS_ERROR_SECURE_CHANNEL);
        }
        int n = ++offset;
        length = data.getIntFrom1Byte(n);
        TPSBuffer oidCardRecognitionData = data.substr(++offset, length);
        logger.debug("TPSProcessor.gp211GetSecureChannelProtocolDetails: oidCardRecognitionData: " + oidCardRecognitionData.toHexString());
        this.platProtInfo.setOidCardRecognitionData(oidCardRecognitionData);
        offset += length + 2 + 1;
        length = data.getIntFrom1Byte(offset++);
        TPSBuffer oidCardManagementTypeAndVer = data.substr(offset, length);
        logger.debug("TPSProcessor.gp211GetSecureChannelProtocolDetails: oidCardManagementTypeAndVer: " + oidCardManagementTypeAndVer.toHexString());
        this.platProtInfo.setOidCardManagementTypeAndVer(oidCardManagementTypeAndVer);
        offset += length + 2 + 1;
        length = data.getIntFrom1Byte(offset++);
        TPSBuffer oidCardIdentificationScheme = data.substr(offset, length);
        logger.debug("TPSProcessor.gp211GetSecureChannelProtocolDetails: oidCardIdentificationScheme: " + oidCardIdentificationScheme.toHexString());
        this.platProtInfo.setOidCardIdentificationScheme(oidCardIdentificationScheme);
        offset += length + 2 + 1;
        length = data.getIntFrom1Byte(offset++);
        TPSBuffer oidSecureChannelProtocol = data.substr(offset, length);
        logger.debug("TPSProcessor.gp211GetSecureChannelProtocolDetails: oidSecureChannelProtocol: " + oidSecureChannelProtocol.toHexString());
        byte protocol = oidSecureChannelProtocol.at(length - 2);
        byte implementation = oidSecureChannelProtocol.at(length - 1);
        this.platProtInfo.setProtocol(protocol);
        this.platProtInfo.setImplementation(implementation);
        this.platProtInfo.setKeysetInfoData(keyData);
        if (protocol == 3) {
            logger.debug("TPSProcessor.gp211GetSecureChannelProtocolDetails: Found protocol 03!");
        }
        if (protocol == 2 || protocol == 3) {
            this.platProtInfo.setPlatform("2.1.1");
        } else {
            this.platProtInfo.setPlatform("2.0.1");
        }
        logger.debug("TPSProcessor.gp211GetSecureChannelProtocolDetails: protocol: " + protocol + " implementation: " + implementation + " keyInfoData: " + keyData.toHexString());
    }

    public PlatformAndSecChannelProtoInfo getChannelPlatformAndProtocolInfo() {
        return this.platProtInfo;
    }

    public int getProtocol() {
        if (this.platProtInfo == null) {
            return 1;
        }
        return this.platProtInfo.getProtocol();
    }

    boolean checkCardGPKeyVersionIsInRange(String CUID, String KDD, String keyInfoData) throws TPSException {
        boolean result = true;
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        String method = "checkCardGPKeyVersionIsInRange: ";
        logger.debug(method + " entering: keyInfoData: " + keyInfoData);
        if (CUID == null || KDD == null || keyInfoData == null) {
            throw new TPSException(method + " Invalid input data!");
        }
        TPSEngineConfig configStore = engine.getConfig();
        String checkBoundedGPKeyVersionConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".enableBoundedGPKeyVersion";
        logger.debug(method + " config to check: " + checkBoundedGPKeyVersionConfig);
        try {
            result = configStore.getBoolean(checkBoundedGPKeyVersionConfig, true);
        }
        catch (EBaseException e) {
            throw new TPSException(method + " error getting config value.");
        }
        logger.debug(method + " returning: " + result);
        if (result) {
            String minConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".minimumGPKeyVersion";
            String maxConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".maximumGPKeyVersion";
            logger.debug(method + " config to check: minConfig: " + minConfig + " maxConfig: " + maxConfig);
            String maxVersion = null;
            String minVersion = null;
            try {
                minVersion = configStore.getString(minConfig, "01");
                maxVersion = configStore.getString(maxConfig, "FF");
            }
            catch (EBaseException e) {
                throw new TPSException(method + " error getting config value.");
            }
            if (minVersion.length() != 2 || maxVersion.length() != 2) {
                result = false;
            }
            logger.debug(method + " minVersion: " + minVersion + " maxVersion: " + maxVersion);
            if (keyInfoData.length() != 4 && keyInfoData.length() != 6) {
                result = false;
            } else {
                String keyInfoVer = keyInfoData.substring(0, 2);
                logger.debug(method + " Version reported from key Info Data: " + keyInfoVer);
                int versionMinCompare = keyInfoVer.compareToIgnoreCase(minVersion);
                int versionMaxCompare = keyInfoVer.compareToIgnoreCase(maxVersion);
                logger.debug(method + " versionMinCompare: " + versionMinCompare + " versionMaxCompare: " + versionMaxCompare);
                if (versionMinCompare >= 0 && versionMaxCompare <= 0) {
                    logger.debug(method + " Version : " + keyInfoVer + " is in range of: " + minVersion + " and: " + maxVersion);
                    result = true;
                    String logMsg = "Token GP key version is within GP key version range.";
                    this.auditKeySanityCheck(this.userid, CUID, KDD, "success", keyInfoVer, null, null, logMsg);
                } else {
                    String logMsg;
                    result = false;
                    logger.debug(method + " Version : " + keyInfoVer + " is NOT in range of: " + minVersion + " and: " + maxVersion);
                    if (versionMinCompare < 0) {
                        logMsg = "Token key version " + keyInfoVer + " is less than minimum GP key version " + minVersion;
                        this.auditKeySanityCheck(this.userid, CUID, KDD, "failure", keyInfoVer, null, null, logMsg);
                        tps.tdb.tdbActivity(this.currentTokenOperation, this.session.getTokenRecord(), this.session.getIpAddress(), logMsg, "failure");
                    }
                    if (versionMaxCompare > 0) {
                        logMsg = "Token key version " + keyInfoVer + " is greater than maximum GP key version " + maxVersion;
                        this.auditKeySanityCheck(this.userid, CUID, KDD, "failure", keyInfoVer, null, null, logMsg);
                        tps.tdb.tdbActivity(this.currentTokenOperation, this.session.getTokenRecord(), this.session.getIpAddress(), logMsg, "failure");
                    }
                }
            }
        } else {
            result = true;
        }
        logger.debug(method + " Returning result of: " + result);
        return result;
    }

    boolean checkCUIDMatchesKDD(String CUID, String KDD) throws TPSException {
        boolean result = true;
        String method = "TPsProcessor.checkCUIDMatchesKDD: ";
        logger.debug(method + " CUID " + CUID + " KDD: " + KDD);
        if (CUID == null || KDD == null) {
            throw new TPSException(method + " invalid input data!");
        }
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        TPSEngineConfig configStore = engine.getConfig();
        String checkCUIDMatchesKDDConfig = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".cuidMustMatchKDD";
        logger.debug(method + " config to check: " + checkCUIDMatchesKDDConfig);
        try {
            result = configStore.getBoolean(checkCUIDMatchesKDDConfig, false);
        }
        catch (EBaseException e) {
            throw new TPSException(method + " error getting config value.");
        }
        logger.debug(method + " config result: " + result);
        if (result) {
            if (CUID.compareToIgnoreCase(KDD) == 0) {
                logger.debug(method + " CUID and KDD values match!");
                result = true;
            } else {
                logger.debug(method + " CUID and KDD values differ!");
                result = false;
                this.auditKeySanityCheck(this.userid, CUID, KDD, "failure", null, null, null, "CUID does not equal KDD");
                tps.tdb.tdbActivity(this.currentTokenOperation, this.session.getTokenRecord(), this.session.getIpAddress(), "CUID: " + CUID + " does not equal KDD: " + KDD, "failure");
            }
        } else {
            result = true;
        }
        logger.debug(method + " returning result: " + result);
        return result;
    }

    protected String getKeyInfoFromTokenDB(String cuid) throws TPSException {
        String keyInfo = null;
        if (cuid == null) {
            throw new TPSException("TPSProcessor.getKeyInfoFromTokenDB: invalid input data!", EndOpMsg.TPSStatus.STATUS_ERROR_MISCONFIGURATION);
        }
        TokenRecord tokenRecord = this.getTokenRecord();
        keyInfo = tokenRecord.getKeyInfo();
        logger.debug("TPProcessor.getKeyInfioFromTokenDB: returning: " + keyInfo);
        return keyInfo;
    }

    boolean checkCardGPKeyVersionMatchesTokenDB(String CUID, String KDD, String keyInfoData) throws TPSException {
        String method = "checkCardGPKeyVersionMatchesTokenDB: ";
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        if (CUID == null || KDD == null || keyInfoData == null) {
            throw new TPSException(method + " Invalid input data!");
        }
        boolean result = true;
        TPSEngineConfig configStore = engine.getConfig();
        String checkValidateVersion = "op." + this.currentTokenOperation + "." + this.selectedTokenType + ".validateCardKeyInfoAgainstTokenDB";
        logger.debug(method + " config to check: " + checkValidateVersion);
        try {
            result = configStore.getBoolean(checkValidateVersion, true);
        }
        catch (EBaseException e) {
            throw new TPSException(method + " error getting config value.");
        }
        logger.debug(method + " config result: " + result);
        if (result) {
            String keyInfoInDB = this.getKeyInfoFromTokenDB(CUID);
            logger.debug(method + " keyInfoFromTokenDB: " + keyInfoInDB);
            logger.debug(method + " keyInfoFromToken: " + keyInfoData);
            if (keyInfoInDB == null) {
                try {
                    this.checkAllowUnknownToken(this.currentTokenOperation);
                    result = true;
                }
                catch (TPSException e) {
                    result = false;
                    String logMsg = "getKeyInfoFromTokenDB returned null but token CUID is present in database";
                    this.auditKeySanityCheck(this.userid, CUID, KDD, "failure", keyInfoData, null, null, logMsg);
                }
            } else if (keyInfoData.compareToIgnoreCase(keyInfoInDB) != 0) {
                logger.debug(method + " Key Info in the DB is NOT the same as the one from the token!");
                result = false;
                String logMsg = "Card claimed key info: " + keyInfoData + " does not match Card DB key info: " + keyInfoInDB;
                this.auditKeySanityCheck(this.userid, CUID, KDD, "failure", keyInfoData, null, keyInfoInDB, logMsg);
                tps.tdb.tdbActivity(this.currentTokenOperation, this.session.getTokenRecord(), this.session.getIpAddress(), logMsg, "failure");
            } else {
                logger.debug(method + " Key Info in the DB IS the same as the one from the token!");
                result = true;
                String logMsg = "Card GP key info matches TokenDB GP key info.";
                this.auditKeySanityCheck(this.userid, CUID, KDD, "success", keyInfoData, null, keyInfoInDB, logMsg);
            }
        } else {
            result = true;
        }
        logger.debug(method + " returning result: " + result);
        return result;
    }

    protected void checkInvalidTokenStatus(TokenRecord tokenRecord, String activityDBOperation) throws TPSException {
        TPSEngine engine = TPSEngine.getInstance();
        TPSSubsystem tps = (TPSSubsystem)engine.getSubsystem("tps");
        TokenStatus status = tokenRecord.getTokenStatus();
        if (!status.isValid()) {
            String logMsg = "Illegal transition attempted for token with status: " + status;
            tps.tdb.tdbActivity(activityDBOperation, tokenRecord, this.session.getIpAddress(), logMsg, "failure");
            throw new TPSException(activityDBOperation + ": " + logMsg, EndOpMsg.TPSStatus.STATUS_ERROR_DISABLED_TOKEN);
        }
    }

    protected void auditAuthSuccess(String subjectID, String op, AppletInfo aInfo, String authMgrId) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        TokenAuthEvent event = TokenAuthEvent.success((String)this.session.getIpAddress(), (String)subjectID, (String)(aInfo != null ? aInfo.getCUIDhexStringPlain() : null), (String)(aInfo != null ? aInfo.getMSNString() : null), (String)op, (String)this.getSelectedTokenType(), (String)(aInfo != null ? aInfo.getFinalAppletVersion() : null), (String)authMgrId);
        auditor.log((LogEvent)event);
    }

    protected void auditAuthFailure(String subjectID, String op, AppletInfo aInfo, String authMgrId) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        TokenAuthEvent event = TokenAuthEvent.failure((String)this.session.getIpAddress(), (String)subjectID, (String)(aInfo != null ? aInfo.getCUIDhexStringPlain() : null), (String)(aInfo != null ? aInfo.getMSNString() : null), (String)op, (String)this.getSelectedTokenType(), (String)(aInfo != null ? aInfo.getFinalAppletVersion() : null), (String)authMgrId);
        auditor.log((LogEvent)event);
    }

    protected void auditOpRequest(String op, AppletInfo aInfo, String status, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditType = "LOGGING_SIGNED_AUDIT_TOKEN_OP_REQUEST_6";
        String auditMessage = CMS.getLogMessage((String)auditType, (Object[])new Object[]{this.session.getIpAddress(), aInfo != null ? aInfo.getCUIDhexStringPlain() : null, aInfo != null ? aInfo.getMSNString() : null, status, op, aInfo != null ? aInfo.getFinalAppletVersion() : null, info});
        auditor.log(auditMessage);
    }

    protected void auditFormatSuccess(String subjectID, AppletInfo aInfo, String keyVersion) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        TokenFormatEvent event = TokenFormatEvent.success((String)this.session.getIpAddress(), (String)subjectID, (String)(aInfo != null ? aInfo.getCUIDhexStringPlain() : null), (String)(aInfo != null ? aInfo.getMSNString() : null), (String)this.getSelectedTokenType(), (String)(aInfo != null ? aInfo.getFinalAppletVersion() : null), (String)keyVersion);
        auditor.log((LogEvent)event);
    }

    protected void auditFormatFailure(String subjectID, AppletInfo aInfo, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        TokenFormatEvent event = TokenFormatEvent.failure((String)this.session.getIpAddress(), (String)subjectID, (String)(aInfo != null ? aInfo.getCUIDhexStringPlain() : null), (String)(aInfo != null ? aInfo.getMSNString() : null), (String)this.getSelectedTokenType(), (String)(aInfo != null ? aInfo.getFinalAppletVersion() : null), (String)info);
        auditor.log((LogEvent)event);
    }

    protected void auditAppletUpgrade(AppletInfo aInfo, String status, String keyVersion, String newVersion, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        TokenAppletUpgradeEvent event = new TokenAppletUpgradeEvent(switch (status) {
            case "success" -> "LOGGING_SIGNED_AUDIT_TOKEN_APPLET_UPGRADE_SUCCESS";
            default -> "LOGGING_SIGNED_AUDIT_TOKEN_APPLET_UPGRADE_FAILURE";
        }, this.session != null ? this.session.getIpAddress() : null, this.userid, aInfo != null ? aInfo.getCUIDhexStringPlain() : null, aInfo != null ? aInfo.getMSNString() : null, status, keyVersion, aInfo != null ? aInfo.getFinalAppletVersion() : null, newVersion, info);
        auditor.log((LogEvent)event);
    }

    protected void auditKeyChangeoverRequired(AppletInfo aInfo, String oldKeyVersion, String newKeyVersion, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditType = "LOGGING_SIGNED_AUDIT_TOKEN_KEY_CHANGEOVER_REQUIRED_10";
        String auditMessage = CMS.getLogMessage((String)auditType, (Object[])new Object[]{this.session != null ? this.session.getIpAddress() : null, this.userid, aInfo != null ? aInfo.getCUIDhexStringPlain() : null, aInfo != null ? aInfo.getMSNString() : null, "na", this.getSelectedTokenType(), aInfo != null ? aInfo.getFinalAppletVersion() : null, oldKeyVersion, newKeyVersion, info});
        auditor.log(auditMessage);
    }

    protected void auditKeyChangeover(AppletInfo aInfo, String status, String oldKeyVersion, String newKeyVersion, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        TokenKeyChangeoverEvent event = new TokenKeyChangeoverEvent(switch (status) {
            case "success" -> "LOGGING_SIGNED_AUDIT_TOKEN_KEY_CHANGEOVER_SUCCESS";
            default -> "LOGGING_SIGNED_AUDIT_TOKEN_KEY_CHANGEOVER_FAILURE";
        }, this.session != null ? this.session.getIpAddress() : null, this.userid, aInfo != null ? aInfo.getCUIDhexStringPlain() : null, aInfo != null ? aInfo.getMSNString() : null, status, this.getSelectedTokenType(), aInfo != null ? aInfo.getFinalAppletVersion() : null, oldKeyVersion, newKeyVersion, info);
        auditor.log((LogEvent)event);
    }

    protected void auditKeySanityCheck(String subjectID, String cuid, String kdd, String status, String tokenKeyVersion, String newKeyVersion, String tokenDBKeyVersion, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditMessage = CMS.getLogMessage((String)(switch (status) {
            case "success" -> "LOGGING_SIGNED_AUDIT_TOKEN_KEY_SANITY_CHECK_SUCCESS_9";
            default -> "LOGGING_SIGNED_AUDIT_TOKEN_KEY_SANITY_CHECK_FAILURE_9";
        }), (Object[])new Object[]{this.session.getIpAddress(), subjectID, cuid, kdd, status, tokenKeyVersion, newKeyVersion, tokenDBKeyVersion, info});
        auditor.log(auditMessage);
    }

    protected void auditRevoke(String cuid, boolean isRevoke, int revokeReason, String status, String serial, String caConnId, String info) {
        TPSEngine engine = TPSEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditType = "LOGGING_SIGNED_AUDIT_TOKEN_CERT_STATUS_CHANGE_REQUEST_10";
        String requestType = "revoke";
        if (!isRevoke) {
            requestType = "off-hold";
        } else if (revokeReason == RevocationReason.CERTIFICATE_HOLD.getCode()) {
            requestType = "on-hold";
        }
        String auditMessage = CMS.getLogMessage((String)auditType, (Object[])new Object[]{this.session != null ? this.session.getIpAddress() : null, this.userid, cuid, status, this.getSelectedTokenType(), serial, requestType, String.valueOf(revokeReason), caConnId, info});
        auditor.log(auditMessage);
    }

    public static void main(String[] args) {
    }
}

