/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.base.ConflictingOperationException;
import com.netscape.certsrv.base.PKIException;
import com.netscape.certsrv.base.ResourceNotFoundException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.group.GroupMemberCollection;
import com.netscape.certsrv.group.GroupMemberData;
import com.netscape.certsrv.group.GroupNotFoundException;
import com.netscape.certsrv.logging.event.ConfigRoleEvent;
import com.netscape.cms.servlet.processors.Processor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMemberProcessor
extends Processor {
    public static Logger logger = LoggerFactory.getLogger(GroupMemberProcessor.class);
    public static final int DEFAULT_SIZE = 20;
    public static final String MULTI_ROLE_ENABLE = "multiroles.enable";
    public static final String MULTI_ROLE_ENFORCE_GROUP_LIST = "multiroles.false.groupEnforceList";
    public static String[] multiRoleGroupEnforceList;
    protected UriInfo uriInfo;

    public GroupMemberProcessor(Locale locale) {
        super("group", locale);
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public GroupMemberData createGroupMemberData(String groupID, String memberID) throws Exception {
        GroupMemberData groupMemberData = new GroupMemberData();
        groupMemberData.setID(memberID);
        groupMemberData.setGroupID(groupID);
        return groupMemberData;
    }

    public GroupMemberCollection findGroupMembers(String groupID, String filter, Integer start, Integer size) {
        try {
            start = start == null ? 0 : start;
            size = size == null ? 20 : size;
            if (groupID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]));
            }
            UGSubsystem userGroupManager = this.engine.getUGSubsystem();
            Group group = userGroupManager.getGroupFromName(groupID);
            if (group == null) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_GROUP_NOT_EXIST", new Object[0]));
                throw new GroupNotFoundException(groupID);
            }
            GroupMemberCollection response = new GroupMemberCollection();
            Enumeration<String> members = group.getMemberNames();
            ArrayList<String> results = new ArrayList<String>();
            while (members.hasMoreElements()) {
                String memberID = members.nextElement();
                if (filter != null && !memberID.contains(filter)) continue;
                results.add(memberID);
            }
            for (int i = start.intValue(); i < start + size && i < results.size(); ++i) {
                String memberID = (String)results.get(i);
                response.addEntry((Object)this.createGroupMemberData(groupID, memberID));
            }
            response.setTotal(results.size());
            return response;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("GroupMemberProcessor: " + e.getMessage(), (Throwable)e);
            throw new PKIException(this.getUserMessage("CMS_INTERNAL_ERROR", new String[0]));
        }
    }

    public GroupMemberData getGroupMember(String groupID, String memberID) {
        try {
            if (groupID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]));
            }
            UGSubsystem userGroupManager = this.engine.getUGSubsystem();
            Group group = userGroupManager.getGroupFromName(groupID);
            if (group == null) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_GROUP_NOT_EXIST", new Object[0]));
                throw new GroupNotFoundException(groupID);
            }
            Enumeration<String> e = group.getMemberNames();
            while (e.hasMoreElements()) {
                String memberName = e.nextElement();
                if (!memberName.equalsIgnoreCase(memberID)) continue;
                GroupMemberData groupMemberData = this.createGroupMemberData(groupID, memberName);
                return groupMemberData;
            }
            throw new ResourceNotFoundException("Group member " + memberID + " not found");
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("GroupMemberProcessor: " + e.getMessage(), (Throwable)e);
            throw new PKIException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GroupMemberData addGroupMember(GroupMemberData groupMemberData) {
        String groupID = groupMemberData.getGroupID();
        EngineConfig config = this.engine.getConfig();
        try {
            if (groupID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]));
            }
            UGSubsystem userGroupManager = this.engine.getUGSubsystem();
            Group group = userGroupManager.getGroupFromName(groupID);
            if (group == null) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_GROUP_NOT_EXIST", new Object[0]));
                throw new GroupNotFoundException(groupID);
            }
            String memberID = groupMemberData.getID();
            boolean multiRole = true;
            try {
                multiRole = config.getBoolean(MULTI_ROLE_ENABLE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (multiRole) {
                userGroupManager.addUserToGroup(group, memberID);
            } else if (this.isGroupInMultiRoleEnforceList(groupID)) {
                if (this.isDuplicate(groupID, memberID)) throw new ConflictingOperationException(CMS.getUserMessage("CMS_BASE_DUPLICATE_ROLES", memberID));
                userGroupManager.addUserToGroup(group, memberID);
            } else {
                userGroupManager.addUserToGroup(group, memberID);
            }
            SessionContext sContext = SessionContext.getContext();
            String adminId = (String)sContext.get((Object)"userid");
            logger.info("Admin UID: {} added User UID: {} to group: {}", new Object[]{adminId, memberID, groupID});
            this.auditAddGroupMember(groupID, groupMemberData, "Success");
            return this.getGroupMember(groupID, memberID);
        }
        catch (PKIException e) {
            this.auditAddGroupMember(groupID, groupMemberData, "Failure");
            throw e;
        }
        catch (Exception e) {
            logger.error("GroupMemberProcessor: " + e.getMessage(), (Throwable)e);
            this.auditAddGroupMember(groupID, groupMemberData, "Failure");
            throw new PKIException(this.getUserMessage("CMS_USRGRP_GROUP_MODIFY_FAILED", new String[0]), (Throwable)e);
        }
    }

    public boolean isGroupInMultiRoleEnforceList(String groupID) {
        if (groupID == null || groupID.equals("")) {
            return true;
        }
        EngineConfig config = this.engine.getConfig();
        String groupList = null;
        if (multiRoleGroupEnforceList == null) {
            try {
                groupList = config.getString(MULTI_ROLE_ENFORCE_GROUP_LIST);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (groupList != null && !groupList.equals("")) {
                multiRoleGroupEnforceList = groupList.split(",");
                for (int j = 0; j < multiRoleGroupEnforceList.length; ++j) {
                    GroupMemberProcessor.multiRoleGroupEnforceList[j] = multiRoleGroupEnforceList[j].trim();
                }
            }
        }
        if (multiRoleGroupEnforceList == null) {
            return true;
        }
        for (int i = 0; i < multiRoleGroupEnforceList.length; ++i) {
            if (!groupID.equals(multiRoleGroupEnforceList[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isDuplicate(String groupID, String memberID) {
        UGSubsystem userGroupManager = this.engine.getUGSubsystem();
        try {
            boolean isMember = userGroupManager.isMemberOf(memberID, groupID);
            if (isMember) {
                return false;
            }
        }
        catch (Exception isMember) {
            // empty catch block
        }
        try {
            Enumeration<Group> groups = userGroupManager.listGroups(null);
            while (groups.hasMoreElements()) {
                Group group = groups.nextElement();
                String name = group.getName();
                Enumeration<Group> g = userGroupManager.findGroups(name);
                Group g1 = g.nextElement();
                if (name.equals(groupID) || !this.isGroupInMultiRoleEnforceList(name)) continue;
                Enumeration<String> members = g1.getMemberNames();
                while (members.hasMoreElements()) {
                    String m1 = members.nextElement();
                    if (!m1.equals(memberID)) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void removeGroupMember(String groupID, String memberID) {
        GroupMemberData groupMemberData = new GroupMemberData();
        groupMemberData.setID(memberID);
        groupMemberData.setGroupID(groupID);
        this.removeGroupMember(groupMemberData);
    }

    public void removeGroupMember(GroupMemberData groupMemberData) {
        String groupID = groupMemberData.getGroupID();
        try {
            if (groupID == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                throw new BadRequestException(this.getUserMessage("CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]));
            }
            UGSubsystem userGroupManager = this.engine.getUGSubsystem();
            Group group = userGroupManager.getGroupFromName(groupID);
            if (group == null) {
                logger.error(CMS.getLogMessage("USRGRP_SRVLT_GROUP_NOT_EXIST", new Object[0]));
                throw new GroupNotFoundException(groupID);
            }
            String memberID = groupMemberData.getID();
            userGroupManager.removeUserFromGroup(group, memberID);
            SessionContext sContext = SessionContext.getContext();
            String adminId = (String)sContext.get((Object)"userid");
            logger.info("Admin UID: {} removed User UID: {} from group: {}", new Object[]{adminId, memberID, groupID});
            this.auditDeleteGroupMember(groupID, groupMemberData, "Success");
        }
        catch (PKIException e) {
            this.auditDeleteGroupMember(groupID, groupMemberData, "Failure");
            throw e;
        }
        catch (Exception e) {
            logger.error("GroupMemberProcessor: " + e.getMessage(), (Throwable)e);
            this.auditDeleteGroupMember(groupID, groupMemberData, "Failure");
            throw new PKIException(this.getUserMessage("CMS_USRGRP_GROUP_MODIFY_FAILED", new String[0]));
        }
    }

    public void auditAddGroupMember(String groupID, GroupMemberData groupMemberData, String status) {
        this.audit("OP_ADD", groupID, this.getParams(groupMemberData), status);
    }

    public void auditDeleteGroupMember(String groupID, GroupMemberData groupMemberData, String status) {
        this.audit("OP_DELETE", groupID, this.getParams(groupMemberData), status);
    }

    public void audit(String type, String id, Map<String, String> params, String status) {
        Auditor auditor = this.engine.getAuditor();
        auditor.log(new ConfigRoleEvent(auditor.getSubjectID(), status, auditor.getParamString("members", type, id, params)));
    }
}

