/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.processors;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.processors.CRMFProcessor;
import com.netscape.cms.servlet.processors.PKCS10Processor;
import com.netscape.cms.servlet.processors.PKIProcessor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.netscape.security.extensions.CertInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs10.CertificationRequest;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cmc.PKIData;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cmc.TaggedCertificationRequest;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMCProcessor
extends PKIProcessor {
    public static Logger logger = LoggerFactory.getLogger(CMCProcessor.class);
    private boolean enforcePop = false;

    public CMCProcessor() {
    }

    public CMCProcessor(CMSRequest cmsReq, CMSServlet servlet, boolean doEnforcePop) {
        super(cmsReq, servlet);
        this.enforcePop = doEnforcePop;
    }

    @Override
    public void process(CMSRequest cmsReq) throws EBaseException {
    }

    @Override
    public void fillCertInfo(String protocolString, X509CertInfo certInfo, AuthToken authToken, ArgBlock httpParams) throws EBaseException {
    }

    @Override
    public X509CertInfo[] fillCertInfoArray(byte[] bytes, AuthToken authToken, ArgBlock httpParams, Request req) throws EBaseException {
        logger.debug("CMCProcessor: In CMCProcessor.fillCertInfoArray!");
        try {
            ByteArrayInputStream cmcBlobIn = new ByteArrayInputStream(bytes);
            ContentInfo cmcReq = (ContentInfo)ContentInfo.getTemplate().decode((InputStream)cmcBlobIn);
            if (!cmcReq.getContentType().equals((Object)ContentInfo.SIGNED_DATA) || !cmcReq.hasContent()) {
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_NO_CMC_CONTENT", new String[0]));
            }
            SignedData cmcFullReq = (SignedData)cmcReq.getInterpretedContent();
            EncapsulatedContentInfo ci = cmcFullReq.getContentInfo();
            OBJECT_IDENTIFIER id = ci.getContentType();
            if (!id.equals((Object)OBJECT_IDENTIFIER.id_cct_PKIData) || !ci.hasContent()) {
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_NO_PKIDATA", new String[0]));
            }
            OCTET_STRING content = ci.getContent();
            ByteArrayInputStream s = new ByteArrayInputStream(content.toByteArray());
            PKIData pkiData = (PKIData)new PKIData.Template().decode((InputStream)s);
            SEQUENCE reqSequence = pkiData.getReqSequence();
            int numReqs = reqSequence.size();
            X509CertInfo[] certInfoArray = new X509CertInfo[numReqs];
            String[] reqIdArray = new String[numReqs];
            for (int i = 0; i < numReqs; ++i) {
                TaggedRequest taggedRequest = (TaggedRequest)reqSequence.elementAt(i);
                TaggedRequest.Type type = taggedRequest.getType();
                if (type.equals(TaggedRequest.PKCS10)) {
                    TaggedCertificationRequest tcr = taggedRequest.getTcr();
                    int p10Id = tcr.getBodyPartID().intValue();
                    reqIdArray[i] = String.valueOf(p10Id);
                    CertificationRequest p10 = tcr.getCertificationRequest();
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    p10.encode((OutputStream)ostream);
                    PKCS10Processor pkcs10Processor = new PKCS10Processor(this.mRequest, this.mServlet);
                    pkcs10Processor.setCMSEngine(this.engine);
                    try {
                        PKCS10 pkcs10 = new PKCS10(ostream.toByteArray());
                        CertInfo certInfo = new CertInfo();
                        pkcs10Processor.fillCertInfo(pkcs10, (X509CertInfo)certInfo, authToken, httpParams);
                        certInfoArray[i] = certInfo;
                        continue;
                    }
                    catch (Exception e) {
                        throw new ECMSGWException(CMS.getUserMessage("CMS_GW_PKCS10_ERROR", e.toString()));
                    }
                }
                if (type.equals(TaggedRequest.CRMF)) {
                    CRMFProcessor crmfProc = new CRMFProcessor(this.mRequest, this.mServlet, this.enforcePop);
                    crmfProc.setCMSEngine(this.engine);
                    CertReqMsg crm = taggedRequest.getCrm();
                    CertRequest certReq = crm.getCertReq();
                    INTEGER certReqId = certReq.getCertReqId();
                    int srcId = certReqId.intValue();
                    reqIdArray[i] = String.valueOf(srcId);
                    certInfoArray[i] = crmfProc.processIndividualRequest(crm, authToken, httpParams);
                    continue;
                }
                throw new ECMSGWException(CMS.getUserMessage("CMS_GW_NO_CMC_CONTENT", new String[0]));
            }
            SET dais = cmcFullReq.getDigestAlgorithmIdentifiers();
            int numDig = dais.size();
            Hashtable<String, byte[]> digs = new Hashtable<String, byte[]>();
            for (int i = 0; i < numDig; ++i) {
                AlgorithmIdentifier dai = (AlgorithmIdentifier)dais.elementAt(i);
                String name = DigestAlgorithm.fromOID((OBJECT_IDENTIFIER)dai.getOID()).toString();
                MessageDigest md = MessageDigest.getInstance(name);
                byte[] digest = md.digest(content.toByteArray());
                digs.put(name, digest);
            }
            SET sis = cmcFullReq.getSignerInfos();
            int numSis = sis.size();
            for (int i = 0; i < numSis; ++i) {
                PublicKey signKey;
                SignerIdentifier sid;
                SignerInfo si = (SignerInfo)sis.elementAt(i);
                String name = si.getDigestAlgorithm().toString();
                byte[] digest = (byte[])digs.get(name);
                if (digest == null) {
                    MessageDigest md = MessageDigest.getInstance(name);
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    pkiData.encode((OutputStream)ostream);
                    digest = md.digest(ostream.toByteArray());
                }
                if ((sid = si.getSignerIdentifier()).getType().equals(SignerIdentifier.ISSUER_AND_SERIALNUMBER)) {
                    IssuerAndSerialNumber issuerAndSerialNumber = sid.getIssuerAndSerialNumber();
                    java.security.cert.Certificate cert = null;
                    if (cmcFullReq.hasCertificates()) {
                        SET certs = cmcFullReq.getCertificates();
                        int numCerts = certs.size();
                        for (int j = 0; j < numCerts; ++j) {
                            Certificate certJss = (Certificate)certs.elementAt(j);
                            CertificateInfo certI = certJss.getInfo();
                            Name issuer = certI.getIssuer();
                            byte[] issuerB = ASN1Util.encode((ASN1Value)issuer);
                            INTEGER sn = certI.getSerialNumber();
                            if (!new String(issuerB).equals(new String(ASN1Util.encode((ASN1Value)issuerAndSerialNumber.getIssuer()))) || !sn.toString().equals(issuerAndSerialNumber.getSerialNumber().toString())) continue;
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            certJss.encode((OutputStream)os);
                            cert = new X509CertImpl(os.toByteArray());
                        }
                    }
                    if (cert == null) {
                        si.verify(digest, id);
                        continue;
                    }
                    signKey = cert.getPublicKey();
                    PK11PubKey pubK = PK11PubKey.fromSPKI((byte[])((X509Key)signKey).getKey());
                    si.verify(digest, id, (PublicKey)pubK);
                    continue;
                }
                OCTET_STRING ski = sid.getSubjectKeyIdentifier();
                signKey = null;
                for (int j = 0; signKey == null && j < numReqs; ++j) {
                    X509Key subjectKeyInfo = (X509Key)((CertificateX509Key)certInfoArray[j].get("key")).get("value");
                    MessageDigest md = MessageDigest.getInstance("SHA-1");
                    md.update(subjectKeyInfo.getEncoded());
                    byte[] skib = md.digest();
                    if (!new String(skib).equals(new String(ski.toByteArray()))) continue;
                    signKey = subjectKeyInfo;
                }
                if (signKey == null) {
                    throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CMC_ERROR", "SubjectKeyIdentifier in SignerInfo does not match any publicKey in the request."));
                }
                PK11PubKey pubK = PK11PubKey.fromSPKI((byte[])((X509Key)signKey).getKey());
                si.verify(digest, id, (PublicKey)pubK);
            }
            SEQUENCE controls = pkiData.getControlSequence();
            int numControls = controls.size();
            for (int i = 0; i < numControls; ++i) {
                ANY val;
                int j;
                String[] vals;
                TaggedAttribute control = (TaggedAttribute)controls.elementAt(i);
                OBJECT_IDENTIFIER type = control.getType();
                SET values = control.getValues();
                int numVals = values.size();
                if (type.equals((Object)OBJECT_IDENTIFIER.id_cmc_transactionId)) {
                    vals = null;
                    if (numVals > 0) {
                        vals = new String[numVals];
                    }
                    for (j = 0; j < numVals; ++j) {
                        val = (ANY)values.elementAt(j);
                        INTEGER transId = (INTEGER)val.decodeWith(INTEGER.getTemplate());
                        if (transId == null) continue;
                        vals[j] = transId.toString();
                    }
                    if (vals == null) continue;
                    req.setExtData("transactionId", vals);
                    continue;
                }
                if (type.equals((Object)OBJECT_IDENTIFIER.id_cmc_senderNonce)) {
                    vals = null;
                    if (numVals > 0) {
                        vals = new String[numVals];
                    }
                    for (j = 0; j < numVals; ++j) {
                        val = (ANY)values.elementAt(j);
                        OCTET_STRING nonce = (OCTET_STRING)val.decodeWith((ASN1Template)OCTET_STRING.getTemplate());
                        if (nonce == null) continue;
                        vals[j] = new String(nonce.toByteArray());
                    }
                    if (vals == null) continue;
                    req.setExtData("senderNonce", vals);
                    continue;
                }
                if (!type.equals((Object)OBJECT_IDENTIFIER.id_cmc_regInfo) && !type.equals((Object)OBJECT_IDENTIFIER.id_cmc_identification) && !type.equals((Object)OBJECT_IDENTIFIER.id_cmc_identityProof)) continue;
            }
            req.setExtData("cmcReqIds", reqIdArray);
            return certInfoArray;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_CMC_TO_CERTINFO_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CMC_TO_CERTINFO_ERROR", new String[0]), e);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_CMC_TO_CERTINFO_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CMC_TO_CERTINFO_ERROR", new String[0]), e);
        }
        catch (InvalidBERException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_CMC_TO_CERTINFO_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CMC_TO_CERTINFO_ERROR", new String[0]), (Exception)((Object)e));
        }
        catch (InvalidKeyException e) {
            logger.error(CMS.getLogMessage("CMSGW_ERROR_CMC_TO_CERTINFO_1", e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CMC_TO_CERTINFO_ERROR", new String[0]), e);
        }
        catch (Exception e) {
            throw new ECMSGWException(CMS.getUserMessage("CMS_GW_CMC_ERROR", e.toString()), e);
        }
    }
}

