/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.authentication.EAuthUserError;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Locale;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChallengePhraseAuthentication
extends AuthManager {
    public static Logger logger = LoggerFactory.getLogger(ChallengePhraseAuthentication.class);
    public static final String TOKEN_CERT_SERIAL = "certSerialToRevoke";
    public static final String CRED_CERT_SERIAL = "certSerialToRevoke";
    public static final String CRED_CHALLENGE = "challengePhrase";
    protected String[] mRequiredCreds = new String[]{"certSerialToRevoke", "challengePhrase"};
    protected CertificateRepository mCertDB;
    private MessageDigest mSHADigest = null;

    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
        try {
            this.mSHADigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new EAuthException(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INTERNAL_ERROR", (String[])new String[]{e.getMessage()}), (Exception)e);
        }
    }

    public void init(ConfigStore config) throws EProfileException {
    }

    public String getText(Locale locale) {
        return null;
    }

    public Enumeration<String> getValueNames() {
        return null;
    }

    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    public boolean isValueWriteable(String name) {
        return false;
    }

    public boolean isSSLClientRequired() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        CAEngine caEngine = (CAEngine)this.engine;
        this.mCertDB = caEngine.getCertificateRepository();
        AuthToken authToken = new AuthToken((AuthManager)this);
        String serialNumString = (String)authCred.get("certSerialToRevoke");
        BigInteger serialNum = null;
        if (serialNumString == null || serialNumString.equals("")) {
            throw new EMissingCredential(CMS.getUserMessage((String)"CMS_AUTHENTICATION_NULL_CREDENTIAL", (String[])new String[]{"certSerialToRevoke"}));
        }
        try {
            serialNumString = serialNumString.trim();
            serialNum = serialNumString.startsWith("0x") || serialNumString.startsWith("0X") ? new BigInteger(serialNumString.substring(2), 16) : new BigInteger(serialNumString);
        }
        catch (NumberFormatException e) {
            throw new EAuthUserError(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_ATTRIBUTE_VALUE", (String[])new String[]{"Invalid serial number"}));
        }
        String challenge = (String)authCred.get(CRED_CHALLENGE);
        if (challenge == null) {
            throw new EMissingCredential(CMS.getUserMessage((String)"CMS_AUTHENTICATION_NULL_CREDENTIAL", (String[])new String[]{CRED_CHALLENGE}));
        }
        if (challenge.equals("")) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_AUTH_REVO_ATTEMPT", (Object[])new Object[]{serialNum.toString()}));
            throw new EInvalidCredentials(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_CREDENTIAL", (String[])new String[0]));
        }
        BigInteger[] bigIntArray = null;
        CertRecord record = null;
        try {
            record = this.mCertDB.readCertificateRecord(serialNum);
        }
        catch (EBaseException ee) {
            logger.warn("ChallengePhraseAuthentication: " + ee.getMessage(), (Throwable)ee);
        }
        if (record != null) {
            String status = record.getStatus();
            if (!status.equals("REVOKED")) {
                boolean samepwd = this.compareChallengePassword(record, challenge);
                if (!samepwd) throw new EAuthUserError(CMS.getUserMessage((String)"CMS_AUTHENTICATION_INVALID_ATTRIBUTE_VALUE", (String[])new String[]{"Invalid password"}));
                bigIntArray = new BigInteger[]{record.getSerialNumber()};
            } else {
                bigIntArray = new BigInteger[]{};
            }
        } else {
            bigIntArray = new BigInteger[]{};
        }
        if (bigIntArray != null && bigIntArray.length > 0) {
            logger.debug("ChallengePhraseAuthentication: challenge authentication serialno array not null");
            for (int i = 0; i < bigIntArray.length; ++i) {
                logger.debug("ChallengePhraseAuthentication: challenge auth serialno " + bigIntArray[i]);
            }
        }
        logger.debug("ChallengePhraseAuthentication: challenge authentication set certSerialToRevoke");
        authToken.set("certSerialToRevoke", bigIntArray);
        return authToken;
    }

    public void populate(AuthToken token, Request request) throws EProfileException {
    }

    private boolean compareChallengePassword(CertRecord record, String pwd) throws EBaseException {
        MetaInfo metaInfo = (MetaInfo)record.get("certMetaInfo");
        if (metaInfo == null) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"metaInfo"}));
        }
        if (pwd == null) {
            logger.warn("ChallengePhraseAuthentication: challenge pwd is null");
            return false;
        }
        String hashpwd = this.hashPassword(pwd);
        String challengeString = (String)metaInfo.get(CRED_CHALLENGE);
        if (challengeString == null) {
            logger.warn("ChallengePhraseAuthentication: challengeString null");
            return false;
        }
        return challengeString.equals(hashpwd);
    }

    public String[] getRequiredCreds() {
        return this.mRequiredCreds;
    }

    public void shutdown() {
    }

    private String hashPassword(String pwd) {
        String salt = "lala123";
        byte[] pwdDigest = this.mSHADigest.digest((salt + pwd).getBytes());
        String b64E = Utils.base64encode((byte[])pwdDigest, (boolean)true);
        return "{SHA-256}" + b64E;
    }
}

