/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.ExtendedKeyUsageExtDefault;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.UserExtensionDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.netscape.security.extensions.ExtendedKeyUsageExtension;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class ExtendedKeyUsageExtConstraint
extends EnrollConstraint {
    public static final String CONFIG_CRITICAL = "exKeyUsageCritical";
    public static final String CONFIG_OIDS = "exKeyUsageOIDs";

    public ExtendedKeyUsageExtConstraint() {
        this.addConfigName(CONFIG_CRITICAL);
        this.addConfigName(CONFIG_OIDS);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_CRITICAL)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_OIDS)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OIDS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        boolean critical;
        ExtendedKeyUsageExtension ext = (ExtendedKeyUsageExtension)this.getExtension("2.5.29.37", info);
        if (ext == null) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_EXTENSION_NOT_FOUND", (String[])new String[]{"2.5.29.37"}));
        }
        String value = this.getConfig(CONFIG_CRITICAL);
        if (!this.isOptional(value) && (critical = this.getBoolean(value)) != ext.isCritical()) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_CRITICAL_NOT_MATCHED", (String[])new String[0]));
        }
        Vector<String> mCache = new Vector<String>();
        StringTokenizer st = new StringTokenizer(this.getConfig(CONFIG_OIDS), ",");
        while (st.hasMoreTokens()) {
            String oid = st.nextToken();
            mCache.addElement(oid);
        }
        Enumeration e = ext.getOIDs();
        while (e.hasMoreElements()) {
            ObjectIdentifier oid = (ObjectIdentifier)e.nextElement();
            if (mCache.contains(oid.toString())) continue;
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_OID_NOT_MATCHED", (String[])new String[]{oid.toString()}));
        }
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig(CONFIG_CRITICAL), this.getConfig(CONFIG_OIDS)};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_EXTENDED_KEY_EXT_TEXT", (String[])params);
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof ExtendedKeyUsageExtDefault) {
            return true;
        }
        return def instanceof UserExtensionDefault;
    }
}

