/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import org.mozilla.jss.netscape.security.extensions.InhibitAnyPolicyExtension;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InhibitAnyPolicyExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(InhibitAnyPolicyExtDefault.class);
    public static final String CONFIG_CRITICAL = "critical";
    public static final String CONFIG_SKIP_CERTS = "skipCerts";
    public static final String VAL_CRITICAL = "critical";
    public static final String VAL_SKIP_CERTS = "skipCerts";
    private static final String SKIP_CERTS = "Skip Certs";

    public InhibitAnyPolicyExtDefault() {
        this.addValueName("critical");
        this.addValueName("skipCerts");
        this.addConfigName("critical");
        this.addConfigName("skipCerts");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("critical")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.startsWith("skipCerts")) {
            return new Descriptor("integer", null, "0", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SKIP_CERTS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (name.equals("skipCerts")) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{"skipCerts"}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("critical")) {
            return new Descriptor("boolean", null, "true", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("skipCerts")) {
            return new Descriptor("integer", null, "0", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SKIP_CERTS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            InhibitAnyPolicyExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (InhibitAnyPolicyExtension)this.getExtension("2.5.29.54", info);
            if (ext == null) {
                this.populate(null, info);
            }
            if (name.equals("critical")) {
                ext = (InhibitAnyPolicyExtension)this.getExtension("2.5.29.54", info);
                if (ext == null) {
                    return;
                }
                boolean critical = Boolean.valueOf(value);
                ext.setCritical(critical);
            } else if (name.equals("skipCerts")) {
                ext = (InhibitAnyPolicyExtension)this.getExtension("2.5.29.54", info);
                if (ext == null) {
                    return;
                }
                boolean critical = ext.isCritical();
                if (value.equals("")) {
                    this.deleteExtension("2.5.29.54", info);
                    return;
                }
                BigInt num = null;
                try {
                    BigInteger l = new BigInteger(value);
                    num = new BigInt(l);
                }
                catch (Exception e) {
                    throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                }
                ext = new InhibitAnyPolicyExtension(critical, num);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension("2.5.29.54", (Extension)ext, info);
        }
        catch (Exception e) {
            logger.warn("InhibitAnyPolicyExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}), (Throwable)e);
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        InhibitAnyPolicyExtension ext = (InhibitAnyPolicyExtension)this.getExtension("2.5.29.54", info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("critical")) {
            ext = (InhibitAnyPolicyExtension)this.getExtension("2.5.29.54", info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals("skipCerts")) {
            ext = (InhibitAnyPolicyExtension)this.getExtension("2.5.29.54", info);
            if (ext == null) {
                return null;
            }
            BigInt n = ext.getSkipCerts();
            return "" + n.toInt();
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        StringBuffer sb = new StringBuffer();
        sb.append("Skip Certs:");
        sb.append(this.getConfig("skipCerts"));
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_INHIBIT_ANY_POLICY_EXT", (String[])new String[]{this.getConfig("critical"), sb.toString()});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        InhibitAnyPolicyExtension ext = null;
        ext = this.createExtension(request);
        this.addExtension("2.5.29.54", (Extension)ext, info);
    }

    public InhibitAnyPolicyExtension createExtension(Request request) throws EProfileException {
        InhibitAnyPolicyExtension ext = null;
        boolean critical = Boolean.valueOf(this.getConfig("critical"));
        String str = this.getConfig("skipCerts");
        if (str == null || str.equals("")) {
            try {
                ext = new InhibitAnyPolicyExtension();
            }
            catch (IOException e) {
                throw new EProfileException((Throwable)e);
            }
            ext.setCritical(critical);
        } else {
            BigInt val = null;
            try {
                BigInteger b = new BigInteger(str);
                val = new BigInt(b);
            }
            catch (NumberFormatException e) {
                throw new EProfileException(CMS.getUserMessage((String)"CMS_PROFILE_INHIBIT_ANY_POLICY_WRONG_SKIP_CERTS", (String[])new String[0]));
            }
            try {
                ext = new InhibitAnyPolicyExtension(critical, val);
            }
            catch (Exception e) {
                logger.warn("InhibitAnyPolicyExtDefault: " + e.getMessage(), (Throwable)e);
            }
        }
        return ext;
    }
}

