/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CRLIssuingPoint;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.cert.RevocationProcessor;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caDoUnrevoke", urlPatterns={"/agent/ca/doUnrevoke"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="templatePath", value="/agent/ca/unrevocationResult.template"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="ID", value="caDoUnrevoke"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.ca.certificate")})
public class DoUnrevoke
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(DoUnrevoke.class);
    private static final long serialVersionUID = -7978703730006036625L;
    private static final String TPL_FILE = "unrevocationResult.template";
    private CertificateRepository mCertDB;
    private String mFormPath = null;
    private CAPublisherProcessor mPublisherProcessor;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mFormPath = "/ca/unrevocationResult.template";
        this.mCertDB = engine.getCertificateRepository();
        this.mPublisherProcessor = engine.getPublisherProcessor();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        EBaseException error = null;
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        try {
            BigInteger[] serialNumber = this.getSerialNumbers(req);
            AuthToken authToken = this.authenticate(cmsReq);
            String authMgr = "noAuthManager";
            if (authToken == null) {
                logger.warn("DoUnrevoke::process() -  authToken is null!");
                return;
            }
            authMgr = authToken.getInString("authMgrInstName");
            String agentID = authToken.getInString("userid");
            String initiative = "fromAgent agentID: " + agentID + " authenticated by " + authMgr;
            AuthzToken authzToken = null;
            try {
                authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "unrevoke");
            }
            catch (EAuthzAccessDenied e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
            if (authzToken == null) {
                cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                return;
            }
            this.process(argSet, header, serialNumber, req, resp, locale[0], initiative);
        }
        catch (NumberFormatException e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_INVALID_SERIAL_NUM_FORMAT", (Object[])new Object[0]), (Throwable)e);
            error = new EBaseException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_BASE_INVALID_NUMBER_FORMAT", (String[])new String[0]), (Throwable)e);
        }
        catch (EBaseException e) {
            error = e;
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, BigInteger[] serialNumbers, HttpServletRequest req, HttpServletResponse resp, Locale locale, String initiative) throws EBaseException {
        CAEngine engine = CAEngine.getInstance();
        RevocationProcessor processor = new RevocationProcessor(this.servletConfig.getServletName(), this.getLocale(req));
        processor.setCMSEngine(engine);
        processor.init();
        processor.setInitiative(initiative);
        processor.setSerialNumber(this.auditSerialNumber(serialNumbers[0].toString()));
        processor.setRevocationReason(RevocationReason.CERTIFICATE_HOLD);
        processor.setRequestType("off-hold");
        processor.setAuthority(engine.getCA());
        try {
            StringBuilder snList = new StringBuilder();
            for (BigInteger serialNumber : serialNumbers) {
                processor.addSerialNumberToUnrevoke(serialNumber);
                if (snList.length() > 0) {
                    snList.append(", ");
                }
                snList.append("0x");
                snList.append(serialNumber.toString(16));
            }
            header.addStringValue("serialNumber", snList.toString());
            processor.createUnrevocationRequest();
            processor.auditChangeRequest("Success");
        }
        catch (EBaseException e) {
            logger.error("Unable to pre-process unrevocation request: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequest("Failure");
            throw e;
        }
        try {
            processor.processUnrevocationRequest();
            Request unrevReq = processor.getRequest();
            RequestStatus status = unrevReq.getRequestStatus();
            String type = unrevReq.getRequestType();
            if (status == RequestStatus.COMPLETE || status == RequestStatus.SVC_PENDING && type.equals("uncert4crl")) {
                Integer result = unrevReq.getExtDataInInteger("Result");
                if (result != null && result.equals(Request.RES_SUCCESS)) {
                    header.addStringValue("unrevoked", "yes");
                } else {
                    header.addStringValue("unrevoked", "no");
                    String error = unrevReq.getExtDataInString("Error");
                    if (error != null) {
                        header.addStringValue("error", error);
                    }
                }
                Integer updateCRLResult = unrevReq.getExtDataInInteger("crlUpdateStatus");
                if (updateCRLResult != null) {
                    header.addStringValue("updateCRL", "yes");
                    if (updateCRLResult.equals(Request.RES_SUCCESS)) {
                        header.addStringValue("updateCRLSuccess", "yes");
                    } else {
                        header.addStringValue("updateCRLSuccess", "no");
                        String crlError = unrevReq.getExtDataInString("crlUpdateError");
                        if (crlError != null) {
                            header.addStringValue("updateCRLError", crlError);
                        }
                    }
                    Integer publishCRLResult = unrevReq.getExtDataInInteger("crlPublishStatus");
                    if (publishCRLResult != null) {
                        if (publishCRLResult.equals(Request.RES_SUCCESS)) {
                            header.addStringValue("publishCRLSuccess", "yes");
                        } else {
                            header.addStringValue("publishCRLSuccess", "no");
                            String publError = unrevReq.getExtDataInString("crlPublishError");
                            if (publError != null) {
                                header.addStringValue("publishCRLError", publError);
                            }
                        }
                    }
                }
                for (CRLIssuingPoint crl : engine.getCRLIssuingPoints()) {
                    String publishStatusStr;
                    Integer publishResult;
                    String updateStatusStr;
                    Integer updateResult;
                    String crlId = crl.getId();
                    if (crlId.equals("MasterCRL") || (updateResult = unrevReq.getExtDataInInteger(updateStatusStr = crl.getCrlUpdateStatusStr())) == null) continue;
                    if (updateResult.equals(Request.RES_SUCCESS)) {
                        logger.debug("DoUnrevoke: adding header " + updateStatusStr + " yes");
                        header.addStringValue(updateStatusStr, "yes");
                    } else {
                        String updateErrorStr = crl.getCrlUpdateErrorStr();
                        logger.debug("DoUnrevoke: adding header " + updateStatusStr + " no");
                        header.addStringValue(updateStatusStr, "no");
                        String error = unrevReq.getExtDataInString(updateErrorStr);
                        if (error != null) {
                            header.addStringValue(updateErrorStr, error);
                        }
                    }
                    if ((publishResult = unrevReq.getExtDataInInteger(publishStatusStr = crl.getCrlPublishStatusStr())) == null) continue;
                    if (publishResult.equals(Request.RES_SUCCESS)) {
                        header.addStringValue(publishStatusStr, "yes");
                        continue;
                    }
                    String publishErrorStr = crl.getCrlPublishErrorStr();
                    header.addStringValue(publishStatusStr, "no");
                    String error = unrevReq.getExtDataInString(publishErrorStr);
                    if (error == null) continue;
                    header.addStringValue(publishErrorStr, error);
                }
                if (this.mPublisherProcessor != null && this.mPublisherProcessor.ldapEnabled()) {
                    header.addStringValue("dirEnabled", "yes");
                    Integer[] ldapPublishStatus = unrevReq.getExtDataInIntegerArray("ldapPublishStatus");
                    if (ldapPublishStatus != null) {
                        if (ldapPublishStatus[0] == Request.RES_SUCCESS) {
                            header.addStringValue("dirUpdated", "yes");
                        } else {
                            header.addStringValue("dirUpdated", "no");
                        }
                    }
                } else {
                    header.addStringValue("dirEnabled", "no");
                }
            } else if (status == RequestStatus.PENDING) {
                header.addStringValue("error", "Request Pending");
                header.addStringValue("unrevoked", "pending");
            } else {
                header.addStringValue("error", "Request Status.Error");
                header.addStringValue("unrevoked", "no");
            }
            processor.auditChangeRequestProcessed("Success");
        }
        catch (EBaseException e) {
            logger.error("Unable to process unrevocation request: " + e.getMessage(), (Throwable)e);
            processor.auditChangeRequestProcessed("Failure");
            throw e;
        }
    }

    private BigInteger[] getSerialNumbers(HttpServletRequest req) throws NumberFormatException {
        String serialNumString = req.getParameter("serialNumber");
        StringTokenizer snList = new StringTokenizer(serialNumString, " ");
        Vector<BigInteger> biList = new Vector<BigInteger>();
        while (snList.hasMoreTokens()) {
            String snStr = snList.nextToken();
            if (snStr != null) {
                BigInteger bi = (snStr = snStr.trim()).startsWith("0x") || snStr.startsWith("0X") ? new BigInteger(snStr.substring(2), 16) : new BigInteger(snStr);
                if (bi.compareTo(BigInteger.ZERO) < 0) {
                    throw new NumberFormatException();
                }
                biList.addElement(bi);
                continue;
            }
            throw new NumberFormatException();
        }
        if (biList.size() < 1) {
            throw new NumberFormatException();
        }
        BigInteger[] biNumbers = new BigInteger[biList.size()];
        for (int i = 0; i < biList.size(); ++i) {
            biNumbers[i] = (BigInteger)biList.elementAt(i);
        }
        return biNumbers;
    }

    private CertId auditSerialNumber(String eeSerialNumber) {
        return eeSerialNumber == null ? null : new CertId(eeSerialNumber.trim());
    }
}

