/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.system;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.system.DomainInfo;
import com.netscape.certsrv.system.SecurityDomainClient;
import com.netscape.certsrv.system.SecurityDomainHost;
import com.netscape.certsrv.system.SecurityDomainSubsystem;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.cli.SubsystemCLI;
import com.netscape.cmstools.system.SecurityDomainHostCLI;
import com.netscape.cmstools.system.SecurityDomainJoinCLI;
import com.netscape.cmstools.system.SecurityDomainLeaveCLI;
import com.netscape.cmstools.system.SecurityDomainShowCLI;
import org.dogtagpki.cli.CLI;

public class SecurityDomainCLI
extends CLI {
    public MainCLI mainCLI;
    public SecurityDomainClient securityDomainClient;

    public SecurityDomainCLI(MainCLI mainCLI) {
        super("securitydomain", "Security domain commands", (CLI)mainCLI);
        this.mainCLI = mainCLI;
        this.addModule((CLI)new SecurityDomainJoinCLI(this));
        this.addModule((CLI)new SecurityDomainLeaveCLI(this));
        this.addModule((CLI)new SecurityDomainShowCLI(this));
        this.addModule(new SecurityDomainHostCLI(this));
    }

    public String getFullName() {
        return this.parent instanceof MainCLI ? this.name : this.parent.getFullName() + "-" + this.name;
    }

    public String getManPage() {
        return "pki-securitydomain";
    }

    public SecurityDomainClient getSecurityDomainClient() throws Exception {
        String subsystem;
        if (this.securityDomainClient != null) {
            return this.securityDomainClient;
        }
        PKIClient client = this.getClient();
        if (this.parent instanceof SubsystemCLI) {
            SubsystemCLI subsystemCLI = (SubsystemCLI)this.parent;
            subsystem = subsystemCLI.getName();
        } else {
            subsystem = "ca";
        }
        this.securityDomainClient = new SecurityDomainClient(client, subsystem);
        return this.securityDomainClient;
    }

    public static void printSecurityDomain(DomainInfo domain) {
        System.out.println("  Domain: " + domain.getName());
        System.out.println();
        for (SecurityDomainSubsystem subsystem : domain.getSubsystemArray()) {
            SecurityDomainHost[] hosts = subsystem.getHostArray();
            if (hosts.length == 0) continue;
            System.out.println("  " + subsystem.getName() + " Subsystem:");
            System.out.println();
            for (SecurityDomainHost host : hosts) {
                System.out.println("    Host ID: " + host.getId());
                System.out.println("    Hostname: " + host.getHostname());
                System.out.println("    Port: " + host.getPort());
                System.out.println("    Secure Port: " + host.getSecurePort());
                if (host.getDomainManager() != null) {
                    System.out.println("    Domain Manager: " + host.getDomainManager());
                }
                System.out.println();
            }
        }
    }
}

