/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tks;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.key.KeyData;
import com.netscape.certsrv.system.TPSConnectorClient;
import com.netscape.cmstools.tks.TKSKeyCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKSKeyExportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TKSKeyExportCLI.class);
    public TKSKeyCLI tksKeyCLI;

    public TKSKeyExportCLI(TKSKeyCLI tksKeyCLI) {
        super("export", "Export key from TKS", (CLI)tksKeyCLI);
        this.tksKeyCLI = tksKeyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <Key ID>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "File to store the exported key");
        option.setArgName("path");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        block12: {
            String[] cmdArgs = cmd.getArgs();
            if (cmdArgs.length < 1) {
                throw new Exception("Missing key ID");
            }
            String keyID = cmdArgs[0];
            String outputFile = cmd.getOptionValue("output");
            PKIClient client = this.getClient();
            TPSConnectorClient tpsConnectorClient = this.tksKeyCLI.getTPSConnectorClient();
            KeyData keyData = tpsConnectorClient.getSharedSecret(keyID);
            logger.info("Wrapped session key: " + keyData.getWrappedPrivateData());
            logger.info("Wrapped secret key: " + keyData.getAdditionalWrappedPrivateData());
            if (outputFile != null) {
                try (FileWriter fw = new FileWriter(outputFile);
                     PrintWriter out = new PrintWriter(fw);){
                    out.println(keyData.toJSON());
                    break block12;
                }
            }
            System.out.println(keyData.toJSON());
        }
    }
}

