/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.token;

import com.netscape.certsrv.tps.token.TokenClient;
import com.netscape.certsrv.tps.token.TokenData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tps.token.TokenCLI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAddCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TokenAddCLI.class);
    public TokenCLI tokenCLI;

    public TokenAddCLI(TokenCLI tokenCLI) {
        super("add", "Add token", (CLI)tokenCLI);
        this.tokenCLI = tokenCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Token ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "user", true, "User ID");
        option.setArgName("User ID");
        this.options.addOption(option);
        option = new Option(null, "policy", true, "Policy");
        option.setArgName("Policy");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("No Token ID specified.");
        }
        String tokenID = cmdArgs[0];
        TokenData tokenData = new TokenData();
        tokenData.setTokenID(tokenID);
        String userID = cmd.getOptionValue("user");
        tokenData.setUserID(userID);
        String policy = cmd.getOptionValue("policy");
        tokenData.setPolicy(policy);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        TokenClient tokenClient = this.tokenCLI.getTokenClient();
        tokenData = tokenClient.addToken(tokenData);
        MainCLI.printMessage("Added token \"" + tokenID + "\"");
        TokenCLI.printToken(tokenData);
    }
}

