/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSearchEntry;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.listener.interceptor.InterceptedSearchOperation;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedSearchEntry
extends InterceptedOperation
implements InMemoryInterceptedSearchEntry {
    @NotNull
    private final ReadOnlySearchRequest searchRequest;
    @Nullable
    private SearchResultEntry entry;

    InterceptedSearchEntry(@NotNull InterceptedSearchOperation op, @NotNull SearchResultEntryProtocolOp entry, Control ... requestControls) {
        super(op);
        this.searchRequest = op.getRequest();
        this.entry = entry.toSearchResultEntry(requestControls);
    }

    @Override
    @NotNull
    public ReadOnlySearchRequest getRequest() {
        return this.searchRequest;
    }

    @Override
    @Nullable
    public SearchResultEntry getSearchEntry() {
        return this.entry;
    }

    @Override
    public void setSearchEntry(@Nullable Entry entry) {
        this.entry = entry == null ? null : (entry instanceof SearchResultEntry ? (SearchResultEntry)entry : new SearchResultEntry(entry, new Control[0]));
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InterceptedSearchEntry(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.searchRequest);
        buffer.append(", entry=");
        buffer.append(this.entry);
        buffer.append(')');
    }
}

