#
SET(CPACK_PACKAGE_DESCRIPTION_SUMMARY "Galera: a synchronous multi-master wsrep provider (replication engine)")
SET(CPACK_PACKAGE_DESCRIPTION "Galera is a fast synchronous multimaster wsrep provider (replication engine)
for transactional databases and similar applications. For more information
about wsrep API see https://github.com/codership/wsrep-API. For a description
of Galera replication engine see https://www.galeracluster.com.

Copyright 2007-2020 Codership Oy. All rights reserved. Use is subject to license terms under GPLv2 license.

This software comes with ABSOLUTELY NO WARRANTY. This is free software,
and you are welcome to modify and redistribute it under the GPLv2 license.")
SET(CPACK_PACKAGE_VERSION ${GALERA_VERSION_WSREP_API}.${GALERA_VERSION_MAJOR}.${GALERA_VERSION_MINOR})
SET(CPACK_PACKAGE_URL "http://mariadb.com")
SET(CPACK_PACKAGE_CONTACT "MariaDB Corporation <info@mariadb.com>")
SET(CPACK_PACKAGE_VENDOR "MariaDB Corporation")
SET(CPACK_COMPONENTS_ALL "galera")
SET(CMAKE_INSTALL_DEFAULT_COMPONENT_NAME "galera")
#
SET(GALERA_VERSION_FULL "${GALERA_VERSION_WSREP_API}.${GALERA_VERSION_MAJOR}.${GALERA_VERSION_MINOR}-${GALERA_VERSION_EXTRA}")
IF(NOT EXISTS ${CMAKE_SOURCE_DIR}/debian/changelog)
  EXECUTE_PROCESS(COMMAND date -R OUTPUT_VARIABLE BUILDDATE OUTPUT_STRIP_TRAILING_WHITESPACE)
  CONFIGURE_FILE(${CMAKE_SOURCE_DIR}/debian/changelog.in ${CMAKE_SOURCE_DIR}/debian/changelog @ONLY)
ENDIF()
#
IF(DEB)
  SET(CPACK_GENERATOR "DEB")
  SET(CPACK_DEBIAN_PACKAGE_SOURCE ${CMAKE_PROJECT_NAME}-${CPACK_PACKAGE_VERSION}-r${GALERA_REVISION})
  SET(CPACK_DEBIAN_PACKAGE_DEBUG ON)
  SET(CPACK_DEBIAN_DEBUGINFO_PACKAGE ON)
  SET(CPACK_DEB_COMPONENT_INSTALL    ON)
  SET(CPACK_DEBIAN_PACKAGE_SHLIBDEPS ON)
  SET(CPACK_DEBIAN_PACKAGE_EPOCH ${GALERA_EPOCH})
  SET(CPACK_DEBIAN_PACKAGE_CONTROL_STRICT_PERMISSION ON)
  SET(CMAKE_INSTALL_PREFIX "/usr")
  SET(INSTALL_SYSCONFDIR "/etc/default")
  SET(INSTALL_SYSTEMD_UNITDIR "/lib/systemd/system")
  SET(CPACK_DEBIAN_PACKAGE_DEPENDS "rsync, socat, lsof")
  SET(CPACK_DEBIAN_PACKAGE_REPLACES "galera, galera-${GALERA_VERSION_MAJOR}")
  SET(CPACK_DEBIAN_PACKAGE_PROVIDES "wsrep, galera, galera-${GALERA_VERSION_MAJOR}, galera-enterprise-${GALERA_VERSION_MAJOR}")
  SET(CPACK_DEBIAN_PACKAGE_RELEASE ${GALERA_VERSION_EXTRA})
  EXECUTE_PROCESS(COMMAND lsb_release -sc
                  OUTPUT_VARIABLE DIST
                  OUTPUT_STRIP_TRAILING_WHITESPACE)
  IF(NOT DIST)
    SET(DIST ${DEB})
  ENDIF()
  SET(CPACK_DEBIAN_PACKAGE_VERSION "${CPACK_PACKAGE_VERSION}+maria~${DIST}")
  SET(CPACK_DEBIAN_PACKAGE_SECTION "libs")
  EXECUTE_PROCESS(COMMAND dpkg --print-architecture
                   OUTPUT_VARIABLE ARCH
                   OUTPUT_STRIP_TRAILING_WHITESPACE)
   IF(ARCH)
     SET(CPACK_DEBIAN_PACKAGE_ARCHITECTURE "${ARCH}")
   ELSE()
     SET(CPACK_DEBIAN_PACKAGE_ARCHITECTURE "all")
   ENDIF()
   SET(CPACK_DEBIAN_FILE_NAME "${PROJECT_NAME}_${CPACK_DEBIAN_PACKAGE_VERSION}-${CPACK_DEBIAN_PACKAGE_RELEASE}_${CPACK_DEBIAN_PACKAGE_ARCHITECTURE}.deb")
  SET(CPACK_DEBIAN_PACKAGE_CONTROL_EXTRA "${CMAKE_CURRENT_SOURCE_DIR}/scripts/packages/deb/postinst;${CMAKE_CURRENT_SOURCE_DIR}/scripts/packages/deb/postrm;${CMAKE_CURRENT_SOURCE_DIR}/scripts/packages/deb/conffiles")
ENDIF()
#
IF(RPM)
  SET(CPACK_GENERATOR "RPM")
  SET(CPACK_RPM_PACKAGE_DEBUG ON)
  SET(CMAKE_INSTALL_PREFIX "/usr")
  SET(INSTALL_SYSCONFDIR "/etc/sysconfig")
  SET(CPACK_RPM_USER_FILELIST "%config(noreplace) ${INSTALL_SYSCONFDIR}/garbd" )

  SET(CPACK_RPM_SPEC_MORE_DEFINE "${CPACK_RPM_SPEC_MORE_DEFINE}
  %define ignore \#
  ")
  SET(ignored
    "%ignore /etc/sysconfig"
    "%ignore /usr/share/man"
    "%ignore /usr/share/man/man8"
    "%ignore /usr/lib/systemd"
    "%ignore /usr/lib/systemd/system"
    )
  SET(CPACK_RPM_USER_FILELIST ${ignored})

  EXECUTE_PROCESS(COMMAND rpm --eval %_unitdir
                  OUTPUT_VARIABLE INSTALL_SYSTEMD_UNITDIR OUTPUT_STRIP_TRAILING_WHITESPACE)
  IF(NOT INSTALL_SYSTEMD_UNITDIR)
    SET(INSTALL_SYSTEMD_UNITDIR "/usr/lib/systemd/system")
  ENDIF()

  EXECUTE_PROCESS(COMMAND rpm --eval %_libdir OUTPUT_VARIABLE LIBDIR OUTPUT_STRIP_TRAILING_WHITESPACE)
  IF(LIBDIR)
    SET(INSTALL_LIBDIR ${LIBDIR}/galera)
  ELSE()
    IF(CMAKE_SIZEOF_VOID_P EQUAL 8)
      SET(INSTALL_LIBDIR "lib64/galera")
    ENDIF()
  ENDIF()

  SET(CPACK_RPM_PACKAGE_EPOCH ${GALERA_EPOCH})
  SET(CPACK_RPM_PACKAGE_RELEASE ${GALERA_VERSION_EXTRA})
  IF(CMAKE_VERSION VERSION_LESS "3.6.0")
    SET(CPACK_RPM_PACKAGE_NAME ${PROJECT_NAME})
    EXECUTE_PROCESS(COMMAND rpm --eval %dist
                    OUTPUT_VARIABLE DIST OUTPUT_STRIP_TRAILING_WHITESPACE)
    SET(CPACK_RPM_PACKAGE_VERSION ${CPACK_PACKAGE_VERSION})
    SET(CPACK_PACKAGE_FILE_NAME "${CPACK_RPM_PACKAGE_NAME}-${CPACK_RPM_PACKAGE_VERSION}-${CPACK_RPM_PACKAGE_RELEASE}${DIST}-${CMAKE_SYSTEM_PROCESSOR}")
  ELSE()
    SET(CPACK_RPM_FILE_NAME "RPM-DEFAULT")
    SET(CPACK_RPM_PACKAGE_RELEASE_DIST ON)
    OPTION(CPACK_RPM_DEBUGINFO_PACKAGE "" ON)
    SET(CPACK_RPM_BUILD_SOURCE_DIRS_PREFIX "/usr/src/debug/${CPACK_RPM_PACKAGE_NAME}-${CPACK_RPM_PACKAGE_VERSION}")
  ENDIF()
  SET(CPACK_RPM_PACKAGE_LICENSE "GPLv2")
  SET(CPACK_RPM_PACKAGE_GROUP "System Environment/Libraries")
  SET(CPACK_RPM_PACKAGE_DESCRIPTION ${CPACK_PACKAGE_DESCRIPTION})
  SET(CPACK_RPM_PACKAGE_PROVIDES "wsrep, galera, galera-${GALERA_VERSION_MAJOR}, galera-enterprise-${GALERA_VERSION_MAJOR}")
  SET(CPACK_RPM_PACKAGE_REQUIRES "rsync, socat, lsof")
  SET(CPACK_RPM_PACKAGE_OBSOLETES "galera")
  SET(CPACK_RPM_POST_INSTALL_SCRIPT_FILE ${CMAKE_CURRENT_SOURCE_DIR}/scripts/packages/rpm/post)
  SET(CPACK_RPM_PRE_UNINSTALL_SCRIPT_FILE ${CMAKE_CURRENT_SOURCE_DIR}/scripts/packages/rpm/preun)
  SET(CPACK_RPM_POST_UNINSTALL_SCRIPT_FILE ${CMAKE_CURRENT_SOURCE_DIR}/scripts/packages/rpm/postun)
ENDIF()
#
