"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanup = cleanup;
exports.addCleanup = addCleanup;
exports.removeCleanup = removeCleanup;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _flushMicrotasks = _interopRequireDefault(require("./flush-microtasks"));

var cleanupCallbacks = [];

function cleanup() {
  return _cleanup.apply(this, arguments);
}

function _cleanup() {
  _cleanup = (0, _asyncToGenerator2["default"])(
  /*#__PURE__*/
  _regenerator["default"].mark(function _callee() {
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return (0, _flushMicrotasks["default"])();

          case 2:
            cleanupCallbacks.forEach(function (cb) {
              return cb();
            });
            cleanupCallbacks = [];

          case 4:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _cleanup.apply(this, arguments);
}

function addCleanup(callback) {
  cleanupCallbacks.push(callback);
}

function removeCleanup(callback) {
  cleanupCallbacks = cleanupCallbacks.filter(function (cb) {
    return cb !== callback;
  });
}