//go:build windows
// +build windows

/*
Copyright (c) 2021 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file contains the function that returns the trusted CA certificates for Windows. This is
// needed because currently Go doesn't know how to load the Windows trusted CA store. See the
// following issues for more information:
//
//	https://github.com/golang/go/issues/16736
//	https://github.com/golang/go/issues/18609

package internal

import (
	"crypto/x509"
)

// loadSystemCAs loads the certificates of the CAs that we will trust. Currently this uses a fixed
// set of CA certificates, which is obviusly going to break in the future, but there is not much we
// can do (or know to do) till Go learns to read the Windows CA trust store.
func loadSystemCAs() (pool *x509.CertPool, err error) {
	pool = x509.NewCertPool()
	pool.AppendCertsFromPEM(ssoCA1)
	pool.AppendCertsFromPEM(ssoCA2)
	pool.AppendCertsFromPEM(apiCA1)
	pool.AppendCertsFromPEM(apiCA2)
	return
}

// The SSO certificates has been obtained with the following command:
//
//	$ openssl s_client -connect sso.redhat.com:443 -showcerts
var ssoCA1 = []byte(`
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
`)

var ssoCA2 = []byte(`
-----BEGIN CERTIFICATE-----
MIIEtjCCA56gAwIBAgIQDHmpRLCMEZUgkmFf4msdgzANBgkqhkiG9w0BAQsFADBs
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2VydCBIaWdoIEFzc3VyYW5j
ZSBFViBSb290IENBMB4XDTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowdTEL
MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
LmRpZ2ljZXJ0LmNvbTE0MDIGA1UEAxMrRGlnaUNlcnQgU0hBMiBFeHRlbmRlZCBW
YWxpZGF0aW9uIFNlcnZlciBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
ggEBANdTpARR+JmmFkhLZyeqk0nQOe0MsLAAh/FnKIaFjI5j2ryxQDji0/XspQUY
uD0+xZkXMuwYjPrxDKZkIYXLBxA0sFKIKx9om9KxjxKws9LniB8f7zh3VFNfgHk/
LhqqqB5LKw2rt2O5Nbd9FLxZS99RStKh4gzikIKHaq7q12TWmFXo/a8aUGxUvBHy
/Urynbt/DvTVvo4WiRJV2MBxNO723C3sxIclho3YIeSwTQyJ3DkmF93215SF2AQh
cJ1vb/9cuhnhRctWVyh+HA1BV6q3uCe7seT6Ku8hI3UarS2bhjWMnHe1c63YlC3k
8wyd7sFOYn4XwHGeLN7x+RAoGTMCAwEAAaOCAUkwggFFMBIGA1UdEwEB/wQIMAYB
Af8CAQAwDgYDVR0PAQH/BAQDAgGGMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEF
BQcDAjA0BggrBgEFBQcBAQQoMCYwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRp
Z2ljZXJ0LmNvbTBLBgNVHR8ERDBCMECgPqA8hjpodHRwOi8vY3JsNC5kaWdpY2Vy
dC5jb20vRGlnaUNlcnRIaWdoQXNzdXJhbmNlRVZSb290Q0EuY3JsMD0GA1UdIAQ2
MDQwMgYEVR0gADAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
b20vQ1BTMB0GA1UdDgQWBBQ901Cl1qCt7vNKYApl0yHU+PjWDzAfBgNVHSMEGDAW
gBSxPsNpA/i/RwHUmCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAnbbQkIbh
hgLtxaDwNBx0wY12zIYKqPBKikLWP8ipTa18CK3mtlC4ohpNiAexKSHc59rGPCHg
4xFJcKx6HQGkyhE6V6t9VypAdP3THYUYUN9XR3WhfVUgLkc3UHKMf4Ib0mKPLQNa
2sPIoc4sUqIAY+tzunHISScjl2SFnjgOrWNoPLpSgVh5oywM395t6zHyuqB8bPEs
1OG9d4Q3A84ytciagRpKkk47RpqF/oOi+Z6Mo8wNXrM9zwR4jxQUezKcxwCmXMS1
oVWNWlZopCJwqjyBcdmdqEU79OX2olHdx3ti6G8MdOu42vi/hw15UJGQmxg7kVkn
8TUoE6smftX3eg==
-----END CERTIFICATE-----
`)

// The API certificates have been obtained with the following command:
//
//	$ openssl s_client -connect api.openshift.com:443 -showcerts
var apiCA1 = []byte(`
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
`)

var apiCA2 = []byte(`
-----BEGIN CERTIFICATE-----
MIIEyDCCA7CgAwIBAgIQDPW9BitWAvR6uFAsI8zwZjANBgkqhkiG9w0BAQsFADBh
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBH
MjAeFw0yMTAzMzAwMDAwMDBaFw0zMTAzMjkyMzU5NTlaMFkxCzAJBgNVBAYTAlVT
MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxMzAxBgNVBAMTKkRpZ2lDZXJ0IEdsb2Jh
bCBHMiBUTFMgUlNBIFNIQTI1NiAyMDIwIENBMTCCASIwDQYJKoZIhvcNAQEBBQAD
ggEPADCCAQoCggEBAMz3EGJPprtjb+2QUlbFbSd7ehJWivH0+dbn4Y+9lavyYEEV
cNsSAPonCrVXOFt9slGTcZUOakGUWzUb+nv6u8W+JDD+Vu/E832X4xT1FE3LpxDy
FuqrIvAxIhFhaZAmunjZlx/jfWardUSVc8is/+9dCopZQ+GssjoP80j812s3wWPc
3kbW20X+fSP9kOhRBx5Ro1/tSUZUfyyIxfQTnJcVPAPooTncaQwywa8WV0yUR0J8
osicfebUTVSvQpmowQTCd5zWSOTOEeAqgJnwQ3DPP3Zr0UxJqyRewg2C/Uaoq2yT
zGJSQnWS+Jr6Xl6ysGHlHx+5fwmY6D36g39HaaECAwEAAaOCAYIwggF+MBIGA1Ud
EwEB/wQIMAYBAf8CAQAwHQYDVR0OBBYEFHSFgMBmx9833s+9KTeqAx2+7c0XMB8G
A1UdIwQYMBaAFE4iVCAYlebjbuYP+vq5Eu0GF485MA4GA1UdDwEB/wQEAwIBhjAd
BgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwdgYIKwYBBQUHAQEEajBoMCQG
CCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQAYIKwYBBQUHMAKG
NGh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEdsb2JhbFJvb3RH
Mi5jcnQwQgYDVR0fBDswOTA3oDWgM4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29t
L0RpZ2lDZXJ0R2xvYmFsUm9vdEcyLmNybDA9BgNVHSAENjA0MAsGCWCGSAGG/WwC
ATAHBgVngQwBATAIBgZngQwBAgEwCAYGZ4EMAQICMAgGBmeBDAECAzANBgkqhkiG
9w0BAQsFAAOCAQEAkPFwyyiXaZd8dP3A+iZ7U6utzWX9upwGnIrXWkOH7U1MVl+t
wcW1BSAuWdH/SvWgKtiwla3JLko716f2b4gp/DA/JIS7w7d7kwcsr4drdjPtAFVS
slme5LnQ89/nD/7d+MS5EHKBCQRfz5eeLjJ1js+aWNJXMX43AYGyZm0pGrFmCW3R
bpD0ufovARTFXFZkAdl9h6g4U5+LXUZtXMYnhIHUfoyMo5tS58aI7Dd8KvvwVVo4
chDYABPPTHPbqjc1qCmBaZx2vN4Ye5DUys/vZwP9BFohFrH/6j/f3IL16/RZkiMN
JCqVJUzKoZHm1Lesh3Sz8W2jmdv51b2EQJ8HmA==
-----END CERTIFICATE-----
`)
